/*
 * Decompiled with CFR 0.152.
 */
package com.commercehub.gradle.plugin.avro;

import com.commercehub.gradle.plugin.avro.FileExtensionSpec;
import com.commercehub.gradle.plugin.avro.FileUtils;
import com.commercehub.gradle.plugin.avro.FilenameUtils;
import com.commercehub.gradle.plugin.avro.OutputDirTask;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.LinkedList;
import org.apache.avro.compiler.idl.Idl;
import org.apache.avro.compiler.idl.ParseException;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.specs.NotSpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskAction;

public class GenerateAvroProtocolTask
extends OutputDirTask {
    @TaskAction
    protected void process() {
        this.getLogger().info("Found {} files", (Object)this.getInputs().getSourceFiles().getFiles().size());
        this.failOnUnsupportedFiles();
        this.processFiles();
    }

    private void failOnUnsupportedFiles() {
        FileCollection unsupportedFiles = this.filterSources((Spec<? super File>)new NotSpec((Spec)new FileExtensionSpec("avdl")));
        if (!unsupportedFiles.isEmpty()) {
            throw new GradleException(String.format("Unsupported file extension for the following files: %s", unsupportedFiles));
        }
    }

    private void processFiles() {
        int processedFileCount = 0;
        ClassLoader loader = this.getRuntimeClassLoader(this.getProject());
        for (File sourceFile : this.filterSources(new FileExtensionSpec("avdl"))) {
            this.processIDLFile(sourceFile, loader);
            ++processedFileCount;
        }
        this.setDidWork(processedFileCount > 0);
    }

    private void processIDLFile(File idlFile, ClassLoader loader) {
        this.getLogger().info("Processing {}", (Object)idlFile);
        File protoFile = new File(this.getOutputDir(), FilenameUtils.getBaseName(idlFile.getName()) + "." + "avpr");
        Idl idl = null;
        try {
            idl = new Idl(idlFile, loader);
            String protoJson = idl.CompilationUnit().toString(true);
            this.writeJsonFile(protoFile, protoJson);
        }
        catch (IOException ex) {
            throw new GradleException(String.format("Failed to compile IDL file %s", idlFile), (Throwable)ex);
        }
        catch (ParseException ex) {
            throw new GradleException(String.format("Failed to compile IDL file %s", idlFile), (Throwable)ex);
        }
        finally {
            if (idl != null) {
                try {
                    idl.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private ClassLoader getRuntimeClassLoader(Project project) {
        LinkedList<URL> urls = new LinkedList<URL>();
        Configuration configuration = project.getConfigurations().getByName("runtime");
        for (File file : configuration) {
            try {
                urls.add(file.toURI().toURL());
            }
            catch (MalformedURLException e) {
                this.getLogger().debug(e.getMessage());
            }
        }
        return urls.isEmpty() ? ClassLoader.getSystemClassLoader() : new URLClassLoader(urls.toArray(new URL[urls.size()]), ClassLoader.getSystemClassLoader());
    }

    private void writeJsonFile(File file, String data) throws IOException {
        FileUtils.writeStringToFile(file, data, "UTF-8");
    }
}

