/*
 * Decompiled with CFR 0.152.
 */
package com.cognitect.transit.impl;

import com.cognitect.transit.WriteHandler;
import com.cognitect.transit.impl.Constants;
import com.cognitect.transit.impl.Emitter;
import com.cognitect.transit.impl.Quote;
import com.cognitect.transit.impl.Util;
import com.cognitect.transit.impl.WriteCache;
import com.cognitect.transit.impl.WriteHandlerMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import java.util.function.Function;

public abstract class AbstractEmitter
implements Emitter {
    private WriteHandlerMap writeHandlerMap;
    private WriteHandler defaultWriteHandler;
    private Function<Object, Object> transform;

    @Deprecated
    protected AbstractEmitter(WriteHandlerMap writeHandlerMap) {
        this(writeHandlerMap, null);
    }

    protected AbstractEmitter(WriteHandlerMap writeHandlerMap, WriteHandler defaultWriteHandler) {
        this.writeHandlerMap = writeHandlerMap;
        this.defaultWriteHandler = defaultWriteHandler;
    }

    protected AbstractEmitter(WriteHandlerMap writeHandlerMap, WriteHandler defaultWriteHandler, Function<Object, Object> transform) {
        this.writeHandlerMap = writeHandlerMap;
        this.writeHandlerMap.transform = transform;
        this.defaultWriteHandler = defaultWriteHandler;
        this.transform = transform;
    }

    protected String escape(String s) {
        char c;
        int l = s.length();
        if (l > 0 && ((c = s.charAt(0)) == '~' || c == '^' || c == '`')) {
            return '~' + s;
        }
        return s;
    }

    protected void emitTagged(String t, Object o, boolean ignored, WriteCache cache) throws Exception {
        this.emitArrayStart(2L);
        this.emitString(Constants.ESC_TAG, t, "", false, cache);
        this.marshal(o, false, cache);
        this.emitArrayEnd();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void emitEncoded(String t, WriteHandler<Object, Object> h, Object o, boolean asMapKey, WriteCache cache) throws Exception {
        if (t.length() == 1) {
            Object r = h.rep(o);
            if (r instanceof String) {
                this.emitString(Constants.ESC_STR, t, (String)r, asMapKey, cache);
                return;
            } else if (this.prefersStrings() || asMapKey) {
                String sr = h.stringRep(o);
                if (sr == null) throw new Exception("Cannot be encoded as a string " + o);
                this.emitString(Constants.ESC_STR, t, sr, asMapKey, cache);
                return;
            } else {
                this.emitTagged(t, r, asMapKey, cache);
            }
            return;
        } else {
            if (asMapKey) {
                throw new Exception("Cannot be used as a map key " + o);
            }
            this.emitTagged(t, h.rep(o), asMapKey, cache);
        }
    }

    protected void emitMap(Object m, boolean ignored, WriteCache cache) throws Exception {
        Set<Map.Entry<Object, Object>> entries = m instanceof Map ? ((Map)m).entrySet() : (Set<Map.Entry<Object, Object>>)m;
        this.emitMap(entries, ignored, cache);
    }

    protected abstract void emitMap(Iterable<Map.Entry<Object, Object>> var1, boolean var2, WriteCache var3) throws Exception;

    protected void emitArray(Object o, boolean ignored, WriteCache cache) throws Exception {
        this.emitArrayStart(Util.arraySize(o));
        if (o instanceof RandomAccess) {
            List xs = (List)o;
            for (int i = 0; i < xs.size(); ++i) {
                this.marshal(xs.get(i), false, cache);
            }
        } else if (o instanceof Iterable) {
            Iterator i = ((Iterable)o).iterator();
            while (i.hasNext()) {
                this.marshal(i.next(), false, cache);
            }
        } else if (o instanceof Object[]) {
            for (Object x : (Object[])o) {
                this.marshal(x, false, cache);
            }
        } else if (o instanceof int[]) {
            int[] x;
            for (int n : x = (int[])o) {
                this.emitInteger(n, false, cache);
            }
        } else if (o instanceof long[]) {
            long[] x;
            for (long n : x = (long[])o) {
                this.emitInteger(n, false, cache);
            }
        } else if (o instanceof float[]) {
            float[] x;
            for (float n : x = (float[])o) {
                this.emitDouble(n, false, cache);
            }
        } else if (o instanceof boolean[]) {
            boolean[] x;
            for (boolean n : x = (boolean[])o) {
                this.emitBoolean(n, false, cache);
            }
        } else if (o instanceof double[]) {
            double[] x;
            for (double n : x = (double[])o) {
                this.emitDouble(n, false, cache);
            }
        } else if (o instanceof char[]) {
            char[] x;
            for (char n : x = (char[])o) {
                this.marshal(Character.valueOf(n), false, cache);
            }
        } else if (o instanceof short[]) {
            short[] x;
            for (short n : x = (short[])o) {
                this.emitInteger(n, false, cache);
            }
        }
        this.emitArrayEnd();
    }

    protected void marshal(Object o, boolean asMapKey, WriteCache cache) throws Exception {
        String t;
        WriteHandler h;
        if (null != this.transform) {
            o = this.transform.apply(o);
        }
        if ((h = this.writeHandlerMap.getHandler(o)) == null) {
            h = this.defaultWriteHandler;
        }
        boolean supported = false;
        if (h != null && (t = h.tag(o)) != null) {
            supported = true;
            if (t.length() == 1) {
                switch (t.charAt(0)) {
                    case '_': {
                        this.emitNil(asMapKey, cache);
                        break;
                    }
                    case 's': {
                        this.emitString(null, null, this.escape((String)h.rep(o)), asMapKey, cache);
                        break;
                    }
                    case '?': {
                        this.emitBoolean((Boolean)h.rep(o), asMapKey, cache);
                        break;
                    }
                    case 'i': {
                        this.emitInteger(h.rep(o), asMapKey, cache);
                        break;
                    }
                    case 'd': {
                        this.emitDouble(h.rep(o), asMapKey, cache);
                        break;
                    }
                    case 'b': {
                        this.emitBinary(h.rep(o), asMapKey, cache);
                        break;
                    }
                    case '\'': {
                        this.emitTagged(t, h.rep(o), false, cache);
                        break;
                    }
                    default: {
                        this.emitEncoded(t, h, o, asMapKey, cache);
                        break;
                    }
                }
            } else if (t.equals("array")) {
                this.emitArray(h.rep(o), asMapKey, cache);
            } else if (t.equals("map")) {
                this.emitMap(h.rep(o), asMapKey, cache);
            } else {
                this.emitEncoded(t, h, o, asMapKey, cache);
            }
            this.flushWriter();
        }
        if (!supported) {
            throw new Exception("Not supported: " + o.getClass());
        }
    }

    protected void marshalTop(Object o, WriteCache cache) throws Exception {
        String tag;
        WriteHandler h = this.writeHandlerMap.getHandler(o);
        if (h == null) {
            h = this.defaultWriteHandler;
        }
        if ((tag = h.tag(o)) == null) {
            throw new Exception("Not supported: " + o);
        }
        if (tag.length() == 1) {
            o = new Quote(o);
        }
        this.marshal(o, false, cache);
    }
}

