/*
 * Decompiled with CFR 0.152.
 */
package com.cognifide.gradle.common.zip;

import com.cognifide.gradle.common.zip.ZipException;
import com.cognifide.gradle.common.zip.ZipFile;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import net.lingala.zip4j.io.inputstream.ZipInputStream;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.ZipParameters;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 .2\u00020\u0001:\u0001.B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J)\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0019\b\u0002\u0010\f\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\n0\r\u00a2\u0006\u0002\b\u000fJ)\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0019\b\u0002\u0010\f\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\n0\r\u00a2\u0006\u0002\b\u000fJ\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0011J\u000e\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u0011J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0019\u001a\u00020\u0011H\u0002J\b\u0010\u001b\u001a\u00020\nH\u0002J\u0014\u0010\u001c\u001a\u0010\u0012\f\u0012\n \u001d*\u0004\u0018\u00010\u00110\u00110\u0013J\u001c\u0010\u001e\u001a\u0010\u0012\f\u0012\n \u001d*\u0004\u0018\u00010\u00110\u00110\u00132\u0006\u0010\u0019\u001a\u00020\u0011J\u001f\u0010\f\u001a\u00020\u000e2\u0017\u0010\f\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\n0\r\u00a2\u0006\u0002\b\u000fJ)\u0010\u001f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0019\b\u0002\u0010\f\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\n0\r\u00a2\u0006\u0002\b\u000fJ)\u0010\u001f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00112\u0019\b\u0002\u0010\f\u001a\u0013\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\n0\r\u00a2\u0006\u0002\b\u000fJ\u000e\u0010 \u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u0011J\u000e\u0010\"\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0011J\u000e\u0010#\u001a\u00020\n2\u0006\u0010$\u001a\u00020\u0003J\u000e\u0010#\u001a\u00020\n2\u0006\u0010%\u001a\u00020\u0011J\u0016\u0010&\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\u0003J\u0016\u0010&\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\u0011J\u0016\u0010(\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u0003J\u0016\u0010(\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u0011J\u0016\u0010)\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010*\u001a\u00020\u0003J\u0016\u0010)\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u0011J\u0016\u0010+\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010$\u001a\u00020\u0003J\u0016\u0010+\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010%\u001a\u00020\u0011J\"\u0010,\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u00112\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\n0\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006/"}, d2={"Lcom/cognifide/gradle/common/zip/ZipFile;", "", "baseFile", "Ljava/io/File;", "(Ljava/io/File;)V", "base", "Lnet/lingala/zip4j/ZipFile;", "getBaseFile", "()Ljava/io/File;", "addDir", "", "sourceDir", "options", "Lkotlin/Function1;", "Lnet/lingala/zip4j/model/ZipParameters;", "Lkotlin/ExtensionFunctionType;", "sourcePath", "", "allFileHeaders", "Lkotlin/sequences/Sequence;", "Lnet/lingala/zip4j/model/FileHeader;", "contains", "", "fileName", "containsDir", "dirName", "dirFileHeaders", "ensureExists", "listAll", "kotlin.jvm.PlatformType", "listDir", "packAll", "readFile", "Lnet/lingala/zip4j/io/inputstream/ZipInputStream;", "readFileAsText", "unpackAll", "targetDir", "targetPath", "unpackDir", "dir", "unpackDirTo", "unpackFile", "targetFile", "unpackFileTo", "walkDir", "callback", "Companion", "common-plugin"})
public final class ZipFile {
    private final net.lingala.zip4j.ZipFile base;
    @NotNull
    private final File baseFile;
    private static final Function1<ZipParameters, Unit> OPTIONS_DEFAULT;
    @NotNull
    public static final Companion Companion;

    private final void ensureExists() {
        if (!this.baseFile.exists()) {
            throw (Throwable)((Object)new ZipException("ZIP file '" + this.baseFile + "' does not exist!"));
        }
    }

    public final boolean contains(@NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        this.ensureExists();
        return this.base.getFileHeader(fileName) != null;
    }

    public final boolean containsDir(@NotNull String dirName) {
        Intrinsics.checkNotNullParameter((Object)dirName, (String)"dirName");
        this.ensureExists();
        return this.base.getFileHeader(StringUtils.appendIfMissing((String)dirName, (CharSequence)"/", (CharSequence[])new CharSequence[0])) != null;
    }

    public final void unpackAll(@NotNull String targetPath) {
        Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
        this.unpackAll(new File(targetPath));
    }

    public final void unpackAll(@NotNull File targetDir) {
        Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
        this.ensureExists();
        this.base.extractAll(targetDir.getAbsolutePath());
    }

    public final void packAll(@NotNull String sourceDir, @NotNull Function1<? super ZipParameters, Unit> options2) {
        Intrinsics.checkNotNullParameter((Object)sourceDir, (String)"sourceDir");
        Intrinsics.checkNotNullParameter(options2, (String)"options");
        this.packAll(new File(sourceDir), options2);
    }

    public static /* synthetic */ void packAll$default(ZipFile zipFile, String string2, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = packAll.1.INSTANCE;
        }
        zipFile.packAll(string2, (Function1<? super ZipParameters, Unit>)function1);
    }

    public final void packAll(@NotNull File sourceDir, @NotNull Function1<? super ZipParameters, Unit> options2) {
        Intrinsics.checkNotNullParameter((Object)sourceDir, (String)"sourceDir");
        Intrinsics.checkNotNullParameter(options2, (String)"options");
        ZipParameters effectiveOptions = this.options(options2);
        File[] fileArray = sourceDir.listFiles();
        if (fileArray == null) {
            fileArray = new File[]{};
        }
        File[] $this$forEach$iv = fileArray;
        boolean $i$f$forEach = false;
        File[] fileArray2 = $this$forEach$iv;
        int n = fileArray2.length;
        for (int j = 0; j < n; ++j) {
            File element$iv;
            File f = element$iv = fileArray2[j];
            boolean bl = false;
            File file2 = f;
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"f");
            if (file2.isDirectory()) {
                this.base.addFolder(f, effectiveOptions);
                continue;
            }
            if (!f.isFile()) continue;
            this.base.addFile(f, effectiveOptions);
        }
    }

    public static /* synthetic */ void packAll$default(ZipFile zipFile, File file2, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = packAll.2.INSTANCE;
        }
        zipFile.packAll(file2, (Function1<? super ZipParameters, Unit>)function1);
    }

    private final Sequence<FileHeader> allFileHeaders() {
        this.ensureExists();
        net.lingala.zip4j.ZipFile zipFile = this.base;
        boolean bl = false;
        boolean bl2 = false;
        net.lingala.zip4j.ZipFile $this$run = zipFile;
        boolean bl3 = false;
        List list2 = $this$run.getFileHeaders();
        if (list2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<net.lingala.zip4j.model.FileHeader>");
        }
        return CollectionsKt.asSequence((Iterable)list2);
    }

    private final Sequence<FileHeader> dirFileHeaders(String dirName) {
        String dirFileName;
        this.ensureExists();
        String string2 = dirFileName = StringUtils.appendIfMissing((String)dirName, (CharSequence)"/", (CharSequence[])new CharSequence[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"dirFileName");
        if (!this.contains(string2)) {
            throw (Throwable)((Object)new ZipException("ZIP file '" + this.baseFile + "' does not contain directory '" + dirName + "'!"));
        }
        net.lingala.zip4j.ZipFile zipFile = this.base;
        boolean bl = false;
        boolean bl2 = false;
        net.lingala.zip4j.ZipFile $this$run = zipFile;
        boolean bl3 = false;
        List list2 = $this$run.getFileHeaders();
        if (list2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<net.lingala.zip4j.model.FileHeader>");
        }
        return SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)list2), (Function1)((Function1)new Function1<FileHeader, Boolean>(dirFileName){
            final /* synthetic */ String $dirFileName$inlined;
            {
                this.$dirFileName$inlined = string2;
                super(1);
            }

            public final boolean invoke(@NotNull FileHeader it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                String string2 = it.getFileName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.fileName");
                String string3 = this.$dirFileName$inlined;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"dirFileName");
                return StringsKt.startsWith$default((String)string2, (String)string3, (boolean)false, (int)2, null);
            }
        }));
    }

    public final void unpackDir(@NotNull String dirName, @NotNull String dir2) {
        Intrinsics.checkNotNullParameter((Object)dirName, (String)"dirName");
        Intrinsics.checkNotNullParameter((Object)dir2, (String)"dir");
        this.unpackDir(dirName, new File(dir2));
    }

    public final void unpackDir(@NotNull String dirName, @NotNull File dir2) {
        Intrinsics.checkNotNullParameter((Object)dirName, (String)"dirName");
        Intrinsics.checkNotNullParameter((Object)dir2, (String)"dir");
        Sequence<FileHeader> $this$forEach$iv = this.dirFileHeaders(dirName);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FileHeader it = (FileHeader)element$iv;
            boolean bl = false;
            this.base.extractFile(it, dir2.getAbsolutePath());
        }
    }

    public final void unpackDirTo(@NotNull String fileName, @NotNull String targetPath) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
        this.unpackDirTo(fileName, new File(targetPath));
    }

    public final void unpackDirTo(@NotNull String dirName, @NotNull File targetDir) {
        Intrinsics.checkNotNullParameter((Object)dirName, (String)"dirName");
        Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
        Sequence<FileHeader> $this$forEach$iv = this.dirFileHeaders(dirName);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String fileName;
            FileHeader it = (FileHeader)element$iv;
            boolean bl = false;
            String string2 = fileName = it.getFileName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"fileName");
            String fileRelativeName = StringsKt.substringAfterLast$default((String)string2, (String)(dirName + '/'), null, (int)2, null);
            File targetFile = FilesKt.resolve((File)targetDir, (String)fileRelativeName);
            this.unpackFile(fileName, targetFile);
        }
    }

    public final void walkDir(@NotNull String dirName, @NotNull Function1<? super FileHeader, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)dirName, (String)"dirName");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Sequence<FileHeader> $this$forEach$iv = this.dirFileHeaders(dirName);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FileHeader it = (FileHeader)element$iv;
            boolean bl = false;
            callback.invoke((Object)it);
        }
    }

    @NotNull
    public final Sequence<String> listAll() {
        return SequencesKt.map(this.allFileHeaders(), (Function1)listAll.1.INSTANCE);
    }

    @NotNull
    public final Sequence<String> listDir(@NotNull String dirName) {
        Intrinsics.checkNotNullParameter((Object)dirName, (String)"dirName");
        return SequencesKt.map(this.dirFileHeaders(dirName), (Function1)listDir.1.INSTANCE);
    }

    public final void unpackFile(@NotNull String fileName, @NotNull String targetPath) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
        this.unpackFile(fileName, new File(targetPath));
    }

    public final void unpackFile(@NotNull String fileName, @NotNull File targetFile) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
        if (!this.contains(fileName)) {
            throw (Throwable)((Object)new ZipException("ZIP file '" + this.baseFile + "' does not contain file '" + fileName + "'!"));
        }
        File file2 = targetFile.getParentFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"targetFile.parentFile");
        this.base.extractFile(fileName, file2.getAbsolutePath(), targetFile.getName());
    }

    public final void unpackFileTo(@NotNull String fileName, @NotNull String targetPath) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
        this.unpackFileTo(fileName, new File(targetPath));
    }

    public final void unpackFileTo(@NotNull String fileName, @NotNull File targetDir) {
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
        this.unpackFile(fileName, FilesKt.resolve((File)targetDir, (String)StringsKt.substringAfterLast$default((String)fileName, (String)"/", null, (int)2, null)));
    }

    public final void addDir(@NotNull String sourcePath, @NotNull Function1<? super ZipParameters, Unit> options2) {
        Intrinsics.checkNotNullParameter((Object)sourcePath, (String)"sourcePath");
        Intrinsics.checkNotNullParameter(options2, (String)"options");
        this.addDir(new File(sourcePath), options2);
    }

    public static /* synthetic */ void addDir$default(ZipFile zipFile, String string2, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = addDir.1.INSTANCE;
        }
        zipFile.addDir(string2, (Function1<? super ZipParameters, Unit>)function1);
    }

    public final void addDir(@NotNull File sourceDir, @NotNull Function1<? super ZipParameters, Unit> options2) {
        Intrinsics.checkNotNullParameter((Object)sourceDir, (String)"sourceDir");
        Intrinsics.checkNotNullParameter(options2, (String)"options");
        this.baseFile.getParentFile().mkdirs();
        this.base.addFolder(sourceDir, this.options(options2));
    }

    public static /* synthetic */ void addDir$default(ZipFile zipFile, File file2, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = addDir.2.INSTANCE;
        }
        zipFile.addDir(file2, (Function1<? super ZipParameters, Unit>)function1);
    }

    @NotNull
    public final ZipInputStream readFile(@NotNull String fileName) {
        FileHeader fileHeader;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
                this.ensureExists();
                fileHeader = this.base.getFileHeader(fileName);
                if (fileHeader == null) break block2;
                FileHeader fileHeader2 = fileHeader;
                boolean bl = false;
                boolean bl2 = false;
                FileHeader it = fileHeader2;
                boolean bl3 = false;
                fileHeader = this.base.getInputStream(it);
                if (fileHeader != null) break block3;
            }
            throw (Throwable)((Object)new ZipException("ZIP file '" + this.baseFile + "' does not contain file '" + fileName + "'!"));
        }
        return fileHeader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final String readFileAsText(@NotNull String fileName) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Closeable closeable = (Closeable)this.readFile(fileName);
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            ZipInputStream it = (ZipInputStream)closeable;
            boolean bl3 = false;
            InputStream inputStream = (InputStream)it;
            Charset charset = Charsets.UTF_8;
            boolean bl4 = false;
            Closeable closeable2 = inputStream;
            int n = 0;
            closeable2 = new InputStreamReader((InputStream)closeable2, charset);
            n = 8192;
            boolean bl5 = false;
            string2 = TextStreamsKt.readText((Reader)(closeable2 instanceof BufferedReader ? (BufferedReader)closeable2 : new BufferedReader((Reader)closeable2, n)));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return string2;
    }

    @NotNull
    public final ZipParameters options(@NotNull Function1<? super ZipParameters, Unit> options2) {
        Intrinsics.checkNotNullParameter(options2, (String)"options");
        ZipParameters zipParameters = new ZipParameters();
        Function1<ZipParameters, Unit> function1 = OPTIONS_DEFAULT;
        boolean bl = false;
        boolean bl2 = false;
        function1.invoke((Object)zipParameters);
        boolean bl3 = false;
        bl = false;
        options2.invoke((Object)zipParameters);
        return zipParameters;
    }

    @NotNull
    public final File getBaseFile() {
        return this.baseFile;
    }

    public ZipFile(@NotNull File baseFile) {
        Intrinsics.checkNotNullParameter((Object)baseFile, (String)"baseFile");
        this.baseFile = baseFile;
        this.base = new net.lingala.zip4j.ZipFile(this.baseFile);
    }

    static {
        Companion = new Companion(null);
        OPTIONS_DEFAULT = Companion.OPTIONS_DEFAULT.1.INSTANCE;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001f\u0010\u0003\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/cognifide/gradle/common/zip/ZipFile$Companion;", "", "()V", "OPTIONS_DEFAULT", "Lkotlin/Function1;", "Lnet/lingala/zip4j/model/ZipParameters;", "", "Lkotlin/ExtensionFunctionType;", "common-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

