/*
 * Decompiled with CFR 0.152.
 */
package com.cognifide.gradle.common.utils;

import com.cognifide.gradle.common.utils.FormatException;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.module.kotlin.KotlinModule;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.gradle.api.Project;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.nodes.Document;
import org.jsoup.parser.Parser;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\n \u0005*\u0004\u0018\u00010\u000b0\u000b2\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\n\u001a\n \u0005*\u0004\u0018\u00010\u000b0\u000b2\u0006\u0010\f\u001a\u00020\tJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\u0011\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00042\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0012\u001a\n \u0005*\u0004\u0018\u00010\u000b0\u000b2\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\u0012\u001a\n \u0005*\u0004\u0018\u00010\u000b0\u000b2\u0006\u0010\f\u001a\u00020\tJ \u0010\u0013\u001a\n \u0005*\u0004\u0018\u00010\t0\t2\u0006\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0017J\u0010\u0010\u0018\u001a\u00020\t2\b\b\u0002\u0010\u0018\u001a\u00020\u0019J\u0016\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u0010\u0010\u001f\u001a\u00020\t2\b\b\u0002\u0010\u0018\u001a\u00020\u0019J\u000e\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\u001cJ\u001e\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020\u001cJ\u000e\u0010&\u001a\u00020\t2\u0006\u0010!\u001a\u00020\u001cJ\u000e\u0010'\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010(\u001a\u00020\t2\u0006\u0010)\u001a\u00020\u001cJ\b\u0010*\u001a\u00020+H\u0002J\u0018\u0010,\u001a\n \u0005*\u0004\u0018\u00010-0-2\u0006\u0010.\u001a\u00020\u0017H\u0002J\u0016\u0010/\u001a\u0002002\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u000e\u00101\u001a\u00020\t2\u0006\u00102\u001a\u00020\tJ\u0016\u00103\u001a\u00020\t2\u0006\u00104\u001a\u00020\u00102\u0006\u00105\u001a\u00020\u0010J\u0016\u00103\u001a\u00020\t2\u0006\u00104\u001a\u00020\u001c2\u0006\u00105\u001a\u00020\u001cJ\u0016\u00106\u001a\u00020\t2\u0006\u00104\u001a\u00020\u00102\u0006\u00105\u001a\u00020\u0010J\u0016\u00106\u001a\u00020\t2\u0006\u00104\u001a\u00020\u001c2\u0006\u00105\u001a\u00020\u001cJ\u0016\u00107\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u00108\u001a\u000209J\u0016\u00107\u001a\u00020\t2\u0006\u00102\u001a\u00020\t2\u0006\u00108\u001a\u000209J\u0016\u0010:\u001a\u00020\t2\u0006\u00102\u001a\u00020\t2\u0006\u0010;\u001a\u00020\tJ\u0016\u0010<\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u00108\u001a\u000209J\u0016\u0010<\u001a\u00020\t2\u0006\u00102\u001a\u00020\t2\u0006\u00108\u001a\u000209J\u000e\u0010=\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010>\u001a\n \u0005*\u0004\u0018\u00010\t0\t2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010?\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010@\u001a\n \u0005*\u0004\u0018\u00010\t0\t2\u0006\u0010\b\u001a\u00020\u0001J\u0018\u0010A\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u00012\b\b\u0002\u0010.\u001a\u00020\u0017J&\u0010A\u001a\u00020\t2\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00010B2\b\b\u0002\u0010.\u001a\u00020\u0017J\"\u0010C\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010D2\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010E\u001a\u00020\tJ\u0016\u0010F\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010D2\u0006\u0010G\u001a\u00020\u000bJ*\u0010F\u001a\n\u0012\u0004\u0012\u0002HH\u0018\u00010D\"\u0004\b\u0000\u0010H2\u0006\u0010G\u001a\u00020\u000b2\f\u0010I\u001a\b\u0012\u0004\u0012\u0002HH0JJ2\u0010K\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t\u0018\u00010B2\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\b\u0002\u0010L\u001a\u00020\t2\b\b\u0002\u0010M\u001a\u00020\tJ\u001c\u0010N\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00010B2\u0006\u0010G\u001a\u00020\u000bJ0\u0010N\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u0002HH\u0018\u00010B\"\u0004\b\u0000\u0010H2\u0006\u0010G\u001a\u00020\u000b2\f\u0010I\u001a\b\u0012\u0004\u0012\u0002HH0JJ\u001c\u0010N\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00010B2\u0006\u0010\u0006\u001a\u00020\u0007J\u001c\u0010N\u001a\u0010\u0012\u0004\u0012\u00020\t\u0012\u0006\u0012\u0004\u0018\u00010\u00010B2\u0006\u0010\f\u001a\u00020\tJ\u000e\u0010O\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tJ)\u0010P\u001a\u0004\u0018\u0001HH\"\u0004\b\u0000\u0010H2\u0006\u0010G\u001a\u00020\u000b2\f\u0010I\u001a\b\u0012\u0004\u0012\u0002HH0J\u00a2\u0006\u0002\u0010QJ'\u0010P\u001a\u0002HH\"\u0004\b\u0000\u0010H2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010I\u001a\b\u0012\u0004\u0012\u0002HH0J\u00a2\u0006\u0002\u0010RJ\"\u0010P\u001a\u0002HH\"\n\b\u0000\u0010H\u0018\u0001*\u00020\u00012\u0006\u0010S\u001a\u00020\tH\u0086\b\u00a2\u0006\u0002\u0010TJ'\u0010P\u001a\u0002HH\"\u0004\b\u0000\u0010H2\u0006\u0010S\u001a\u00020\t2\f\u0010I\u001a\b\u0012\u0004\u0012\u0002HH0J\u00a2\u0006\u0002\u0010UJ\u000e\u0010V\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010W\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0001J\u0016\u0010X\u001a\u00020\u00172\u0006\u0010Y\u001a\u00020\t2\u0006\u0010Z\u001a\u00020\tJ\u000e\u0010[\u001a\n \u0005*\u0004\u0018\u00010\u000e0\u000eJ\b\u0010\\\u001a\u00020+H\u0002J\u0010\u0010]\u001a\n \u0005*\u0004\u0018\u00010-0-H\u0002J(\u0010^\u001a\n \u0005*\u0004\u0018\u00010_0_\"\u0004\b\u0000\u0010H*\u00020+2\f\u0010I\u001a\b\u0012\u0004\u0012\u0002HH0JH\u0002J(\u0010`\u001a\n \u0005*\u0004\u0018\u00010a0a\"\u0004\b\u0000\u0010H*\u00020+2\f\u0010I\u001a\b\u0012\u0004\u0012\u0002HH0JH\u0002\u00a8\u0006b"}, d2={"Lcom/cognifide/gradle/common/utils/Formats;", "", "()V", "asHtml", "Lorg/jsoup/nodes/Document;", "kotlin.jvm.PlatformType", "input", "Ljava/io/InputStream;", "value", "", "asJson", "Lcom/fasterxml/jackson/databind/JsonNode;", "text", "asVersion", "Lorg/gradle/util/GradleVersion;", "partsTaken", "", "asXml", "asYml", "checksum", "file", "Ljava/io/File;", "recalculate", "", "date", "Ljava/util/Date;", "dateAt", "timestamp", "", "zoneId", "Ljava/time/ZoneId;", "dateFileName", "duration", "millis", "durationFit", "thenMillis", "thenZoneId", "durationMillis", "durationSince", "fileSize", "fileSizeBytesToHuman", "bytes", "jsonMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "jsonWriter", "Lcom/fasterxml/jackson/databind/ObjectWriter;", "pretty", "localDateTimeAt", "Ljava/time/LocalDateTime;", "normalizePath", "path", "percent", "current", "total", "percentExplained", "projectPath", "project", "Lorg/gradle/api/Project;", "relativePath", "basePath", "rootProjectPath", "toBase64", "toChecksum", "toChecksumFile", "toHashCodeHex", "toJson", "", "toList", "", "delimiter", "toListFromJson", "jsonNode", "T", "clazz", "Ljava/lang/Class;", "toMap", "valueDelimiter", "keyDelimiter", "toMapFromJson", "toMd5", "toObjectFromJson", "(Lcom/fasterxml/jackson/databind/JsonNode;Ljava/lang/Class;)Ljava/lang/Object;", "(Ljava/io/InputStream;Ljava/lang/Class;)Ljava/lang/Object;", "json", "(Ljava/lang/String;)Ljava/lang/Object;", "(Ljava/lang/String;Ljava/lang/Class;)Ljava/lang/Object;", "toPassword", "toYml", "versionAtLeast", "actual", "required", "versionUnknown", "ymlMapper", "ymlWriter", "listType", "Lcom/fasterxml/jackson/databind/type/CollectionType;", "mapType", "Lcom/fasterxml/jackson/databind/type/MapType;", "common-plugin"})
public final class Formats {
    @NotNull
    public static final Formats INSTANCE;

    @NotNull
    public final GradleVersion asVersion(@NotNull String value, int partsTaken) {
        GradleVersion gradleVersion;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (StringsKt.isBlank((CharSequence)value)) {
            GradleVersion gradleVersion2 = this.versionUnknown();
            Intrinsics.checkNotNullExpressionValue((Object)gradleVersion2, (String)"versionUnknown()");
            return gradleVersion2;
        }
        try {
            GradleVersion gradleVersion3 = GradleVersion.version((String)CollectionsKt.joinToString$default((Iterable)CollectionsKt.take((Iterable)StringsKt.split$default((CharSequence)value, (String[])new String[]{"."}, (boolean)false, (int)0, (int)6, null), (int)partsTaken), (CharSequence)".", null, null, (int)0, null, null, (int)62, null));
            Intrinsics.checkNotNullExpressionValue((Object)gradleVersion3, (String)"GradleVersion.version(va\u2026Taken).joinToString(\".\"))");
            gradleVersion = gradleVersion3;
        }
        catch (IllegalArgumentException e) {
            GradleVersion gradleVersion4 = this.versionUnknown();
            Intrinsics.checkNotNullExpressionValue((Object)gradleVersion4, (String)"versionUnknown()");
            return gradleVersion4;
        }
        return gradleVersion;
    }

    public static /* synthetic */ GradleVersion asVersion$default(Formats formats, String string2, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 3;
        }
        return formats.asVersion(string2, n);
    }

    public final boolean versionAtLeast(@NotNull String actual, @NotNull String required) {
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        Intrinsics.checkNotNullParameter((Object)required, (String)"required");
        return Formats.asVersion$default(this, actual, 0, 2, null).compareTo(Formats.asVersion$default(this, required, 0, 2, null)) >= 0;
    }

    public final GradleVersion versionUnknown() {
        return GradleVersion.version((String)"0.0.0");
    }

    private final <T> MapType mapType(ObjectMapper $this$mapType, Class<T> clazz) {
        return $this$mapType.getTypeFactory().constructMapType(LinkedHashMap.class, String.class, clazz);
    }

    private final <T> CollectionType listType(ObjectMapper $this$listType, Class<T> clazz) {
        return $this$listType.getTypeFactory().constructCollectionType(LinkedList.class, clazz);
    }

    private final ObjectMapper jsonMapper() {
        ObjectMapper objectMapper = new ObjectMapper(new JsonFactory());
        boolean bl = false;
        boolean bl2 = false;
        ObjectMapper $this$apply = objectMapper;
        boolean bl3 = false;
        $this$apply.registerModule((Module)new KotlinModule(0, false, false, false, 15, null));
        return objectMapper;
    }

    /*
     * WARNING - void declaration
     */
    private final ObjectWriter jsonWriter(boolean pretty) {
        ObjectWriter objectWriter;
        ObjectMapper objectMapper = this.jsonMapper();
        boolean bl = false;
        boolean bl2 = false;
        ObjectMapper $this$run = objectMapper;
        boolean bl3 = false;
        if (pretty) {
            void $this$apply;
            DefaultPrettyPrinter defaultPrettyPrinter = new DefaultPrettyPrinter();
            boolean bl4 = false;
            boolean bl5 = false;
            DefaultPrettyPrinter defaultPrettyPrinter2 = defaultPrettyPrinter;
            ObjectMapper objectMapper2 = $this$run;
            boolean bl6 = false;
            $this$apply.indentArraysWith((DefaultPrettyPrinter.Indenter)DefaultIndenter.SYSTEM_LINEFEED_INSTANCE);
            Unit unit = Unit.INSTANCE;
            objectWriter = objectMapper2.writer((PrettyPrinter)defaultPrettyPrinter);
        } else {
            objectWriter = $this$run.writer();
        }
        return objectWriter;
    }

    public final JsonNode asJson(@NotNull InputStream input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return this.jsonMapper().readTree(input);
    }

    public final JsonNode asJson(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return this.jsonMapper().readTree(text2);
    }

    @Nullable
    public final <T> T toObjectFromJson(@NotNull JsonNode jsonNode, @NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter((Object)jsonNode, (String)"jsonNode");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        if (jsonNode.isMissingNode()) {
            return null;
        }
        return (T)this.jsonMapper().treeToValue((TreeNode)jsonNode, clazz);
    }

    @Nullable
    public final <T> Map<String, T> toMapFromJson(@NotNull JsonNode jsonNode, @NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter((Object)jsonNode, (String)"jsonNode");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        if (jsonNode.isMissingNode()) {
            return null;
        }
        ObjectMapper objectMapper = this.jsonMapper();
        boolean bl = false;
        boolean bl2 = false;
        ObjectMapper $this$run = objectMapper;
        boolean bl3 = false;
        Map map2 = (Map)$this$run.convertValue((Object)jsonNode, (JavaType)INSTANCE.mapType($this$run, clazz));
        if (map2 == null) {
            boolean bl4 = false;
            map2 = MapsKt.emptyMap();
        }
        return map2;
    }

    @Nullable
    public final <T> List<T> toListFromJson(@NotNull JsonNode jsonNode, @NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter((Object)jsonNode, (String)"jsonNode");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        if (jsonNode.isMissingNode()) {
            return null;
        }
        ObjectMapper objectMapper = this.jsonMapper();
        boolean bl = false;
        boolean bl2 = false;
        ObjectMapper $this$run = objectMapper;
        boolean bl3 = false;
        List list2 = (List)$this$run.convertValue((Object)jsonNode, (JavaType)INSTANCE.listType($this$run, clazz));
        if (list2 == null) {
            boolean bl4 = false;
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    @NotNull
    public final Map<String, Object> toMapFromJson(@NotNull JsonNode jsonNode) {
        Intrinsics.checkNotNullParameter((Object)jsonNode, (String)"jsonNode");
        if (jsonNode.isMissingNode()) {
            boolean bl = false;
            return MapsKt.emptyMap();
        }
        if (jsonNode.getNodeType() != JsonNodeType.OBJECT) {
            throw (Throwable)((Object)new FormatException("Only JSON node of type '" + JsonNodeType.OBJECT + "' " + "can be converted to map but type '" + jsonNode.getNodeType() + "' detected!\n" + "Ensure that JSON to be converted is not blank."));
        }
        ObjectMapper objectMapper = this.jsonMapper();
        boolean bl = false;
        boolean bl2 = false;
        ObjectMapper $this$run = objectMapper;
        boolean bl3 = false;
        Map map2 = (Map)$this$run.convertValue((Object)jsonNode, (JavaType)INSTANCE.mapType($this$run, Object.class));
        if (map2 == null) {
            boolean bl4 = false;
            map2 = MapsKt.emptyMap();
        }
        return map2;
    }

    @NotNull
    public final List<Object> toListFromJson(@NotNull JsonNode jsonNode) {
        Intrinsics.checkNotNullParameter((Object)jsonNode, (String)"jsonNode");
        if (jsonNode.isMissingNode()) {
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
        if (jsonNode.getNodeType() != JsonNodeType.ARRAY) {
            throw (Throwable)((Object)new FormatException("Only JSON node of type '" + JsonNodeType.ARRAY + "' " + "can be converted to list but type '" + jsonNode.getNodeType() + "' detected!\n" + "Ensure that JSON to be converted is not blank."));
        }
        ObjectMapper objectMapper = this.jsonMapper();
        boolean bl = false;
        boolean bl2 = false;
        ObjectMapper $this$run = objectMapper;
        boolean bl3 = false;
        List list2 = (List)$this$run.convertValue((Object)jsonNode, (JavaType)INSTANCE.listType($this$run, Object.class));
        if (list2 == null) {
            boolean bl4 = false;
            list2 = CollectionsKt.emptyList();
        }
        return list2;
    }

    public final /* synthetic */ <T> T toObjectFromJson(String json) {
        int $i$f$toObjectFromJson = 0;
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return (T)this.toObjectFromJson(json, Object.class);
    }

    public final <T> T toObjectFromJson(@NotNull InputStream input, @NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        return (T)this.jsonMapper().readValue(input, clazz);
    }

    public final <T> T toObjectFromJson(@NotNull String json, @NotNull Class<T> clazz) {
        Intrinsics.checkNotNullParameter((Object)json, (String)"json");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        return (T)this.jsonMapper().readValue(json, clazz);
    }

    @NotNull
    public final Map<String, Object> toMapFromJson(@NotNull InputStream input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        JsonNode jsonNode = this.asJson(input);
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"asJson(input)");
        return this.toMapFromJson(jsonNode);
    }

    @NotNull
    public final Map<String, Object> toMapFromJson(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        JsonNode jsonNode = this.asJson(text2);
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"asJson(text)");
        return this.toMapFromJson(jsonNode);
    }

    @NotNull
    public final String toJson(@NotNull Object value, boolean pretty) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string2 = this.jsonWriter(pretty).writeValueAsString(value);
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public static /* synthetic */ String toJson$default(Formats formats, Object object, boolean bl, int n, Object object2) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return formats.toJson(object, bl);
    }

    @NotNull
    public final String toJson(@NotNull Map<String, ? extends Object> value, boolean pretty) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        String string2 = this.jsonWriter(pretty).writeValueAsString(value);
        if (string2 == null) {
            string2 = "{}";
        }
        return string2;
    }

    public static /* synthetic */ String toJson$default(Formats formats, Map map2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return formats.toJson(map2, bl);
    }

    private final ObjectMapper ymlMapper() {
        ObjectMapper objectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        boolean bl = false;
        boolean bl2 = false;
        ObjectMapper $this$apply = objectMapper;
        boolean bl3 = false;
        $this$apply.registerModule((Module)new KotlinModule(0, false, false, false, 15, null));
        return objectMapper;
    }

    private final ObjectWriter ymlWriter() {
        return this.ymlMapper().writer();
    }

    public final JsonNode asYml(@NotNull InputStream input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        return this.ymlMapper().readTree(input);
    }

    public final JsonNode asYml(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return this.ymlMapper().readTree(text2);
    }

    @NotNull
    public final String toYml(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String string2 = this.ymlWriter().writeValueAsString(value);
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public final Document asHtml(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return Parser.htmlParser().parseInput(value, "");
    }

    public final Document asHtml(@NotNull InputStream input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        InputStream inputStream = input;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        Closeable closeable = inputStream;
        int n = 0;
        closeable = new InputStreamReader((InputStream)closeable, charset);
        n = 8192;
        boolean bl2 = false;
        return Parser.htmlParser().parseInput((Reader)(closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n)), "");
    }

    public final Document asXml(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return Parser.xmlParser().parseInput(value, "");
    }

    public final Document asXml(@NotNull InputStream input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        InputStream inputStream = input;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        Closeable closeable = inputStream;
        int n = 0;
        closeable = new InputStreamReader((InputStream)closeable, charset);
        n = 8192;
        boolean bl2 = false;
        return Parser.xmlParser().parseInput((Reader)(closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n)), "");
    }

    @Nullable
    public final List<String> toList(@Nullable String value, @NotNull String delimiter) {
        String between;
        Intrinsics.checkNotNullParameter((Object)delimiter, (String)"delimiter");
        CharSequence charSequence = value;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return null;
        }
        String string2 = StringUtils.substringBetween((String)value, (String)"[", (String)"]");
        if (string2 == null) {
            string2 = between = value;
        }
        if (StringsKt.isBlank((CharSequence)between)) {
            return null;
        }
        return StringsKt.split$default((CharSequence)between, (String[])new String[]{delimiter}, (boolean)false, (int)0, (int)6, null);
    }

    public static /* synthetic */ List toList$default(Formats formats, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = ",";
        }
        return formats.toList(string2, string3);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Map<String, String> toMap(@Nullable String value, @NotNull String valueDelimiter, @NotNull String keyDelimiter) {
        Map map2;
        Intrinsics.checkNotNullParameter((Object)valueDelimiter, (String)"valueDelimiter");
        Intrinsics.checkNotNullParameter((Object)keyDelimiter, (String)"keyDelimiter");
        List<String> list2 = this.toList(value, valueDelimiter);
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Pair pair;
                void v;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                List list3 = StringsKt.split$default((CharSequence)((CharSequence)v), (String[])new String[]{keyDelimiter}, (boolean)false, (int)0, (int)6, null);
                boolean bl2 = false;
                boolean bl3 = false;
                List e = list3;
                boolean bl4 = false;
                switch (e.size()) {
                    case 2: {
                        pair = TuplesKt.to(e.get(0), e.get(1));
                        break;
                    }
                    default: {
                        pair = TuplesKt.to((Object)v, (Object)"");
                    }
                }
                Pair pair2 = pair;
                collection.add(pair2);
            }
            map2 = MapsKt.toMap((Iterable)((List)destination$iv$iv));
        } else {
            map2 = null;
        }
        return map2;
    }

    public static /* synthetic */ Map toMap$default(Formats formats, String string2, String string3, String string4, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = ",";
        }
        if ((n & 4) != 0) {
            string4 = "=";
        }
        return formats.toMap(string2, string3, string4);
    }

    @NotNull
    public final String toPassword(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return StringsKt.repeat((CharSequence)"*", (int)value.length());
    }

    @NotNull
    public final String toBase64(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Base64.Encoder encoder = Base64.getEncoder();
        String string2 = value;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        String string3 = encoder.encodeToString(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"Base64.getEncoder().enco\u2026ring(value.toByteArray())");
        return string3;
    }

    @NotNull
    public final String toMd5(@NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        String string2 = text2;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] data = byArray;
        messageDigest.update(data, 0, data.length);
        BigInteger result = new BigInteger(1, messageDigest.digest());
        charset = StringCompanionObject.INSTANCE;
        String string3 = "%1$032x";
        Object[] objectArray = new Object[]{result};
        boolean bl2 = false;
        String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
        return string4;
    }

    public final String toHashCodeHex(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return Integer.toHexString(new HashCodeBuilder().append(value).toHashCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String toChecksum(@NotNull File file2) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Object object = file2;
        boolean bl = false;
        object = new FileInputStream((File)object);
        bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            FileInputStream it = (FileInputStream)object;
            boolean bl3 = false;
            string2 = DigestUtils.md5Hex((InputStream)it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return string2;
    }

    @NotNull
    public final File toChecksumFile(@NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return FilesKt.resolveSibling((File)file2, (String)(file2.getName() + ".md5"));
    }

    public final String checksum(@NotNull File file2, boolean recalculate) {
        String string2;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        File file3 = this.toChecksumFile(file2);
        boolean bl = false;
        boolean bl2 = false;
        File checksumFile2 = file3;
        boolean bl3 = false;
        if (recalculate || !checksumFile2.exists()) {
            String string3 = INSTANCE.toChecksum(file2);
            boolean bl4 = false;
            boolean bl5 = false;
            String it = string3;
            boolean bl6 = false;
            String string4 = it;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"it");
            FilesKt.writeText$default((File)checksumFile2, (String)string4, null, (int)2, null);
            string2 = string3;
        } else {
            string2 = FilesKt.readText$default((File)checksumFile2, null, (int)1, null);
        }
        return string2;
    }

    public static /* synthetic */ String checksum$default(Formats formats, File file2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return formats.checksum(file2, bl);
    }

    @NotNull
    public final String fileSize(@NotNull File file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return this.fileSizeBytesToHuman(file2.exists() ? FileUtils.sizeOf((File)file2) : 0L);
    }

    @NotNull
    public final String fileSizeBytesToHuman(long bytes) {
        String string2;
        if (bytes < (long)1024) {
            string2 = bytes + " B";
        } else if (bytes < (long)0x100000) {
            string2 = String.valueOf(bytes / (long)1024) + " KB";
        } else if (bytes < (long)0x40000000) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string3 = "%.2f MB";
            Object[] objectArray = new Object[]{(double)bytes / 1048576.0};
            boolean bl = false;
            String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            string2 = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
        } else {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string5 = "%.2f GB";
            Object[] objectArray = new Object[]{(double)bytes / 1.073741824E9};
            boolean bl = false;
            String string6 = String.format(string5, Arrays.copyOf(objectArray, objectArray.length));
            string2 = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"java.lang.String.format(format, *args)");
        }
        return string2;
    }

    @NotNull
    public final String percent(int current, int total) {
        return this.percent((long)current, (long)total);
    }

    @NotNull
    public final String percentExplained(int current, int total) {
        return "" + current + '/' + total + '=' + this.percent(current, total);
    }

    @NotNull
    public final String percent(long current, long total) {
        long l = total;
        double value = l == 0L ? 0.0 : (double)current / (double)total;
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = "%.2f";
        Object[] objectArray = new Object[]{value * 100.0};
        boolean bl = false;
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(this, *args)");
        return stringBuilder.append(string3).append('%').toString();
    }

    @NotNull
    public final String percentExplained(long current, long total) {
        return "" + current + '/' + total + '=' + this.percent(current, total);
    }

    @NotNull
    public final LocalDateTime localDateTimeAt(long timestamp, @NotNull ZoneId zoneId) {
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(timestamp), zoneId);
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"LocalDateTime.ofInstant(\u2026Milli(timestamp), zoneId)");
        return localDateTime;
    }

    @NotNull
    public final String date(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        String string2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"SimpleDateFormat(\"yyyy-M\u2026d HH:mm:ss\").format(date)");
        return string2;
    }

    public static /* synthetic */ String date$default(Formats formats, Date date, int n, Object object) {
        if ((n & 1) != 0) {
            date = new Date();
        }
        return formats.date(date);
    }

    @NotNull
    public final Date dateAt(long timestamp, @NotNull ZoneId zoneId) {
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        Date date = Date.from(this.localDateTimeAt(timestamp, zoneId).atZone(ZoneId.systemDefault()).toInstant());
        Intrinsics.checkNotNullExpressionValue((Object)date, (String)"Date.from(localDateTimeA\u2026emDefault()).toInstant())");
        return date;
    }

    @NotNull
    public final String dateFileName(@NotNull Date date) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        String string2 = new SimpleDateFormat("yyyyMMddHHmmss").format(date);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"SimpleDateFormat(\"yyyyMMddHHmmss\").format(date)");
        return string2;
    }

    public static /* synthetic */ String dateFileName$default(Formats formats, Date date, int n, Object object) {
        if ((n & 1) != 0) {
            date = new Date();
        }
        return formats.dateFileName(date);
    }

    @NotNull
    public final String duration(long millis) {
        String string2 = DurationFormatUtils.formatDuration((long)RangesKt.coerceAtLeast((long)millis, (long)0L), (String)"mm:ss");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"DurationFormatUtils.form\u2026erceAtLeast(0L), \"mm:ss\")");
        return string2;
    }

    @NotNull
    public final String durationSince(long millis) {
        return this.duration(System.currentTimeMillis() - millis);
    }

    public final boolean durationFit(long thenMillis, @NotNull ZoneId thenZoneId, long durationMillis) {
        Intrinsics.checkNotNullParameter((Object)thenZoneId, (String)"thenZoneId");
        ZonedDateTime nowTimestamp = LocalDateTime.now().atZone(ZoneId.systemDefault());
        LocalDateTime thenTimestamp = this.localDateTimeAt(thenMillis, thenZoneId);
        long diffMillis = ChronoUnit.MILLIS.between(thenTimestamp, nowTimestamp);
        return diffMillis < durationMillis;
    }

    @NotNull
    public final String rootProjectPath(@NotNull File file2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string2 = file2.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.absolutePath");
        return this.rootProjectPath(string2, project);
    }

    @NotNull
    public final String rootProjectPath(@NotNull String path, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Project project2 = project.getRootProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project.rootProject");
        return this.projectPath(path, project2);
    }

    @NotNull
    public final String projectPath(@NotNull File file2, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        String string2 = file2.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.absolutePath");
        return this.projectPath(string2, project);
    }

    @NotNull
    public final String projectPath(@NotNull String path, @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        File file2 = project.getProjectDir();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"project.projectDir");
        String string2 = file2.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"project.projectDir.absolutePath");
        return this.relativePath(path, string2);
    }

    @NotNull
    public final String relativePath(@NotNull String path, @NotNull String basePath) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        Path source = Paths.get(path, new String[0]);
        Path base = Paths.get(basePath, new String[0]);
        return ((Object)base.relativize(source)).toString();
    }

    @NotNull
    public final String normalizePath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return StringsKt.replace$default((String)path, (String)"\\", (String)"/", (boolean)false, (int)4, null);
    }

    private Formats() {
    }

    static {
        Formats formats;
        INSTANCE = formats = new Formats();
    }
}

