/*
 * Decompiled with CFR 0.152.
 */
package com.cognifide.gradle.common.http;

import com.cognifide.gradle.common.CommonExtension;
import com.cognifide.gradle.common.build.ObjectFactory;
import com.cognifide.gradle.common.file.transfer.http.HttpFileTransfer;
import com.cognifide.gradle.common.guava.net.UrlEscapers;
import com.cognifide.gradle.common.http.HttpClient;
import com.cognifide.gradle.common.http.HttpException;
import com.cognifide.gradle.common.http.PreemptiveAuthInterceptor;
import com.cognifide.gradle.common.http.RequestException;
import com.cognifide.gradle.common.http.ResponseException;
import com.cognifide.gradle.common.utils.Formats;
import com.cognifide.gradle.common.utils.FormatsKt;
import com.cognifide.gradle.common.utils.Utils;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0080\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u0094\u00012\u00020\u0001:\u0002\u0094\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010=\u001a\u00020 2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020@0?2\u0006\u0010A\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0002J\u000e\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020\fJ\u000e\u0010B\u001a\u00020C2\u0006\u0010E\u001a\u000209J\u000e\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020\fJ\u000e\u0010F\u001a\u00020G2\u0006\u0010E\u001a\u000209J\u001c\u0010I\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00010J2\u0006\u0010E\u001a\u000209J$\u0010I\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00010J2\u0006\u0010E\u001a\u0002092\u0006\u0010K\u001a\u00020\fJ\u0016\u0010L\u001a\u00020G2\u0006\u0010E\u001a\u0002092\u0006\u0010K\u001a\u00020\fJ\"\u0010M\u001a\u0002HN\"\n\b\u0000\u0010N\u0018\u0001*\u00020\u00012\u0006\u0010E\u001a\u000209H\u0086\b\u00a2\u0006\u0002\u0010OJ'\u0010M\u001a\u0002HN\"\u0004\b\u0000\u0010N2\u0006\u0010E\u001a\u0002092\f\u0010P\u001a\b\u0012\u0004\u0012\u0002HN0Q\u00a2\u0006\u0002\u0010RJ\u000e\u0010S\u001a\u00020T2\u0006\u0010E\u001a\u000209J\u000e\u0010U\u001a\u00020\f2\u0006\u0010E\u001a\u000209J\u000e\u0010V\u001a\u00020C2\u0006\u0010W\u001a\u00020\fJ\u000e\u0010V\u001a\u00020C2\u0006\u0010E\u001a\u000209J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010X\u001a\u00020\fH\u0016J'\u0010Y\u001a\u00020 2\u0006\u0010E\u001a\u0002092\u0017\u0010Z\u001a\u0013\u0012\u0004\u0012\u00020C\u0012\u0004\u0012\u00020\u00070\u001e\u00a2\u0006\u0002\b!J\u0016\u0010[\u001a\u00020 2\u0006\u0010E\u001a\u0002092\u0006\u0010\\\u001a\u00020'J\u001c\u0010[\u001a\u00020 2\u0006\u0010E\u001a\u0002092\f\u0010]\u001a\b\u0012\u0004\u0012\u00020'0^J\u0018\u0010[\u001a\u00020 2\u0006\u0010E\u001a\u0002092\b\b\u0002\u0010]\u001a\u00020_J \u0010`\u001a\u00020 2\u0006\u0010E\u001a\u0002092\u0006\u0010a\u001a\u00020\f2\b\b\u0002\u0010b\u001a\u00020\u0007J*\u0010\u0019\u001a\u0002HN\"\u0004\b\u0000\u0010N2\u0017\u0010c\u001a\u0013\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u0002HN0\u001e\u00a2\u0006\u0002\b!\u00a2\u0006\u0002\u0010dJ\u001f\u0010\u001d\u001a\u00020 2\u0017\u0010e\u001a\u0013\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001e\u00a2\u0006\u0002\b!J\u001e\u0010f\u001a\u00020g2\u0014\u0010h\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00010JH\u0016J\u001e\u0010i\u001a\u00020g2\u0014\u0010h\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00010JH\u0016J\u000e\u0010j\u001a\u00020 2\u0006\u0010X\u001a\u00020\fJ8\u0010j\u001a\u0002HN\"\u0004\b\u0000\u0010N2\u0006\u0010X\u001a\u00020\f2\u001d\u0010k\u001a\u0019\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u0002HN0l\u00a2\u0006\u0002\b!\u00a2\u0006\u0002\u0010mJQ\u0010j\u001a\u0002HN\"\u0004\b\u0000\u0010N2\u0006\u0010X\u001a\u00020\f2\u001d\u0010k\u001a\u0019\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u0002HN0l\u00a2\u0006\u0002\b!2\u0017\u0010n\u001a\u0013\u0012\u0004\u0012\u00020o\u0012\u0004\u0012\u00020 0\u001e\u00a2\u0006\u0002\b!\u00a2\u0006\u0002\u0010pJ\u000e\u0010q\u001a\u00020r2\u0006\u0010s\u001a\u00020\fJ\u0016\u0010q\u001a\u00020 2\u0006\u0010s\u001a\u00020\f2\u0006\u0010t\u001a\u00020rJ\u0016\u0010u\u001a\u00020r2\u0006\u0010s\u001a\u00020\f2\u0006\u0010v\u001a\u00020rJ\u000e\u0010w\u001a\u00020 2\u0006\u0010x\u001a\u000207J:\u0010w\u001a\u0002HN\"\u0004\b\u0000\u0010N2\u0006\u0010x\u001a\u0002072\u001d\u0010k\u001a\u0019\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u0002HN0l\u00a2\u0006\u0002\b!H\u0016\u00a2\u0006\u0002\u0010yJ,\u0010z\u001a\u0002HN\"\u0004\b\u0000\u0010N2\u0017\u0010{\u001a\u0013\u0012\u0004\u0012\u00020|\u0012\u0004\u0012\u0002HN0\u001e\u00a2\u0006\u0002\b!H\u0002\u00a2\u0006\u0002\u0010dJ\u000e\u0010}\u001a\u00020 2\u0006\u0010X\u001a\u00020\fJ8\u0010}\u001a\u0002HN\"\u0004\b\u0000\u0010N2\u0006\u0010X\u001a\u00020\f2\u001d\u0010k\u001a\u0019\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u0002HN0l\u00a2\u0006\u0002\b!\u00a2\u0006\u0002\u0010mJQ\u0010}\u001a\u0002HN\"\u0004\b\u0000\u0010N2\u0006\u0010X\u001a\u00020\f2\u001d\u0010k\u001a\u0019\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u0002HN0l\u00a2\u0006\u0002\b!2\u0017\u0010n\u001a\u0013\u0012\u0004\u0012\u00020~\u0012\u0004\u0012\u00020 0\u001e\u00a2\u0006\u0002\b!\u00a2\u0006\u0002\u0010pJ\u000e\u0010\u007f\u001a\u00020 2\u0006\u0010X\u001a\u00020\fJ8\u0010\u007f\u001a\u0002HN\"\u0004\b\u0000\u0010N2\u0006\u0010X\u001a\u00020\f2\u001d\u0010k\u001a\u0019\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u0002HN0l\u00a2\u0006\u0002\b!\u00a2\u0006\u0002\u0010mJR\u0010\u007f\u001a\u0002HN\"\u0004\b\u0000\u0010N2\u0006\u0010X\u001a\u00020\f2\u001d\u0010k\u001a\u0019\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u0002HN0l\u00a2\u0006\u0002\b!2\u0018\u0010n\u001a\u0014\u0012\u0005\u0012\u00030\u0080\u0001\u0012\u0004\u0012\u00020 0\u001e\u00a2\u0006\u0002\b!\u00a2\u0006\u0002\u0010pJ\u0010\u0010\u0081\u0001\u001a\u00020 2\u0007\u0010\u0082\u0001\u001a\u00020\fJ9\u0010\u0081\u0001\u001a\u0002HN\"\u0004\b\u0000\u0010N2\u0006\u0010X\u001a\u00020\f2\u001d\u0010k\u001a\u0019\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u0002HN0l\u00a2\u0006\u0002\b!\u00a2\u0006\u0002\u0010mJS\u0010\u0081\u0001\u001a\u0002HN\"\u0004\b\u0000\u0010N2\u0006\u0010X\u001a\u00020\f2\u001d\u0010k\u001a\u0019\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u0002HN0l\u00a2\u0006\u0002\b!2\u0018\u0010n\u001a\u0014\u0012\u0005\u0012\u00030\u0083\u0001\u0012\u0004\u0012\u00020 0\u001e\u00a2\u0006\u0002\b!\u00a2\u0006\u0002\u0010pJ9\u0010\u0084\u0001\u001a\u0002HN\"\u0004\b\u0000\u0010N2\u0006\u0010X\u001a\u00020\f2\u001d\u0010k\u001a\u0019\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u0002HN0l\u00a2\u0006\u0002\b!\u00a2\u0006\u0002\u0010mJS\u0010\u0084\u0001\u001a\u0002HN\"\u0004\b\u0000\u0010N2\u0006\u0010X\u001a\u00020\f2\u001d\u0010k\u001a\u0019\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u0002HN0l\u00a2\u0006\u0002\b!2\u0018\u0010n\u001a\u0014\u0012\u0005\u0012\u00030\u0085\u0001\u0012\u0004\u0012\u00020 0\u001e\u00a2\u0006\u0002\b!\u00a2\u0006\u0002\u0010pJ(\u0010\u0084\u0001\u001a\u00020 2\u0007\u0010\u0086\u0001\u001a\u00020\f2\u0016\b\u0002\u0010h\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00010JJR\u0010\u0084\u0001\u001a\u0002HN\"\u0004\b\u0000\u0010N2\u0006\u0010X\u001a\u00020\f2\u0016\b\u0002\u0010h\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00010J2\u001d\u0010k\u001a\u0019\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u0002HN0l\u00a2\u0006\u0002\b!\u00a2\u0006\u0003\u0010\u0087\u0001J'\u0010\u0088\u0001\u001a\u00020 2\u0006\u0010X\u001a\u00020\f2\u0016\b\u0002\u0010h\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00010JJR\u0010\u0088\u0001\u001a\u0002HN\"\u0004\b\u0000\u0010N2\u0006\u0010X\u001a\u00020\f2\u0016\b\u0002\u0010h\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00010J2\u001d\u0010k\u001a\u0019\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u0002HN0l\u00a2\u0006\u0002\b!\u00a2\u0006\u0003\u0010\u0087\u0001J'\u0010\u0089\u0001\u001a\u00020 2\u0006\u0010X\u001a\u00020\f2\u0016\b\u0002\u0010h\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00010JJR\u0010\u0089\u0001\u001a\u0002HN\"\u0004\b\u0000\u0010N2\u0006\u0010X\u001a\u00020\f2\u0016\b\u0002\u0010h\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00010J2\u001d\u0010k\u001a\u0019\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u0002HN0l\u00a2\u0006\u0002\b!\u00a2\u0006\u0003\u0010\u0087\u0001J\u000f\u0010\u008a\u0001\u001a\u00020 2\u0006\u0010X\u001a\u00020\fJ9\u0010\u008a\u0001\u001a\u0002HN\"\u0004\b\u0000\u0010N2\u0006\u0010X\u001a\u00020\f2\u001d\u0010k\u001a\u0019\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u0002HN0l\u00a2\u0006\u0002\b!\u00a2\u0006\u0002\u0010mJS\u0010\u008a\u0001\u001a\u0002HN\"\u0004\b\u0000\u0010N2\u0006\u0010X\u001a\u00020\f2\u001d\u0010k\u001a\u0019\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u0002HN0l\u00a2\u0006\u0002\b!2\u0018\u0010n\u001a\u0014\u0012\u0005\u0012\u00030\u008b\u0001\u0012\u0004\u0012\u00020 0\u001e\u00a2\u0006\u0002\b!\u00a2\u0006\u0002\u0010pJB\u0010\u008c\u0001\u001a\u0002HN\"\u0004\b\u0000\u0010N2\u0006\u0010x\u001a\u00020\f2\u0006\u0010X\u001a\u00020\f2\u001d\u0010k\u001a\u0019\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u0002HN0l\u00a2\u0006\u0002\b!\u00a2\u0006\u0003\u0010\u008d\u0001J \u00106\u001a\u00020 2\u0018\u0010\u008e\u0001\u001a\u0013\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020 0\u001e\u00a2\u0006\u0002\b!J\u001b\u00108\u001a\u00020 2\u0013\u0010\u008f\u0001\u001a\u000e\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u00020 0\u001eJ\u001a\u0010<\u001a\u00020 2\u0012\u0010k\u001a\u000e\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u00020 0\u001eJ\u0011\u0010\u0090\u0001\u001a\u00020 2\u0006\u0010E\u001a\u000209H\u0016J \u0010\u0091\u0001\u001a\u00020 *\u00030\u0092\u00012\u0006\u0010A\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0002J\u000b\u0010\u0093\u0001\u001a\u00020 *\u00020\u001fR5\u0010\u0005\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007 \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR5\u0010\u000b\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010\f0\f \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\f0\f\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nRD\u0010\u0010\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000f2\u0016\u0010\u000e\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\f\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000f8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R5\u0010\u0015\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010\f0\f \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\f0\f\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\nR5\u0010\u0017\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010\f0\f \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\f0\f\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\nR\u001c\u0010\u0019\u001a\n \b*\u0004\u0018\u00010\u001a0\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u001f\u0010\u001d\u001a\u0013\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020 0\u001e\u00a2\u0006\u0002\b!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R5\u0010\"\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007 \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\nR5\u0010$\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007 \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\nR5\u0010&\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010'0' \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010'0'\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010\nR\u0016\u0010)\u001a\n \b*\u0004\u0018\u00010*0*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R5\u0010+\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010,0, \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010,0,\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\nR5\u0010.\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010,0, \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010,0,\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\nR5\u00100\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010\f0\f \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\f0\f\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u0010\nR5\u00102\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010'0' \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010'0'\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\nR5\u00104\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010\f0\f \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\f0\f\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\nR\u001f\u00106\u001a\u0013\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020 0\u001e\u00a2\u0006\u0002\b!X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00108\u001a\u000e\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u00020 0\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R5\u0010:\u001a&\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007 \b*\u0012\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u0007\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010\nR\u001a\u0010<\u001a\u000e\u0012\u0004\u0012\u000209\u0012\u0004\u0012\u00020 0\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0095\u0001"}, d2={"Lcom/cognifide/gradle/common/http/HttpClient;", "", "common", "Lcom/cognifide/gradle/common/CommonExtension;", "(Lcom/cognifide/gradle/common/CommonExtension;)V", "authorizationPreemptive", "Lorg/gradle/api/provider/Property;", "", "kotlin.jvm.PlatformType", "getAuthorizationPreemptive", "()Lorg/gradle/api/provider/Property;", "baseUrl", "", "getBaseUrl", "value", "Lkotlin/Pair;", "basicCredentials", "getBasicCredentials", "()Lkotlin/Pair;", "setBasicCredentials", "(Lkotlin/Pair;)V", "basicPassword", "getBasicPassword", "basicUser", "getBasicUser", "client", "Lorg/apache/http/impl/client/CloseableHttpClient;", "getClient", "()Lorg/apache/http/impl/client/CloseableHttpClient;", "clientBuilder", "Lkotlin/Function1;", "Lorg/apache/http/impl/client/HttpClientBuilder;", "", "Lkotlin/ExtensionFunctionType;", "connectionIgnoreSsl", "getConnectionIgnoreSsl", "connectionRetries", "getConnectionRetries", "connectionTimeout", "", "getConnectionTimeout", "logger", "Lorg/gradle/api/logging/Logger;", "multipartBinaryType", "Lorg/apache/http/entity/ContentType;", "getMultipartBinaryType", "multipartTextType", "getMultipartTextType", "proxyHost", "getProxyHost", "proxyPort", "getProxyPort", "proxyScheme", "getProxyScheme", "requestConfigurer", "Lorg/apache/http/client/methods/HttpRequestBase;", "responseChecker", "Lorg/apache/http/HttpResponse;", "responseChecks", "getResponseChecks", "responseHandler", "addEntityUrlencoded", "result", "", "Lorg/apache/http/NameValuePair;", "key", "asHtml", "Lorg/jsoup/nodes/Document;", "htmlString", "response", "asJson", "Lcom/fasterxml/jackson/databind/JsonNode;", "jsonString", "asMapFromJson", "", "jsonPointer", "asNodeFromJson", "asObjectFromJson", "T", "(Lorg/apache/http/HttpResponse;)Ljava/lang/Object;", "clazz", "Ljava/lang/Class;", "(Lorg/apache/http/HttpResponse;Ljava/lang/Class;)Ljava/lang/Object;", "asStream", "Ljava/io/InputStream;", "asString", "asXml", "xmlString", "uri", "checkHtml", "validator", "checkStatus", "statusCode", "statusCodes", "", "Lkotlin/ranges/IntRange;", "checkText", "containedText", "ignoreCase", "action", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "builder", "createEntityMultipart", "Lorg/apache/http/HttpEntity;", "params", "createEntityUrlencoded", "delete", "handler", "Lkotlin/Function2;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "options", "Lorg/apache/http/client/methods/HttpDelete;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "download", "Ljava/io/File;", "fileUrl", "target", "downloadTo", "dir", "execute", "method", "(Lorg/apache/http/client/methods/HttpRequestBase;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "fileTransfer", "operation", "Lcom/cognifide/gradle/common/file/transfer/http/HttpFileTransfer;", "get", "Lorg/apache/http/client/methods/HttpGet;", "head", "Lorg/apache/http/client/methods/HttpHead;", "patch", "path", "Lorg/apache/http/client/methods/HttpPatch;", "post", "Lorg/apache/http/client/methods/HttpPost;", "url", "(Ljava/lang/String;Ljava/util/Map;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "postMultipart", "postUrlencoded", "put", "Lorg/apache/http/client/methods/HttpPut;", "request", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "configurer", "checker", "throwStatusException", "addEntityMultipart", "Lorg/apache/http/entity/mime/MultipartEntityBuilder;", "useDefaults", "Companion", "common-plugin"})
public class HttpClient {
    private final Logger logger;
    private final Property<Integer> connectionTimeout;
    private final Property<Boolean> connectionIgnoreSsl;
    private final Property<Boolean> connectionRetries;
    private final Property<Boolean> authorizationPreemptive;
    private final Property<String> baseUrl;
    private final Property<String> basicUser;
    private final Property<String> basicPassword;
    private final Property<ContentType> multipartTextType;
    private final Property<ContentType> multipartBinaryType;
    private final Property<String> proxyHost;
    private final Property<Integer> proxyPort;
    private final Property<String> proxyScheme;
    private Function1<? super HttpRequestBase, Unit> requestConfigurer;
    private Function1<? super HttpClientBuilder, Unit> clientBuilder;
    private Function1<? super HttpResponse, Unit> responseHandler;
    private final Property<Boolean> responseChecks;
    private Function1<? super HttpResponse, Unit> responseChecker;
    private final CommonExtension common;
    @NotNull
    private static final IntRange STATUS_CODE_VALID;
    @NotNull
    public static final Companion Companion;

    public final Property<Integer> getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public final Property<Boolean> getConnectionIgnoreSsl() {
        return this.connectionIgnoreSsl;
    }

    public final Property<Boolean> getConnectionRetries() {
        return this.connectionRetries;
    }

    public final Property<Boolean> getAuthorizationPreemptive() {
        return this.authorizationPreemptive;
    }

    public final Property<String> getBaseUrl() {
        return this.baseUrl;
    }

    public final Property<String> getBasicUser() {
        return this.basicUser;
    }

    public final Property<String> getBasicPassword() {
        return this.basicPassword;
    }

    @NotNull
    public final Pair<String, String> getBasicCredentials() {
        block3: {
            block2: {
                Property<String> property = this.basicUser;
                Intrinsics.checkNotNullExpressionValue(property, (String)"basicUser");
                if (!property.isPresent()) break block2;
                Property<String> property2 = this.basicPassword;
                Intrinsics.checkNotNullExpressionValue(property2, (String)"basicPassword");
                if (property2.isPresent()) break block3;
            }
            throw (Throwable)((Object)new HttpException("HTTP client basic credentials are missing!"));
        }
        return TuplesKt.to((Object)this.basicUser.get(), (Object)this.basicPassword.get());
    }

    public final void setBasicCredentials(@NotNull Pair<String, String> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.basicUser.set(value.getFirst());
        this.basicPassword.set(value.getSecond());
    }

    public final Property<ContentType> getMultipartTextType() {
        return this.multipartTextType;
    }

    public final Property<ContentType> getMultipartBinaryType() {
        return this.multipartBinaryType;
    }

    public final Property<String> getProxyHost() {
        return this.proxyHost;
    }

    public final Property<Integer> getProxyPort() {
        return this.proxyPort;
    }

    public final Property<String> getProxyScheme() {
        return this.proxyScheme;
    }

    public final void requestConfigurer(@NotNull Function1<? super HttpRequestBase, Unit> configurer) {
        Intrinsics.checkNotNullParameter(configurer, (String)"configurer");
        this.requestConfigurer = configurer;
    }

    public final void clientBuilder(@NotNull Function1<? super HttpClientBuilder, Unit> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        this.clientBuilder = builder;
    }

    public final void useDefaults(@NotNull HttpClientBuilder $this$useDefaults) {
        Unit unit;
        CharSequence $this$apply;
        HttpClientBuilder httpClientBuilder;
        Intrinsics.checkNotNullParameter((Object)$this$useDefaults, (String)"$this$useDefaults");
        Property<String> property = this.basicUser;
        Intrinsics.checkNotNullExpressionValue(property, (String)"basicUser");
        CharSequence charSequence = (CharSequence)property.getOrNull();
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            Property<String> property2 = this.basicPassword;
            Intrinsics.checkNotNullExpressionValue(property2, (String)"basicPassword");
            charSequence = (CharSequence)property2.getOrNull();
            bl = false;
            bl2 = false;
            if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
                Object object = this.authorizationPreemptive.get();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"authorizationPreemptive.get()");
                if (((Boolean)object).booleanValue()) {
                    $this$useDefaults.addInterceptorFirst((HttpRequestInterceptor)new PreemptiveAuthInterceptor());
                }
                charSequence = new BasicCredentialsProvider();
                bl = false;
                bl2 = false;
                CharSequence charSequence2 = charSequence;
                httpClientBuilder = $this$useDefaults;
                boolean bl3 = false;
                $this$apply.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials((String)this.basicUser.get(), (String)this.basicPassword.get()));
                unit = Unit.INSTANCE;
                httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)charSequence);
            }
        }
        charSequence = RequestConfig.custom();
        bl = false;
        bl2 = false;
        $this$apply = charSequence;
        httpClientBuilder = $this$useDefaults;
        boolean bl4 = false;
        $this$apply.setCookieSpec("standard");
        if (!((Boolean)this.connectionRetries.get()).booleanValue()) {
            Object object = this.connectionTimeout.get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"connectionTimeout.get()");
            $this$apply.setSocketTimeout(((Number)object).intValue());
        }
        Object object = this.connectionTimeout.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"connectionTimeout.get()");
        $this$apply.setConnectTimeout(((Number)object).intValue());
        Object object2 = this.connectionTimeout.get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"connectionTimeout.get()");
        $this$apply.setConnectionRequestTimeout(((Number)object2).intValue());
        unit = Unit.INSTANCE;
        httpClientBuilder.setDefaultRequestConfig(charSequence.build());
        Property<String> property3 = this.proxyHost;
        Intrinsics.checkNotNullExpressionValue(property3, (String)"proxyHost");
        charSequence = (CharSequence)property3.getOrNull();
        bl = false;
        bl2 = false;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            Property<Integer> property4 = this.proxyPort;
            Intrinsics.checkNotNullExpressionValue(property4, (String)"proxyPort");
            if (property4.isPresent()) {
                String string2 = (String)this.proxyHost.get();
                Object object3 = this.proxyPort.get();
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"proxyPort.get()");
                $this$useDefaults.setProxy(new HttpHost(string2, ((Number)object3).intValue(), (String)this.proxyScheme.get()));
            }
        }
        Object object4 = this.connectionIgnoreSsl.get();
        Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"connectionIgnoreSsl.get()");
        if (((Boolean)object4).booleanValue()) {
            $this$useDefaults.setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(new SSLContextBuilder().loadTrustMaterial(null, (TrustStrategy)useDefaults.3.INSTANCE).build(), (HostnameVerifier)NoopHostnameVerifier.INSTANCE));
        }
        if (!((Boolean)this.connectionRetries.get()).booleanValue()) {
            $this$useDefaults.disableAutomaticRetries();
        }
    }

    private final CloseableHttpClient getClient() {
        HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
        Function1<? super HttpClientBuilder, Unit> function1 = this.clientBuilder;
        boolean bl = false;
        boolean bl2 = false;
        function1.invoke((Object)httpClientBuilder);
        return httpClientBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T client(@NotNull Function1<? super CloseableHttpClient, ? extends T> action) {
        Object object;
        Intrinsics.checkNotNullParameter(action, (String)"action");
        Closeable closeable = (Closeable)this.getClient();
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        try {
            object = action.invoke((Object)closeable);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return (T)object;
    }

    public final void responseHandler(@NotNull Function1<? super HttpResponse, Unit> handler) {
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        this.responseHandler = handler;
    }

    public final Property<Boolean> getResponseChecks() {
        return this.responseChecks;
    }

    public final void responseChecker(@NotNull Function1<? super HttpResponse, Unit> checker) {
        Intrinsics.checkNotNullParameter(checker, (String)"checker");
        this.responseChecker = checker;
    }

    public final <T> T request(@NotNull String method, @NotNull String uri, @NotNull Function2<? super HttpClient, ? super HttpResponse, ? extends T> handler) {
        T t;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        String string2 = method;
        boolean bl = false;
        String string3 = string2.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase()");
        switch (string3) {
            case "get": {
                t = this.get(uri, handler);
                break;
            }
            case "post": {
                t = this.post(uri, handler);
                break;
            }
            case "put": {
                t = this.put(uri, handler);
                break;
            }
            case "patch": {
                t = this.patch(uri, handler);
                break;
            }
            case "head": {
                t = this.head(uri, handler);
                break;
            }
            case "delete": {
                t = this.delete(uri, handler);
                break;
            }
            default: {
                throw (Throwable)((Object)new RequestException("Invalid HTTP client method: '" + method + '\''));
            }
        }
        return t;
    }

    public final void get(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        this.get(uri, get.1.INSTANCE);
    }

    public final <T> T get(@NotNull String uri, @NotNull Function2<? super HttpClient, ? super HttpResponse, ? extends T> handler) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        return this.get(uri, handler, (Function1<? super HttpGet, Unit>)((Function1)get.2.INSTANCE));
    }

    public final <T> T get(@NotNull String uri, @NotNull Function2<? super HttpClient, ? super HttpResponse, ? extends T> handler, @NotNull Function1<? super HttpGet, Unit> options2) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        Intrinsics.checkNotNullParameter(options2, (String)"options");
        HttpGet httpGet = new HttpGet(this.baseUrl(uri));
        boolean bl = false;
        boolean bl2 = false;
        options2.invoke((Object)httpGet);
        return this.execute((HttpRequestBase)httpGet, handler);
    }

    public final void head(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        this.head(uri, head.1.INSTANCE);
    }

    public final <T> T head(@NotNull String uri, @NotNull Function2<? super HttpClient, ? super HttpResponse, ? extends T> handler) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        return this.head(uri, handler, (Function1<? super HttpHead, Unit>)((Function1)head.2.INSTANCE));
    }

    public final <T> T head(@NotNull String uri, @NotNull Function2<? super HttpClient, ? super HttpResponse, ? extends T> handler, @NotNull Function1<? super HttpHead, Unit> options2) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        Intrinsics.checkNotNullParameter(options2, (String)"options");
        HttpHead httpHead = new HttpHead(this.baseUrl(uri));
        boolean bl = false;
        boolean bl2 = false;
        options2.invoke((Object)httpHead);
        return this.execute((HttpRequestBase)httpHead, handler);
    }

    public final void delete(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        this.delete(uri, delete.1.INSTANCE);
    }

    public final <T> T delete(@NotNull String uri, @NotNull Function2<? super HttpClient, ? super HttpResponse, ? extends T> handler) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        return this.delete(uri, handler, (Function1<? super HttpDelete, Unit>)((Function1)delete.2.INSTANCE));
    }

    public final <T> T delete(@NotNull String uri, @NotNull Function2<? super HttpClient, ? super HttpResponse, ? extends T> handler, @NotNull Function1<? super HttpDelete, Unit> options2) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        Intrinsics.checkNotNullParameter(options2, (String)"options");
        HttpDelete httpDelete = new HttpDelete(this.baseUrl(uri));
        boolean bl = false;
        boolean bl2 = false;
        options2.invoke((Object)httpDelete);
        return this.execute((HttpRequestBase)httpDelete, handler);
    }

    public final void put(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        this.put(uri, put.1.INSTANCE);
    }

    public final <T> T put(@NotNull String uri, @NotNull Function2<? super HttpClient, ? super HttpResponse, ? extends T> handler) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        return this.put(uri, handler, (Function1<? super HttpPut, Unit>)((Function1)put.2.INSTANCE));
    }

    public final <T> T put(@NotNull String uri, @NotNull Function2<? super HttpClient, ? super HttpResponse, ? extends T> handler, @NotNull Function1<? super HttpPut, Unit> options2) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        Intrinsics.checkNotNullParameter(options2, (String)"options");
        HttpPut httpPut = new HttpPut(this.baseUrl(uri));
        boolean bl = false;
        boolean bl2 = false;
        options2.invoke((Object)httpPut);
        return this.execute((HttpRequestBase)httpPut, handler);
    }

    public final void patch(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.patch(path, patch.1.INSTANCE);
    }

    public final <T> T patch(@NotNull String uri, @NotNull Function2<? super HttpClient, ? super HttpResponse, ? extends T> handler) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        return this.patch(uri, handler, (Function1<? super HttpPatch, Unit>)((Function1)patch.2.INSTANCE));
    }

    public final <T> T patch(@NotNull String uri, @NotNull Function2<? super HttpClient, ? super HttpResponse, ? extends T> handler, @NotNull Function1<? super HttpPatch, Unit> options2) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        Intrinsics.checkNotNullParameter(options2, (String)"options");
        HttpPatch httpPatch = new HttpPatch(this.baseUrl(uri));
        boolean bl = false;
        boolean bl2 = false;
        options2.invoke((Object)httpPatch);
        return this.execute((HttpRequestBase)httpPatch, handler);
    }

    public final void post(@NotNull String url, @NotNull Map<String, ? extends Object> params) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(params, (String)"params");
        this.postUrlencoded(url, params);
    }

    public static /* synthetic */ void post$default(HttpClient httpClient, String string2, Map map2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: post");
        }
        if ((n & 2) != 0) {
            boolean bl = false;
            map2 = MapsKt.emptyMap();
        }
        httpClient.post(string2, map2);
    }

    public final <T> T post(@NotNull String uri, @NotNull Map<String, ? extends Object> params, @NotNull Function2<? super HttpClient, ? super HttpResponse, ? extends T> handler) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(params, (String)"params");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        return this.postUrlencoded(uri, params, handler);
    }

    public static /* synthetic */ Object post$default(HttpClient httpClient, String string2, Map map2, Function2 function2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: post");
        }
        if ((n & 2) != 0) {
            boolean bl = false;
            map2 = MapsKt.emptyMap();
        }
        return httpClient.post(string2, map2, function2);
    }

    public final void postUrlencoded(@NotNull String uri, @NotNull Map<String, ? extends Object> params) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(params, (String)"params");
        this.postUrlencoded(uri, params, postUrlencoded.1.INSTANCE);
    }

    public static /* synthetic */ void postUrlencoded$default(HttpClient httpClient, String string2, Map map2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: postUrlencoded");
        }
        if ((n & 2) != 0) {
            boolean bl = false;
            map2 = MapsKt.emptyMap();
        }
        httpClient.postUrlencoded(string2, map2);
    }

    public final <T> T postUrlencoded(@NotNull String uri, @NotNull Map<String, ? extends Object> params, @NotNull Function2<? super HttpClient, ? super HttpResponse, ? extends T> handler) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(params, (String)"params");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        return this.post(uri, handler, (Function1<? super HttpPost, Unit>)((Function1)new Function1<HttpPost, Unit>(this, params){
            final /* synthetic */ HttpClient this$0;
            final /* synthetic */ Map $params;

            public final void invoke(@NotNull HttpPost $this$post) {
                Intrinsics.checkNotNullParameter((Object)$this$post, (String)"$receiver");
                $this$post.setEntity(this.this$0.createEntityUrlencoded(this.$params));
            }
            {
                this.this$0 = httpClient;
                this.$params = map2;
                super(1);
            }
        }));
    }

    public static /* synthetic */ Object postUrlencoded$default(HttpClient httpClient, String string2, Map map2, Function2 function2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: postUrlencoded");
        }
        if ((n & 2) != 0) {
            boolean bl = false;
            map2 = MapsKt.emptyMap();
        }
        return httpClient.postUrlencoded(string2, map2, function2);
    }

    public final void postMultipart(@NotNull String uri, @NotNull Map<String, ? extends Object> params) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(params, (String)"params");
        this.postMultipart(uri, params, postMultipart.1.INSTANCE);
    }

    public static /* synthetic */ void postMultipart$default(HttpClient httpClient, String string2, Map map2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: postMultipart");
        }
        if ((n & 2) != 0) {
            boolean bl = false;
            map2 = MapsKt.emptyMap();
        }
        httpClient.postMultipart(string2, map2);
    }

    public final <T> T postMultipart(@NotNull String uri, @NotNull Map<String, ? extends Object> params, @NotNull Function2<? super HttpClient, ? super HttpResponse, ? extends T> handler) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(params, (String)"params");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        return this.post(uri, handler, (Function1<? super HttpPost, Unit>)((Function1)new Function1<HttpPost, Unit>(this, params){
            final /* synthetic */ HttpClient this$0;
            final /* synthetic */ Map $params;

            public final void invoke(@NotNull HttpPost $this$post) {
                Intrinsics.checkNotNullParameter((Object)$this$post, (String)"$receiver");
                $this$post.setEntity(this.this$0.createEntityMultipart(this.$params));
            }
            {
                this.this$0 = httpClient;
                this.$params = map2;
                super(1);
            }
        }));
    }

    public static /* synthetic */ Object postMultipart$default(HttpClient httpClient, String string2, Map map2, Function2 function2, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: postMultipart");
        }
        if ((n & 2) != 0) {
            boolean bl = false;
            map2 = MapsKt.emptyMap();
        }
        return httpClient.postMultipart(string2, map2, function2);
    }

    public final <T> T post(@NotNull String uri, @NotNull Function2<? super HttpClient, ? super HttpResponse, ? extends T> handler) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        return this.post(uri, handler, (Function1<? super HttpPost, Unit>)((Function1)post.1.INSTANCE));
    }

    public final <T> T post(@NotNull String uri, @NotNull Function2<? super HttpClient, ? super HttpResponse, ? extends T> handler, @NotNull Function1<? super HttpPost, Unit> options2) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        Intrinsics.checkNotNullParameter(options2, (String)"options");
        HttpPost httpPost = new HttpPost(this.baseUrl(uri));
        boolean bl = false;
        boolean bl2 = false;
        options2.invoke((Object)httpPost);
        return this.execute((HttpRequestBase)httpPost, handler);
    }

    @NotNull
    public final InputStream asStream(@NotNull HttpResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Object object = this.responseChecks.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"responseChecks.get()");
        if (((Boolean)object).booleanValue()) {
            this.responseChecker.invoke((Object)response);
        }
        HttpEntity httpEntity = response.getEntity();
        Intrinsics.checkNotNullExpressionValue((Object)httpEntity, (String)"response.entity");
        InputStream inputStream = httpEntity.getContent();
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"response.entity.content");
        return inputStream;
    }

    @NotNull
    public final JsonNode asJson(@NotNull HttpResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        JsonNode jsonNode = Formats.INSTANCE.asJson(this.asStream(response));
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"Formats.asJson(asStream(response))");
        return jsonNode;
    }

    @NotNull
    public final JsonNode asJson(@NotNull String jsonString) {
        Intrinsics.checkNotNullParameter((Object)jsonString, (String)"jsonString");
        JsonNode jsonNode = Formats.INSTANCE.asJson(jsonString);
        Intrinsics.checkNotNullExpressionValue((Object)jsonNode, (String)"Formats.asJson(jsonString)");
        return jsonNode;
    }

    @NotNull
    public final Document asHtml(@NotNull HttpResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Document document = Formats.INSTANCE.asHtml(this.asStream(response));
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"Formats.asHtml(asStream(response))");
        return document;
    }

    @NotNull
    public final Document asHtml(@NotNull String htmlString) {
        Intrinsics.checkNotNullParameter((Object)htmlString, (String)"htmlString");
        Document document = Formats.INSTANCE.asHtml(htmlString);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"Formats.asHtml(htmlString)");
        return document;
    }

    @NotNull
    public final Document asXml(@NotNull HttpResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Document document = Formats.INSTANCE.asXml(this.asStream(response));
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"Formats.asXml(asStream(response))");
        return document;
    }

    @NotNull
    public final Document asXml(@NotNull String xmlString) {
        Intrinsics.checkNotNullParameter((Object)xmlString, (String)"xmlString");
        Document document = Formats.INSTANCE.asXml(xmlString);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"Formats.asXml(xmlString)");
        return document;
    }

    @NotNull
    public final String asString(@NotNull HttpResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        String string2 = IOUtils.toString((InputStream)this.asStream(response), (Charset)Charsets.UTF_8);
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public final /* synthetic */ <T> T asObjectFromJson(HttpResponse response) {
        int $i$f$asObjectFromJson = 0;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.reifiedOperationMarker((int)4, (String)"T");
        return (T)this.asObjectFromJson(response, Object.class);
    }

    public final <T> T asObjectFromJson(@NotNull HttpResponse response, @NotNull Class<T> clazz) {
        T t;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter(clazz, (String)"clazz");
        try {
            t = Formats.INSTANCE.toObjectFromJson(this.asStream(response), clazz);
        }
        catch (IOException e) {
            throw (Throwable)((Object)new ResponseException("Cannot parse response JSON as object, because response is probably malformed. Cause: " + e.getMessage() + '\n' + response, e));
        }
        return t;
    }

    @NotNull
    public final Map<String, Object> asMapFromJson(@NotNull HttpResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return FormatsKt.asMap(this.asJson(response));
    }

    @NotNull
    public final Map<String, Object> asMapFromJson(@NotNull HttpResponse response, @NotNull String jsonPointer) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)jsonPointer, (String)"jsonPointer");
        return FormatsKt.asMap(this.asNodeFromJson(response, jsonPointer));
    }

    @NotNull
    public final JsonNode asNodeFromJson(@NotNull HttpResponse response, @NotNull String jsonPointer) {
        JsonNode jsonNode;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)jsonPointer, (String)"jsonPointer");
        JsonNode json = this.asJson(response);
        try {
            jsonNode = json.at(jsonPointer);
            boolean bl = false;
            boolean bl2 = false;
            JsonNode it = jsonNode;
            boolean bl3 = false;
            JsonNode jsonNode2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)jsonNode2, (String)"it");
            if (jsonNode2.isMissingNode()) {
                throw (Throwable)((Object)new ResponseException("Cannot parse response JSON as map, because node at pointer '" + jsonPointer + "' is missing!\n" + response));
            }
            JsonNode jsonNode3 = jsonNode;
            Intrinsics.checkNotNullExpressionValue((Object)jsonNode3, (String)"json.at(jsonPointer).als\u2026          }\n            }");
            jsonNode = jsonNode3;
        }
        catch (Exception e) {
            throw (Throwable)((Object)new ResponseException("Cannot parse response JSON as map, because response is probably malformed. Cause: " + e.getMessage() + '\n' + response, e));
        }
        return jsonNode;
    }

    public final void checkStatus(@NotNull HttpResponse response, @NotNull IntRange statusCodes) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)statusCodes, (String)"statusCodes");
        StatusLine statusLine = response.getStatusLine();
        Intrinsics.checkNotNullExpressionValue((Object)statusLine, (String)"response.statusLine");
        if (!statusCodes.contains(statusLine.getStatusCode())) {
            this.throwStatusException(response);
        }
    }

    public static /* synthetic */ void checkStatus$default(HttpClient httpClient, HttpResponse httpResponse, IntRange intRange, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: checkStatus");
        }
        if ((n & 2) != 0) {
            intRange = STATUS_CODE_VALID;
        }
        httpClient.checkStatus(httpResponse, intRange);
    }

    public final void checkStatus(@NotNull HttpResponse response, int statusCode) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        this.checkStatus(response, CollectionsKt.listOf((Object)statusCode));
    }

    public final void checkStatus(@NotNull HttpResponse response, @NotNull List<Integer> statusCodes) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter(statusCodes, (String)"statusCodes");
        StatusLine statusLine = response.getStatusLine();
        Intrinsics.checkNotNullExpressionValue((Object)statusLine, (String)"response.statusLine");
        if (!statusCodes.contains(statusLine.getStatusCode())) {
            this.throwStatusException(response);
        }
    }

    public void throwStatusException(@NotNull HttpResponse response) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        throw (Throwable)((Object)new ResponseException("Unexpected response status detected: " + response.getStatusLine()));
    }

    public final void checkText(@NotNull HttpResponse response, @NotNull String containedText, boolean ignoreCase) {
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)containedText, (String)"containedText");
        String text2 = this.asString(response);
        if (!StringsKt.contains((CharSequence)text2, (CharSequence)containedText, (boolean)ignoreCase)) {
            this.logger.debug("Actual text:\n" + text2);
            throw (Throwable)((Object)new ResponseException("Response does not contain text: " + containedText));
        }
    }

    public static /* synthetic */ void checkText$default(HttpClient httpClient, HttpResponse httpResponse, String string2, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: checkText");
        }
        if ((n & 4) != 0) {
            bl = true;
        }
        httpClient.checkText(httpResponse, string2, bl);
    }

    public final void checkHtml(@NotNull HttpResponse response, @NotNull Function1<? super Document, Boolean> validator) {
        Document doc;
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter(validator, (String)"validator");
        String html = this.asString(response);
        Document document = doc = Jsoup.parse((String)html);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"doc");
        if (!((Boolean)validator.invoke((Object)document)).booleanValue()) {
            this.logger.debug("Actual HTML:\n" + html);
            throw (Throwable)((Object)new ResponseException("Response HTML does not pass validation"));
        }
    }

    @NotNull
    public String baseUrl(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        StringBuilder stringBuilder = new StringBuilder();
        Property<String> property = this.baseUrl;
        Intrinsics.checkNotNullExpressionValue(property, (String)"baseUrl");
        String string2 = (String)property.getOrNull();
        if (string2 == null) {
            string2 = "";
        }
        return stringBuilder.append(string2).append(UrlEscapers.urlFragmentEscaper().escape(uri)).toString();
    }

    public <T> T execute(@NotNull HttpRequestBase method, @NotNull Function2<? super HttpClient, ? super HttpResponse, ? extends T> handler) {
        T t;
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter(handler, (String)"handler");
        try {
            t = this.client((Function1)new Function1<CloseableHttpClient, T>(this, method, handler){
                final /* synthetic */ HttpClient this$0;
                final /* synthetic */ HttpRequestBase $method;
                final /* synthetic */ Function2 $handler;

                public final T invoke(@NotNull CloseableHttpClient $this$client) {
                    Intrinsics.checkNotNullParameter((Object)$this$client, (String)"$receiver");
                    HttpClient.access$getRequestConfigurer$p(this.this$0).invoke((Object)this.$method);
                    CloseableHttpResponse response = $this$client.execute((HttpUriRequest)this.$method);
                    Function1 function1 = HttpClient.access$getResponseHandler$p(this.this$0);
                    CloseableHttpResponse closeableHttpResponse = response;
                    Intrinsics.checkNotNullExpressionValue((Object)closeableHttpResponse, (String)"response");
                    function1.invoke((Object)closeableHttpResponse);
                    return (T)this.$handler.invoke((Object)this.this$0, (Object)response);
                }
                {
                    this.this$0 = httpClient;
                    this.$method = httpRequestBase;
                    this.$handler = function2;
                    super(1);
                }
            });
        }
        catch (Exception e) {
            throw (Throwable)((Object)new RequestException("Failed request to " + method + "! Cause: " + e.getMessage(), e));
        }
        return t;
    }

    public final void execute(@NotNull HttpRequestBase method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        this.execute(method, execute.2.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public HttpEntity createEntityUrlencoded(@NotNull Map<String, ? extends Object> params) {
        List list2;
        void $this$fold$iv;
        Intrinsics.checkNotNullParameter(params, (String)"params");
        Iterable iterable = params.entrySet();
        boolean bl = false;
        List initial$iv = new ArrayList();
        boolean $i$f$fold = false;
        List accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void key;
            void $dstr$key$value;
            Map.Entry entry = (Map.Entry)element$iv;
            List result = accumulator$iv;
            boolean bl2 = false;
            void var11_12 = $dstr$key$value;
            boolean bl3 = false;
            String string2 = (String)var11_12.getKey();
            var11_12 = $dstr$key$value;
            bl3 = false;
            Object value = var11_12.getValue();
            Utils.INSTANCE.unroll(value, (Function1<Object, Unit>)((Function1)new Function1<Object, Unit>(result, (String)key, this){
                final /* synthetic */ List $result;
                final /* synthetic */ String $key;
                final /* synthetic */ HttpClient this$0;
                {
                    this.$result = list2;
                    this.$key = string2;
                    this.this$0 = httpClient;
                    super(1);
                }

                public final void invoke(@Nullable Object it) {
                    HttpClient.access$addEntityUrlencoded(this.this$0, this.$result, this.$key, it);
                }
            }));
            accumulator$iv = result;
        }
        List list3 = list2 = accumulator$iv;
        return (HttpEntity)new UrlEncodedFormEntity(list3);
    }

    private final void addEntityUrlencoded(List<NameValuePair> result, String key, Object value) {
        Object object = value;
        if (object == null || (object = object.toString()) == null) {
            object = "";
        }
        result.add((NameValuePair)new BasicNameValuePair(key, (String)object));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public HttpEntity createEntityMultipart(@NotNull Map<String, ? extends Object> params) {
        Intrinsics.checkNotNullParameter(params, (String)"params");
        MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
        boolean bl = false;
        boolean bl2 = false;
        MultipartEntityBuilder $this$apply = multipartEntityBuilder;
        boolean bl3 = false;
        Map<String, ? extends Object> $this$forEach$iv = params;
        boolean $i$f$forEach = false;
        Map<String, ? extends Object> map2 = $this$forEach$iv;
        boolean bl4 = false;
        Iterator<Map.Entry<String, ? extends Object>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            void key;
            Map.Entry<String, ? extends Object> element$iv;
            Map.Entry<String, ? extends Object> $dstr$key$value = element$iv = iterator.next();
            boolean bl5 = false;
            Map.Entry<String, ? extends Object> entry = $dstr$key$value;
            boolean bl6 = false;
            String string2 = entry.getKey();
            entry = $dstr$key$value;
            bl6 = false;
            Object value = entry.getValue();
            Utils.INSTANCE.unroll(value, (Function1<Object, Unit>)((Function1)new Function1<Object, Unit>((String)key, $this$apply, this, params){
                final /* synthetic */ String $key;
                final /* synthetic */ MultipartEntityBuilder $this_apply$inlined;
                final /* synthetic */ HttpClient this$0;
                final /* synthetic */ Map $params$inlined;
                {
                    this.$key = string2;
                    this.$this_apply$inlined = multipartEntityBuilder;
                    this.this$0 = httpClient;
                    this.$params$inlined = map2;
                    super(1);
                }

                public final void invoke(@Nullable Object it) {
                    HttpClient.access$addEntityMultipart(this.this$0, this.$this_apply$inlined, this.$key, it);
                }
            }));
        }
        HttpEntity httpEntity = multipartEntityBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)httpEntity, (String)"MultipartEntityBuilder.c\u2026it) } }\n        }.build()");
        return httpEntity;
    }

    private final void addEntityMultipart(MultipartEntityBuilder $this$addEntityMultipart, String key, Object value) {
        if (value instanceof File && ((File)value).exists()) {
            $this$addEntityMultipart.addBinaryBody(key, (File)value, (ContentType)this.multipartBinaryType.get(), ((File)value).getName());
        } else {
            Object object = value;
            if (object == null || (object = object.toString()) == null) {
                object = "";
            }
            $this$addEntityMultipart.addTextBody(key, (String)object, (ContentType)this.multipartTextType.get());
        }
    }

    @NotNull
    public final File download(@NotNull String fileUrl) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        return (File)this.fileTransfer((Function1)new Function1<HttpFileTransfer, File>(fileUrl){
            final /* synthetic */ String $fileUrl;

            @NotNull
            public final File invoke(@NotNull HttpFileTransfer $this$fileTransfer) {
                Intrinsics.checkNotNullParameter((Object)$this$fileTransfer, (String)"$receiver");
                return $this$fileTransfer.download(this.$fileUrl);
            }
            {
                this.$fileUrl = string2;
                super(1);
            }
        });
    }

    public final void download(@NotNull String fileUrl, @NotNull File target) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.fileTransfer((Function1)new Function1<HttpFileTransfer, Unit>(fileUrl, target){
            final /* synthetic */ String $fileUrl;
            final /* synthetic */ File $target;

            public final void invoke(@NotNull HttpFileTransfer $this$fileTransfer) {
                Intrinsics.checkNotNullParameter((Object)$this$fileTransfer, (String)"$receiver");
                $this$fileTransfer.download(this.$fileUrl, this.$target);
            }
            {
                this.$fileUrl = string2;
                this.$target = file2;
                super(1);
            }
        });
    }

    @NotNull
    public final File downloadTo(@NotNull String fileUrl, @NotNull File dir2) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        Intrinsics.checkNotNullParameter((Object)dir2, (String)"dir");
        return (File)this.fileTransfer((Function1)new Function1<HttpFileTransfer, File>(fileUrl, dir2){
            final /* synthetic */ String $fileUrl;
            final /* synthetic */ File $dir;

            @NotNull
            public final File invoke(@NotNull HttpFileTransfer $this$fileTransfer) {
                Intrinsics.checkNotNullParameter((Object)$this$fileTransfer, (String)"$receiver");
                return $this$fileTransfer.downloadTo(this.$fileUrl, this.$dir);
            }
            {
                this.$fileUrl = string2;
                this.$dir = file2;
                super(1);
            }
        });
    }

    private final <T> T fileTransfer(Function1<? super HttpFileTransfer, ? extends T> operation) {
        return this.common.httpFile((Function1)new Function1<HttpFileTransfer, T>(this, operation){
            final /* synthetic */ HttpClient this$0;
            final /* synthetic */ Function1 $operation;

            public final T invoke(@NotNull HttpFileTransfer $this$httpFile) {
                Intrinsics.checkNotNullParameter((Object)$this$httpFile, (String)"$receiver");
                $this$httpFile.setClient$common_plugin(this.this$0);
                return (T)this.$operation.invoke((Object)$this$httpFile);
            }
            {
                this.this$0 = httpClient;
                this.$operation = function1;
                super(1);
            }
        });
    }

    public HttpClient(@NotNull CommonExtension common) {
        Property $this$typed;
        Intrinsics.checkNotNullParameter((Object)common, (String)"common");
        this.common = common;
        this.logger = this.common.getLogger();
        this.connectionTimeout = this.common.getObj().int((Function1<? super Property<Integer>, Unit>)((Function1)connectionTimeout.1.INSTANCE));
        this.connectionIgnoreSsl = this.common.getObj().boolean((Function1<? super Property<Boolean>, Unit>)((Function1)connectionIgnoreSsl.1.INSTANCE));
        this.connectionRetries = this.common.getObj().boolean((Function1<? super Property<Boolean>, Unit>)((Function1)connectionRetries.1.INSTANCE));
        this.authorizationPreemptive = this.common.getObj().boolean((Function1<? super Property<Boolean>, Unit>)((Function1)authorizationPreemptive.1.INSTANCE));
        this.baseUrl = ObjectFactory.string$default(this.common.getObj(), null, 1, null);
        this.basicUser = ObjectFactory.string$default(this.common.getObj(), null, 1, null);
        this.basicPassword = ObjectFactory.string$default(this.common.getObj(), null, 1, null);
        ObjectFactory this_$iv = this.common.getObj();
        boolean $i$f$typed = false;
        Property property = this_$iv.getFactory().property(ContentType.class);
        boolean bl = false;
        boolean bl2 = false;
        Property property2 = property;
        HttpClient httpClient = this;
        boolean bl3 = false;
        ContentType contentType = ContentType.TEXT_PLAIN;
        Intrinsics.checkNotNullExpressionValue((Object)contentType, (String)"ContentType.TEXT_PLAIN");
        $this$typed.convention((Object)ContentType.create((String)contentType.getMimeType(), (Charset)StandardCharsets.UTF_8));
        Unit unit = Unit.INSTANCE;
        httpClient.multipartTextType = property;
        this_$iv = this.common.getObj();
        $i$f$typed = false;
        property = this_$iv.getFactory().property(ContentType.class);
        bl = false;
        bl2 = false;
        $this$typed = property;
        httpClient = this;
        boolean bl4 = false;
        $this$typed.convention((Object)ContentType.DEFAULT_BINARY);
        unit = Unit.INSTANCE;
        httpClient.multipartBinaryType = property;
        this.proxyHost = ObjectFactory.string$default(this.common.getObj(), null, 1, null);
        this.proxyPort = ObjectFactory.int$default(this.common.getObj(), null, 1, null);
        this.proxyScheme = ObjectFactory.string$default(this.common.getObj(), null, 1, null);
        this.requestConfigurer = requestConfigurer.1.INSTANCE;
        this.clientBuilder = (Function1)new Function1<HttpClientBuilder, Unit>(this){
            final /* synthetic */ HttpClient this$0;

            public final void invoke(@NotNull HttpClientBuilder $receiver) {
                Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                $receiver.useSystemProperties();
                this.this$0.useDefaults($receiver);
            }
            {
                this.this$0 = httpClient;
                super(1);
            }
        };
        this.responseHandler = responseHandler.1.INSTANCE;
        this.responseChecks = this.common.getObj().boolean((Function1<? super Property<Boolean>, Unit>)((Function1)responseChecks.1.INSTANCE));
        this.responseChecker = (Function1)new Function1<HttpResponse, Unit>(this){
            final /* synthetic */ HttpClient this$0;

            public final void invoke(@NotNull HttpResponse it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                HttpClient.checkStatus$default(this.this$0, it, null, 2, null);
            }
            {
                this.this$0 = httpClient;
                super(1);
            }
        };
    }

    static {
        Companion = new Companion(null);
        STATUS_CODE_VALID = RangesKt.until((int)200, (int)300);
    }

    public static final /* synthetic */ Function1 access$getRequestConfigurer$p(HttpClient $this) {
        return $this.requestConfigurer;
    }

    public static final /* synthetic */ void access$setRequestConfigurer$p(HttpClient $this, Function1 function1) {
        $this.requestConfigurer = function1;
    }

    public static final /* synthetic */ Function1 access$getResponseHandler$p(HttpClient $this) {
        return $this.responseHandler;
    }

    public static final /* synthetic */ void access$setResponseHandler$p(HttpClient $this, Function1 function1) {
        $this.responseHandler = function1;
    }

    public static final /* synthetic */ void access$addEntityUrlencoded(HttpClient $this, List result, String key, Object value) {
        $this.addEntityUrlencoded(result, key, value);
    }

    public static final /* synthetic */ void access$addEntityMultipart(HttpClient $this, MultipartEntityBuilder $this$access_u24addEntityMultipart, String key, Object value) {
        $this.addEntityMultipart($this$access_u24addEntityMultipart, key, value);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/cognifide/gradle/common/http/HttpClient$Companion;", "", "()V", "STATUS_CODE_VALID", "Lkotlin/ranges/IntRange;", "getSTATUS_CODE_VALID", "()Lkotlin/ranges/IntRange;", "common-plugin"})
    public static final class Companion {
        @NotNull
        public final IntRange getSTATUS_CODE_VALID() {
            return STATUS_CODE_VALID;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

