/*
 * Decompiled with CFR 0.152.
 */
package com.cognifide.gradle.common.health;

import com.cognifide.gradle.common.CommonException;
import com.cognifide.gradle.common.CommonExtension;
import com.cognifide.gradle.common.build.ProgressIndicator;
import com.cognifide.gradle.common.build.PropertyParser;
import com.cognifide.gradle.common.build.Retry;
import com.cognifide.gradle.common.health.HealthCheck;
import com.cognifide.gradle.common.health.HealthChecker;
import com.cognifide.gradle.common.health.HealthException;
import com.cognifide.gradle.common.health.HealthStatus;
import com.cognifide.gradle.common.health.HttpCheck;
import com.cognifide.gradle.common.http.HttpClient;
import com.cognifide.gradle.common.net.NetUtils;
import com.cognifide.gradle.common.utils.Formats;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.apache.http.HttpResponse;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010:\u001a\u00020!2\u0006\u0010;\u001a\u00020\r2\u000e\u0010:\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010<J(\u0010=\u001a\u00020!2\u0006\u0010>\u001a\u00020\r2\u0006\u0010?\u001a\u00020\r2\u0006\u0010@\u001a\u00020A2\b\b\u0002\u0010B\u001a\u00020AJ/\u0010C\u001a\u00020!2\u0006\u0010>\u001a\u00020\r2\u0006\u0010D\u001a\u00020\r2\u0017\u0010E\u001a\u0013\u0012\u0004\u0012\u00020F\u0012\u0004\u0012\u00020!0\u001f\u00a2\u0006\u0002\b\"J \u0010C\u001a\u00020!2\u0006\u0010>\u001a\u00020\r2\u0006\u0010D\u001a\u00020\r2\b\b\u0002\u0010G\u001a\u00020AJ(\u0010C\u001a\u00020!2\u0006\u0010>\u001a\u00020\r2\u0006\u0010D\u001a\u00020\r2\u0006\u0010H\u001a\u00020\r2\b\b\u0002\u0010G\u001a\u00020AJ\u001f\u0010\u001e\u001a\u00020!2\u0017\u0010I\u001a\u0013\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001f\u00a2\u0006\u0002\b\"J(\u0010J\u001a\u00020!2\u0006\u0010>\u001a\u00020\r2\u0006\u0010?\u001a\u00020\r2\u0006\u0010@\u001a\u00020A2\b\b\u0002\u0010B\u001a\u00020AJ1\u0010K\u001a\u00020!2\u0006\u0010>\u001a\u00020\r2\u0006\u0010D\u001a\u00020\r2\u0019\b\u0002\u0010E\u001a\u0013\u0012\u0004\u0012\u00020F\u0012\u0004\u0012\u00020!0\u001f\u00a2\u0006\u0002\b\"J \u0010L\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\b\b\u0002\u00100\u001a\u0002022\b\b\u0002\u0010-\u001a\u00020\u0011J\u0016\u0010M\u001a\u00020!2\u0006\u0010N\u001a\u0002062\u0006\u0010O\u001a\u000206J\u001a\u0010P\u001a\u00020!*\u00020\r2\u000e\u0010:\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010<J\u001c\u0010L\u001a\u00020!*\u00020Q2\u0006\u0010-\u001a\u00020\u00112\u0006\u00100\u001a\u000202H\u0002R \u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR \u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\t\"\u0004\b\u001d\u0010\u000bR\u001f\u0010\u001e\u001a\u0013\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001f\u00a2\u0006\u0002\b\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010#\u001a\n %*\u0004\u0018\u00010$0$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010&\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\t\"\u0004\b(\u0010\u000bR\u0011\u0010)\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u000fR\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010-\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010\u0013\"\u0004\b/\u0010\u0015R5\u00100\u001a&\u0012\f\u0012\n %*\u0004\u0018\u00010202 %*\u0012\u0012\f\u0012\n %*\u0004\u0018\u00010202\u0018\u00010101\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R5\u00105\u001a&\u0012\f\u0012\n %*\u0004\u0018\u00010606 %*\u0012\u0012\f\u0012\n %*\u0004\u0018\u00010606\u0018\u00010101\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00104R5\u00108\u001a&\u0012\f\u0012\n %*\u0004\u0018\u00010606 %*\u0012\u0012\f\u0012\n %*\u0004\u0018\u00010606\u0018\u00010101\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u00104\u00a8\u0006R"}, d2={"Lcom/cognifide/gradle/common/health/HealthChecker;", "", "common", "Lcom/cognifide/gradle/common/CommonExtension;", "(Lcom/cognifide/gradle/common/CommonExtension;)V", "all", "", "Lcom/cognifide/gradle/common/health/HealthStatus;", "getAll", "()Ljava/util/List;", "setAll", "(Ljava/util/List;)V", "allStatuses", "", "getAllStatuses", "()Ljava/lang/String;", "assuranceRetry", "Lcom/cognifide/gradle/common/build/Retry;", "getAssuranceRetry", "()Lcom/cognifide/gradle/common/build/Retry;", "setAssuranceRetry", "(Lcom/cognifide/gradle/common/build/Retry;)V", "checks", "", "Lcom/cognifide/gradle/common/health/HealthCheck;", "getCommon", "()Lcom/cognifide/gradle/common/CommonExtension;", "failed", "getFailed", "setFailed", "httpOptions", "Lkotlin/Function1;", "Lcom/cognifide/gradle/common/http/HttpClient;", "", "Lkotlin/ExtensionFunctionType;", "logger", "Lorg/gradle/api/logging/Logger;", "kotlin.jvm.PlatformType", "passed", "getPassed", "setPassed", "passedRatio", "getPassedRatio", "prop", "Lcom/cognifide/gradle/common/build/PropertyParser;", "retry", "getRetry", "setRetry", "verbose", "Lorg/gradle/api/provider/Property;", "", "getVerbose", "()Lorg/gradle/api/provider/Property;", "waitAfter", "", "getWaitAfter", "waitBefore", "getWaitBefore", "check", "name", "Lkotlin/Function0;", "host", "checkName", "hostName", "port", "", "timeout", "http", "url", "criteria", "Lcom/cognifide/gradle/common/health/HttpCheck;", "statusCode", "containedText", "options", "noHost", "noHttp", "start", "wait", "before", "after", "invoke", "Lcom/cognifide/gradle/common/build/ProgressIndicator;", "common-plugin"})
public final class HealthChecker {
    private final Logger logger;
    private final PropertyParser prop;
    private final List<HealthCheck> checks;
    private Function1<? super HttpClient, Unit> httpOptions;
    private final Property<Boolean> verbose;
    @NotNull
    private Retry retry;
    @NotNull
    private Retry assuranceRetry;
    private final Property<Long> waitBefore;
    private final Property<Long> waitAfter;
    @NotNull
    private List<HealthStatus> all;
    @NotNull
    private List<HealthStatus> passed;
    @NotNull
    private List<HealthStatus> failed;
    @NotNull
    private final CommonExtension common;

    public final Property<Boolean> getVerbose() {
        return this.verbose;
    }

    @NotNull
    public final Retry getRetry() {
        return this.retry;
    }

    public final void setRetry(@NotNull Retry retry2) {
        Intrinsics.checkNotNullParameter((Object)retry2, (String)"<set-?>");
        this.retry = retry2;
    }

    @NotNull
    public final Retry getAssuranceRetry() {
        return this.assuranceRetry;
    }

    public final void setAssuranceRetry(@NotNull Retry retry2) {
        Intrinsics.checkNotNullParameter((Object)retry2, (String)"<set-?>");
        this.assuranceRetry = retry2;
    }

    public final Property<Long> getWaitBefore() {
        return this.waitBefore;
    }

    public final Property<Long> getWaitAfter() {
        return this.waitAfter;
    }

    public final void wait(long before, long after2) {
        this.waitBefore.set((Object)before);
        this.waitAfter.set((Object)after2);
    }

    public final void check(@NotNull String name, @NotNull Function0<? extends Object> check) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(check, (String)"check");
        Collection collection = this.checks;
        HealthCheck healthCheck = new HealthCheck(name, check);
        boolean bl = false;
        collection.add(healthCheck);
    }

    public final void invoke(@NotNull String $this$invoke, @NotNull Function0<? extends Object> check) {
        Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$this$invoke");
        Intrinsics.checkNotNullParameter(check, (String)"check");
        this.check($this$invoke, check);
    }

    @NotNull
    public final List<HealthStatus> getAll() {
        return this.all;
    }

    public final void setAll(@NotNull List<HealthStatus> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.all = list2;
    }

    @NotNull
    public final String getAllStatuses() {
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)this.all, (Comparator)ComparisonsKt.compareBy((Function1[])new Function1[]{allStatuses.1.INSTANCE, allStatuses.2.INSTANCE})), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final List<HealthStatus> getPassed() {
        return this.passed;
    }

    public final void setPassed(@NotNull List<HealthStatus> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.passed = list2;
    }

    @NotNull
    public final String getPassedRatio() {
        return "" + this.passed.size() + '/' + this.all.size() + " (" + Formats.INSTANCE.percent(this.passed.size(), this.all.size()) + ')';
    }

    @NotNull
    public final List<HealthStatus> getFailed() {
        return this.failed;
    }

    public final void setFailed(@NotNull List<HealthStatus> list2) {
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        this.failed = list2;
    }

    @NotNull
    public final List<HealthStatus> start(boolean verbose2, @NotNull Retry retry2) {
        Intrinsics.checkNotNullParameter((Object)retry2, (String)"retry");
        if (this.checks.isEmpty()) {
            this.logger.info("Health checking skipped as no checks defined.");
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
        this.common.progress(this.checks.size(), (Function1)new Function1<ProgressIndicator, Unit>(this, retry2, verbose2){
            final /* synthetic */ HealthChecker this$0;
            final /* synthetic */ Retry $retry;
            final /* synthetic */ boolean $verbose;

            public final void invoke(@NotNull ProgressIndicator $this$progress) {
                Intrinsics.checkNotNullParameter((Object)$this$progress, (String)"$receiver");
                $this$progress.setStep("Health checking");
                $this$progress.setMessage("Wait Before");
                if (((Number)this.this$0.getWaitBefore().get()).longValue() > 0L) {
                    CommonExtension commonExtension = this.this$0.getCommon();
                    Object object = this.this$0.getWaitBefore().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"waitBefore.get()");
                    commonExtension.progressCountdown(((Number)object).longValue());
                }
                try {
                    this.this$0.getAssuranceRetry().withSleepTillEnd((Function1<? super Long, Unit>)((Function1)new Function1<Long, Unit>(this, $this$progress){
                        final /* synthetic */ start.1 this$0;
                        final /* synthetic */ ProgressIndicator $this_progress;

                        public final void invoke(long no) {
                            HealthChecker.access$start(this.this$0.this$0, this.$this_progress, this.this$0.$retry, this.this$0.$verbose);
                            this.$this_progress.increment();
                            HealthChecker.access$getLogger$p(this.this$0.this$0).info("Health checking passed (" + no + '/' + this.this$0.this$0.getAssuranceRetry().getTimes() + ')');
                        }
                        {
                            this.this$0 = var1_1;
                            this.$this_progress = progressIndicator;
                            super(1);
                        }
                    }));
                }
                catch (HealthException e) {
                    String message = "Health checking failed. Success ratio: " + this.this$0.getPassedRatio() + ":\n" + this.this$0.getAllStatuses();
                    if (this.$verbose) {
                        throw (Throwable)((Object)new HealthException(message));
                    }
                    HealthChecker.access$getLogger$p(this.this$0).error(message);
                }
                $this$progress.setMessage("Wait After");
                if (((Number)this.this$0.getWaitAfter().get()).longValue() > 0L) {
                    CommonExtension commonExtension = this.this$0.getCommon();
                    Object object = this.this$0.getWaitAfter().get();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"waitAfter.get()");
                    commonExtension.progressCountdown(((Number)object).longValue());
                }
                HealthChecker.access$getLogger$p(this.this$0).lifecycle("Health checking succeed.\n" + this.this$0.getAllStatuses());
            }
            {
                this.this$0 = healthChecker;
                this.$retry = retry2;
                this.$verbose = bl;
                super(1);
            }
        });
        return this.all;
    }

    public static /* synthetic */ List start$default(HealthChecker healthChecker, boolean bl, Retry retry2, int n, Object object) {
        if ((n & 1) != 0) {
            Object object2 = healthChecker.verbose.get();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"this.verbose.get()");
            bl = (Boolean)object2;
        }
        if ((n & 2) != 0) {
            retry2 = healthChecker.retry;
        }
        return healthChecker.start(bl, retry2);
    }

    /*
     * WARNING - void declaration
     */
    private final void start(ProgressIndicator $this$start, Retry retry2, boolean verbose2) {
        block10: {
            Retry this_$iv = retry2;
            boolean $i$f$withSleep = false;
            Exception exception$iv = null;
            long l = 0L;
            long l2 = this_$iv.getTimes();
            while (l < l2) {
                void i$iv;
                void no$iv = i$iv + 1L;
                try {
                    List list2;
                    void $this$filterTo$iv$iv;
                    void $this$filter$iv;
                    void no = no$iv;
                    boolean bl = false;
                    Iterable iterable = this.failed;
                    boolean bl2 = false;
                    $this$start.setMessage(!iterable.isEmpty() ? "Attempt " + (long)no + '/' + retry2.getTimes() + ", " + this.failed.size() + " failed" : "Attempt " + (long)no + '/' + retry2.getTimes());
                    this.all = CollectionsKt.toList((Iterable)this.common.getParallel().map((Iterable)this.checks, start.2.1.INSTANCE));
                    iterable = this.all;
                    HealthChecker healthChecker = this;
                    boolean $i$f$filter = false;
                    void var19_17 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        HealthStatus it = (HealthStatus)element$iv$iv;
                        boolean bl3 = false;
                        if (!it.getSucceed()) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    healthChecker.passed = list2 = (List)destination$iv$iv;
                    this.failed = CollectionsKt.minus((Iterable)this.all, (Iterable)this.passed);
                    if (verbose2) {
                        Iterable $this$sortedBy$iv = this.failed;
                        boolean $i$f$sortedBy = false;
                        boolean bl4 = false;
                        this.logger.info(CollectionsKt.joinToString$default((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

                            public final int compare(T a, T b) {
                                boolean bl = false;
                                HealthStatus it = (HealthStatus)a;
                                boolean bl2 = false;
                                Comparable comparable = (Comparable)((Object)it.getCheck().getName());
                                it = (HealthStatus)b;
                                Comparable comparable2 = comparable;
                                bl2 = false;
                                String string2 = it.getCheck().getName();
                                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string2)));
                            }
                        }), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
                    }
                    iterable = this.failed;
                    bl2 = false;
                    if (!iterable.isEmpty()) {
                        throw (Throwable)((Object)new HealthException("Health checks failed. Retrying..."));
                    }
                    break block10;
                }
                catch (Exception e$iv) {
                    exception$iv = e$iv;
                    if (!(e$iv instanceof HealthException)) {
                        Exception exception = exception$iv;
                        if (exception == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"exception");
                        }
                        throw (Throwable)exception;
                    }
                    if (i$iv < this_$iv.getTimes()) {
                        long delay$iv = ((Number)this_$iv.getDelay().invoke((Object)((long)no$iv))).longValue();
                        Thread.sleep(delay$iv);
                    }
                    ++i$iv;
                }
            }
            Exception exception = exception$iv;
            if (exception == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"exception");
            }
            throw (Throwable)exception;
        }
    }

    public final void http(@NotNull String checkName, @NotNull String url, int statusCode) {
        Intrinsics.checkNotNullParameter((Object)checkName, (String)"checkName");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.http(checkName, url, (Function1<? super HttpCheck, Unit>)((Function1)new Function1<HttpCheck, Unit>(statusCode){
            final /* synthetic */ int $statusCode;

            public final void invoke(@NotNull HttpCheck $this$http) {
                Intrinsics.checkNotNullParameter((Object)$this$http, (String)"$receiver");
                $this$http.respondsWith(this.$statusCode);
            }
            {
                this.$statusCode = n;
                super(1);
            }
        }));
    }

    public static /* synthetic */ void http$default(HealthChecker healthChecker, String string2, String string3, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 200;
        }
        healthChecker.http(string2, string3, n);
    }

    public final void http(@NotNull String checkName, @NotNull String url, @NotNull String containedText, int statusCode) {
        Intrinsics.checkNotNullParameter((Object)checkName, (String)"checkName");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)containedText, (String)"containedText");
        this.http(checkName, url, (Function1<? super HttpCheck, Unit>)((Function1)new Function1<HttpCheck, Unit>(containedText, statusCode){
            final /* synthetic */ String $containedText;
            final /* synthetic */ int $statusCode;

            public final void invoke(@NotNull HttpCheck $this$http) {
                Intrinsics.checkNotNullParameter((Object)$this$http, (String)"$receiver");
                $this$http.containsText(this.$containedText, this.$statusCode);
            }
            {
                this.$containedText = string2;
                this.$statusCode = n;
                super(1);
            }
        }));
    }

    public static /* synthetic */ void http$default(HealthChecker healthChecker, String string2, String string3, String string4, int n, int n2, Object object) {
        if ((n2 & 8) != 0) {
            n = 200;
        }
        healthChecker.http(string2, string3, string4, n);
    }

    public final void http(@NotNull String checkName, @NotNull String url, @NotNull Function1<? super HttpCheck, Unit> criteria) {
        Intrinsics.checkNotNullParameter((Object)checkName, (String)"checkName");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(criteria, (String)"criteria");
        this.check(checkName, (Function0<? extends Object>)((Function0)new Function0<Object>(this, url, criteria){
            final /* synthetic */ HealthChecker this$0;
            final /* synthetic */ String $url;
            final /* synthetic */ Function1 $criteria;

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Object invoke() {
                void result;
                Ref.ObjectRef objectRef = new Ref.ObjectRef();
                objectRef.element = null;
                this.this$0.getCommon().http((Function1)new Function1<HttpClient, Unit>(this, (Ref.ObjectRef)result){
                    final /* synthetic */ http.3 this$0;
                    final /* synthetic */ Ref.ObjectRef $result;

                    public final void invoke(@NotNull HttpClient $this$http) {
                        Intrinsics.checkNotNullParameter((Object)$this$http, (String)"$receiver");
                        Object object = new HttpCheck(this.this$0.$url);
                        Function1<HttpClient, Unit> function1 = this.this$0.$criteria;
                        boolean bl = false;
                        boolean bl2 = false;
                        function1.invoke(object);
                        HttpCheck check = object;
                        object = $this$http;
                        function1 = HealthChecker.access$getHttpOptions$p(this.this$0.this$0);
                        bl = false;
                        bl2 = false;
                        function1.invoke(object);
                        object = $this$http;
                        function1 = check.getOptions$common_plugin();
                        bl = false;
                        bl2 = false;
                        function1.invoke(object);
                        $this$http.request(check.getMethod(), check.getUrl(), (Function2)new Function2<HttpClient, HttpResponse, Unit>(this, check){
                            final /* synthetic */ http.1 this$0;
                            final /* synthetic */ HttpCheck $check;

                            public final void invoke(@NotNull HttpClient $this$request, @NotNull HttpResponse response) {
                                Intrinsics.checkNotNullParameter((Object)$this$request, (String)"$receiver");
                                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                                this.this$0.$result.element = this.$check.getMethod() + ' ' + this.$check.getUrl() + " -> " + response.getStatusLine();
                                Iterable $this$forEach$iv = this.$check.getChecks$common_plugin();
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    Function2 it = (Function2)element$iv;
                                    boolean bl = false;
                                    it.invoke((Object)$this$request, (Object)response);
                                }
                            }
                            {
                                this.this$0 = var1_1;
                                this.$check = httpCheck;
                                super(2);
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                        this.$result = objectRef;
                        super(1);
                    }
                });
                return result.element;
            }
            {
                this.this$0 = healthChecker;
                this.$url = string2;
                this.$criteria = function1;
                super(0);
            }
        }));
    }

    public final void noHttp(@NotNull String checkName, @NotNull String url, @NotNull Function1<? super HttpCheck, Unit> criteria) {
        Intrinsics.checkNotNullParameter((Object)checkName, (String)"checkName");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter(criteria, (String)"criteria");
        this.check(checkName, (Function0<? extends Object>)((Function0)new Function0<Unit>(this, url, criteria){
            final /* synthetic */ HealthChecker this$0;
            final /* synthetic */ String $url;
            final /* synthetic */ Function1 $criteria;

            public final void invoke() {
                this.this$0.getCommon().http((Function1)new Function1<HttpClient, Unit>(this){
                    final /* synthetic */ noHttp.2 this$0;

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull HttpClient $this$http) {
                        void responds;
                        Intrinsics.checkNotNullParameter((Object)$this$http, (String)"$receiver");
                        Object object = new HttpCheck(this.this$0.$url);
                        Object object2 = this.this$0.$criteria;
                        boolean bl = false;
                        boolean bl2 = false;
                        object2.invoke(object);
                        HttpCheck check = object;
                        object = $this$http;
                        object2 = HealthChecker.access$getHttpOptions$p(this.this$0.this$0);
                        bl = false;
                        bl2 = false;
                        object2.invoke(object);
                        object = $this$http;
                        object2 = check.getOptions$common_plugin();
                        bl = false;
                        bl2 = false;
                        object2.invoke(object);
                        object = new Ref.BooleanRef();
                        ((Ref.BooleanRef)object).element = false;
                        try {
                            $this$http.request(check.getMethod(), check.getUrl(), (Function2)new Function2<HttpClient, HttpResponse, Unit>((Ref.BooleanRef)responds){
                                final /* synthetic */ Ref.BooleanRef $responds;

                                public final void invoke(@NotNull HttpClient $this$request, @NotNull HttpResponse it) {
                                    Intrinsics.checkNotNullParameter((Object)$this$request, (String)"$receiver");
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    this.$responds.element = true;
                                }
                                {
                                    this.$responds = booleanRef;
                                    super(2);
                                }
                            });
                        }
                        catch (CommonException commonException) {
                            // empty catch block
                        }
                        if (responds.element) {
                            StringBuilder stringBuilder = new StringBuilder().append("HTTP ");
                            object2 = check.getMethod();
                            bl = false;
                            Object object3 = object2;
                            if (object3 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                            }
                            String string2 = ((String)object3).toUpperCase();
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toUpperCase()");
                            throw (Throwable)new IllegalStateException(stringBuilder.append(string2).append(" '").append(check.getUrl()).append("' is available").toString());
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                });
            }
            {
                this.this$0 = healthChecker;
                this.$url = string2;
                this.$criteria = function1;
                super(0);
            }
        }));
    }

    public static /* synthetic */ void noHttp$default(HealthChecker healthChecker, String string2, String string3, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = noHttp.1.INSTANCE;
        }
        healthChecker.noHttp(string2, string3, (Function1<? super HttpCheck, Unit>)function1);
    }

    public final void host(@NotNull String checkName, @NotNull String hostName, int port, int timeout2) {
        Intrinsics.checkNotNullParameter((Object)checkName, (String)"checkName");
        Intrinsics.checkNotNullParameter((Object)hostName, (String)"hostName");
        this.check(checkName, (Function0<? extends Object>)((Function0)new Function0<Unit>(hostName, port, timeout2){
            final /* synthetic */ String $hostName;
            final /* synthetic */ int $port;
            final /* synthetic */ int $timeout;

            public final void invoke() {
                if (!NetUtils.INSTANCE.isHostReachable(this.$hostName, this.$port, this.$timeout)) {
                    throw (Throwable)new IllegalStateException("Host '" + this.$hostName + "' at port " + this.$port + " is not reachable");
                }
            }
            {
                this.$hostName = string2;
                this.$port = n;
                this.$timeout = n2;
                super(0);
            }
        }));
    }

    public static /* synthetic */ void host$default(HealthChecker healthChecker, String string2, String string3, int n, int n2, int n3, Object object) {
        if ((n3 & 8) != 0) {
            n2 = 1000;
        }
        healthChecker.host(string2, string3, n, n2);
    }

    public final void noHost(@NotNull String checkName, @NotNull String hostName, int port, int timeout2) {
        Intrinsics.checkNotNullParameter((Object)checkName, (String)"checkName");
        Intrinsics.checkNotNullParameter((Object)hostName, (String)"hostName");
        this.check(checkName, (Function0<? extends Object>)((Function0)new Function0<Unit>(hostName, port, timeout2){
            final /* synthetic */ String $hostName;
            final /* synthetic */ int $port;
            final /* synthetic */ int $timeout;

            public final void invoke() {
                if (NetUtils.INSTANCE.isHostReachable(this.$hostName, this.$port, this.$timeout)) {
                    throw (Throwable)new IllegalStateException("Host '" + this.$hostName + "' at port " + this.$port + " is reachable");
                }
            }
            {
                this.$hostName = string2;
                this.$port = n;
                this.$timeout = n2;
                super(0);
            }
        }));
    }

    public static /* synthetic */ void noHost$default(HealthChecker healthChecker, String string2, String string3, int n, int n2, int n3, Object object) {
        if ((n3 & 8) != 0) {
            n2 = 1000;
        }
        healthChecker.noHost(string2, string3, n, n2);
    }

    public final void httpOptions(@NotNull Function1<? super HttpClient, Unit> options2) {
        Intrinsics.checkNotNullParameter(options2, (String)"options");
        this.httpOptions = options2;
    }

    @NotNull
    public final CommonExtension getCommon() {
        return this.common;
    }

    public HealthChecker(@NotNull CommonExtension common) {
        Intrinsics.checkNotNullParameter((Object)common, (String)"common");
        this.common = common;
        this.logger = this.common.getLogger();
        this.prop = this.common.getProp();
        boolean bl = false;
        this.checks = new ArrayList();
        this.httpOptions = (Function1)new Function1<HttpClient, Unit>(this){
            final /* synthetic */ HealthChecker this$0;

            public final void invoke(@NotNull HttpClient $receiver) {
                block1: {
                    int it;
                    boolean bl;
                    boolean bl2;
                    Comparable<Boolean> comparable;
                    Intrinsics.checkNotNullParameter((Object)$receiver, (String)"$receiver");
                    $receiver.getAuthorizationPreemptive().set((Object)true);
                    Object object = $receiver.getConnectionRetries();
                    boolean bl3 = false;
                    boolean bl4 = false;
                    Property<Boolean> $this$apply = object;
                    boolean bl5 = false;
                    $this$apply.convention((Object)false);
                    Boolean bl6 = HealthChecker.access$getProp$p(this.this$0).boolean("healthChecker.http.connectionRetries");
                    if (bl6 != null) {
                        comparable = bl6;
                        bl2 = false;
                        bl = false;
                        it = comparable.booleanValue();
                        boolean bl7 = false;
                        $this$apply.set((Object)(it != 0));
                    }
                    object = $receiver.getConnectionTimeout();
                    bl3 = false;
                    bl4 = false;
                    $this$apply = object;
                    boolean bl8 = false;
                    $this$apply.convention((Object)5000);
                    Integer n = HealthChecker.access$getProp$p(this.this$0).int("healthChecker.http.connectionTimeout");
                    if (n == null) break block1;
                    comparable = n;
                    bl2 = false;
                    bl = false;
                    it = ((Number)((Object)comparable)).intValue();
                    boolean bl9 = false;
                    $this$apply.set((Object)it);
                }
            }
            {
                this.this$0 = healthChecker;
                super(1);
            }
        };
        this.verbose = this.common.getObj().boolean((Function1<? super Property<Boolean>, Unit>)((Function1)new Function1<Property<Boolean>, Unit>(this){
            final /* synthetic */ HealthChecker this$0;

            public final void invoke(@NotNull Property<Boolean> $this$boolean) {
                block0: {
                    Intrinsics.checkNotNullParameter($this$boolean, (String)"$receiver");
                    $this$boolean.convention((Object)true);
                    Boolean bl = this.this$0.getCommon().getProp().boolean("healthChecker.verbose");
                    if (bl == null) break block0;
                    Boolean bl2 = bl;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    boolean it = bl2;
                    boolean bl5 = false;
                    $this$boolean.set((Object)it);
                }
            }
            {
                this.this$0 = healthChecker;
                super(1);
            }
        }));
        this.retry = this.common.retry((Function1<? super Retry, Unit>)((Function1)new Function1<Retry, Unit>(this){
            final /* synthetic */ HealthChecker this$0;

            public final void invoke(@NotNull Retry $this$retry) {
                Intrinsics.checkNotNullParameter((Object)$this$retry, (String)"$receiver");
                Long l = HealthChecker.access$getProp$p(this.this$0).long("healthChecker.retry.times");
                Long l2 = HealthChecker.access$getProp$p(this.this$0).long("healthChecker.retry.delay");
                $this$retry.after(l != null ? l : 60L, l2 != null ? l2 : 5000L);
            }
            {
                this.this$0 = healthChecker;
                super(1);
            }
        }));
        this.assuranceRetry = this.common.retry((Function1<? super Retry, Unit>)((Function1)new Function1<Retry, Unit>(this){
            final /* synthetic */ HealthChecker this$0;

            public final void invoke(@NotNull Retry $this$retry) {
                Intrinsics.checkNotNullParameter((Object)$this$retry, (String)"$receiver");
                Long l = HealthChecker.access$getProp$p(this.this$0).long("healthChecker.assuranceRetry.times");
                Long l2 = HealthChecker.access$getProp$p(this.this$0).long("healthChecker.assuranceRetry.delay");
                $this$retry.after(l != null ? l : 2L, l2 != null ? l2 : 1000L);
            }
            {
                this.this$0 = healthChecker;
                super(1);
            }
        }));
        this.waitBefore = this.common.getObj().long((Function1<? super Property<Long>, Unit>)((Function1)new Function1<Property<Long>, Unit>(this){
            final /* synthetic */ HealthChecker this$0;

            public final void invoke(@NotNull Property<Long> $this$long) {
                block0: {
                    Intrinsics.checkNotNullParameter($this$long, (String)"$receiver");
                    $this$long.convention((Object)TimeUnit.SECONDS.toMillis(0L));
                    Long l = this.this$0.getCommon().getProp().long("healthChecker.wait.before");
                    if (l == null) break block0;
                    Long l2 = l;
                    boolean bl = false;
                    boolean bl2 = false;
                    long it = ((Number)l2).longValue();
                    boolean bl3 = false;
                    $this$long.set((Object)it);
                }
            }
            {
                this.this$0 = healthChecker;
                super(1);
            }
        }));
        this.waitAfter = this.common.getObj().long((Function1<? super Property<Long>, Unit>)((Function1)new Function1<Property<Long>, Unit>(this){
            final /* synthetic */ HealthChecker this$0;

            public final void invoke(@NotNull Property<Long> $this$long) {
                block0: {
                    Intrinsics.checkNotNullParameter($this$long, (String)"$receiver");
                    $this$long.convention((Object)TimeUnit.SECONDS.toMillis(0L));
                    Long l = this.this$0.getCommon().getProp().long("healthChecker.wait.after");
                    if (l == null) break block0;
                    Long l2 = l;
                    boolean bl = false;
                    boolean bl2 = false;
                    long it = ((Number)l2).longValue();
                    boolean bl3 = false;
                    $this$long.set((Object)it);
                }
            }
            {
                this.this$0 = healthChecker;
                super(1);
            }
        }));
        bl = false;
        this.all = CollectionsKt.emptyList();
        bl = false;
        this.passed = CollectionsKt.emptyList();
        bl = false;
        this.failed = CollectionsKt.emptyList();
    }

    public static final /* synthetic */ void access$start(HealthChecker $this, ProgressIndicator $this$access_u24start, Retry retry2, boolean verbose2) {
        $this.start($this$access_u24start, retry2, verbose2);
    }

    public static final /* synthetic */ Logger access$getLogger$p(HealthChecker $this) {
        return $this.logger;
    }

    public static final /* synthetic */ Function1 access$getHttpOptions$p(HealthChecker $this) {
        return $this.httpOptions;
    }

    public static final /* synthetic */ void access$setHttpOptions$p(HealthChecker $this, Function1 function1) {
        $this.httpOptions = function1;
    }

    public static final /* synthetic */ PropertyParser access$getProp$p(HealthChecker $this) {
        return $this.prop;
    }
}

