/*
 * Decompiled with CFR 0.152.
 */
package com.cognifide.gradle.common.file.transfer.http;

import com.cognifide.gradle.common.CommonExtension;
import com.cognifide.gradle.common.file.transfer.FileDownloader;
import com.cognifide.gradle.common.file.transfer.ProtocolFileTransfer;
import com.cognifide.gradle.common.file.transfer.http.HttpFileException;
import com.cognifide.gradle.common.http.HttpClient;
import com.cognifide.gradle.common.utils.UtilsKt;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001f\u0010\u0005\u001a\u00020\u00132\u0017\u0010\u0014\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00130\u0015\u00a2\u0006\u0002\b\u0016J \u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\f2\u0006\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lcom/cognifide/gradle/common/file/transfer/http/HttpFileTransfer;", "Lcom/cognifide/gradle/common/file/transfer/ProtocolFileTransfer;", "common", "Lcom/cognifide/gradle/common/CommonExtension;", "(Lcom/cognifide/gradle/common/CommonExtension;)V", "client", "Lcom/cognifide/gradle/common/http/HttpClient;", "getClient$common_plugin", "()Lcom/cognifide/gradle/common/http/HttpClient;", "setClient$common_plugin", "(Lcom/cognifide/gradle/common/http/HttpClient;)V", "name", "", "getName", "()Ljava/lang/String;", "protocols", "", "getProtocols", "()Ljava/util/List;", "", "options", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "downloadFrom", "dirUrl", "fileName", "target", "Ljava/io/File;", "Companion", "common-plugin"})
public final class HttpFileTransfer
extends ProtocolFileTransfer {
    @NotNull
    private HttpClient client;
    @NotNull
    public static final String NAME = "http";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final HttpClient getClient$common_plugin() {
        return this.client;
    }

    public final void setClient$common_plugin(@NotNull HttpClient httpClient) {
        Intrinsics.checkNotNullParameter((Object)httpClient, (String)"<set-?>");
        this.client = httpClient;
    }

    public final void client(@NotNull Function1<? super HttpClient, Unit> options2) {
        Intrinsics.checkNotNullParameter(options2, (String)"options");
        UtilsKt.using(this.client, options2);
    }

    @Override
    @NotNull
    public String getName() {
        return NAME;
    }

    @Override
    @NotNull
    public List<String> getProtocols() {
        return CollectionsKt.listOf((Object[])new String[]{"http://*", "https://*"});
    }

    @Override
    public void downloadFrom(@NotNull String dirUrl, @NotNull String fileName, @NotNull File target) {
        Intrinsics.checkNotNullParameter((Object)dirUrl, (String)"dirUrl");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        String sourceUrl = dirUrl + '/' + fileName;
        try {
            this.client.get(sourceUrl, (Function2)new Function2<HttpClient, HttpResponse, Unit>(this, sourceUrl, target){
                final /* synthetic */ HttpFileTransfer this$0;
                final /* synthetic */ String $sourceUrl;
                final /* synthetic */ File $target;

                public final void invoke(@NotNull HttpClient $this$get, @NotNull HttpResponse response) {
                    Intrinsics.checkNotNullParameter((Object)$this$get, (String)"$receiver");
                    Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                    HttpFileTransfer.access$getCommon$p(this.this$0).getLogger().info("Downloading: " + this.$sourceUrl + " -> " + this.$target);
                    this.this$0.downloader((Function1<? super FileDownloader, Unit>)((Function1)new Function1<FileDownloader, Unit>(response){
                        final /* synthetic */ HttpResponse $response;

                        public final void invoke(@NotNull FileDownloader $this$downloader) {
                            Intrinsics.checkNotNullParameter((Object)$this$downloader, (String)"$receiver");
                            HttpEntity httpEntity = this.$response.getEntity();
                            Intrinsics.checkNotNullExpressionValue((Object)httpEntity, (String)"response.entity");
                            $this$downloader.setSize(httpEntity.getContentLength());
                        }
                        {
                            this.$response = httpResponse;
                            super(1);
                        }
                    })).download($this$get.asStream(response), this.$target);
                }
                {
                    this.this$0 = httpFileTransfer;
                    this.$sourceUrl = string2;
                    this.$target = file2;
                    super(2);
                }
            });
        }
        catch (Exception e) {
            throw (Throwable)((Object)new HttpFileException("Cannot download URL '" + sourceUrl + "' to file '" + target + "' using HTTP(s). Cause: " + e.getMessage(), e));
        }
    }

    public HttpFileTransfer(@NotNull CommonExtension common) {
        Intrinsics.checkNotNullParameter((Object)common, (String)"common");
        super(common);
        this.client = new HttpClient(common);
    }

    public static final /* synthetic */ CommonExtension access$getCommon$p(HttpFileTransfer $this) {
        return $this.getCommon();
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/cognifide/gradle/common/file/transfer/http/HttpFileTransfer$Companion;", "", "()V", "NAME", "", "common-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

