/*
 * Decompiled with CFR 0.152.
 */
package com.cognifide.gradle.common.file.transfer;

import com.cognifide.gradle.common.CommonExtension;
import com.cognifide.gradle.common.build.ProgressLogger;
import com.cognifide.gradle.common.file.transfer.FileUploader;
import com.cognifide.gradle.common.utils.Formats;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\n\u001a\u00020\u0006H\u0002J,\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0014\b\u0002\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\f0\u0012J$\u0010\u0013\u001a\u00020\f*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/cognifide/gradle/common/file/transfer/FileUploader;", "", "common", "Lcom/cognifide/gradle/common/CommonExtension;", "(Lcom/cognifide/gradle/common/CommonExtension;)V", "loggedKb", "", "processedBytes", "size", "startTime", "remainingTime", "upload", "", "file", "Ljava/io/File;", "output", "Ljava/io/OutputStream;", "cleanup", "Lkotlin/Function1;", "logProgress", "Lcom/cognifide/gradle/common/build/ProgressLogger;", "operation", "", "readBytes", "Companion", "common-plugin"})
public final class FileUploader {
    private long processedBytes;
    private long loggedKb;
    private long size;
    private long startTime;
    private final CommonExtension common;
    public static final int TRANSFER_CHUNK_100_KB = 102400;
    public static final int KILOBYTE = 1024;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final void upload(@NotNull File file2, @NotNull OutputStream output, @NotNull Function1<? super File, Unit> cleanup) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        Intrinsics.checkNotNullParameter(cleanup, (String)"cleanup");
        this.common.progressLogger((Function1)new Function1<ProgressLogger, Unit>(this, file2, output, cleanup){
            final /* synthetic */ FileUploader this$0;
            final /* synthetic */ File $file;
            final /* synthetic */ OutputStream $output;
            final /* synthetic */ Function1 $cleanup;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(@NotNull ProgressLogger $this$progressLogger) {
                Intrinsics.checkNotNullParameter((Object)$this$progressLogger, (String)"$receiver");
                Object object = this.$file;
                boolean bl = false;
                object = new FileInputStream((File)object);
                bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    FileInputStream input = (FileInputStream)object;
                    boolean bl3 = false;
                    FileUploader.access$setSize$p(this.this$0, this.$file.length());
                    FileUploader.access$setStartTime$p(this.this$0, System.currentTimeMillis());
                    boolean finished = false;
                    try {
                        byte[] buf = new byte[102400];
                        int read = input.read(buf);
                        while (read >= 0) {
                            this.$output.write(buf, 0, read);
                            FileUploader.access$logProgress(this.this$0, $this$progressLogger, "Uploading", read, this.$file);
                            read = input.read(buf);
                        }
                        this.$output.flush();
                        finished = true;
                    }
                    catch (Throwable throwable2) {
                        this.$output.close();
                        this.$cleanup.invoke((Object)this.$file);
                        throw throwable2;
                    }
                    this.$output.close();
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
            {
                this.this$0 = fileUploader;
                this.$file = file2;
                this.$output = outputStream;
                this.$cleanup = function1;
                super(1);
            }
        });
    }

    public static /* synthetic */ void upload$default(FileUploader fileUploader, File file2, OutputStream outputStream, Function1 function1, int n, Object object) {
        if ((n & 4) != 0) {
            function1 = upload.1.INSTANCE;
        }
        fileUploader.upload(file2, outputStream, (Function1<? super File, Unit>)function1);
    }

    private final void logProgress(ProgressLogger $this$logProgress, String operation, long readBytes, File file2) {
        this.processedBytes += readBytes;
        long processedKb = this.processedBytes / (long)1024;
        if (processedKb > this.loggedKb) {
            String msg = this.size > 0L ? operation + ": " + file2.getName() + " | " + Formats.INSTANCE.fileSizeBytesToHuman(this.processedBytes) + '/' + Formats.INSTANCE.fileSizeBytesToHuman(this.size) + " (" + Formats.INSTANCE.percent(this.processedBytes, this.size) + ',' + " time left: " + Formats.INSTANCE.duration(this.remainingTime()) + ')' : operation + ": " + file2.getName() + " | " + Formats.INSTANCE.fileSizeBytesToHuman(this.processedBytes);
            $this$logProgress.progress(msg);
            this.loggedKb = processedKb;
        }
    }

    private final long remainingTime() {
        long elapsedTime = System.currentTimeMillis() - this.startTime;
        long allTime = elapsedTime * this.size / this.processedBytes;
        return RangesKt.coerceAtLeast((long)(allTime - elapsedTime), (long)0L);
    }

    public FileUploader(@NotNull CommonExtension common) {
        Intrinsics.checkNotNullParameter((Object)common, (String)"common");
        this.common = common;
        this.startTime = -1L;
    }

    public static final /* synthetic */ long access$getSize$p(FileUploader $this) {
        return $this.size;
    }

    public static final /* synthetic */ void access$setSize$p(FileUploader $this, long l) {
        $this.size = l;
    }

    public static final /* synthetic */ long access$getStartTime$p(FileUploader $this) {
        return $this.startTime;
    }

    public static final /* synthetic */ void access$setStartTime$p(FileUploader $this, long l) {
        $this.startTime = l;
    }

    public static final /* synthetic */ void access$logProgress(FileUploader $this, ProgressLogger $this$access_u24logProgress, String operation, long readBytes, File file2) {
        $this.logProgress($this$access_u24logProgress, operation, readBytes, file2);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/cognifide/gradle/common/file/transfer/FileUploader$Companion;", "", "()V", "KILOBYTE", "", "TRANSFER_CHUNK_100_KB", "common-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

