/*
 * Decompiled with CFR 0.152.
 */
package com.cognifide.gradle.common.file.transfer;

import com.cognifide.gradle.common.CommonExtension;
import com.cognifide.gradle.common.file.FileException;
import com.cognifide.gradle.common.file.transfer.AbstractFileTransfer;
import com.cognifide.gradle.common.file.transfer.FileEntry;
import com.cognifide.gradle.common.file.transfer.FileTransfer;
import com.cognifide.gradle.common.file.transfer.FileTransferException;
import com.cognifide.gradle.common.file.transfer.FileTransferFactory;
import com.cognifide.gradle.common.file.transfer.FileTransferHandler;
import com.cognifide.gradle.common.file.transfer.FileUtils;
import com.cognifide.gradle.common.file.transfer.ProtocolFileTransfer;
import com.cognifide.gradle.common.file.transfer.generic.CustomFileTransfer;
import com.cognifide.gradle.common.file.transfer.generic.PathFileTransfer;
import com.cognifide.gradle.common.file.transfer.generic.UrlFileTransfer;
import com.cognifide.gradle.common.file.transfer.http.HttpFileTransfer;
import com.cognifide.gradle.common.file.transfer.resolve.ResolveFileTransfer;
import com.cognifide.gradle.common.file.transfer.sftp.SftpFileTransfer;
import com.cognifide.gradle.common.file.transfer.smb.SmbFileTransfer;
import com.cognifide.gradle.common.utils.UtilsKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.logging.Logger;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 X2\u00020\u0001:\u0001XB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\n\u001a\u00020<2\b\u0010:\u001a\u0004\u0018\u00010\f2\b\u0010$\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\fJ'\u0010\u0012\u001a\u00020<2\u0006\u0010=\u001a\u00020\f2\u0017\u0010>\u001a\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020<0?\u00a2\u0006\u0002\b@J\u0018\u0010A\u001a\u00020<2\u0006\u0010B\u001a\u00020\f2\u0006\u0010C\u001a\u00020\fH\u0016J\u0010\u0010D\u001a\u00020E2\u0006\u0010F\u001a\u00020\fH\u0016J \u0010G\u001a\u00020<2\u0006\u0010B\u001a\u00020\f2\u0006\u0010C\u001a\u00020\f2\u0006\u0010H\u001a\u00020EH\u0016J\u001e\u0010I\u001a\u00020<2\u0006\u0010J\u001a\u00020\u00012\u0006\u0010F\u001a\u00020\f2\u0006\u0010H\u001a\u00020EJ&\u0010I\u001a\u00020<2\u0006\u0010J\u001a\u00020\u00012\u0006\u0010B\u001a\u00020\f2\u0006\u0010C\u001a\u00020\f2\u0006\u0010H\u001a\u00020EJ\u0010\u0010K\u001a\u00020L2\u0006\u0010F\u001a\u00020\fH\u0016J\u000e\u0010M\u001a\u00020N2\u0006\u0010F\u001a\u00020\fJ\u001f\u0010\u001e\u001a\u00020<2\u0017\u0010O\u001a\u0013\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020<0?\u00a2\u0006\u0002\b@J\u0016\u0010P\u001a\b\u0012\u0004\u0012\u00020Q0\u00062\u0006\u0010B\u001a\u00020\fH\u0016J\u000e\u0010R\u001a\u00020\u00012\u0006\u0010=\u001a\u00020\fJ\u001f\u0010&\u001a\u00020<2\u0017\u0010O\u001a\u0013\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020<0?\u00a2\u0006\u0002\b@J\u001f\u0010*\u001a\u00020<2\u0017\u0010O\u001a\u0013\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020<0?\u00a2\u0006\u0002\b@J\u001f\u0010.\u001a\u00020<2\u0017\u0010O\u001a\u0013\u0012\u0004\u0012\u00020/\u0012\u0004\u0012\u00020<0?\u00a2\u0006\u0002\b@J\u001f\u00102\u001a\u00020<2\u0017\u0010O\u001a\u0013\u0012\u0004\u0012\u000203\u0012\u0004\u0012\u00020<0?\u00a2\u0006\u0002\b@J\u001a\u0010S\u001a\u0004\u0018\u00010Q2\u0006\u0010B\u001a\u00020\f2\u0006\u0010C\u001a\u00020\fH\u0016J\u0010\u0010T\u001a\u00020<2\u0006\u0010B\u001a\u00020\fH\u0016J \u0010U\u001a\u00020<2\u0006\u0010B\u001a\u00020\f2\u0006\u0010C\u001a\u00020\f2\u0006\u0010V\u001a\u00020EH\u0016J\u001e\u0010W\u001a\u00020<2\u0006\u0010J\u001a\u00020\u00012\u0006\u0010F\u001a\u00020\f2\u0006\u0010V\u001a\u00020EJ&\u0010W\u001a\u00020<2\u0006\u0010J\u001a\u00020\u00012\u0006\u0010B\u001a\u00020\f2\u0006\u0010C\u001a\u00020\f2\u0006\u0010V\u001a\u00020EJ\u001f\u00106\u001a\u00020<2\u0017\u0010O\u001a\u0013\u0012\u0004\u0012\u000207\u0012\u0004\u0012\u00020<0?\u00a2\u0006\u0002\b@R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R5\u0010\u0015\u001a&\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\f0\f \u0017*\u0012\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\f0\f\u0018\u00010\u00160\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0016\u0010\"\u001a\n \u0017*\u0004\u0018\u00010#0#X\u0082\u0004\u00a2\u0006\u0002\n\u0000R5\u0010$\u001a&\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\f0\f \u0017*\u0012\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\f0\f\u0018\u00010\u00160\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0019R\u0011\u0010&\u001a\u00020'\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020+\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0011\u0010.\u001a\u00020/\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0011\u00102\u001a\u000203\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0011\u00106\u001a\u000207\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R5\u0010:\u001a&\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\f0\f \u0017*\u0012\u0012\f\u0012\n \u0017*\u0004\u0018\u00010\f0\f\u0018\u00010\u00160\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010\u0019\u00a8\u0006Y"}, d2={"Lcom/cognifide/gradle/common/file/transfer/FileTransferManager;", "Lcom/cognifide/gradle/common/file/transfer/FileTransfer;", "common", "Lcom/cognifide/gradle/common/CommonExtension;", "(Lcom/cognifide/gradle/common/CommonExtension;)V", "all", "", "Lcom/cognifide/gradle/common/file/transfer/AbstractFileTransfer;", "getAll", "()Ljava/util/List;", "credentials", "Lkotlin/Pair;", "", "getCredentials", "()Lkotlin/Pair;", "credentialsString", "getCredentialsString", "()Ljava/lang/String;", "custom", "", "Lcom/cognifide/gradle/common/file/transfer/generic/CustomFileTransfer;", "domain", "Lorg/gradle/api/provider/Property;", "kotlin.jvm.PlatformType", "getDomain", "()Lorg/gradle/api/provider/Property;", "factory", "Lcom/cognifide/gradle/common/file/transfer/FileTransferFactory;", "getFactory", "()Lcom/cognifide/gradle/common/file/transfer/FileTransferFactory;", "http", "Lcom/cognifide/gradle/common/file/transfer/http/HttpFileTransfer;", "getHttp", "()Lcom/cognifide/gradle/common/file/transfer/http/HttpFileTransfer;", "logger", "Lorg/gradle/api/logging/Logger;", "password", "getPassword", "path", "Lcom/cognifide/gradle/common/file/transfer/generic/PathFileTransfer;", "getPath", "()Lcom/cognifide/gradle/common/file/transfer/generic/PathFileTransfer;", "resolve", "Lcom/cognifide/gradle/common/file/transfer/resolve/ResolveFileTransfer;", "getResolve", "()Lcom/cognifide/gradle/common/file/transfer/resolve/ResolveFileTransfer;", "sftp", "Lcom/cognifide/gradle/common/file/transfer/sftp/SftpFileTransfer;", "getSftp", "()Lcom/cognifide/gradle/common/file/transfer/sftp/SftpFileTransfer;", "smb", "Lcom/cognifide/gradle/common/file/transfer/smb/SmbFileTransfer;", "getSmb", "()Lcom/cognifide/gradle/common/file/transfer/smb/SmbFileTransfer;", "url", "Lcom/cognifide/gradle/common/file/transfer/generic/UrlFileTransfer;", "getUrl", "()Lcom/cognifide/gradle/common/file/transfer/generic/UrlFileTransfer;", "user", "getUser", "", "name", "definition", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "deleteFrom", "dirUrl", "fileName", "download", "Ljava/io/File;", "fileUrl", "downloadFrom", "target", "downloadUsing", "transfer", "handles", "", "handling", "Lcom/cognifide/gradle/common/file/transfer/FileTransferHandler;", "options", "list", "Lcom/cognifide/gradle/common/file/transfer/FileEntry;", "named", "stat", "truncate", "uploadTo", "source", "uploadUsing", "Companion", "common-plugin"})
public final class FileTransferManager
implements FileTransfer {
    private final Logger logger;
    private final Property<String> user;
    private final Property<String> password;
    private final Property<String> domain;
    @NotNull
    private final FileTransferFactory factory;
    @NotNull
    private final HttpFileTransfer http;
    @NotNull
    private final SftpFileTransfer sftp;
    @NotNull
    private final SmbFileTransfer smb;
    @NotNull
    private final ResolveFileTransfer resolve;
    @NotNull
    private final UrlFileTransfer url;
    @NotNull
    private final PathFileTransfer path;
    private final List<CustomFileTransfer> custom;
    private final CommonExtension common;
    @NotNull
    public static final String NAME = "manager";
    @NotNull
    public static final String TMP_SUFFIX = ".tmp";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public final Property<String> getUser() {
        return this.user;
    }

    public final Property<String> getPassword() {
        return this.password;
    }

    public final Property<String> getDomain() {
        return this.domain;
    }

    @NotNull
    public final Pair<String, String> getCredentials() {
        block3: {
            block2: {
                Property<String> property = this.user;
                Intrinsics.checkNotNullExpressionValue(property, (String)"user");
                if (!property.isPresent()) break block2;
                Property<String> property2 = this.password;
                Intrinsics.checkNotNullExpressionValue(property2, (String)"password");
                if (property2.isPresent()) break block3;
            }
            throw (Throwable)((Object)new FileTransferException("File transfer credentials are missing!"));
        }
        return TuplesKt.to((Object)this.user.get(), (Object)this.password.get());
    }

    @NotNull
    public final String getCredentialsString() {
        Pair<String, String> pair = this.getCredentials();
        boolean bl = false;
        boolean bl2 = false;
        Pair<String, String> $this$run = pair;
        boolean bl3 = false;
        return (String)$this$run.getFirst() + ':' + (String)$this$run.getSecond();
    }

    public final void credentials(@Nullable String user2, @Nullable String password2, @Nullable String domain2) {
        this.user.set((Object)user2);
        this.password.set((Object)password2);
        this.domain.set((Object)domain2);
        this.http.getClient$common_plugin().getBasicUser().set((Object)user2);
        this.http.getClient$common_plugin().getBasicPassword().set((Object)password2);
        this.sftp.getUser().set((Object)user2);
        this.sftp.getPassword().set((Object)password2);
        this.smb.getUser().set((Object)user2);
        this.smb.getPassword().set((Object)password2);
        this.smb.getDomain().set((Object)domain2);
    }

    public static /* synthetic */ void credentials$default(FileTransferManager fileTransferManager, String string2, String string3, String string4, int n, Object object) {
        if ((n & 4) != 0) {
            string4 = null;
        }
        fileTransferManager.credentials(string2, string3, string4);
    }

    @NotNull
    public final FileTransferFactory getFactory() {
        return this.factory;
    }

    @NotNull
    public final HttpFileTransfer getHttp() {
        return this.http;
    }

    public final void http(@NotNull Function1<? super HttpFileTransfer, Unit> options2) {
        Intrinsics.checkNotNullParameter(options2, (String)"options");
        UtilsKt.using(this.http, options2);
    }

    @NotNull
    public final SftpFileTransfer getSftp() {
        return this.sftp;
    }

    public final void sftp(@NotNull Function1<? super SftpFileTransfer, Unit> options2) {
        Intrinsics.checkNotNullParameter(options2, (String)"options");
        UtilsKt.using(this.sftp, options2);
    }

    @NotNull
    public final SmbFileTransfer getSmb() {
        return this.smb;
    }

    public final void smb(@NotNull Function1<? super SmbFileTransfer, Unit> options2) {
        Intrinsics.checkNotNullParameter(options2, (String)"options");
        UtilsKt.using(this.smb, options2);
    }

    @NotNull
    public final ResolveFileTransfer getResolve() {
        return this.resolve;
    }

    public final void resolve(@NotNull Function1<? super ResolveFileTransfer, Unit> options2) {
        Intrinsics.checkNotNullParameter(options2, (String)"options");
        UtilsKt.using(this.resolve, options2);
    }

    @NotNull
    public final UrlFileTransfer getUrl() {
        return this.url;
    }

    public final void url(@NotNull Function1<? super UrlFileTransfer, Unit> options2) {
        Intrinsics.checkNotNullParameter(options2, (String)"options");
        UtilsKt.using(this.url, options2);
    }

    @NotNull
    public final PathFileTransfer getPath() {
        return this.path;
    }

    public final void path(@NotNull Function1<? super PathFileTransfer, Unit> options2) {
        Intrinsics.checkNotNullParameter(options2, (String)"options");
        UtilsKt.using(this.path, options2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<AbstractFileTransfer> getAll() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = CollectionsKt.plus((Collection)this.custom, (Object[])new AbstractFileTransfer[]{this.http, this.sftp, this.smb, this.resolve, this.url, this.path});
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            AbstractFileTransfer it = (AbstractFileTransfer)element$iv$iv;
            boolean bl = false;
            Object object = it.getEnabled().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"it.enabled.get()");
            if (!((Boolean)object).booleanValue()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public File download(@NotNull String fileUrl) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        String string2 = FileUtils.INSTANCE.nameFromUrl(fileUrl);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"FileUtils.nameFromUrl(fileUrl)");
        File file2 = this.common.temporaryFile(string2);
        boolean bl = false;
        boolean bl2 = false;
        File it = file2;
        boolean bl3 = false;
        this.download(fileUrl, it);
        return file2;
    }

    @Override
    public void downloadFrom(@NotNull String dirUrl, @NotNull String fileName, @NotNull File target) {
        Intrinsics.checkNotNullParameter((Object)dirUrl, (String)"dirUrl");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.downloadUsing(this.handling(dirUrl), dirUrl, fileName, target);
    }

    /*
     * WARNING - void declaration
     */
    public final void downloadUsing(@NotNull FileTransfer transfer, @NotNull String fileUrl, @NotNull File target) {
        void dirUrl;
        Intrinsics.checkNotNullParameter((Object)transfer, (String)"transfer");
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Pair<String, String> pair = FileUtils.INSTANCE.splitUrl(fileUrl);
        String string2 = (String)pair.component1();
        String fileName = (String)pair.component2();
        this.downloadUsing(transfer, (String)dirUrl, fileName, target);
    }

    public final void downloadUsing(@NotNull FileTransfer transfer, @NotNull String dirUrl, @NotNull String fileName, @NotNull File target) {
        Intrinsics.checkNotNullParameter((Object)transfer, (String)"transfer");
        Intrinsics.checkNotNullParameter((Object)dirUrl, (String)"dirUrl");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (target.exists()) {
            this.common.getLogger().info("Skipping downloading file from URL '" + dirUrl + '/' + fileName + "' to '" + target + "' as of it already exists.");
            return;
        }
        target.getParentFile().mkdirs();
        File tmp = new File(target.getParentFile(), target.getName() + TMP_SUFFIX);
        if (tmp.exists()) {
            tmp.delete();
        }
        transfer.downloadFrom(dirUrl, fileName, tmp);
        tmp.renameTo(target);
    }

    @Override
    public void uploadTo(@NotNull String dirUrl, @NotNull String fileName, @NotNull File source) {
        Intrinsics.checkNotNullParameter((Object)dirUrl, (String)"dirUrl");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.uploadUsing(this.handling(dirUrl), dirUrl, fileName, source);
    }

    /*
     * WARNING - void declaration
     */
    public final void uploadUsing(@NotNull FileTransfer transfer, @NotNull String fileUrl, @NotNull File source) {
        void dirUrl;
        Intrinsics.checkNotNullParameter((Object)transfer, (String)"transfer");
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Pair<String, String> pair = FileUtils.INSTANCE.splitUrl(fileUrl);
        String string2 = (String)pair.component1();
        String fileName = (String)pair.component2();
        this.uploadUsing(transfer, (String)dirUrl, fileName, source);
    }

    public final void uploadUsing(@NotNull FileTransfer transfer, @NotNull String dirUrl, @NotNull String fileName, @NotNull File source) {
        Intrinsics.checkNotNullParameter((Object)transfer, (String)"transfer");
        Intrinsics.checkNotNullParameter((Object)dirUrl, (String)"dirUrl");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        String fileUrl = dirUrl + '/' + fileName;
        try {
            if (this.stat(dirUrl, fileName) != null) {
                this.logger.info("Skipping uploading file to URL '" + fileUrl + "' as of it already exists on server.");
                return;
            }
        }
        catch (FileException e) {
            this.logger.debug("Cannot check status of uploaded file at URL '" + fileUrl + '\'', (Throwable)((Object)e));
        }
        transfer.uploadTo(dirUrl, fileName, source);
    }

    @Override
    @NotNull
    public List<FileEntry> list(@NotNull String dirUrl) {
        Intrinsics.checkNotNullParameter((Object)dirUrl, (String)"dirUrl");
        return this.handling(dirUrl).list(dirUrl);
    }

    @Override
    public void deleteFrom(@NotNull String dirUrl, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)dirUrl, (String)"dirUrl");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        this.handling(dirUrl).deleteFrom(dirUrl, fileName);
    }

    @Override
    public void truncate(@NotNull String dirUrl) {
        Intrinsics.checkNotNullParameter((Object)dirUrl, (String)"dirUrl");
        this.handling(dirUrl).truncate(dirUrl);
    }

    @Override
    @Nullable
    public FileEntry stat(@NotNull String dirUrl, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)dirUrl, (String)"dirUrl");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return this.handling(dirUrl).stat(dirUrl, fileName);
    }

    @Override
    public boolean handles(@NotNull String fileUrl) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
            Iterable $this$any$iv = this.getAll();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    AbstractFileTransfer it = (AbstractFileTransfer)element$iv;
                    boolean bl2 = false;
                    if (!it.handles(fileUrl)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final FileTransferHandler handling(@NotNull String fileUrl) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
            Iterable iterable = this.getAll();
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                AbstractFileTransfer it = (AbstractFileTransfer)t;
                boolean bl3 = false;
                if (!it.handles(fileUrl)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        AbstractFileTransfer abstractFileTransfer = v0;
        if (abstractFileTransfer == null) {
            throw (Throwable)((Object)new FileException("File transfer supporting URL '" + fileUrl + "' not found!"));
        }
        return abstractFileTransfer;
    }

    /*
     * WARNING - void declaration
     */
    public final void custom(@NotNull String name, @NotNull Function1<? super CustomFileTransfer, Unit> definition) {
        void $this$apply;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(definition, (String)"definition");
        CustomFileTransfer customFileTransfer = new CustomFileTransfer(this.common);
        boolean bl = false;
        boolean bl2 = false;
        CustomFileTransfer customFileTransfer2 = customFileTransfer;
        List<CustomFileTransfer> list2 = this.custom;
        boolean bl3 = false;
        $this$apply.setName(name);
        $this$apply.setProtocols(CollectionsKt.listOf((Object)(name + "://*")));
        void var8_9 = $this$apply;
        Function1<? super CustomFileTransfer, Unit> function1 = definition;
        boolean bl4 = false;
        boolean bl5 = false;
        function1.invoke((Object)var8_9);
        Unit unit = Unit.INSTANCE;
        list2.add(customFileTransfer);
    }

    @NotNull
    public final FileTransfer named(@NotNull String name) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Iterable iterable = this.getAll();
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                AbstractFileTransfer it = (AbstractFileTransfer)t;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        AbstractFileTransfer abstractFileTransfer = v0;
        if (abstractFileTransfer == null) {
            throw (Throwable)((Object)new FileException("File transfer named '" + name + "' not found!"));
        }
        return abstractFileTransfer;
    }

    public FileTransferManager(@NotNull CommonExtension common) {
        ProtocolFileTransfer $this$apply;
        Intrinsics.checkNotNullParameter((Object)common, (String)"common");
        this.common = common;
        this.logger = this.common.getProject().getLogger();
        this.user = this.common.getObj().string((Function1<? super Property<String>, Unit>)((Function1)new Function1<Property<String>, Unit>(this){
            final /* synthetic */ FileTransferManager this$0;

            public final void invoke(@NotNull Property<String> $this$string) {
                block0: {
                    Intrinsics.checkNotNullParameter($this$string, (String)"$receiver");
                    String string2 = FileTransferManager.access$getCommon$p(this.this$0).getProp().string("fileTransfer.user");
                    if (string2 == null) break block0;
                    String string3 = string2;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string3;
                    boolean bl3 = false;
                    $this$string.set((Object)it);
                }
            }
            {
                this.this$0 = fileTransferManager;
                super(1);
            }
        }));
        this.password = this.common.getObj().string((Function1<? super Property<String>, Unit>)((Function1)new Function1<Property<String>, Unit>(this){
            final /* synthetic */ FileTransferManager this$0;

            public final void invoke(@NotNull Property<String> $this$string) {
                block0: {
                    Intrinsics.checkNotNullParameter($this$string, (String)"$receiver");
                    String string2 = FileTransferManager.access$getCommon$p(this.this$0).getProp().string("fileTransfer.password");
                    if (string2 == null) break block0;
                    String string3 = string2;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string3;
                    boolean bl3 = false;
                    $this$string.set((Object)it);
                }
            }
            {
                this.this$0 = fileTransferManager;
                super(1);
            }
        }));
        this.domain = this.common.getObj().string((Function1<? super Property<String>, Unit>)((Function1)new Function1<Property<String>, Unit>(this){
            final /* synthetic */ FileTransferManager this$0;

            public final void invoke(@NotNull Property<String> $this$string) {
                block0: {
                    Intrinsics.checkNotNullParameter($this$string, (String)"$receiver");
                    String string2 = FileTransferManager.access$getCommon$p(this.this$0).getProp().string("fileTransfer.domain");
                    if (string2 == null) break block0;
                    String string3 = string2;
                    boolean bl = false;
                    boolean bl2 = false;
                    String it = string3;
                    boolean bl3 = false;
                    $this$string.set((Object)it);
                }
            }
            {
                this.this$0 = fileTransferManager;
                super(1);
            }
        }));
        this.factory = new FileTransferFactory(this.common);
        ProtocolFileTransfer protocolFileTransfer = new HttpFileTransfer(this.common);
        boolean bl = false;
        boolean bl2 = false;
        HttpFileTransfer httpFileTransfer = protocolFileTransfer;
        FileTransferManager fileTransferManager = this;
        boolean bl3 = false;
        ((HttpFileTransfer)$this$apply).getClient$common_plugin().getBasicUser().convention((Provider)this.user);
        ((HttpFileTransfer)$this$apply).getClient$common_plugin().getBasicPassword().convention((Provider)this.password);
        Unit unit = Unit.INSTANCE;
        fileTransferManager.http = protocolFileTransfer;
        protocolFileTransfer = new SftpFileTransfer(this.common);
        bl = false;
        bl2 = false;
        $this$apply = protocolFileTransfer;
        fileTransferManager = this;
        boolean bl4 = false;
        ((SftpFileTransfer)$this$apply).getUser().convention((Provider)this.user);
        ((SftpFileTransfer)$this$apply).getPassword().convention((Provider)this.password);
        unit = Unit.INSTANCE;
        fileTransferManager.sftp = protocolFileTransfer;
        protocolFileTransfer = new SmbFileTransfer(this.common);
        bl = false;
        bl2 = false;
        $this$apply = protocolFileTransfer;
        fileTransferManager = this;
        boolean bl5 = false;
        ((SmbFileTransfer)$this$apply).getUser().convention((Provider)this.user);
        ((SmbFileTransfer)$this$apply).getPassword().convention((Provider)this.password);
        ((SmbFileTransfer)$this$apply).getDomain().convention((Provider)this.domain);
        unit = Unit.INSTANCE;
        fileTransferManager.smb = protocolFileTransfer;
        this.resolve = new ResolveFileTransfer(this.common);
        this.url = new UrlFileTransfer(this.common);
        this.path = new PathFileTransfer(this.common);
        boolean bl6 = false;
        this.custom = new ArrayList();
    }

    @Override
    public void download(@NotNull String fileUrl, @NotNull File target) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        FileTransfer.DefaultImpls.download(this, fileUrl, target);
    }

    @Override
    public void uploadTo(@NotNull String dirUrl, @NotNull File source) {
        Intrinsics.checkNotNullParameter((Object)dirUrl, (String)"dirUrl");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        FileTransfer.DefaultImpls.uploadTo(this, dirUrl, source);
    }

    @Override
    @Nullable
    public FileEntry stat(@NotNull String fileUrl) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        return FileTransfer.DefaultImpls.stat(this, fileUrl);
    }

    @Override
    @NotNull
    public File downloadTo(@NotNull String fileUrl, @NotNull File dir2) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        Intrinsics.checkNotNullParameter((Object)dir2, (String)"dir");
        return FileTransfer.DefaultImpls.downloadTo(this, fileUrl, dir2);
    }

    @Override
    public void upload(@NotNull String fileUrl, @NotNull File source) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        FileTransfer.DefaultImpls.upload(this, fileUrl, source);
    }

    @Override
    public void delete(@NotNull String fileUrl) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        FileTransfer.DefaultImpls.delete(this, fileUrl);
    }

    @Override
    public boolean exists(@NotNull String fileUrl) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        return FileTransfer.DefaultImpls.exists(this, fileUrl);
    }

    @Override
    public boolean exists(@NotNull String dirUrl, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)dirUrl, (String)"dirUrl");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return FileTransfer.DefaultImpls.exists(this, dirUrl, fileName);
    }

    public static final /* synthetic */ CommonExtension access$getCommon$p(FileTransferManager $this) {
        return $this.common;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/cognifide/gradle/common/file/transfer/FileTransferManager$Companion;", "", "()V", "NAME", "", "TMP_SUFFIX", "common-plugin"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

