/*
 * Decompiled with CFR 0.152.
 */
package com.cognifide.gradle.common.file.transfer;

import com.cognifide.gradle.common.CommonExtension;
import com.cognifide.gradle.common.file.FileException;
import com.cognifide.gradle.common.file.transfer.AbstractFileTransfer;
import com.cognifide.gradle.common.file.transfer.FileDownloader;
import com.cognifide.gradle.common.file.transfer.FileEntry;
import com.cognifide.gradle.common.file.transfer.FileTransferHandler;
import com.cognifide.gradle.common.file.transfer.FileUploader;
import com.cognifide.gradle.common.file.transfer.FileUtils;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0015H\u0016J \u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u0018H\u0016J!\u0010\u001c\u001a\u00020\u001d2\u0019\b\u0002\u0010\u001e\u001a\u0013\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u00130\u001f\u00a2\u0006\u0002\b J\u0016\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001a\u0010$\u001a\u0004\u0018\u00010#2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0015H\u0016J\u0010\u0010%\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J \u0010&\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010'\u001a\u00020\u0018H\u0016J!\u0010(\u001a\u00020)2\u0019\b\u0002\u0010\u001e\u001a\u0013\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020\u00130\u001f\u00a2\u0006\u0002\b R\u0014\u0010\u0003\u001a\u00020\u0004X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R8\u0010\b\u001a&\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n \u000b*\u0012\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0018\u00010\t0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR8\u0010\u000e\u001a&\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n \u000b*\u0012\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0018\u00010\u000f0\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006*"}, d2={"Lcom/cognifide/gradle/common/file/transfer/AbstractFileTransfer;", "Lcom/cognifide/gradle/common/file/transfer/FileTransferHandler;", "Ljava/io/Serializable;", "common", "Lcom/cognifide/gradle/common/CommonExtension;", "(Lcom/cognifide/gradle/common/CommonExtension;)V", "getCommon", "()Lcom/cognifide/gradle/common/CommonExtension;", "enabled", "Lorg/gradle/api/provider/Property;", "", "kotlin.jvm.PlatformType", "getEnabled", "()Lorg/gradle/api/provider/Property;", "parallelable", "Lorg/gradle/api/provider/Provider;", "getParallelable", "()Lorg/gradle/api/provider/Provider;", "deleteFrom", "", "dirUrl", "", "fileName", "download", "Ljava/io/File;", "fileUrl", "downloadFrom", "target", "downloader", "Lcom/cognifide/gradle/common/file/transfer/FileDownloader;", "options", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "list", "", "Lcom/cognifide/gradle/common/file/transfer/FileEntry;", "stat", "truncate", "uploadTo", "source", "uploader", "Lcom/cognifide/gradle/common/file/transfer/FileUploader;", "common-plugin"})
public abstract class AbstractFileTransfer
implements FileTransferHandler,
Serializable {
    private final Property<Boolean> enabled;
    private final Provider<Boolean> parallelable;
    @NotNull
    private final CommonExtension common;

    @Override
    public Property<Boolean> getEnabled() {
        return this.enabled;
    }

    @Override
    public Provider<Boolean> getParallelable() {
        return this.parallelable;
    }

    @Override
    @NotNull
    public File download(@NotNull String fileUrl) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        String string2 = FileUtils.INSTANCE.nameFromUrl(fileUrl);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"FileUtils.nameFromUrl(fileUrl)");
        File file2 = this.common.temporaryFile(string2);
        boolean bl = false;
        boolean bl2 = false;
        File it = file2;
        boolean bl3 = false;
        this.download(fileUrl, it);
        return file2;
    }

    @Override
    public void downloadFrom(@NotNull String dirUrl, @NotNull String fileName, @NotNull File target) {
        Intrinsics.checkNotNullParameter((Object)dirUrl, (String)"dirUrl");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        throw (Throwable)((Object)new FileException("File transfer '" + this.getName() + "' does not support 'download' operation."));
    }

    @Override
    public void uploadTo(@NotNull String dirUrl, @NotNull String fileName, @NotNull File source) {
        Intrinsics.checkNotNullParameter((Object)dirUrl, (String)"dirUrl");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        throw (Throwable)((Object)new FileException("File transfer '" + this.getName() + "' does not support 'upload' operation."));
    }

    @Override
    public void deleteFrom(@NotNull String dirUrl, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)dirUrl, (String)"dirUrl");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        throw (Throwable)((Object)new FileException("File transfer '" + this.getName() + "' does not support 'delete' operation."));
    }

    @Override
    public void truncate(@NotNull String dirUrl) {
        Intrinsics.checkNotNullParameter((Object)dirUrl, (String)"dirUrl");
        throw (Throwable)((Object)new FileException("File transfer '" + this.getName() + "' does not support 'truncate' operation."));
    }

    @Override
    @NotNull
    public List<FileEntry> list(@NotNull String dirUrl) {
        Intrinsics.checkNotNullParameter((Object)dirUrl, (String)"dirUrl");
        throw (Throwable)((Object)new FileException("File transfer '" + this.getName() + "' does not support 'list' operation."));
    }

    @Override
    @Nullable
    public FileEntry stat(@NotNull String dirUrl, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)dirUrl, (String)"dirUrl");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        throw (Throwable)((Object)new FileException("File transfer '" + this.getName() + "' does not support 'stat' operation."));
    }

    @NotNull
    public final FileDownloader downloader(@NotNull Function1<? super FileDownloader, Unit> options2) {
        Intrinsics.checkNotNullParameter(options2, (String)"options");
        FileDownloader fileDownloader = new FileDownloader(this.common);
        boolean bl = false;
        boolean bl2 = false;
        options2.invoke((Object)fileDownloader);
        return fileDownloader;
    }

    public static /* synthetic */ FileDownloader downloader$default(AbstractFileTransfer abstractFileTransfer, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: downloader");
        }
        if ((n & 1) != 0) {
            function1 = downloader.1.INSTANCE;
        }
        return abstractFileTransfer.downloader((Function1<? super FileDownloader, Unit>)function1);
    }

    @NotNull
    public final FileUploader uploader(@NotNull Function1<? super FileUploader, Unit> options2) {
        Intrinsics.checkNotNullParameter(options2, (String)"options");
        FileUploader fileUploader = new FileUploader(this.common);
        boolean bl = false;
        boolean bl2 = false;
        options2.invoke((Object)fileUploader);
        return fileUploader;
    }

    public static /* synthetic */ FileUploader uploader$default(AbstractFileTransfer abstractFileTransfer, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: uploader");
        }
        if ((n & 1) != 0) {
            function1 = uploader.1.INSTANCE;
        }
        return abstractFileTransfer.uploader((Function1<? super FileUploader, Unit>)function1);
    }

    @NotNull
    protected final CommonExtension getCommon() {
        return this.common;
    }

    public AbstractFileTransfer(@NotNull CommonExtension common) {
        Intrinsics.checkNotNullParameter((Object)common, (String)"common");
        this.common = common;
        this.enabled = this.common.getObj().boolean((Function1<? super Property<Boolean>, Unit>)((Function1)enabled.1.INSTANCE));
        this.parallelable = this.common.getObj().provider(parallelable.1.INSTANCE);
    }

    @Override
    public void download(@NotNull String fileUrl, @NotNull File target) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        FileTransferHandler.DefaultImpls.download(this, fileUrl, target);
    }

    @Override
    public void uploadTo(@NotNull String dirUrl, @NotNull File source) {
        Intrinsics.checkNotNullParameter((Object)dirUrl, (String)"dirUrl");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        FileTransferHandler.DefaultImpls.uploadTo(this, dirUrl, source);
    }

    @Override
    @Nullable
    public FileEntry stat(@NotNull String fileUrl) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        return FileTransferHandler.DefaultImpls.stat(this, fileUrl);
    }

    @Override
    @NotNull
    public File downloadTo(@NotNull String fileUrl, @NotNull File dir2) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        Intrinsics.checkNotNullParameter((Object)dir2, (String)"dir");
        return FileTransferHandler.DefaultImpls.downloadTo(this, fileUrl, dir2);
    }

    @Override
    public void upload(@NotNull String fileUrl, @NotNull File source) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        FileTransferHandler.DefaultImpls.upload(this, fileUrl, source);
    }

    @Override
    public void delete(@NotNull String fileUrl) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        FileTransferHandler.DefaultImpls.delete(this, fileUrl);
    }

    @Override
    public boolean exists(@NotNull String fileUrl) {
        Intrinsics.checkNotNullParameter((Object)fileUrl, (String)"fileUrl");
        return FileTransferHandler.DefaultImpls.exists(this, fileUrl);
    }

    @Override
    public boolean exists(@NotNull String dirUrl, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)dirUrl, (String)"dirUrl");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        return FileTransferHandler.DefaultImpls.exists(this, dirUrl, fileName);
    }
}

