/*
 * Decompiled with CFR 0.152.
 */
package com.cognifide.gradle.common.file.resolver;

import com.cognifide.gradle.common.CommonExtension;
import com.cognifide.gradle.common.file.resolver.FileGroup;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import org.gradle.api.Action;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileTree;
import org.gradle.api.tasks.util.PatternFilterable;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\b\u0016\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u001b\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u0005J\u001c\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\b0\u001f2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u0005J\u000e\u0010!\u001a\u00020\"2\u0006\u0010\u001c\u001a\u00020\bJ\u001e\u0010#\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\bJ\u001e\u0010%\u001a\u00020&2\u0006\u0010\u001c\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u00052\u0006\u0010'\u001a\u00020\bJ\u0016\u0010(\u001a\u00020&2\u0006\u0010)\u001a\u00020\b2\u0006\u0010$\u001a\u00020\bJ\u0016\u0010*\u001a\u00020&2\u0006\u0010)\u001a\u00020\b2\u0006\u0010'\u001a\u00020\bJ\u0006\u0010+\u001a\u00020\bJ%\u0010,\u001a\u00020&2\u001d\u0010-\u001a\u0019\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0019\u00a2\u0006\u0002\b\u001aJ%\u0010.\u001a\u00020&2\u001d\u0010-\u001a\u0019\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020&0\u0019\u00a2\u0006\u0002\b\u001aR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\f\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u000f\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0010\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u0017\u001a\u001f\u0012\u001b\u0012\u0019\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0019\u00a2\u0006\u0002\b\u001a0\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/cognifide/gradle/common/file/resolver/FileResolution;", "", "group", "Lcom/cognifide/gradle/common/file/resolver/FileGroup;", "id", "", "resolver", "Lkotlin/Function1;", "Ljava/io/File;", "(Lcom/cognifide/gradle/common/file/resolver/FileGroup;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "common", "Lcom/cognifide/gradle/common/CommonExtension;", "dir", "getDir", "()Ljava/io/File;", "file", "getFile", "file$delegate", "Lkotlin/Lazy;", "getGroup", "()Lcom/cognifide/gradle/common/file/resolver/FileGroup;", "getId", "()Ljava/lang/String;", "thenOperations", "", "Lkotlin/Function2;", "Lkotlin/ExtensionFunctionType;", "archiveFile", "archive", "entryPattern", "archiveFiles", "Lkotlin/sequences/Sequence;", "entriesPattern", "archiveTree", "Lorg/gradle/api/file/FileTree;", "copyArchiveFile", "target", "copyArchiveFiles", "", "targetDir", "copyFile", "source", "copyToDirectory", "resolve", "then", "operation", "use", "common-plugin"})
public class FileResolution {
    private final CommonExtension common;
    @NotNull
    private final Lazy file$delegate;
    private List<Function2<FileResolution, File, File>> thenOperations;
    @NotNull
    private final FileGroup group;
    @NotNull
    private final String id;
    private final Function1<FileResolution, File> resolver;

    @NotNull
    public final File getDir() {
        Object object = this.group.getResolver().getDownloadDir().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"group.resolver.downloadDir.get()");
        File file2 = ((Directory)object).getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"group.resolver.downloadDir.get().asFile");
        return FilesKt.resolve((File)file2, (String)this.id);
    }

    @NotNull
    public final File getFile() {
        Lazy lazy = this.file$delegate;
        FileResolution fileResolution = this;
        Object var3_3 = null;
        boolean bl = false;
        return (File)lazy.getValue();
    }

    @NotNull
    public final File resolve() {
        return this.getFile();
    }

    public final void use(@NotNull Function2<? super FileResolution, ? super File, Unit> operation) {
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        this.then((Function2<? super FileResolution, ? super File, ? extends File>)((Function2)new Function2<FileResolution, File, File>(operation){
            final /* synthetic */ Function2 $operation;

            @NotNull
            public final File invoke(@NotNull FileResolution $this$then, @NotNull File it) {
                Intrinsics.checkNotNullParameter((Object)$this$then, (String)"$receiver");
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$operation.invoke((Object)$this$then, (Object)it);
                return it;
            }
            {
                this.$operation = function2;
                super(2);
            }
        }));
    }

    public final void then(@NotNull Function2<? super FileResolution, ? super File, ? extends File> operation) {
        Intrinsics.checkNotNullParameter(operation, (String)"operation");
        this.thenOperations.add(operation);
    }

    public final void copyFile(@NotNull File source, @NotNull File target) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (!target.exists()) {
            this.common.getLogger().info("Copying resolved file '" + source + "' to file '" + target + '\'');
            FilesKt.copyTo$default((File)source, (File)target, (boolean)false, (int)0, (int)6, null);
        }
    }

    public final void copyToDirectory(@NotNull File source, @NotNull File targetDir) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
        File targetFile = new File(targetDir, source.getName());
        if (!targetFile.exists()) {
            FilesKt.copyTo$default((File)source, (File)targetFile, (boolean)false, (int)0, (int)6, null);
        }
    }

    @NotNull
    public final FileTree archiveTree(@NotNull File archive) {
        FileTree fileTree;
        Intrinsics.checkNotNullParameter((Object)archive, (String)"archive");
        String string2 = FilesKt.getExtension((File)archive);
        switch (string2.hashCode()) {
            case 120609: {
                if (string2.equals("zip")) {
                    FileTree fileTree2 = this.common.getProject().zipTree((Object)archive);
                    fileTree = fileTree2;
                    Intrinsics.checkNotNullExpressionValue((Object)fileTree2, (String)"common.project.zipTree(archive)");
                    break;
                }
            }
            default: {
                FileTree fileTree3 = this.common.getProject().tarTree((Object)archive);
                fileTree = fileTree3;
                Intrinsics.checkNotNullExpressionValue((Object)fileTree3, (String)"common.project.tarTree(archive)");
            }
        }
        return fileTree;
    }

    @NotNull
    public final File archiveFile(@NotNull File archive, @NotNull String entryPattern) {
        Intrinsics.checkNotNullParameter((Object)archive, (String)"archive");
        Intrinsics.checkNotNullParameter((Object)entryPattern, (String)"entryPattern");
        FileTree fileTree = this.archiveTree(archive).matching((Action)new Action<PatternFilterable>(entryPattern){
            final /* synthetic */ String $entryPattern;

            public final void execute(PatternFilterable it) {
                it.include(new String[]{this.$entryPattern});
            }
            {
                this.$entryPattern = string2;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"archiveTree(archive)\n   \u2026t.include(entryPattern) }");
        File file2 = fileTree.getSingleFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"archiveTree(archive)\n   \u2026ntryPattern) }.singleFile");
        return file2;
    }

    @NotNull
    public final Sequence<File> archiveFiles(@NotNull File archive, @NotNull String entriesPattern) {
        Intrinsics.checkNotNullParameter((Object)archive, (String)"archive");
        Intrinsics.checkNotNullParameter((Object)entriesPattern, (String)"entriesPattern");
        FileTree fileTree = this.archiveTree(archive).matching((Action)new Action<PatternFilterable>(entriesPattern){
            final /* synthetic */ String $entriesPattern;

            public final void execute(PatternFilterable it) {
                it.include(new String[]{this.$entriesPattern});
            }
            {
                this.$entriesPattern = string2;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)fileTree, (String)"archiveTree(archive)\n   \u2026include(entriesPattern) }");
        return CollectionsKt.asSequence((Iterable)((Iterable)fileTree));
    }

    @NotNull
    public final File copyArchiveFile(@NotNull File archive, @NotNull String entryPattern, @NotNull File target) {
        Intrinsics.checkNotNullParameter((Object)archive, (String)"archive");
        Intrinsics.checkNotNullParameter((Object)entryPattern, (String)"entryPattern");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        File file2 = target;
        boolean bl = false;
        boolean bl2 = false;
        File $this$apply = file2;
        boolean bl3 = false;
        if (!$this$apply.exists()) {
            File archiveFile2 = this.archiveFile(archive, entryPattern);
            this.common.getLogger().info("Copying resolved archive file '" + archiveFile2 + "' to '" + $this$apply + '\'');
            FilesKt.copyTo$default((File)archiveFile2, (File)$this$apply, (boolean)false, (int)0, (int)6, null);
        }
        return file2;
    }

    public final void copyArchiveFiles(@NotNull File archive, @NotNull String entriesPattern, @NotNull File targetDir) {
        Intrinsics.checkNotNullParameter((Object)archive, (String)"archive");
        Intrinsics.checkNotNullParameter((Object)entriesPattern, (String)"entriesPattern");
        Intrinsics.checkNotNullParameter((Object)targetDir, (String)"targetDir");
        Sequence<File> $this$forEach$iv = this.archiveFiles(archive, entriesPattern);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            File archiveFile2 = (File)element$iv;
            boolean bl = false;
            File file2 = new File(targetDir, archiveFile2.getName());
            boolean bl2 = false;
            boolean bl3 = false;
            File $this$apply = file2;
            boolean bl4 = false;
            if ($this$apply.exists()) continue;
            this.common.getLogger().info("Copying resolved archive file '" + archiveFile2 + "' to '" + $this$apply + '\'');
            FilesKt.copyTo$default((File)archiveFile2, (File)$this$apply, (boolean)false, (int)0, (int)6, null);
        }
    }

    @NotNull
    public final FileGroup getGroup() {
        return this.group;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public FileResolution(@NotNull FileGroup group2, @NotNull String id, @NotNull Function1<? super FileResolution, ? extends File> resolver) {
        Intrinsics.checkNotNullParameter((Object)group2, (String)"group");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(resolver, (String)"resolver");
        this.group = group2;
        this.id = id;
        this.resolver = resolver;
        this.common = this.group.getResolver().getCommon();
        this.file$delegate = LazyKt.lazy((Function0)((Function0)new Function0<File>(this){
            final /* synthetic */ FileResolution this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final File invoke() {
                void $this$fold$iv;
                Iterable iterable = FileResolution.access$getThenOperations$p(this.this$0);
                Object initial$iv = FileResolution.access$getResolver$p(this.this$0).invoke((Object)this.this$0);
                boolean $i$f$fold = false;
                Object accumulator$iv = initial$iv;
                for (T element$iv : $this$fold$iv) {
                    void o;
                    Function2 function2 = (Function2)element$iv;
                    File f = (File)accumulator$iv;
                    boolean bl = false;
                    accumulator$iv = (File)o.invoke((Object)this.this$0, (Object)f);
                }
                return (File)accumulator$iv;
            }
            {
                this.this$0 = fileResolution;
                super(0);
            }
        }));
        boolean bl = false;
        this.thenOperations = new ArrayList();
    }

    public static final /* synthetic */ List access$getThenOperations$p(FileResolution $this) {
        return $this.thenOperations;
    }

    public static final /* synthetic */ void access$setThenOperations$p(FileResolution $this, List list2) {
        $this.thenOperations = list2;
    }

    public static final /* synthetic */ Function1 access$getResolver$p(FileResolution $this) {
        return $this.resolver;
    }
}

