/*
 * Decompiled with CFR 0.152.
 */
package com.codetaco.math.impl.token;

import com.codetaco.math.impl.EquImpl;
import com.codetaco.math.impl.EquPart;
import com.codetaco.math.impl.token.TokLiteral;
import com.codetaco.math.impl.token.TokNumber;
import com.codetaco.math.impl.token.TokOperator;
import com.codetaco.math.impl.token.TokVariable;
import java.util.Collection;

public abstract class Token
extends EquPart {
    private StringBuffer value;

    public static Token instanceFor(EquImpl equ, char c) {
        if (c == '\'' || c == '\"') {
            return new TokLiteral(equ, c);
        }
        if (Character.isDigit(c) || c == '-' || c == '.') {
            return new TokNumber(equ);
        }
        if (Character.isLetter(c) || c == '_') {
            return new TokVariable(equ);
        }
        return new TokOperator(equ);
    }

    public Token(EquImpl equ) {
        super(equ);
        this.setValue(new StringBuffer());
    }

    public boolean accepts(char c) {
        return true;
    }

    public boolean accepts(char c, char peek) {
        return this.accepts(c);
    }

    public void addTo(Collection<EquPart> tokens) throws Exception {
        tokens.add(this.morph());
    }

    public StringBuffer getValue() {
        return this.value;
    }

    protected EquPart morph() throws Exception {
        return this;
    }

    public void put(char c) {
        this.getValue().append(c);
    }

    public void setValue(StringBuffer newValue) {
        this.value = newValue;
    }

    public String toString() {
        return this.getValue().toString();
    }
}

