/*
 * Decompiled with CFR 0.152.
 */
package com.codetaco.math.impl.operator;

import com.codetaco.math.impl.EquImpl;
import com.codetaco.math.impl.EquPart;
import com.codetaco.math.impl.Operator;
import com.codetaco.math.impl.ValueStack;
import java.text.ParseException;

public class OpNegate
extends Operator {
    public OpNegate(EquImpl equ) {
        super(equ);
    }

    public OpNegate(EquImpl equ, EquPart opTok) {
        super(equ, opTok);
    }

    @Override
    protected int precedence() {
        return 3;
    }

    @Override
    public void resolve(ValueStack values) throws Exception {
        block5: {
            if (values.size() < 1) {
                throw new Exception("missing operands for " + this.toString());
            }
            try {
                Object value = values.popWhatever();
                if (value instanceof Long) {
                    values.push(new Long(0L - (Long)value));
                    break block5;
                }
                if (value instanceof Double) {
                    values.push(new Double(0.0 - (Double)value));
                    break block5;
                }
                throw new Exception(this.toString() + "; invalid type: " + value.toString());
            }
            catch (ParseException e) {
                e.fillInStackTrace();
                throw new Exception(this.toString() + "; " + e.getMessage(), e);
            }
        }
    }

    public String toString() {
        return "op(negate)";
    }
}

