/*
 * Decompiled with CFR 0.152.
 */
package com.codetaco.math.impl.operator;

import com.codetaco.math.impl.EquImpl;
import com.codetaco.math.impl.EquPart;
import com.codetaco.math.impl.Operator;
import com.codetaco.math.impl.ValueStack;
import java.text.ParseException;

public class OpMultiply
extends Operator {
    public OpMultiply(EquImpl equ) {
        super(equ);
    }

    public OpMultiply(EquImpl equ, EquPart opTok) {
        super(equ, opTok);
    }

    @Override
    protected int precedence() {
        return 4;
    }

    @Override
    public void resolve(ValueStack values) throws Exception {
        block7: {
            if (values.size() < 2) {
                throw new Exception("missing operands for " + this.toString());
            }
            try {
                Object[] value = values.ensureSameTypes();
                if (value[0] instanceof Integer) {
                    values.push((Integer)value[1] * (Integer)value[0]);
                    break block7;
                }
                if (value[0] instanceof Long) {
                    values.push((Long)value[1] * (Long)value[0]);
                    break block7;
                }
                if (value[0] instanceof Float) {
                    values.push(Float.valueOf(((Float)value[1]).floatValue() * ((Float)value[0]).floatValue()));
                    break block7;
                }
                if (value[0] instanceof Double) {
                    values.push((Double)value[1] * (Double)value[0]);
                    break block7;
                }
                throw new Exception("invalid types");
            }
            catch (ParseException e) {
                e.fillInStackTrace();
                throw new Exception(this.toString() + "; " + e.getMessage(), e);
            }
        }
    }

    public String toString() {
        return "op(multiply)";
    }
}

