/*
 * Decompiled with CFR 0.152.
 */
package com.codetaco.math.impl.operator;

import com.codetaco.math.impl.EquImpl;
import com.codetaco.math.impl.EquPart;
import com.codetaco.math.impl.Operation;
import com.codetaco.math.impl.Operator;
import com.codetaco.math.impl.ValueStack;
import com.codetaco.math.impl.token.TokVariable;
import com.codetaco.math.impl.token.TokVariableWithValue;
import java.text.ParseException;

public class OpAssignment
extends Operator {
    public OpAssignment(EquImpl equ) {
        super(equ);
    }

    public OpAssignment(EquImpl equ, EquPart opTok) {
        super(equ, opTok);
    }

    @Override
    protected int precedence() {
        return 990;
    }

    @Override
    public boolean preceeds(Operation rightOp) {
        if (rightOp instanceof OpAssignment) {
            return false;
        }
        return super.preceeds(rightOp);
    }

    @Override
    public void resolve(ValueStack values) throws Exception {
        if (values.size() < 2) {
            throw new Exception("missing operands for " + this.toString());
        }
        try {
            Object op2 = values.popExactly();
            Object op1 = values.popExactly();
            if (op2 instanceof TokVariable) {
                throw new Exception("invalid assignment value: " + op2.toString());
            }
            if (op1 instanceof TokVariable) {
                this.getEqu().getSupport().assignVariable(((TokVariable)op1).getValue().toString(), op2);
                values.push(op2);
                return;
            }
            if (op1 instanceof TokVariableWithValue) {
                TokVariableWithValue varValue1 = (TokVariableWithValue)op1;
                this.getEqu().getSupport().assignVariable(varValue1.getVariable().getValue().toString(), op2);
                values.push(op2);
                return;
            }
            throw new Exception("invalid assignment target: " + op1.toString());
        }
        catch (ParseException e) {
            e.fillInStackTrace();
            throw new Exception(this.toString() + "; " + e.getMessage(), e);
        }
    }

    public String toString() {
        return "op(assignment)";
    }
}

