/*
 * Decompiled with CFR 0.152.
 */
package com.codetaco.math.impl.function;

import com.codetaco.math.impl.EquImpl;
import com.codetaco.math.impl.Function;
import com.codetaco.math.impl.ValueStack;
import com.codetaco.math.impl.support.EquationSupport;
import com.codetaco.math.impl.token.TokVariable;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Hashtable;

public class FuncTieredRate
extends Function {
    public FuncTieredRate(EquImpl equ) {
        super(equ);
    }

    public FuncTieredRate(EquImpl equ, TokVariable var) {
        super(equ, var);
    }

    @Override
    public void resolve(ValueStack values) throws Exception {
        if (values.size() < 2) {
            throw new Exception("missing operands for " + this.toString());
        }
        try {
            String tableName = values.popString();
            Double baseAmount = values.popDouble();
            if (baseAmount == 0.0) {
                values.push(new Double(0.0));
                return;
            }
            EquationSupport model = this.getEqu().getSupport();
            Hashtable<Double, Double> rateTable = model.resolveRate(tableName, this.getEqu().getBaseDate(), baseAmount);
            double blendedRate = 0.0;
            double previousLimit = 0.0;
            double previousRate = 0.0;
            Enumeration<Double> limits = rateTable.keys();
            while (limits.hasMoreElements()) {
                Double limit = limits.nextElement();
                Double rate = rateTable.get(limit);
                if (previousRate > 0.0) {
                    blendedRate += previousRate * ((limit - previousLimit) / baseAmount);
                }
                previousRate = rate;
                previousLimit = limit;
            }
            if (previousRate > 0.0) {
                blendedRate += previousRate * ((baseAmount - previousLimit) / baseAmount);
            }
            values.push(new Double(blendedRate));
        }
        catch (ParseException e) {
            e.fillInStackTrace();
            throw new Exception(this.toString() + "; " + e.getMessage(), e);
        }
    }

    public String toString() {
        return "function(tieredrate)";
    }
}

