/*
 * Decompiled with CFR 0.152.
 */
package com.codetaco.math.impl.function;

import com.codetaco.math.impl.EquImpl;
import com.codetaco.math.impl.Function;
import com.codetaco.math.impl.ValueStack;
import com.codetaco.math.impl.token.TokVariable;
import java.text.ParseException;

public class FuncAcotan
extends Function {
    public FuncAcotan(EquImpl equ) {
        super(equ);
    }

    public FuncAcotan(EquImpl equ, TokVariable var) {
        super(equ, var);
    }

    @Override
    public void resolve(ValueStack values) throws Exception {
        if (values.size() < 1) {
            throw new Exception("missing operands for " + this.toString());
        }
        try {
            double degrees = values.popDouble();
            double rads = degrees * (Math.PI / 180);
            values.push(new Double(1.5707963267948966 - Math.atan(rads)));
        }
        catch (ParseException e) {
            e.fillInStackTrace();
            throw new Exception(this.toString() + "; " + e.getMessage(), e);
        }
    }

    public String toString() {
        return "function(acotan)";
    }
}

