/*
 * Decompiled with CFR 0.152.
 */
package com.codetaco.math.impl.function;

import com.codetaco.date.CalendarFactory;
import com.codetaco.math.impl.EquImpl;
import com.codetaco.math.impl.Function;
import com.codetaco.math.impl.ValueStack;
import com.codetaco.math.impl.token.TokVariable;
import java.text.ParseException;
import java.time.ZonedDateTime;

public abstract class AbstractToTemporal
extends Function {
    AbstractToTemporal(EquImpl equ) {
        super(equ);
    }

    AbstractToTemporal(EquImpl equ, TokVariable var) {
        super(equ, var);
    }

    @Override
    public void resolve(ValueStack values) throws Exception {
        if (values.size() < 1) {
            throw new Exception("missing operands for " + this.toString());
        }
        try {
            if (this.getParameterCount() == 2) {
                String userSuppliedFormatString = values.popString();
                this.parseWithUserSuppliedFormat(values, userSuppliedFormatString, values.popString());
            } else {
                this.parseWithKnownFormats(values, values.popWhatever());
            }
        }
        catch (ParseException e) {
            e.fillInStackTrace();
            throw new Exception(this.toString() + "; " + e.getMessage(), e);
        }
    }

    abstract void parseWithUserSuppliedFormat(ValueStack var1, String var2, String var3);

    private void parseWithKnownFormats(ValueStack values, Object inputObject) throws Exception {
        if (inputObject instanceof String) {
            values.push(CalendarFactory.asZoned((String)((String)inputObject), (String[])new String[]{this.adjustments()}));
        } else {
            if (inputObject instanceof TokVariable) {
                throw new Exception("unresolved variable: " + ((TokVariable)inputObject).getName());
            }
            if (inputObject instanceof Long) {
                values.push(CalendarFactory.asZoned((long)((Long)inputObject), (String[])new String[]{this.adjustments()}));
            } else if (inputObject instanceof Double) {
                values.push(CalendarFactory.asZoned((long)((Double)inputObject).longValue(), (String[])new String[]{this.adjustments()}));
            } else {
                values.push(CalendarFactory.asZoned((ZonedDateTime)((ZonedDateTime)inputObject), (String[])new String[]{this.adjustments()}));
            }
        }
    }

    abstract String adjustments();
}

