/*
 * Decompiled with CFR 0.152.
 */
package com.codetaco.math.impl;

import com.codetaco.math.MathException;
import com.codetaco.math.impl.EquPart;
import com.codetaco.math.impl.Function;
import com.codetaco.math.impl.Operation;
import com.codetaco.math.impl.Operator;
import com.codetaco.math.impl.ValueStack;
import com.codetaco.math.impl.function.FuncAbs;
import com.codetaco.math.impl.function.FuncAcos;
import com.codetaco.math.impl.function.FuncAcotan;
import com.codetaco.math.impl.function.FuncAlpha;
import com.codetaco.math.impl.function.FuncAsin;
import com.codetaco.math.impl.function.FuncAtan;
import com.codetaco.math.impl.function.FuncBandedRate;
import com.codetaco.math.impl.function.FuncBytesToHex;
import com.codetaco.math.impl.function.FuncCos;
import com.codetaco.math.impl.function.FuncCubeRoot;
import com.codetaco.math.impl.function.FuncDate;
import com.codetaco.math.impl.function.FuncDateTime;
import com.codetaco.math.impl.function.FuncDegreesToRads;
import com.codetaco.math.impl.function.FuncFlatRate;
import com.codetaco.math.impl.function.FuncHaversine;
import com.codetaco.math.impl.function.FuncIf;
import com.codetaco.math.impl.function.FuncKm2Mi;
import com.codetaco.math.impl.function.FuncLog;
import com.codetaco.math.impl.function.FuncLog10;
import com.codetaco.math.impl.function.FuncMax;
import com.codetaco.math.impl.function.FuncMi2Km;
import com.codetaco.math.impl.function.FuncMin;
import com.codetaco.math.impl.function.FuncNot;
import com.codetaco.math.impl.function.FuncRadsToDegrees;
import com.codetaco.math.impl.function.FuncRoot;
import com.codetaco.math.impl.function.FuncRound;
import com.codetaco.math.impl.function.FuncSin;
import com.codetaco.math.impl.function.FuncSqrt;
import com.codetaco.math.impl.function.FuncStringCat;
import com.codetaco.math.impl.function.FuncStringContains;
import com.codetaco.math.impl.function.FuncStringEmpty;
import com.codetaco.math.impl.function.FuncStringIndexOf;
import com.codetaco.math.impl.function.FuncStringLTrim;
import com.codetaco.math.impl.function.FuncStringLength;
import com.codetaco.math.impl.function.FuncStringLowerCase;
import com.codetaco.math.impl.function.FuncStringMatch;
import com.codetaco.math.impl.function.FuncStringMatches;
import com.codetaco.math.impl.function.FuncStringMetaphone;
import com.codetaco.math.impl.function.FuncStringRTrim;
import com.codetaco.math.impl.function.FuncStringReplace;
import com.codetaco.math.impl.function.FuncStringSubstr;
import com.codetaco.math.impl.function.FuncStringTrim;
import com.codetaco.math.impl.function.FuncStringUpCase;
import com.codetaco.math.impl.function.FuncTan;
import com.codetaco.math.impl.function.FuncTieredRate;
import com.codetaco.math.impl.function.FuncTime;
import com.codetaco.math.impl.function.FuncToDate;
import com.codetaco.math.impl.function.FuncToDateTime;
import com.codetaco.math.impl.function.FuncToDouble;
import com.codetaco.math.impl.function.FuncToFloat;
import com.codetaco.math.impl.function.FuncToInt;
import com.codetaco.math.impl.function.FuncToLong;
import com.codetaco.math.impl.function.FuncToString;
import com.codetaco.math.impl.function.FuncToTime;
import com.codetaco.math.impl.function.FuncTrunc;
import com.codetaco.math.impl.operator.OpAdd;
import com.codetaco.math.impl.operator.OpAnd;
import com.codetaco.math.impl.operator.OpAssignment;
import com.codetaco.math.impl.operator.OpAssignmentAdd;
import com.codetaco.math.impl.operator.OpAssignmentDivide;
import com.codetaco.math.impl.operator.OpAssignmentMinus;
import com.codetaco.math.impl.operator.OpAssignmentMultiply;
import com.codetaco.math.impl.operator.OpChain;
import com.codetaco.math.impl.operator.OpComma;
import com.codetaco.math.impl.operator.OpCompareEqual;
import com.codetaco.math.impl.operator.OpCompareGreater;
import com.codetaco.math.impl.operator.OpCompareLess;
import com.codetaco.math.impl.operator.OpCompareNotEqual;
import com.codetaco.math.impl.operator.OpCompareNotGreater;
import com.codetaco.math.impl.operator.OpCompareNotLess;
import com.codetaco.math.impl.operator.OpDivide;
import com.codetaco.math.impl.operator.OpFactorial;
import com.codetaco.math.impl.operator.OpLeftParen;
import com.codetaco.math.impl.operator.OpMinus;
import com.codetaco.math.impl.operator.OpMinusMinus;
import com.codetaco.math.impl.operator.OpMod;
import com.codetaco.math.impl.operator.OpMultiply;
import com.codetaco.math.impl.operator.OpNand;
import com.codetaco.math.impl.operator.OpNegate;
import com.codetaco.math.impl.operator.OpNor;
import com.codetaco.math.impl.operator.OpOr;
import com.codetaco.math.impl.operator.OpPlusPlus;
import com.codetaco.math.impl.operator.OpPower;
import com.codetaco.math.impl.operator.OpRightParen;
import com.codetaco.math.impl.operator.OpXnor;
import com.codetaco.math.impl.operator.OpXor;
import com.codetaco.math.impl.support.DefaultEquationSupport;
import com.codetaco.math.impl.support.EquationSupport;
import com.codetaco.math.impl.token.TokLiteral;
import com.codetaco.math.impl.token.TokVariable;
import com.codetaco.math.impl.token.TokVariableWithValue;
import com.codetaco.math.impl.token.Token;
import java.lang.reflect.Constructor;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.stream.IntStream;
import org.apache.commons.codec.language.Metaphone;

public class EquImpl {
    private static EquImpl instance;
    private Map<String, Constructor<?>> functionMap;
    private Map<String, Constructor<?>> operatorMap;
    private Date baseDate;
    private EquationSupport support;
    private String equ;
    private List<EquPart> rpn;
    private List<EquPart> tokens;
    private Set<String> variablesThatExistedBeforePreviousEvaluation;
    private Metaphone cachedMetaphone;

    public Set<String> gatherVariables() {
        HashSet<String> vars = new HashSet<String>();
        for (EquPart token : this.tokens) {
            if (!(token instanceof TokVariable)) continue;
            vars.add(((TokVariable)token).getValue().toString());
        }
        return vars;
    }

    public static EquImpl getInstance(EquationSupport support) {
        EquImpl equ = EquImpl.getInstance(true);
        return equ.setSupport(support);
    }

    public static EquImpl getInstance() {
        return EquImpl.getInstance(false);
    }

    public static EquImpl getInstance(boolean fresh) {
        if (instance == null || fresh) {
            EquImpl newInstance = new EquImpl();
            try {
                newInstance.initialize();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            instance = newInstance;
        }
        return instance;
    }

    public void compile(String _equ) {
        this.equ = _equ;
        this.tokens = this.tokenize();
        this.tokens = this.minusMinus(this.tokens);
        this.tokens = this.negatize(this.tokens);
        this.tokens = this.multiplize(this.tokens);
        this.countParameters(this.tokens);
        this.rpn = this.rpnize(this.tokens);
    }

    void countParameters(List<EquPart> oldTokens) {
        EquPart[] equParts = oldTokens.toArray(new EquPart[0]);
        for (int f = 0; f < equParts.length; ++f) {
            if (!(equParts[f] instanceof Function)) continue;
            ((Function)equParts[f]).updateParameterCount(equParts, f);
        }
    }

    public Object evaluate() {
        try {
            ValueStack values = new ValueStack();
            if (this.rpn == null) {
                return null;
            }
            if (this.variablesThatExistedBeforePreviousEvaluation != null) {
                for (String varName : this.getSupport().getVariableNames()) {
                    if (this.variablesThatExistedBeforePreviousEvaluation.contains(varName)) continue;
                    this.getSupport().removeVariable(varName);
                }
            }
            this.variablesThatExistedBeforePreviousEvaluation = this.getSupport().getVariableNames();
            for (EquPart part : this.rpn) {
                part.resolve(values);
            }
            if (values.isEmpty()) {
                return null;
            }
            Object result = values.firstElement();
            values.clear();
            if (result instanceof TokVariableWithValue) {
                return ((TokVariableWithValue)result).getCurrentValue();
            }
            return result;
        }
        catch (Exception e) {
            throw MathException.builder().cause(e).build();
        }
    }

    public Object evaluate(String _equ) {
        this.compile(_equ);
        return this.evaluate();
    }

    public Function function(TokVariable varTok) {
        String token = varTok.getValue().toString();
        Constructor<?> constructor = this.functionMap.get(token.toLowerCase());
        if (constructor == null) {
            return null;
        }
        try {
            return (Function)constructor.newInstance(this, varTok);
        }
        catch (Exception e) {
            throw MathException.builder().cause(new Exception("function construction", e)).build();
        }
    }

    public Date getBaseDate() {
        return this.baseDate;
    }

    public Metaphone getMetaphone() {
        if (this.cachedMetaphone == null) {
            this.cachedMetaphone = new Metaphone();
        }
        return this.cachedMetaphone;
    }

    public EquationSupport getSupport() {
        if (this.support == null) {
            this.setSupport(new DefaultEquationSupport());
            this.initializeSupport();
        }
        return this.support;
    }

    public void initialize() {
        this.functionMap = new Hashtable();
        this.registerFunction("if", FuncIf.class);
        this.registerFunction("rate", FuncFlatRate.class);
        this.registerFunction("bandedrate", FuncBandedRate.class);
        this.registerFunction("tieredrate", FuncTieredRate.class);
        this.registerFunction("round", FuncRound.class);
        this.registerFunction("alpha", FuncAlpha.class);
        this.registerFunction("max", FuncMax.class);
        this.registerFunction("min", FuncMin.class);
        this.registerFunction("sin", FuncSin.class);
        this.registerFunction("tan", FuncTan.class);
        this.registerFunction("abs", FuncAbs.class);
        this.registerFunction("acos", FuncAcos.class);
        this.registerFunction("acotan", FuncAcotan.class);
        this.registerFunction("asin", FuncAsin.class);
        this.registerFunction("atan", FuncAtan.class);
        this.registerFunction("cos", FuncCos.class);
        this.registerFunction("deg", FuncRadsToDegrees.class);
        this.registerFunction("rad", FuncDegreesToRads.class);
        this.registerFunction("root", FuncRoot.class);
        this.registerFunction("sqrt", FuncSqrt.class);
        this.registerFunction("cbrt", FuncCubeRoot.class);
        this.registerFunction("log", FuncLog.class);
        this.registerFunction("log10", FuncLog10.class);
        this.registerFunction("trunc", FuncTrunc.class);
        this.registerFunction("not", FuncNot.class);
        this.registerFunction("match", FuncStringMatch.class);
        this.registerFunction("matches", FuncStringMatches.class);
        this.registerFunction("contains", FuncStringContains.class);
        this.registerFunction("empty", FuncStringEmpty.class);
        this.registerFunction("isempty", FuncStringEmpty.class);
        this.registerFunction("cat", FuncStringCat.class);
        this.registerFunction("length", FuncStringLength.class);
        this.registerFunction("substr", FuncStringSubstr.class);
        this.registerFunction("rtrim", FuncStringRTrim.class);
        this.registerFunction("ltrim", FuncStringLTrim.class);
        this.registerFunction("trim", FuncStringTrim.class);
        this.registerFunction("indexOf", FuncStringIndexOf.class);
        this.registerFunction("date", FuncDate.class);
        this.registerFunction("time", FuncTime.class);
        this.registerFunction("dateTime", FuncDateTime.class);
        this.registerFunction("toDateTime", FuncToDateTime.class);
        this.registerFunction("toDate", FuncToDate.class);
        this.registerFunction("toTime", FuncToTime.class);
        this.registerFunction("toString", FuncToString.class);
        this.registerFunction("ucase", FuncStringUpCase.class);
        this.registerFunction("lcase", FuncStringLowerCase.class);
        this.registerFunction("metaphone", FuncStringMetaphone.class);
        this.registerFunction("toInt", FuncToInt.class);
        this.registerFunction("toFloat", FuncToFloat.class);
        this.registerFunction("toLong", FuncToLong.class);
        this.registerFunction("toDouble", FuncToDouble.class);
        this.registerFunction("toHex", FuncBytesToHex.class);
        this.registerFunction("replace", FuncStringReplace.class);
        this.registerFunction("haversine", FuncHaversine.class);
        this.registerFunction("mi2km", FuncMi2Km.class);
        this.registerFunction("km2mi", FuncKm2Mi.class);
        this.operatorMap = new Hashtable();
        this.registerOperator("^", OpPower.class);
        this.registerOperator(",", OpComma.class);
        this.registerOperator(";", OpChain.class);
        this.registerOperator("*", OpMultiply.class);
        this.registerOperator("/", OpDivide.class);
        this.registerOperator("+", OpAdd.class);
        this.registerOperator("-", OpMinus.class);
        this.registerOperator("(", OpLeftParen.class);
        this.registerOperator(")", OpRightParen.class);
        this.registerOperator("=", OpCompareEqual.class);
        this.registerOperator("!=", OpCompareNotEqual.class);
        this.registerOperator(">", OpCompareGreater.class);
        this.registerOperator("<=", OpCompareNotGreater.class);
        this.registerOperator("<", OpCompareLess.class);
        this.registerOperator(">=", OpCompareNotLess.class);
        this.registerOperator(":=", OpAssignment.class);
        this.registerOperator("&&", OpAnd.class);
        this.registerOperator("!&", OpNand.class);
        this.registerOperator("||", OpOr.class);
        this.registerOperator("!|", OpNor.class);
        this.registerOperator("~|", OpXor.class);
        this.registerOperator("!~|", OpXnor.class);
        this.registerOperator("%", OpMod.class);
        this.registerOperator("!", OpFactorial.class);
        this.registerOperator("+=", OpAssignmentAdd.class);
        this.registerOperator("-=", OpAssignmentMinus.class);
        this.registerOperator("*=", OpAssignmentMultiply.class);
        this.registerOperator("/=", OpAssignmentDivide.class);
        this.registerOperator("++", OpPlusPlus.class);
        this.registerOperator("--", OpMinusMinus.class);
    }

    private void initializeSupport() {
        try {
            this.getSupport();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<EquPart> multiplize(List<EquPart> oldTokens) {
        EquPart[] equParts = oldTokens.toArray(new EquPart[0]);
        EquPart[] fixed = new EquPart[equParts.length * 2];
        fixed[0] = equParts[0];
        int left = 0;
        for (int right = 1; right < equParts.length; ++right) {
            if (fixed[left].multiplize(equParts[right])) {
                OpMultiply m = new OpMultiply(this, fixed[left]);
                fixed[++left] = m;
            }
            fixed[++left] = equParts[right];
        }
        ArrayList<EquPart> tokens = new ArrayList<EquPart>();
        IntStream.range(0, fixed.length).filter(i -> fixed[i] != null).forEach(i -> tokens.add(fixed[i]));
        return tokens;
    }

    private List<EquPart> minusMinus(List<EquPart> equParts) {
        ArrayList<EquPart> newList = new ArrayList<EquPart>();
        for (int right = 1; right <= equParts.size(); ++right) {
            int left = right - 1;
            if (right < equParts.size() && equParts.get(left) instanceof OpMinus && equParts.get(right) instanceof OpMinus) {
                newList.add(new OpMinusMinus(this, equParts.get(left)));
                ++right;
                continue;
            }
            newList.add(equParts.get(left));
        }
        return newList;
    }

    private List<EquPart> negatize(List<EquPart> equParts) {
        for (int right = 1; right < equParts.size(); ++right) {
            int left = right - 1;
            if (!(equParts.get(left) instanceof OpMinus)) continue;
            if (left == 0) {
                equParts.set(left, new OpNegate(this, equParts.get(left)));
                continue;
            }
            if (!equParts.get(left - 1).negatize(equParts.get(right))) continue;
            equParts.set(left, new OpNegate(this, equParts.get(left)));
        }
        return equParts;
    }

    public Operator operator(Token tok) {
        String token = tok.getValue().toString();
        Constructor<?> constructor = this.operatorMap.get(token);
        if (constructor == null) {
            return null;
        }
        try {
            return (Operator)constructor.newInstance(this, tok);
        }
        catch (Exception e) {
            throw MathException.builder().cause(new Exception("operator construction", e)).build();
        }
    }

    public void registerFunction(String name, Class<?> functionSubclass) {
        String token = name.toLowerCase();
        if (this.functionMap.containsKey(name)) {
            throw MathException.builder().cause(new Exception("duplicate function: " + token)).build();
        }
        try {
            this.functionMap.put(token, functionSubclass.getConstructor(EquImpl.class, TokVariable.class));
        }
        catch (Exception e) {
            throw MathException.builder().cause(new Exception("register function: " + token, e)).build();
        }
    }

    private void registerOperator(String name, Class<?> operatorSubclass) {
        String token = name.toLowerCase();
        if (this.operatorMap.containsKey(name)) {
            throw MathException.builder().cause(new Exception("duplicate operator: " + token)).build();
        }
        try {
            this.operatorMap.put(token, operatorSubclass.getConstructor(EquImpl.class, EquPart.class));
        }
        catch (Exception e) {
            throw MathException.builder().cause(new Exception("register operator: " + token, e)).build();
        }
    }

    private List<EquPart> rpnize(List<EquPart> oldTokens) {
        Stack<EquPart> _rpn = new Stack<EquPart>();
        Stack<Operation> ops = new Stack<Operation>();
        for (EquPart token : oldTokens) {
            if (token instanceof Token) {
                _rpn.add(token);
                continue;
            }
            Operation rightOp = (Operation)token;
            if (ops.empty()) {
                if (!rightOp.includeInRpn()) continue;
                ops.push(rightOp);
                continue;
            }
            Operation leftOp = (Operation)ops.peek();
            if (leftOp.preceeds(rightOp)) {
                _rpn.add((EquPart)ops.pop());
                int level = rightOp.getLevel();
                if (rightOp instanceof OpRightParen) {
                    ++level;
                }
                Operation compareOp = rightOp;
                if (!ops.empty() && (leftOp = (Operation)ops.peek()).getLevel() >= level && leftOp.preceeds(compareOp)) {
                    _rpn.add((EquPart)ops.pop());
                    compareOp = leftOp;
                }
            }
            if (!rightOp.includeInRpn()) continue;
            ops.push(rightOp);
        }
        while (!ops.empty()) {
            _rpn.add((EquPart)ops.pop());
        }
        return _rpn;
    }

    public void setBaseDate(Date newBaseDate) {
        this.baseDate = newBaseDate;
    }

    public EquImpl setSupport(EquationSupport newSupport) {
        this.support = newSupport;
        return this;
    }

    public String showRPN() {
        StringBuilder sb = new StringBuilder();
        this.showRPN(sb);
        return sb.toString();
    }

    public void showRPN(StringBuilder sb) {
        for (EquPart part : this.rpn) {
            sb.append(part.toString());
            sb.append("\n");
        }
    }

    private List<EquPart> tokenize() {
        try {
            ArrayList<EquPart> tokens = new ArrayList<EquPart>();
            Token token = null;
            int level = 0;
            for (int a = 0; a < this.equ.length(); ++a) {
                char c = this.equ.charAt(a);
                int peeka = a + 1;
                char peekc = peeka == this.equ.length() ? (char)'\u0000' : this.equ.charAt(peeka);
                boolean isWhitespace = Character.isWhitespace(c);
                if (!(!isWhitespace || token instanceof TokLiteral && token.accepts(c, peekc))) {
                    if (token != null) {
                        token.addTo(tokens);
                    }
                    token = null;
                    continue;
                }
                if (c == '(') {
                    ++level;
                }
                if (c == ')') {
                    --level;
                }
                if (token != null && token.accepts(c, peekc)) {
                    token.put(c);
                    continue;
                }
                if (token != null) {
                    token.addTo(tokens);
                }
                token = Token.instanceFor(this, c);
                token.setLevel(level);
                token.put(c);
            }
            if (token != null) {
                token.addTo(tokens);
            }
            return tokens;
        }
        catch (Exception e) {
            throw MathException.builder().cause(e).build();
        }
    }

    public String toString() {
        return this.equ;
    }

    public void unregisterFunction(String name) {
        String token = name.toLowerCase();
        if (!this.functionMap.containsKey(token)) {
            throw MathException.builder().cause(new Exception("unknown function: " + token)).build();
        }
        this.functionMap.remove(token);
    }

    public void unregisterOperator(String name) {
        String token = name.toLowerCase();
        if (!this.operatorMap.containsKey(token)) {
            throw MathException.builder().cause(new Exception("unknown operator: " + token)).build();
        }
        this.operatorMap.remove(token);
    }
}

