/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.logevents;

import com.codeborne.selenide.logevents.LogEvent;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SelenideLog
implements LogEvent {
    private final long startNs;
    private long endNs;
    private final String subject;
    private final String element;
    private LogEvent.EventStatus status = LogEvent.EventStatus.IN_PROGRESS;
    private Throwable error;

    public SelenideLog(String element, String subject) {
        this.element = element;
        this.subject = subject;
        this.startNs = System.nanoTime();
    }

    @Override
    @Nonnull
    public String getSubject() {
        return this.subject;
    }

    @Override
    @Nonnull
    public LogEvent.EventStatus getStatus() {
        return this.status;
    }

    protected void setStatus(LogEvent.EventStatus status) {
        this.status = status;
        this.endNs = System.nanoTime();
    }

    @Override
    @Nonnull
    public String getElement() {
        return this.element;
    }

    @Override
    public long getDuration() {
        return (this.endNs - this.startNs) / 1000000L;
    }

    @Override
    @Nullable
    public Throwable getError() {
        return this.error;
    }

    public void setError(Throwable error) {
        this.error = error;
    }

    @Nonnull
    public String toString() {
        return String.format("$(\"%s\") %s", this.element, this.subject);
    }
}

