/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.impl.Describe;
import com.codeborne.selenide.impl.SelenideElementProxy;
import com.codeborne.selenide.impl.WebElementSource;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class WebElementWrapper
extends WebElementSource {
    private final Driver driver;
    private final WebElement delegate;

    public static SelenideElement wrap(Driver driver, WebElement element) {
        return element instanceof SelenideElement ? (SelenideElement)element : (SelenideElement)Proxy.newProxyInstance(element.getClass().getClassLoader(), new Class[]{SelenideElement.class}, (InvocationHandler)new SelenideElementProxy(new WebElementWrapper(driver, element)));
    }

    protected WebElementWrapper(Driver driver, WebElement delegate) {
        this.driver = driver;
        this.delegate = delegate;
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public WebElement getWebElement() {
        return this.delegate;
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public String getSearchCriteria() {
        return Describe.shortly(this.driver, this.delegate);
    }

    @CheckReturnValue
    @Nonnull
    public String toString() {
        return Describe.describe(this.driver(), this.delegate);
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public Driver driver() {
        return this.driver;
    }
}

