/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.commands.GetOwnText;
import com.codeborne.selenide.impl.Html;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class OwnText
extends Condition {
    private final String expectedText;

    public OwnText(String expectedText) {
        super("own text");
        this.expectedText = expectedText;
        if (StringUtils.isEmpty((CharSequence)expectedText)) {
            throw new IllegalArgumentException("Argument must not be null or empty string. Use $.shouldHave(exactOwnText(\"\").");
        }
    }

    @Override
    public boolean apply(Driver driver, WebElement element) {
        return Html.text.contains(GetOwnText.getOwnText(driver, element), this.expectedText);
    }

    @Override
    public String toString() {
        return String.format("%s '%s'", this.getName(), this.expectedText);
    }
}

