/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.Config;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideWait;
import com.codeborne.selenide.ex.AlertNotFoundException;
import com.codeborne.selenide.ex.FrameNotFoundException;
import com.codeborne.selenide.ex.UIAssertionError;
import com.codeborne.selenide.ex.WindowNotFoundException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.InvalidArgumentException;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;

@ParametersAreNonnullByDefault
public class SelenideTargetLocator
implements WebDriver.TargetLocator {
    private final Driver driver;
    private final WebDriver webDriver;
    private final Config config;
    private final WebDriver.TargetLocator delegate;

    public SelenideTargetLocator(Driver driver) {
        this.driver = driver;
        this.config = driver.config();
        this.webDriver = driver.getWebDriver();
        this.delegate = this.webDriver.switchTo();
    }

    @Nonnull
    public WebDriver frame(int index) {
        try {
            return (WebDriver)this.Wait().until((Function)ExpectedConditions.frameToBeAvailableAndSwitchToIt((int)index));
        }
        catch (NoSuchElementException | TimeoutException e) {
            throw this.frameNotFoundError("No frame found with index: " + index, e);
        }
        catch (InvalidArgumentException e) {
            if (this.isFirefox62Bug(e) || this.isChrome75Error(e)) {
                throw this.frameNotFoundError("No frame found with index: " + index, e);
            }
            throw e;
        }
    }

    @Nonnull
    public WebDriver frame(String nameOrId) {
        try {
            return (WebDriver)this.Wait().until((Function)ExpectedConditions.frameToBeAvailableAndSwitchToIt((String)nameOrId));
        }
        catch (NoSuchElementException | TimeoutException e) {
            throw this.frameNotFoundError("No frame found with id/name: " + nameOrId, e);
        }
        catch (InvalidArgumentException e) {
            if (this.isFirefox62Bug(e)) {
                throw this.frameNotFoundError("No frame found with id/name: " + nameOrId, e);
            }
            throw e;
        }
    }

    @Nonnull
    public WebDriver frame(WebElement frameElement) {
        try {
            return (WebDriver)this.Wait().until((Function)ExpectedConditions.frameToBeAvailableAndSwitchToIt((WebElement)frameElement));
        }
        catch (NoSuchElementException | TimeoutException e) {
            throw this.frameNotFoundError("No frame found with element: " + frameElement, e);
        }
        catch (InvalidArgumentException e) {
            if (this.isFirefox62Bug(e)) {
                throw this.frameNotFoundError("No frame found with element: " + frameElement, e);
            }
            throw e;
        }
    }

    private boolean isFirefox62Bug(InvalidArgumentException e) {
        return e.getMessage().contains("untagged enum FrameId");
    }

    private boolean isChrome75Error(InvalidArgumentException e) {
        return e.getMessage().contains("invalid argument: 'id' out of range");
    }

    @Nonnull
    public WebDriver parentFrame() {
        return this.delegate.parentFrame();
    }

    @Nonnull
    public WebDriver defaultContent() {
        return this.delegate.defaultContent();
    }

    @Nonnull
    public WebElement activeElement() {
        return this.delegate.activeElement();
    }

    @Nonnull
    public Alert alert() {
        try {
            return (Alert)this.Wait().until((Function)ExpectedConditions.alertIsPresent());
        }
        catch (TimeoutException e) {
            throw this.alertNotFoundError(e);
        }
    }

    @Nonnull
    public WebDriver innerFrame(String ... frames) {
        this.delegate.defaultContent();
        for (String frame : frames) {
            try {
                String selector = String.format("frame#%1$s,frame[name=%1$s],iframe#%1$s,iframe[name=%1$s]", frame);
                this.Wait().until((Function)SelenideTargetLocator.frameToBeAvailableAndSwitchToIt_fixed(By.cssSelector((String)selector)));
            }
            catch (NoSuchElementException | TimeoutException e) {
                throw this.frameNotFoundError("No frame found with id/name = " + frame, e);
            }
        }
        return this.webDriver;
    }

    private static ExpectedCondition<WebDriver> frameToBeAvailableAndSwitchToIt_fixed(final By locator) {
        return new ExpectedCondition<WebDriver>(){

            @Nullable
            public WebDriver apply(WebDriver driver) {
                try {
                    return driver.switchTo().frame(driver.findElement(locator));
                }
                catch (WebDriverException e) {
                    return null;
                }
            }

            @CheckReturnValue
            @Nonnull
            public String toString() {
                return "frame to be available: " + locator;
            }
        };
    }

    private static ExpectedCondition<WebDriver> windowToBeAvailableAndSwitchToIt(final String nameOrHandleOrTitle) {
        return new ExpectedCondition<WebDriver>(){

            @Nullable
            public WebDriver apply(WebDriver driver) {
                try {
                    return driver.switchTo().window(nameOrHandleOrTitle);
                }
                catch (NoSuchWindowException windowWithNameOrHandleNotFound) {
                    try {
                        return SelenideTargetLocator.windowByTitle(driver, nameOrHandleOrTitle);
                    }
                    catch (NoSuchWindowException e) {
                        return null;
                    }
                }
            }

            @CheckReturnValue
            @Nonnull
            public String toString() {
                return "window to be available by name or handle or title: " + nameOrHandleOrTitle;
            }
        };
    }

    private static ExpectedCondition<WebDriver> windowToBeAvailableAndSwitchToIt(final int index) {
        return new ExpectedCondition<WebDriver>(){

            @Nullable
            public WebDriver apply(WebDriver driver) {
                try {
                    ArrayList windowHandles = new ArrayList(driver.getWindowHandles());
                    return driver.switchTo().window((String)windowHandles.get(index));
                }
                catch (IndexOutOfBoundsException windowWithIndexNotFound) {
                    return null;
                }
            }

            @CheckReturnValue
            @Nonnull
            public String toString() {
                return "window to be available by index: " + index;
            }
        };
    }

    @CheckReturnValue
    @Nonnull
    public WebDriver window(int index) {
        try {
            return (WebDriver)this.Wait().until((Function)SelenideTargetLocator.windowToBeAvailableAndSwitchToIt(index));
        }
        catch (TimeoutException e) {
            throw this.windowNotFoundError("No window found with index: " + index, e);
        }
    }

    @CheckReturnValue
    @Nonnull
    public WebDriver window(int index, Duration duration) {
        try {
            return (WebDriver)this.Wait(duration).until((Function)SelenideTargetLocator.windowToBeAvailableAndSwitchToIt(index));
        }
        catch (TimeoutException e) {
            throw this.windowNotFoundError("No window found with index: " + index, e);
        }
    }

    @CheckReturnValue
    @Nonnull
    public WebDriver window(String nameOrHandleOrTitle) {
        try {
            return (WebDriver)this.Wait().until((Function)SelenideTargetLocator.windowToBeAvailableAndSwitchToIt(nameOrHandleOrTitle));
        }
        catch (TimeoutException e) {
            throw this.windowNotFoundError("No window found with name or handle or title: " + nameOrHandleOrTitle, e);
        }
    }

    @CheckReturnValue
    @Nonnull
    public WebDriver window(String nameOrHandleOrTitle, Duration duration) {
        try {
            return (WebDriver)this.Wait(duration).until((Function)SelenideTargetLocator.windowToBeAvailableAndSwitchToIt(nameOrHandleOrTitle));
        }
        catch (TimeoutException e) {
            throw this.windowNotFoundError("No window found with name or handle or title: " + nameOrHandleOrTitle, e);
        }
    }

    @CheckReturnValue
    @Nonnull
    private static WebDriver windowByTitle(WebDriver driver, String title) {
        Set windowHandles = driver.getWindowHandles();
        for (String windowHandle : windowHandles) {
            driver.switchTo().window(windowHandle);
            if (!title.equals(driver.getTitle())) continue;
            return driver;
        }
        throw new NoSuchWindowException("Window with title not found: " + title);
    }

    private SelenideWait Wait() {
        return new SelenideWait(this.webDriver, this.config.timeout(), this.config.pollingInterval());
    }

    private SelenideWait Wait(Duration timeout) {
        return new SelenideWait(this.webDriver, timeout.toMillis(), this.config.pollingInterval());
    }

    private Error frameNotFoundError(String message, Throwable cause) {
        FrameNotFoundException error = new FrameNotFoundException(this.driver, message, cause);
        return UIAssertionError.wrap(this.driver, (Error)((Object)error), this.config.timeout());
    }

    private Error windowNotFoundError(String message, Throwable cause) {
        WindowNotFoundException error = new WindowNotFoundException(this.driver, message, cause);
        return UIAssertionError.wrap(this.driver, (Error)((Object)error), this.config.timeout());
    }

    private Error alertNotFoundError(Throwable cause) {
        AlertNotFoundException error = new AlertNotFoundException(this.driver, "Alert not found", cause);
        return UIAssertionError.wrap(this.driver, (Error)((Object)error), this.config.timeout());
    }
}

