/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.FileDownloadMode;
import com.codeborne.selenide.files.FileFilter;
import com.codeborne.selenide.files.FileFilters;

public class DownloadOptions {
    private static final long UNSPECIFIED_TIMEOUT = Long.MIN_VALUE;
    private final FileDownloadMode method;
    private final long timeout;
    private final FileFilter filter;

    private DownloadOptions(FileDownloadMode method, long timeout, FileFilter filter) {
        this.method = method;
        this.timeout = timeout;
        this.filter = filter;
    }

    public FileDownloadMode getMethod() {
        return this.method;
    }

    public long getTimeout(long defaultValue) {
        return this.timeout == Long.MIN_VALUE ? defaultValue : this.timeout;
    }

    public FileFilter getFilter() {
        return this.filter;
    }

    public DownloadOptions withTimeout(long timeout) {
        return new DownloadOptions(this.method, timeout, this.filter);
    }

    public DownloadOptions withFilter(FileFilter filter) {
        return new DownloadOptions(this.method, this.timeout, filter);
    }

    public String toString() {
        return String.format("method=%s, timeout=%s ms, filter='%s'", new Object[]{this.method, this.timeout, this.filter.description()});
    }

    public static DownloadOptions using(FileDownloadMode method) {
        return new DownloadOptions(method, Long.MIN_VALUE, FileFilters.none());
    }
}

