/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.http44;

import com.cloudinary.utils.ObjectUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.BasicNameValuePair;

public class ApiUtils {
    public static void setTimeouts(HttpRequestBase request, Map options) {
        Integer connectTimeout;
        Integer connectionRequestTimeout;
        RequestConfig config = request.getConfig();
        RequestConfig.Builder builder = config != null ? RequestConfig.copy((RequestConfig)config) : RequestConfig.custom();
        Integer timeout = (Integer)options.get("timeout");
        if (timeout != null) {
            builder.setSocketTimeout(timeout.intValue());
        }
        if ((connectionRequestTimeout = (Integer)options.get("connection_request_timeout")) != null) {
            builder.setConnectionRequestTimeout(connectionRequestTimeout.intValue());
        }
        if ((connectTimeout = (Integer)options.get("connect_timeout")) != null) {
            builder.setConnectTimeout(connectTimeout.intValue());
        }
        request.setConfig(builder.build());
    }

    static List<NameValuePair> prepareParams(Map<String, ?> params) {
        ArrayList<NameValuePair> requestParams = new ArrayList<NameValuePair>(params.size());
        for (Map.Entry<String, ?> param : params.entrySet()) {
            if (param.getValue() instanceof Iterable) {
                for (Object single : (Iterable)param.getValue()) {
                    requestParams.add((NameValuePair)new BasicNameValuePair(param.getKey() + "[]", ObjectUtils.asString(single)));
                }
                continue;
            }
            requestParams.add((NameValuePair)new BasicNameValuePair(param.getKey(), ObjectUtils.asString(param.getValue())));
        }
        return requestParams;
    }
}

