/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.http.internal;

import com.cloudant.http.HttpConnection;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.URL;

public class DefaultHttpUrlConnectionFactory
implements HttpConnection.HttpUrlConnectionFactory {
    protected Proxy proxy = null;

    @Override
    public HttpURLConnection openConnection(URL url) throws IOException {
        if (this.proxy != null) {
            return (HttpURLConnection)url.openConnection(this.proxy);
        }
        return (HttpURLConnection)url.openConnection();
    }

    @Override
    public void setProxy(URL proxyUrl) {
        if (!"http".equals(proxyUrl.getProtocol()) && !"https".equals(proxyUrl.getProtocol())) {
            throw new IllegalArgumentException("Only HTTP type proxies are supported");
        }
        this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyUrl.getHost(), proxyUrl.getPort()));
    }
}

