/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.http.internal;

import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.Locale;

public class Base64OutputStreamFactory {
    private static final boolean runningOnAndroid;

    public static OutputStream get(OutputStream os) {
        try {
            if (runningOnAndroid) {
                Class<?> c = Class.forName("android.util.Base64OutputStream");
                Constructor<?> ctor = c.getDeclaredConstructor(OutputStream.class, Integer.TYPE);
                return (OutputStream)ctor.newInstance(os, 2);
            }
            Class<?> c = Class.forName("org.apache.commons.codec.binary.Base64OutputStream");
            Constructor<?> ctor = c.getDeclaredConstructor(OutputStream.class, Boolean.TYPE, Integer.TYPE, byte[].class);
            return (OutputStream)ctor.newInstance(os, true, 0, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        String javaRuntime = System.getProperty("java.runtime.name", "");
        runningOnAndroid = javaRuntime.toLowerCase(Locale.ENGLISH).contains("android runtime");
    }
}

