/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.http.interceptors;

import com.cloudant.http.Http;
import com.cloudant.http.HttpConnection;
import com.cloudant.http.HttpConnectionInterceptorContext;
import com.cloudant.http.HttpConnectionRequestInterceptor;
import com.cloudant.http.HttpConnectionResponseInterceptor;
import com.cloudant.http.interceptors.HttpConnectionInterceptorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;

public class CookieInterceptor
implements HttpConnectionRequestInterceptor,
HttpConnectionResponseInterceptor {
    private static final Logger logger = Logger.getLogger(CookieInterceptor.class.getCanonicalName());
    private final byte[] sessionRequestBody;
    private String cookie = null;
    private boolean shouldAttemptCookieRequest = true;

    public CookieInterceptor(String username, String password) {
        try {
            username = URLEncoder.encode(username, "UTF-8");
            password = URLEncoder.encode(password, "UTF-8");
            this.sessionRequestBody = String.format("name=%s&password=%s", username, password).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public HttpConnectionInterceptorContext interceptRequest(HttpConnectionInterceptorContext context) {
        HttpURLConnection connection = context.connection.getConnection();
        if (this.shouldAttemptCookieRequest) {
            if (this.cookie == null) {
                this.cookie = this.getCookie(connection.getURL(), context);
            }
            connection.setRequestProperty("Cookie", this.cookie);
        }
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpConnectionInterceptorContext interceptResponse(HttpConnectionInterceptorContext context) {
        HttpURLConnection connection = context.connection.getConnection();
        String cookieHeader = connection.getHeaderField("Set-Cookie");
        if (cookieHeader != null) {
            this.cookie = this.extractCookieFromHeaderValue(cookieHeader);
            return context;
        }
        try {
            boolean renewCookie = false;
            int statusCode = connection.getResponseCode();
            switch (statusCode) {
                case 403: {
                    InputStream errorStream = connection.getErrorStream();
                    try {
                        String errorString = IOUtils.toString((InputStream)errorStream, (String)"UTF-8");
                        if (!errorString.matches("(?siu).*\\\"error\\\"\\s*:\\s*\\\"credentials_expired\\\".*")) {
                            HttpConnectionInterceptorException toThrow = new HttpConnectionInterceptorException(errorString);
                            toThrow.deserialize = true;
                            throw toThrow;
                        }
                        renewCookie = true;
                        break;
                    }
                    finally {
                        errorStream.close();
                    }
                }
                case 401: {
                    renewCookie = true;
                    break;
                }
            }
            if (renewCookie) {
                this.cookie = this.getCookie(connection.getURL(), context);
                context.replayRequest = this.cookie != null;
            }
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Failed to get response code from request", e);
        }
        return context;
    }

    private String getCookie(URL url, HttpConnectionInterceptorContext context) {
        try {
            URL sessionURL = new URL(String.format("%s://%s:%d/_session", url.getProtocol(), url.getHost(), url.getPort()));
            HttpConnection conn = Http.POST(sessionURL, "application/x-www-form-urlencoded");
            conn.setRequestBody(this.sessionRequestBody);
            conn.requestInterceptors.addAll(context.connection.requestInterceptors);
            conn.requestInterceptors.remove(this);
            conn.responseInterceptors.addAll(context.connection.responseInterceptors);
            conn.responseInterceptors.remove(this);
            HttpURLConnection connection = conn.execute().getConnection();
            String cookieHeader = connection.getHeaderField("Set-Cookie");
            int responseCode = connection.getResponseCode();
            if (responseCode / 100 == 2) {
                if (this.sessionHasStarted(connection.getInputStream())) {
                    return this.extractCookieFromHeaderValue(cookieHeader);
                }
                return null;
            }
            if (responseCode == 401) {
                this.shouldAttemptCookieRequest = false;
                logger.severe("Credentials are incorrect, cookie authentication will not be attempted again by this interceptor object");
            } else if (responseCode / 100 == 5) {
                logger.log(Level.SEVERE, "Failed to get cookie from server, response code %s, cookie auth", responseCode);
            } else {
                logger.log(Level.SEVERE, "Failed to get cookie from server, response code %s, cookie authentication will not be attempted again", responseCode);
                this.shouldAttemptCookieRequest = false;
            }
        }
        catch (MalformedURLException e) {
            logger.log(Level.SEVERE, "Failed to create URL for _session endpoint", e);
        }
        catch (UnsupportedEncodingException e) {
            logger.log(Level.SEVERE, "Failed to encode cookieRequest body", e);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Failed to read cookie response header", e);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sessionHasStarted(InputStream responseStream) throws IOException {
        try {
            String response = IOUtils.toString((InputStream)responseStream, (String)"UTF-8");
            boolean bl = response.matches("(?s)(?i)(?u).*\\\"ok\\\"\\s*:\\s*true.*");
            return bl;
        }
        finally {
            IOUtils.closeQuietly((InputStream)responseStream);
        }
    }

    private String extractCookieFromHeaderValue(String cookieHeaderValue) {
        return cookieHeaderValue.substring(0, cookieHeaderValue.indexOf(";"));
    }
}

