/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.client.internal.views;

import com.cloudant.client.api.model.Document;
import com.cloudant.client.api.views.ViewResponse;
import com.cloudant.client.internal.views.ViewQueryParameters;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class RowImpl<K, V>
implements ViewResponse.Row<K, V> {
    private final ViewQueryParameters<K, V> parameters;
    private final Gson gson;
    private final JsonObject row;

    RowImpl(ViewQueryParameters<K, V> parameters, JsonElement row) {
        this.parameters = parameters;
        this.gson = parameters.getClient().getGson();
        this.row = row.isJsonObject() ? row.getAsJsonObject() : new JsonObject();
    }

    @Override
    public String getId() {
        JsonElement id = this.row.get("id");
        if (id != null) {
            return id.getAsString();
        }
        return null;
    }

    @Override
    public K getKey() {
        return (K)this.gson.fromJson(this.row.get("key"), this.parameters.getKeyType());
    }

    @Override
    public V getValue() {
        return (V)this.gson.fromJson(this.row.get("value"), this.parameters.getValueType());
    }

    @Override
    public Document getDocument() {
        return (Document)this.gson.fromJson(this.row.get("doc"), Document.class);
    }

    @Override
    public <D> D getDocumentAsType(Class<D> docType) {
        return (D)this.gson.fromJson(this.row.get("doc"), docType);
    }
}

