/*
 * Decompiled with CFR 0.152.
 */
package com.citruspay.citrusbrowser.core;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.http.SslError;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.CookieManager;
import android.webkit.JavascriptInterface;
import android.webkit.SslErrorHandler;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.citruspay.citrusbrowser.core.FlashResponseData;
import com.citruspay.citrusbrowser.core.g;
import com.citruspay.citrusbrowser.listener.d;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;

public class CitrusWebView
extends WebView
implements com.citruspay.citrusbrowser.listener.a {
    private Context mContext = null;
    private d presenter = null;
    private FlashListener mFlashListener = null;
    protected static final String CHARSET_DEFAULT = "UTF-8";
    protected WeakReference<Activity> mActivity;
    protected WeakReference<Fragment> mFragment;
    protected CitrusWebViewListener mCitrusWebViewListener;
    protected long mLastError;
    protected final Map<String, String> mHttpHeaders = new HashMap<String, String>();

    public CitrusWebView(Context context) {
        super(context);
        this.mContext = context;
        this.init(context);
    }

    public CitrusWebView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mContext = context;
        this.init(context);
    }

    public CitrusWebView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.mContext = context;
        this.init(context);
    }

    public void setFlashListener(FlashListener flashListener) {
        this.mFlashListener = flashListener;
    }

    public void setCitrusWebViewListener(Activity activity, CitrusWebViewListener citrusWebViewListener) {
        this.mActivity = activity != null ? new WeakReference<Activity>(activity) : null;
        this.mCitrusWebViewListener = citrusWebViewListener;
    }

    public void setCitrusWebViewListener(Fragment fragment, CitrusWebViewListener citrusWebViewListener) {
        this.mFragment = fragment != null ? new WeakReference<Fragment>(fragment) : null;
        this.mCitrusWebViewListener = citrusWebViewListener;
    }

    public void loadHtml(String string2) {
        this.loadHtml(string2, null);
    }

    public void loadHtml(String string2, String string3) {
        this.loadHtml(string2, string3, null);
    }

    public void loadHtml(String string2, String string3, String string4) {
        this.loadHtml(string2, string3, string4, "utf-8");
    }

    public void loadHtml(String string2, String string3, String string4, String string5) {
        this.loadDataWithBaseURL(string3, string2, "text/html", string5, string4);
    }

    @SuppressLint(value={"NewApi"})
    public void onResume() {
        if (Build.VERSION.SDK_INT >= 11) {
            super.onResume();
        }
        this.resumeTimers();
    }

    @SuppressLint(value={"NewApi"})
    public void onPause() {
        this.pauseTimers();
        if (Build.VERSION.SDK_INT >= 11) {
            super.onPause();
        }
    }

    public void onDestroy() {
        try {
            ((ViewGroup)this.getParent()).removeView((View)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.removeAllViews();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.destroy();
    }

    public void addHttpHeader(String string2, String string3) {
        this.mHttpHeaders.put(string2, string3);
    }

    public void removeHttpHeader(String string2) {
        this.mHttpHeaders.remove(string2);
    }

    public void onBackPressed() {
        if (this.canGoBack()) {
            this.goBack();
        }
    }

    public void setCookiesEnabled(boolean bl) {
        CookieManager.getInstance().setAcceptCookie(bl);
    }

    @SuppressLint(value={"NewApi"})
    public void setThirdPartyCookiesEnabled(boolean bl) {
        if (Build.VERSION.SDK_INT >= 21) {
            CookieManager.getInstance().setAcceptThirdPartyCookies((WebView)this, bl);
        }
    }

    @SuppressLint(value={"NewApi"})
    protected void setMixedContentAllowed(WebSettings webSettings, boolean bl) {
        if (Build.VERSION.SDK_INT >= 21) {
            webSettings.setMixedContentMode(bl ? 0 : 1);
        }
    }

    @SuppressLint(value={"SetJavaScriptEnabled", "AddJavascriptInterface"})
    protected void init(Context context) {
        if (this.isInEditMode()) {
            return;
        }
        if (context instanceof Activity) {
            this.mActivity = new WeakReference<Activity>((Activity)context);
        }
        this.presenter = d.a(this.mContext);
        this.presenter.a(this);
        this.setFocusable(true);
        this.setFocusableInTouchMode(true);
        this.setSaveEnabled(true);
        super.addJavascriptInterface((Object)new a(), "CitrusFlashPaymentStartedAndroid");
        WebSettings webSettings = this.getSettings();
        webSettings.setAllowFileAccess(false);
        webSettings.setBuiltInZoomControls(false);
        webSettings.setJavaScriptEnabled(true);
        webSettings.setDomStorageEnabled(true);
        if (Build.VERSION.SDK_INT < 18) {
            webSettings.setRenderPriority(WebSettings.RenderPriority.HIGH);
        }
        this.setMixedContentAllowed(webSettings, true);
        this.setThirdPartyCookiesEnabled(true);
        if (Build.VERSION.SDK_INT <= 18) {
            webSettings.setSavePassword(false);
        }
        webSettings.setSaveFormData(false);
        super.setWebViewClient((WebViewClient)new b());
    }

    public void loadUrl(String string2, Map<String, String> map) {
        if (map == null) {
            map = this.mHttpHeaders;
        } else if (this.mHttpHeaders.size() > 0) {
            map.putAll(this.mHttpHeaders);
        }
        if (!TextUtils.isEmpty((CharSequence)string2) && map != null) {
            super.loadUrl(string2, map);
        }
    }

    public void loadUrl(String string2) {
        if (this.mHttpHeaders.size() > 0) {
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                super.loadUrl(string2, this.mHttpHeaders);
            }
        } else if (!TextUtils.isEmpty((CharSequence)string2)) {
            super.loadUrl(string2);
        }
    }

    protected void setLastError() {
        this.mLastError = System.currentTimeMillis();
    }

    protected boolean hasError() {
        return this.mLastError + 500L >= System.currentTimeMillis();
    }

    private void startFlash(FlashResponseData flashResponseData) {
        if (this.mFlashListener != null) {
            this.mFlashListener.startFlash(flashResponseData);
        }
    }

    private void notifyFlash(d.b b2, String string2) {
        Log.d((String)"CCCC", (String)("FlashState : " + (Object)((Object)b2) + " URL : " + string2));
        if (this.presenter != null) {
            this.presenter.a(b2, string2);
        }
    }

    @Override
    public void loadJS(String string2) {
        super.loadUrl(string2);
    }

    @Override
    public void stopLoading() {
        super.stopLoading();
    }

    @Override
    public void hideWebView() {
        this.setVisibility(8);
    }

    @Override
    public void showWebView() {
        this.setVisibility(0);
    }

    private class b
    extends WebViewClient {
        private b() {
        }

        public void onPageStarted(WebView webView, String string2, Bitmap bitmap) {
            if (!CitrusWebView.this.hasError() && CitrusWebView.this.mCitrusWebViewListener != null) {
                CitrusWebView.this.mCitrusWebViewListener.onPageStarted(string2, bitmap);
            }
            CitrusWebView.this.notifyFlash(d.b.b, string2);
        }

        public void onPageFinished(WebView webView, String string2) {
            if (!CitrusWebView.this.hasError() && CitrusWebView.this.mCitrusWebViewListener != null) {
                CitrusWebView.this.mCitrusWebViewListener.onPageFinished(string2);
            }
            webView.loadUrl("javascript:window.CitrusFlashPaymentStartedAndroid.printHTML('<html>'+document.getElementsByTagName('html')[0].innerHTML+'</html>');");
            CitrusWebView.this.notifyFlash(d.b.a, string2);
        }

        public void onReceivedError(WebView webView, int n, String string2, String string3) {
            CitrusWebView.this.setLastError();
            if (CitrusWebView.this.mCitrusWebViewListener != null) {
                CitrusWebView.this.mCitrusWebViewListener.onPageError(n, string2, string3);
            }
        }

        public boolean shouldOverrideUrlLoading(WebView webView, String string2) {
            if (string2.contains("vpc_TxnResponseCode=F")) {
                CitrusWebView.this.notifyFlash(d.b.d, null);
            }
            if (CitrusWebView.this.mCitrusWebViewListener != null) {
                CitrusWebView.this.mCitrusWebViewListener.shouldOverrideUrlLoading(webView, string2);
            }
            webView.loadUrl(string2);
            return true;
        }

        public void onReceivedSslError(WebView webView, SslErrorHandler sslErrorHandler, SslError sslError) {
            super.onReceivedSslError(webView, sslErrorHandler, sslError);
            sslErrorHandler.cancel();
        }
    }

    private class a {
        private a() {
        }

        @JavascriptInterface
        public void cardData(String string2) {
            Log.d((String)"CARD DATA :: ", (String)string2);
            FlashResponseData flashResponseData = new FlashResponseData();
            flashResponseData.parseResponse(string2);
            if (flashResponseData.getTxnDetails().getTxnType() == g.a || flashResponseData.getTxnDetails().getTxnType() == g.b) {
                CitrusWebView.this.startFlash(flashResponseData);
            }
        }

        @JavascriptInterface
        public void printHTML(String string2) {
            if (!TextUtils.isEmpty((CharSequence)string2) && (string2.contains("Un-Registered") || string2.contains("Step 1"))) {
                CitrusWebView.this.notifyFlash(d.b.c, null);
            }
        }

        @JavascriptInterface
        public void citiCardViewVisibility(String string2) {
            Log.d((String)"CCCC", (String)("citiCardViewVisibility : " + string2));
            CitrusWebView.this.notifyFlash(d.b.i, string2);
        }
    }

    public static interface FlashListener {
        public void startFlash(FlashResponseData var1);
    }

    public static interface CitrusWebViewListener {
        public void onPageStarted(String var1, Bitmap var2);

        public void onPageFinished(String var1);

        public void onPageError(int var1, String var2, String var3);

        public void shouldOverrideUrlLoading(WebView var1, String var2);
    }
}

