package com.citruspay.citrusbrowser.core;

/**
 * TxnDetails class is a POJO class which holds the Transaction details i.e. the amount , currency, txn type.
 * Together these details are required to for the flash experience.
 * Created by Gautam on 15/6/16.
 */
public class TxnDetails {
    private Amount mAmount = null;
    //    private String mCardNumber = null;
    private String mTxnAmt = null;
    private String mTxnCurrency = null;
    private String mTxnTypeStr = null;
    private TxnType mTxnType = null;

    public TxnDetails(Amount amount/*, String cardNumber*/) {
        this.mAmount = amount;
//        this.mCardNumber = cardNumber;
    }

    public TxnDetails(String txnAmt, String txnCurrency, String txnType) {
        this.mAmount = new Amount(txnAmt);
        this.mTxnCurrency = txnCurrency;
        this.mTxnType = TxnType.getTxnType(txnType);
    }

    public TxnDetails(String txnAmt, String txnCurrency, TxnType txnType) {
        this.mAmount = new Amount(txnAmt);
        this.mTxnCurrency = txnCurrency;
        this.mTxnType = txnType;
    }

    public Amount getAmount() {
        return mAmount;
    }

    public void setAmount(Amount amount) {
        this.mAmount = amount;
    }

//    public String getCardNumber() {
//        return mCardNumber;
//    }
//
//    public void setCardNumber(String cardNumber) {
//        this.mCardNumber = cardNumber;
//    }

    public TxnType getTxnType() {
        return mTxnType;
    }
}
