package com.citruspay.citrusbrowser.core;

import com.citruspay.citrusbrowser.CitrusBrowserFragment;
import com.citruspay.citrusbrowser.listener.CitrusBrowserCallback;

import java.util.ArrayList;

/**
 * Created by gautam on 9/13/16.
 */
public class FlashPaymentTracker {

    private static FlashPaymentTracker mFlashPaymentTracker = null;
    private static CitrusBrowserFragment mCitrusBrowserFragment;
    private ArrayList<CitrusBrowserCallback> listeners = null;

    private FlashPaymentTracker() {
        this.listeners = new ArrayList<>();
    }

    /**
     * Get FlashPaymentTracker instance.
     *
     * @return
     */
    public static FlashPaymentTracker getInstance() {
        if (mFlashPaymentTracker == null) {
            synchronized (FlashPaymentTracker.class) {
                if (mFlashPaymentTracker == null) {
                    mFlashPaymentTracker = new FlashPaymentTracker();
                }
            }
        }
        return mFlashPaymentTracker;
    }

    public void flashListener(CitrusBrowserFragment citrusBrowserFragment) {
        mCitrusBrowserFragment = citrusBrowserFragment;
    }

    public void sendPaymentStatus(PaymentStatus paymentStatus) {
        if (mCitrusBrowserFragment != null)
            mCitrusBrowserFragment.displayFlashStatus(paymentStatus);
    }

    public void addListener(CitrusBrowserCallback callback) {
        if (listeners != null) {
            listeners.add(callback);
        }
    }

    public void notifyListeners(PaymentStatus status) {
        if (status == PaymentStatus.CANCELLED) {
            if (listeners != null) {
                for (int i = 0; i < listeners.size(); i++) {
                    listeners.get(i).txnCancelled();
                }
            }
        }
    }

    public void clear() {
        if (listeners != null)
            listeners.clear();
        if (mCitrusBrowserFragment != null)
            mCitrusBrowserFragment = null;
    }
}
