package com.citruspay.citrusbrowser.core;

import android.text.TextUtils;

import com.citruspay.citrusbrowser.utils.Constants;
import com.citruspay.graphics.AssetsHelper;

import org.json.JSONArray;
import org.json.JSONObject;

/**
 * This class contains the Bin service response and other JS information.
 * Created by Gautam on 16/6/16.
 */
public class BankJSConfig {

    private String OTPTxnJS = "";
    private String passwordTxnJS = "";
    private String enterPasswordJS = "";
    private String setPasswordJS = "";
    private String sendOTPJS = "";
    private String setOTPJS = "";
    private String resendOTPJS = "";
    private String bankNameForOTPParsing = null;
    private String bankName = null;
    private String issuingBankName = null;
    private String bankIconName = null;
    private String cardType = null;
    private JSONArray bankSMSNames = null;
    private static BankJSConfig mBankJSConfig = null;
    private CardScheme cardScheme = null;
    private BankCid mBankCid = null;
    private boolean showEnterPassword;
    private boolean bypassSendOTPBtn = false;
    private boolean bypassEnterPasswordBtn = false;
    private boolean hideResendBtn = false;
    @AssetsHelper.LARGEBANK
    String mBankAssetName = AssetsHelper.LARGEBANK.DEFAULT;
    @AssetsHelper.LARGECARD
    String mCardAssetName = AssetsHelper.CARD.DEFAULT;


    private BankJSConfig() {

    }

    /**
     * Get FlashConfigParser instance.
     *
     * @return
     */
    public static BankJSConfig getInstance() {
        if (mBankJSConfig == null) {
            synchronized (BankJSConfig.class) {
                if (mBankJSConfig == null) {
                    mBankJSConfig = new BankJSConfig();
                }
            }
        }
        return mBankJSConfig;
    }

    public void clear() {
//        if (mBankJSConfig != null) {
        mBankJSConfig = null;
        cardScheme = null;
        mBankCid = null;
//        }
    }

    public void parseBankJSConfig(JSONObject object) {
        issuingBankName = object.optString(Constants.KEY_ISSUING_BANK_NAME);
        cardType = object.optString(Constants.KEY_CARD_TYPE);
        String cardSchemeStr = object.optString(Constants.KEY_CARD_SCHEME);
        cardScheme = CardScheme.getCardScheme(cardSchemeStr);
        if (!TextUtils.isEmpty(issuingBankName))
            parseBankIconName(issuingBankName);

    }

    public void parseCardJSConfig(JSONObject cardJsConfigObject) {
        if (cardJsConfigObject != null) {

            JSONObject bankConfigObject;
            JSONObject jsConfigObject;
            try {
                bankConfigObject = cardJsConfigObject.optJSONObject(Constants.KEY_CONFIG);
                if (bankConfigObject != null) {
                    bypassSendOTPBtn = bankConfigObject.optBoolean(Constants.KEY_BYPASS_SEND_OTP_BTN);
                    bypassEnterPasswordBtn = bankConfigObject.optBoolean(Constants.KEY_BYPASS_ENTER_PASS_BTN);
                    hideResendBtn = bankConfigObject.optBoolean(Constants.KEY_HIDE_RESEND_BTN);
                    showEnterPassword = bankConfigObject.optBoolean(Constants.KEY_SHOW_ENTER_PASSWORD);
                }
                jsConfigObject = cardJsConfigObject.optJSONObject(Constants.KEY_JS_CONFIG);

                if (jsConfigObject != null) {
                    OTPTxnJS = jsConfigObject.optString(Constants.KEY_OTP_TXN_JS);
                    passwordTxnJS = jsConfigObject.optString(Constants.KEY_PASS_TXN_JS);
                    enterPasswordJS = jsConfigObject.optString(Constants.KEY_ENTER_PASS_JS);
                    setPasswordJS = jsConfigObject.optString(Constants.KEY_SET_PASS_JS);
                    sendOTPJS = jsConfigObject.optString(Constants.KEY_SEND_OTP_JS);
                    setOTPJS = jsConfigObject.optString(Constants.KEY_SET_OTP_JS);
                    resendOTPJS = jsConfigObject.optString(Constants.KEY_RESEND_OTP_JS);
                }

            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void parseBankIconName(String bankName) {
        if (bankName.equalsIgnoreCase("SBI BANK") || bankName.equalsIgnoreCase("SBI(Maestro)") || bankName.equalsIgnoreCase("SBI CARDS & PAYMENTS") || bankName.equalsIgnoreCase("State Bank of India")) {
            bankIconName = "sbi";
            mBankCid = BankCid.SBI_BANK;
            mBankAssetName = AssetsHelper.LARGEBANK.SBI;
        } else if (bankName.equalsIgnoreCase("ICICI BANK") || bankName.equalsIgnoreCase("ICICI BANK LTD")) {
            bankIconName = "icici";
            mBankCid = BankCid.ICICI_BANK;
            mBankAssetName = AssetsHelper.LARGEBANK.ICICI;
        } else if (bankName.equalsIgnoreCase("HDFC BANK") || bankName.equalsIgnoreCase("HDFC BANK LIMITED") || bankName.equalsIgnoreCase("HDFC BANK LIMITED(Maestro)")) {
            bankIconName = "hdfc";
            mBankCid = BankCid.HDFC_BANK;
            mBankAssetName = AssetsHelper.LARGEBANK.HDFC;
        } else if (bankName.equalsIgnoreCase("AXIS BANK") || bankName.equalsIgnoreCase("Axis Bank Limited")) {
            bankIconName = "axis";
            mBankCid = BankCid.AXIS;
            mBankAssetName = AssetsHelper.LARGEBANK.AXIS;
        } else if (bankName.equalsIgnoreCase("KOTAK MAHINDRA BANK") || bankName.equalsIgnoreCase("Kotak Mahindra Bank Ltd")) {
            bankIconName = "kotak";
            mBankCid = BankCid.KOTAK_MAHINDRA_BANK;
            mBankAssetName = AssetsHelper.LARGEBANK.KOTAK;
        } else if (bankName.equalsIgnoreCase("CITI BANK") || bankName.equalsIgnoreCase("CITI BANK LTD") || bankName.equalsIgnoreCase("CITI BANK LTD(Maestro)")) {
            bankIconName = "citi";
            mBankCid = BankCid.CITI_BANK;
            mBankAssetName = AssetsHelper.LARGEBANK.CITI;
        }
    }


    public boolean getHideResendBtn() {
        return hideResendBtn;
    }


    public boolean getBypassEnterPasswordBtn() {
        return bypassEnterPasswordBtn;
    }


    public boolean getBypassSendOTPBtn() {
        return bypassSendOTPBtn;
    }


    public String getBankName() {
        return bankName;
    }

    public String getIssuingBankName() {
        return issuingBankName;
    }

    public String getBankNameForOTPParsing() {
        return bankNameForOTPParsing;
    }


    public String getResendOTPJS() {
        return resendOTPJS;
    }


    public String getSetOTPJS(String otp) {
        return setOTPJS.replace(Constants.OTP_REPLACE_STR, otp);
    }


    public String getSendOTPJS() {
        return sendOTPJS;
    }


    public String getSetPasswordJS(String password) {
        return setPasswordJS.replace(Constants.PASSWORD_REPLACE_STR, password);
    }

    public String getEnterPasswordJS() {
        return enterPasswordJS;
    }

    public boolean isShowEnterPassword() {
        return showEnterPassword;
    }


    public String getPasswordTxnJS() {
        return passwordTxnJS;
    }


    public String getOTPTxnJS() {
        return OTPTxnJS;
    }


    public String getCardType() {
        return cardType;
    }

    public CardScheme getCardScheme() {
        return cardScheme;
    }

    public BankCid getBankCid() {
        return mBankCid;
    }

    public String getBankAssetName() {
        return mBankAssetName;
    }

    public String getCardAssetName(CardScheme cardScheme) {

        return mCardAssetName = AssetsHelper.getCard(cardScheme.getName());

    }
}
