package com.citruspay.citrusbrowser.views;

import android.os.Handler;

import java.util.Random;

/**
 * Created by Gautam on 13/4/16.
 */
public class ProgressGenerator {
    public interface OnCompleteListener {

        void onComplete();
    }

    private OnCompleteListener mListener;
    private int mProgress = 0;
    private int randomDelayRange = 500;
    private ProcessButton processBtn = null;

    public ProgressGenerator(OnCompleteListener listener) {
        mListener = listener;
    }

    public void start(final ProcessButton button) {
        processBtn = button;
        final Handler handler = new Handler();
        handler.postDelayed(new Runnable() {
            @Override
            public void run() {
                mProgress += 10;
//                Logger.d("Progress " +mProgress);
                button.setProgress(mProgress);
                if (mProgress < 100) {
                    handler.postDelayed(this, generateDelay());
                } else {
                    mProgress = 0;
                    mListener.onComplete();
                }
            }
        }, generateDelay());
    }

    private Random random = new Random();

    private int generateDelay() {
        return random.nextInt(randomDelayRange);
    }

    public ProcessButton getProcessBtn() {
        return processBtn;
    }

    public int getRandomDelayRange() {
        return randomDelayRange;
    }

    public void setRandomDelayRange(int randomDelayRange) {
        this.randomDelayRange = randomDelayRange;
    }

}
