package com.citruspay.citrusbrowser.core;

import java.util.Map;

/**
 * This class contains all the config params and methods that merchants need to set and which will
 * define how the CitrusBrowser operates and performs the payment. Created by Gautam on 15/6/16.
 */
public class CitrusBrowserConfig {

    private String paymentUrl = null;
    private Map<String, String> headers = null;
    private TxnDetails mTxnDetails = null;
    private CardDetails mCardDetails = null;
    private PaymentStatus mPaymentStatus = null;
    private NativeScreenType mNativeScreenType = NativeScreenType.THREE_QUARTERS;
    private boolean autoReadOTP = true;
    private boolean autoSubmitOTP = true;
    public static final String KEY_CITRUS_BROWSER_CONFIG = "key_citrus_browser_config";
    private static CitrusBrowserConfig mCitrusBrowserConfig = null;


    private CitrusBrowserConfig() {

    }

    /**
     * Get CitrusBrowserConfig instance.
     */
    public static CitrusBrowserConfig getInstance() {
        if (mCitrusBrowserConfig == null) {
            synchronized (CitrusBrowserConfig.class) {
                if (mCitrusBrowserConfig == null) {
                    mCitrusBrowserConfig = new CitrusBrowserConfig();
                }
            }
        }
        return mCitrusBrowserConfig;
    }

    public void clear() {
        headers = null;
        mCardDetails = null;
        mTxnDetails = null;
        mPaymentStatus = null;
        mNativeScreenType = null;
        mCitrusBrowserConfig = null;
    }

    /**
     * The URL in the form of a string on which the redirection will happen for making a payment.
     */
    private void setPaymentUrl(String url) {
        this.paymentUrl = url;
    }

    /**
     * The URL in the form of a string on which the redirection will happen for making a payment.
     * Also a Map containing certain headers required to add to the webview.
     */
    private void setPaymentUrl(String uRL, Map<String, String> headers) {
        this.paymentUrl = uRL;
        this.headers = headers;
    }

    /**
     * The Bank page HTML in the form of String.
     */
    private void setPaymentHtml(String HTML) {

    }

    /**
     * Set this method to TRUE to show the Native UI screen, else to view the traditional WebView.
     */
    private void enableNativeView(boolean value) {

    }

    /**
     * TxnDetails class is a POJO class which holds the Transaction details i.e. the amount ,
     * currency, txn type. Set this method with Txn details for the current Txn. Together these
     * details are required to Flash UI experience.
     */
    public void setTxnDetails(TxnDetails details) {
        this.mTxnDetails = details;
    }


    /**
     * CardDetails class is a POJO class which holds the Card details i.e. card number, Card prefix,
     * card suffix and card token. Together these details are required to show the card number on
     * the CitrusBrowser UI and for other use cases.
     */
    public void setCardDetails(CardDetails mCardDetails) {
        this.mCardDetails = mCardDetails;
    }

    /**
     * PaymentStatus is an enum consisting these values (SUCCESS, FAIL or CANCELLED) This statuses
     * are important in order to track transaction success/failure cases. Accordingly the
     * CitrusBrowser UI will show appropriate indication to the user.
     */
    private void setPaymentStatus(PaymentStatus status) {
        this.mPaymentStatus = status;
    }

    /**
     * NativeScreenType determines the flash screen render type you want.
     */
    public void setNativeScreenType(NativeScreenType mNativeScreenType) {
        if (mNativeScreenType != null) {
            this.mNativeScreenType = mNativeScreenType;
        }
    }

    /**
     * Set Auto read OTP status.
     */
    private void setAutoReadOTP(boolean autoReadOTP) {
        this.autoReadOTP = autoReadOTP;
    }

    /**
     * Set Auto submit OTP status.
     */
    public void setAutoSubmitOTP(boolean autoSubmitOTP) {
        this.autoSubmitOTP = autoSubmitOTP;
    }

    /**
     * Get Txn Details.
     */
    public TxnDetails getTxnDetails() {
        return this.mTxnDetails;
    }

    /**
     * Get Payment Status.
     */
    private PaymentStatus getPaymentStatus() {
        return mPaymentStatus;
    }

    /**
     * Get Auto Read Status.
     */
    private boolean isAutoReadOTP() {
        return autoReadOTP;
    }

    /**
     * Get Auto Submit Status.
     */
    public boolean isAutoSubmitOTP() {
        return autoSubmitOTP;
    }

    /**
     * Get Native Screen render Type.
     */
    public NativeScreenType getNativeScreenType() {
        return mNativeScreenType;
    }

    /**
     * Get Payment URL.
     */
    private String getPaymentUrl() {
        return paymentUrl;
    }

    /**
     * Get Webview Headers.
     */
    private Map<String, String> getHeaders() {
        return headers;
    }

    /**
     * Get Card Details.
     */
    public CardDetails getCardDetails() {
        return mCardDetails;
    }
}
