package com.citruspay.citrusbrowser;

import android.Manifest;
import android.animation.ObjectAnimator;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.PorterDuff;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.DialogFragment;
import android.support.v4.content.LocalBroadcastManager;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.StyleSpan;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.view.animation.LinearInterpolator;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import android.widget.TextView;

import com.citruspay.citrusbrowser.core.Amount;
import com.citruspay.citrusbrowser.core.BankCid;
import com.citruspay.citrusbrowser.core.BankJSConfig;
import com.citruspay.citrusbrowser.core.Callback;
import com.citruspay.citrusbrowser.core.CardDetails;
import com.citruspay.citrusbrowser.core.CitrusBrowserConfig;
import com.citruspay.citrusbrowser.core.FlashConfigParser;
import com.citruspay.citrusbrowser.core.FlashPaymentTracker;
import com.citruspay.citrusbrowser.core.NativeScreenType;
import com.citruspay.citrusbrowser.core.PaymentStatus;
import com.citruspay.citrusbrowser.core.TxnDetails;
import com.citruspay.citrusbrowser.core.TxnType;
import com.citruspay.citrusbrowser.listener.FlashObserver;
import com.citruspay.citrusbrowser.listener.OTPViewListener;
import com.citruspay.citrusbrowser.listener.Presenter;
import com.citruspay.citrusbrowser.listener.Presenter.CitrusWebViewState;
import com.citruspay.citrusbrowser.listener.SMSReceiver;
import com.citruspay.citrusbrowser.network.BinRequest;
import com.citruspay.citrusbrowser.utils.Constants;
import com.citruspay.citrusbrowser.utils.Utils;
import com.citruspay.citrusbrowser.views.OTPPopupView;
import com.citruspay.citrusbrowser.views.TypeWriterTextView;
import com.citruspay.graphics.AssetDownloadManager;
import com.citruspay.graphics.AssetsHelper;
import com.citruspay.graphics.BitmapCallBack;

import org.json.JSONObject;

/**
 * Created by Gautam on 10/6/16.
 */
public class CitrusBrowserFragment extends DialogFragment implements OTPViewListener,
        FlashObserver {

    private static Context mContext = null;
    private static final int PERMISSIONS_REQUEST_CODE_RECEIVE_SMS = 101;
    private static final long TXN_CALLBACK_WAIT_PERIOD = 3000;
    private static final long OTP_READ_TIMEOUT = 30000;
    private CitrusBrowserConfig mCitrusBrowserConfig = null;
    private String otp = null;
    private String cardNumber = null;
    private int screenWidth = 0;
    private final int WAIT_TIME = 400;
    private ProgressBar mProgressBar = null;
    private boolean txnProcessed = false;
    private boolean smsPermissionGranted = false;
    private boolean mSMSReceiverRegistered = false;
    private boolean autoReadOTP = false;
    private boolean otpPopupDismissed = false;
    private boolean mLoading = false;
    private boolean isCardUnRegistered = false;
    private boolean txnCallbackReceived = false;
    private boolean isCardUnSupported = false;
    private boolean autoSubmitAllowed = true;
    private View rootView;
    private OTPPopupView mOTPPopupView = null;
    private BinRequest mBinRequest = null;
    private BankJSConfig mBankJSConfig = null;
    private Amount amount = null;
    private SMSReceiver mSMSReceiver = null;
    private BroadcastReceiver mAutoOtpSMSReceiveListener = null;
    private CountDownTimer mTimer = null;
    private TextView otpPopupCancelImgView = null;
    private Handler otpReadHandler = null;
    private Runnable otpReadRunnable = null;
    private NativeScreenType mNativeScreenType = null;
    private TxnType mTxnType = null;
    private Presenter presenter = null;
    private FlashConfigParser mFlashConfigParser = null;
    private boolean resendOtpRequested = false;
    private boolean showingOtpScreen = false;

    public CitrusBrowserFragment() {

    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        presenter = Presenter.getInstance(mContext);
        presenter.listen(this);
    }

    public static CitrusBrowserFragment newInstance(Context context) {

        mContext = context;
        CitrusBrowserFragment fragment = new CitrusBrowserFragment();
        return fragment;
    }

    @Override
    public void onAttach(Activity activity) {
        super.onAttach(activity);

        CitrusBrowserActivity citrusBrowserActivity = (CitrusBrowserActivity) activity;
        mCitrusBrowserConfig = citrusBrowserActivity.getCitrusBrowserConfig();
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
                             Bundle savedInstanceState) {

        rootView = inflater.inflate(R.layout.fragment_citrus_browser, container, false);

        FlashPaymentTracker.getInstance().flashListener(this);

        fetchFlashConfig();

        initViews();

        handleWindowProperties();

        handlePopupHeight();

        initializeTimer();

        if (mCitrusBrowserConfig != null) {
            CardDetails mCardDetails = mCitrusBrowserConfig.getCardDetails();
            TxnDetails mTxnDetails = mCitrusBrowserConfig.getTxnDetails();
            mTxnType = mTxnDetails.getTxnType();

            if (mCardDetails != null) {
                fetchBinData(mCardDetails);
            }

            amount = mTxnDetails.getAmount();
            autoSubmitAllowed = mCitrusBrowserConfig.isAutoSubmitOTP();

        }

        checkSmsPermission();

        return rootView;
    }

    /**
     * Fetch Flash Config from local storage or from server.
     */
    private void fetchFlashConfig() {
        requestFlashConfig();
    }

    /**
     * Init screen views
     */
    private void initViews() {
        mProgressBar = (ProgressBar) rootView.findViewById(R.id.progressBar);

        mOTPPopupView = (OTPPopupView) rootView.findViewById(R.id.otpPopupView1Id);
        mOTPPopupView.setListener(this);

        otpPopupCancelImgView = (TextView) rootView.findViewById(R.id.otpPopupCancelTextViewId);
        otpPopupCancelImgView.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                handleCancelTransaction();
            }
        });

        AssetDownloadManager.getInstance()
                .getBrandingBitmap(AssetsHelper.BRANDING.BRANDING_FOOTER, new BitmapCallBack() {
                    @Override
                    public void onBitmapReceived(Bitmap bitmap) {
//                Drawable drawable = new BitmapDrawable(getResources(), bitmap);
                        if (rootView.findViewById(R.id.bottomTrustsImgViewId) != null) {
                            ((ImageView) rootView.findViewById(R.id.bottomTrustsImgViewId))
                                    .setImageBitmap(bitmap);
                        }
                    }

                    @Override
                    public void onBitmapFailed(Bitmap bitmap) {
//                Drawable drawable = new BitmapDrawable(getResources(), bitmap);
                        if (rootView.findViewById(R.id.bottomTrustsImgViewId) != null) {
                            ((ImageView) rootView.findViewById(R.id.bottomTrustsImgViewId))
                                    .setImageBitmap(bitmap);
                        }
                    }
                });

    }

    private void showDialog(String message, boolean cancelable) {
        // Show dialog only when otppop view is not visible
        if (mProgressBar != null && !showingOtpScreen) {
            mProgressBar.setVisibility(View.VISIBLE);
        }
    }

    private void dismissDialog() {
        if (mProgressBar != null) {
            mProgressBar.setVisibility(View.GONE);
        }
    }

    /**
     * Hnadle Flash popup height.
     */
    private void handlePopupHeight() {
        ScrollView view = (ScrollView) rootView.findViewById(R.id.otpPopupScrollViewId);
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams)
                view.getLayoutParams();
        int height = getResources().getDisplayMetrics().heightPixels;
        mNativeScreenType = mCitrusBrowserConfig.getNativeScreenType();
        if (mNativeScreenType != null) {
            params.height = (int) (height / mNativeScreenType.getViewHeightFactor());
        } else {
            mNativeScreenType = NativeScreenType.THREE_QUARTERS;
            params.height = (int) (height / 1.5);
        }

        view.setLayoutParams(params);
    }

    /**
     * Initialize webview timer.
     */
    private void initializeTimer() {
        // Timer to dismiss dialog after specific time once the url loading is complete.
        mTimer = new CountDownTimer(WAIT_TIME, 100) {
            @Override
            public void onTick(long millisUntilFinished) {
            }

            @Override
            public void onFinish() {

                dismissDialog();

                if (!mLoading) {
                    if (!otpPopupDismissed) {

                        // Do this only if the popup has not been dismissed before.
                        if (!isCardUnRegistered) {

                            if (mBankJSConfig.getBankCid() != BankCid.CITI_BANK) {
                                // Display OTP Popup only when it is not CITI Card
                                displayOtpPopup();
                            } else {
                                displayOtpPopup();
                                // Displaying OTP Popup will be deferred till the time we detect the card scenario.
                                new Handler().postDelayed(new Runnable() {
                                    @Override
                                    public void run() {
                                        // Check whether the OTP DIV is visible or not, to be called only in  case of CITI Bank
                                        String javascript =
                                                "javascript:" + Constants.FLASH_JS_INTERFACE_NAME
                                                        + ".citiCardViewVisibility(document.getElementsByClassName('right1')[0].style.display);";
                                        notifyCitrusWebView(
                                                CitrusWebViewState.CHECK_CITI_OTP2_VIEW_VISIBILITY,
                                                javascript);
                                    }
                                }, 200);
                            }
                        } else {
                            Log.d("Card is Unregistered.", "");
                            mOTPPopupView.showCardUnregistered();
                        }
                    }
                }
            }
        };
    }

    /**
     * ``` Fetch Flash Config JS Data.
     */
    private void requestFlashConfig() {

        mFlashConfigParser = FlashConfigParser.getInstance();
        Callback binResponseCallback = new Callback<JSONObject>() {
            @Override
            public void success(JSONObject obj) {

                if (mFlashConfigParser != null) {
                    if (obj != null) {
                        mFlashConfigParser.parseFlashConfig(obj);

//                        FileStorage.storeFile(mContext, obj.toString());
                    }
                }
            }

            @Override
            public void error() {
                Log.v("Flash Config JS error", "error");
            }
        };

        mBinRequest = new BinRequest(mContext, binResponseCallback);
        mBinRequest.execute(Constants.FLASH_CONFIG_URL, null, null);

    }

    /**
     * Fetch Bin Data
     */
    private void fetchBinData(CardDetails cardDetails) {

        String binData;
        String binUrl;
        mBankJSConfig = BankJSConfig.getInstance();
        cardNumber = cardDetails.getCardNumber();
        if (!TextUtils.isEmpty(cardDetails.getCardToken())) {
            binData = cardDetails.getCardToken();
            binUrl = Constants.TOKEN_BIN_REQUEST_URL;
        } else {
            binData = cardNumber.length() > 6 ? cardNumber.substring(0, 6) : "";
            binUrl = Constants.CARD_BIN_REQUEST_URL;
        }

        Callback binResponseCallback = new Callback<JSONObject>() {
            @Override
            public void success(JSONObject json) {

                if (mBankJSConfig != null) {
                    if (json != null) {
                        mBankJSConfig.parseBankJSConfig(json);

                        if (mFlashConfigParser != null) {
                            mFlashConfigParser
                                    .parseFlashJS(mBankJSConfig.getIssuingBankName().toLowerCase(),
                                            mBankJSConfig.getCardType(), mBankJSConfig.getCardScheme());
                        }

                        // If the card is not supported then otpTxnJS will be null.
                        if (!TextUtils.isEmpty(mBankJSConfig.getOTPTxnJS())) {
                            // This is supported card
                            dismissDialog();
                            animateOTPPopup();

                            mOTPPopupView.setFlashConfig(mFlashConfigParser);
                            mOTPPopupView.setBankJsConfig(mBankJSConfig);

                            registerSMSReceivers();

                            if (mNativeScreenType != null
                                    && mNativeScreenType != NativeScreenType.ONE_QUARTER) {
                                if (mNativeScreenType != null
                                        && mNativeScreenType != NativeScreenType.ONE_QUARTER) {
                                    initOTPPopupViews();
                                }
                            } else {
                                // The card is not supported.
                                handleUnsupportedCard();
                            }
                        }
                    } else {
                        handleUnsupportedCard();
                    }
                }
            }

            @Override
            public void error() {
                Log.v("Bin service error", "error");
                handleUnsupportedCard();
            }
        };

        mBinRequest = new BinRequest(mContext, binResponseCallback);
        mBinRequest.execute(binUrl, binData, null);

        showDialog("", true);
    }

    private void handleUnsupportedCard() {
        dismissDialog();
        unregisterSMSReceivers();
        dismissOtpPopup();

        if (getActivity() != null) {
            getActivity().finish();
        }
    }

    /**
     * Handle Flash Window properties.
     */
    private void handleWindowProperties() {

        DisplayMetrics metrics = getResources().getDisplayMetrics();
        screenWidth = metrics.widthPixels;

        if (getActivity() != null) {
            WindowManager.LayoutParams params = getActivity().getWindow().getAttributes();
            params.width = screenWidth;

            getActivity().getWindow().setAttributes(params);
        }

    }

    /**
     * Display Flash popup to user.
     */
    private void displayOtpPopup() {

        Log.d("CCC", "displayOtpPopup");

        if (!otpPopupDismissed) {
            // Display popup only if the autoOTP is enabled and payment mode is Credit/Debit Card.

            // Prevent the activity from sleeping.
            if (getActivity() != null) {
                getActivity().getWindow().addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);
            }

            // Show the otp popup views
            rootView.findViewById(R.id.otpPopupProcessingTxtId).setVisibility(View.GONE);
            rootView.findViewById(R.id.otpPopupProgressBarID).setVisibility(View.GONE);
            rootView.findViewById(R.id.otpPopupView1Id).setVisibility(View.VISIBLE);
            rootView.findViewById(R.id.otpPopupHeaderLayoutId).setVisibility(View.VISIBLE);

            // No need of displaying other popup views in case of 25%.
            if (mNativeScreenType == NativeScreenType.ONE_QUARTER) {

                rootView.findViewById(R.id.linearLayout).setVisibility(View.GONE);
                rootView.findViewById(R.id.otpPopupScrollViewId)
                        .setOnTouchListener(new View.OnTouchListener() {

                            @Override
                            public boolean onTouch(View v, MotionEvent event) {
                                return true;
                            }
                        });
                rootView.findViewById(R.id.otpPopupScrollViewId).post(new Runnable() {
                    @Override
                    public void run() {
                        ((ScrollView) rootView.findViewById(R.id.otpPopupScrollViewId))
                                .fullScroll(ScrollView.FOCUS_DOWN);
                    }
                });
            }

            if (mBankJSConfig == null || TextUtils.isEmpty(mBankJSConfig.getOTPTxnJS())) {
                isCardUnSupported = true;
                Log.d("Display OTP", "Card is Unsupported.");
                mOTPPopupView.showCardUnSupported();
            } else {
//                If in case of few banks there is no option to enter password, only otp is directly triggered, so hide the enter password button.
                if (mBankJSConfig.getBypassEnterPasswordBtn()) {
                    mOTPPopupView.toggleEnterPasswordOption(false);
                }

                mOTPPopupView.setPasswordText(
                        "Continue with " + mFlashConfigParser.getCardPwds().getCurrentCardPwd());
//         If in case of few banks the otp is directly triggered, so hide the send OTP button.
                if (mBankJSConfig.getBypassSendOTPBtn()) {
                    displayOtpAutoDetectPopup();
                } else if (mBankJSConfig.isShowEnterPassword()) {
                    mOTPPopupView.displayEnterPasswordPopup();
                }
            }
        }
    }

    private void displayOtpAutoDetectPopup() {
        // This boolean will always be true on older Android versions.
        // On Android 6.0+ it will depend on whether user grants permission.
        if (smsPermissionGranted) {
            mOTPPopupView
                    .setOtpAutoReadState(OTPPopupView.OTPAutoReadState.AutoReadEnabled);
            startOtpReadTimer();
        } else {
            mOTPPopupView
                    .setOtpAutoReadState(OTPPopupView.OTPAutoReadState.AutoReadDisabled);
        }
        mOTPPopupView.displayOtpAutoDetectPopup();
    }

    /**
     * Dismiss Flash Popup
     */

    private void dismissOtpPopup() {

        showingOtpScreen = false;

        // Hide the Overlay on the otp popup i.e. dark gray screen

        otpPopupDismissed = true;

        Context context = getContext();
        if (context != null) {
            // Hide the OTP Popup.
            Animation slide_down = AnimationUtils.loadAnimation(getContext(),
                    R.anim.slide_down);
            slide_down.setAnimationListener(new Animation.AnimationListener() {
                @Override
                public void onAnimationStart(Animation animation) {

                }

                @Override
                public void onAnimationEnd(Animation animation) {
                    if (rootView.findViewById(R.id.otpPopupCancelTextViewId) != null) {
                        rootView.findViewById(R.id.otpPopupCancelTextViewId)
                                .setVisibility(View.GONE);
                    }

                    rootView.findViewById(R.id.otpPopupBottomBarLayoutId).setVisibility(View.GONE);
                    rootView.findViewById(R.id.otpPopupOverlayId).setVisibility(View.GONE);
                    mOTPPopupView = null;
                }

                @Override
                public void onAnimationRepeat(Animation animation) {

                }
            });
            rootView.findViewById(R.id.otpPopupScrollViewId).startAnimation(slide_down);
        } else {
            if (rootView.findViewById(R.id.otpPopupCancelTextViewId) != null) {
                rootView.findViewById(R.id.otpPopupCancelTextViewId).setVisibility(View.GONE);
            }

            rootView.findViewById(R.id.otpPopupBottomBarLayoutId).setVisibility(View.GONE);
            rootView.findViewById(R.id.otpPopupOverlayId).setVisibility(View.GONE);
            mOTPPopupView = null;
        }

        rootView.findViewById(R.id.otpPopupScrollViewId).setVisibility(View.GONE);
        rootView.findViewById(R.id.otpPopupCancelTextViewId).setVisibility(View.GONE);

        mBankJSConfig = null;
        mFlashConfigParser = null;
        BankJSConfig.getInstance().clear();
        FlashConfigParser.getInstance().clear();
        FlashPaymentTracker.getInstance().clear();
        CitrusBrowserConfig.getInstance().clear();

    }


    /**
     * Animate Flash popup
     */
    private void animateOTPPopup() {
        showingOtpScreen = true;

        Animation slide_up = AnimationUtils.loadAnimation(mContext,
                R.anim.slide_up);
        slide_up.setAnimationListener(new Animation.AnimationListener() {
            @Override
            public void onAnimationStart(Animation animation) {

            }

            @Override
            public void onAnimationEnd(Animation animation) {
                rootView.findViewById(R.id.otpPopupCancelTextViewId).setVisibility(View.VISIBLE);
                ((TypeWriterTextView) rootView.findViewById(R.id.otpPopupProcessingTxtId))
                        .animateText("Processing...", 15);
                rootView.findViewById(R.id.otpPopupProgressBarID).setVisibility(View.VISIBLE);
                rootView.findViewById(R.id.otpPopupBottomBarLayoutId).setVisibility(View.VISIBLE);
                handleProgressBarAnimation();
            }

            @Override
            public void onAnimationRepeat(Animation animation) {

            }
        });

        // Show OTP Popup Layout
        rootView.findViewById(R.id.otpPopupScrollViewId).startAnimation(slide_up);
        rootView.findViewById(R.id.otpPopupScrollViewId).setVisibility(View.VISIBLE);

    }

    /**
     * Animate Flash progress.
     */
    private void handleProgressBarAnimation() {

        final ProgressBar progressBar = (ProgressBar) rootView
                .findViewById(R.id.otpPopupProgressBarID);

        LayerDrawable layerDrawable = (LayerDrawable) (progressBar).getProgressDrawable();
        Drawable progressDrawable = layerDrawable.findDrawableByLayerId(android.R.id.progress);
        progressDrawable
                .setColorFilter(getResources().getColor(R.color.colorPrimary), PorterDuff.Mode.SRC_IN);

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.HONEYCOMB) {
            ObjectAnimator animation = ObjectAnimator.ofInt(progressBar, "progress", 0, 100);
            animation.setDuration(6500);
            animation.setInterpolator(new LinearInterpolator());
            animation.start();
        }
    }

    /**
     * Init Flash popup views.
     */
    private void initOTPPopupViews() {

        AssetDownloadManager.getInstance()
                .getLargeBankBitmap(mBankJSConfig.getBankAssetName(), new BitmapCallBack() {
                    @Override
                    public void onBitmapReceived(Bitmap bitmap) {
//                Drawable drawable = new BitmapDrawable(getResources(), bitmap);
                        if (rootView.findViewById(R.id.otpPopupBankImgId) != null) {
                            ((ImageView) rootView.findViewById(R.id.otpPopupBankImgId))
                                    .setImageBitmap(bitmap);
                        }
                    }

                    @Override
                    public void onBitmapFailed(Bitmap bitmap) {
//                Drawable drawable = new BitmapDrawable(getResources(), bitmap);
                        if (rootView.findViewById(R.id.otpPopupBankImgId) != null) {
                            ((ImageView) rootView.findViewById(R.id.otpPopupBankImgId))
                                    .setImageBitmap(bitmap);
                        }
                    }
                });

        AssetDownloadManager.getInstance()
                .getLargeCardBitmap(mBankJSConfig.getCardAssetName(mBankJSConfig.getCardScheme()),
                        new BitmapCallBack() {
                            @Override
                            public void onBitmapReceived(Bitmap bitmap) {
//                Drawable drawable = new BitmapDrawable(getResources(), bitmap);
                                if (rootView.findViewById(R.id.otpPopupCardSchemeImgId) != null) {
                                    ((ImageView) rootView.findViewById(R.id.otpPopupCardSchemeImgId))
                                            .setImageBitmap(bitmap);
                                }
                            }

                            @Override
                            public void onBitmapFailed(Bitmap bitmap) {
//                Drawable drawable = new BitmapDrawable(getResources(), bitmap);
                                if (rootView.findViewById(R.id.otpPopupCardSchemeImgId) != null) {
                                    ((ImageView) rootView.findViewById(R.id.otpPopupCardSchemeImgId))
                                            .setImageBitmap(bitmap);
                                }
                            }
                        });

        // create a bold StyleSpan to be used on the SpannableStringBuilder
        StyleSpan boldSpan = new StyleSpan(Typeface.BOLD); // Span to make text bold

        String txnAmountStr = amount.getValue();
        if (!TextUtils.isEmpty(txnAmountStr)) {
            // a SpannableStringBuilder containing amount text to display
            SpannableStringBuilder sb = new SpannableStringBuilder(
                    "Paying  " + getResources().getString(R.string.Rs) + " " + txnAmountStr);
            // set only the amount part of the SpannableStringBuilder to be bold
            sb.setSpan(boldSpan, 10, 10 + txnAmountStr.length(),
                    Spannable.SPAN_INCLUSIVE_INCLUSIVE);
            ((TextView) rootView.findViewById(R.id.payAmountTextId)).setText(sb);
        }

        if (!TextUtils.isEmpty(cardNumber)) {
            String formattedCardNum = Utils.formatCardNumber(cardNumber);
            // a SpannableStringBuilder containing card number text to display
            SpannableStringBuilder sb1 = new SpannableStringBuilder(formattedCardNum);

            sb1.setSpan(boldSpan, formattedCardNum.length() - 4,
                    (formattedCardNum.length() - 4) + 4, Spannable.SPAN_INCLUSIVE_INCLUSIVE);

            ((TextView) rootView.findViewById(R.id.cardTextId)).setText(sb1);
        }

    }


    /**
     * Request SMS permission for Android Version M.
     */
    private void checkSmsPermission() {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M
                && getActivity().checkSelfPermission(Manifest.permission.RECEIVE_SMS)
                != PackageManager.PERMISSION_GRANTED) {
            //After this point you wait for callback in onRequestPermissionsResult(int, String[], int[]) overriden method
            Log.d("Check SMS Permission", "Requesting SMS permission");
            requestPermissions(new String[]{Manifest.permission.RECEIVE_SMS},
                    PERMISSIONS_REQUEST_CODE_RECEIVE_SMS);
        } else {
            //do something, permission was previously granted; or legacy device
            Log.d("Check SMS Permission", "SMS permission already granted");
            smsPermissionGranted = true;
            registerSMSReceivers();

//            if (resendOtpRequested) {
            if (mOTPPopupView.isResendClicked()) {
                String resendOtpJs = mBankJSConfig.getResendOTPJS();
                notifyCitrusWebView(Presenter.CitrusWebViewState.LOAD_URL, resendOtpJs);
                if (smsPermissionGranted) {
                    startOtpReadTimer();
                }
                mOTPPopupView.displayOtpAutoDetectPopup();
            }
        }

        mOTPPopupView.smsPermissionStatus(smsPermissionGranted);
    }

    /**
     * SMS Permission result
     */
    @Override
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions,
                                           @NonNull int[] grantResults) {
        if (requestCode == PERMISSIONS_REQUEST_CODE_RECEIVE_SMS
                && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
            // Do something with granted permission
            Log.d("Check SMS Permission", "SMS permission granted");
            smsPermissionGranted = true;
            registerSMSReceivers();
        } else if (requestCode == PERMISSIONS_REQUEST_CODE_RECEIVE_SMS
                && grantResults[0] == PackageManager.PERMISSION_DENIED) {
            Log.d("Check SMS Permission", "SMS permission denied");
            smsPermissionGranted = false;
            if (mAutoOtpSMSReceiveListener != null) {
                unregisterSMSReceivers();
            }
        }

        mOTPPopupView.smsPermissionStatus(smsPermissionGranted);

//        if (resendOtpRequested) {
        if (mOTPPopupView.isResendClicked()) {
            String resendOtpJs = mBankJSConfig.getResendOTPJS();
            notifyCitrusWebView(Presenter.CitrusWebViewState.LOAD_URL, resendOtpJs);
            if (smsPermissionGranted) {
                startOtpReadTimer();
            }
            mOTPPopupView.displayOtpAutoDetectPopup();
        }
    }

    /**
     * Register SMS receivers.
     */
    private void registerSMSReceivers() {
        // Register receivers only if the autoOTP is enabled and payment mode is Credit/Debit Card.
        if (smsPermissionGranted && mBankJSConfig
                != null/*&& autoOTPEnabled && mPaymentOption instanceof CardOption && mEnvironment == Environment.PRODUCTION*/) {
            Log.d("Register SMS Receiver", "Registering SMS receivers");

            mSMSReceiverRegistered = true;

            if (mSMSReceiver == null) {
                mSMSReceiver = new SMSReceiver(mBankJSConfig);
            }

            if (mAutoOtpSMSReceiveListener == null) {
                mAutoOtpSMSReceiveListener = new BroadcastReceiver() {
                    @Override
                    public void onReceive(Context context, Intent intent) {
                        autoOtpReceived(intent);
                    }
                };
            }

            IntentFilter intentFilter = new IntentFilter(Constants.ACTION_SMS_RECEIVED);
            intentFilter.setPriority(Constants.SMS_RECEIVER_PRIORITY);
            if (getActivity() != null) {
                getActivity().registerReceiver(mSMSReceiver, intentFilter);
            }

            LocalBroadcastManager.getInstance(mContext).registerReceiver(mAutoOtpSMSReceiveListener,
                    new IntentFilter(Constants.ACTION_AUTO_READ_OTP));
        }
    }

    /**
     * UnRegister SMS receivers.
     */
    private void unregisterSMSReceivers() {

        // Unregister receivers only if the autoOTP is enabled and payment mode is Credit/Debit Card.
        if (mSMSReceiverRegistered) {

            Log.d("Unregister SMS Receiver", "Unregistering SMS receivers");

            if (mSMSReceiver != null) {
                if (getActivity() != null) {
                    getActivity().unregisterReceiver(mSMSReceiver);
                }
                mSMSReceiverRegistered = false;
                mSMSReceiver = null;
            }

            if (mAutoOtpSMSReceiveListener != null) {
                LocalBroadcastManager.getInstance(mContext)
                        .unregisterReceiver(mAutoOtpSMSReceiveListener);
                mAutoOtpSMSReceiveListener = null;
            }
        }
    }

    /**
     * Handle OTP received scenario
     */
    private void autoOtpReceived(Intent intent) {
        otp = intent.getStringExtra(Constants.INTENT_EXTRA_AUTO_OTP);
        // Check whether the otp is not empty
        if (!TextUtils.isEmpty(otp)) {
            mOTPPopupView.displayAutoReadOTP();
            unregisterSMSReceivers();
            autoReadOTP = true;

            // This is done to avoid,
            // when user cancels transaction, so OTP Dialog is dismissed.
            // After this, OTP is received and trying to set on a Null reference field.
            if (!otpPopupDismissed) {
                mOTPPopupView.displayAutoReadSetOTP(otp);
                // take this parameter dynamically later.
                if (autoSubmitAllowed) {
                    final Handler handler = new Handler();
                    handler.postDelayed(new Runnable() {
                        @Override
                        public void run() {
                            onProcessTransactionClicked(otp);
                        }
                    }, 3000);
                }
            }
        }
    }


    /**
     * Display flash payment status on the UI.
     */
    public void displayFlashStatus(final PaymentStatus paymentStatus) {

        txnCallbackReceived = true;
        if (getActivity() != null) {
            getActivity().runOnUiThread(new Runnable() {
                @Override
                public void run() {
                    mOTPPopupView.displayTransactionStatus(paymentStatus);
                    if (!otpPopupDismissed) {
                        // Delay so that the otp dismiss animation finishes.
                        final Handler handler = new Handler();
                        handler.postDelayed(new Runnable() {
                            @Override
                            public void run() {
                                if (mTimer != null) {
                                    mTimer.cancel();
                                }
                                unregisterSMSReceivers();
                                dismissOtpPopup();
                                if (getActivity() != null) {
                                    getActivity().finish();
                                }

                            }
                        }, 4000);
                    }
                }
            });
        }

    }


    /**
     * Wait for callback of txn actions.
     */
    private void waitForTxnCallback() {
        //if no callback is received after 20 seconds
        //dismiss the popup
        new Handler().postDelayed(new Runnable() {
            @Override
            public void run() {
                if (!txnCallbackReceived) {
                    notifyCitrusWebView(Presenter.CitrusWebViewState.SHOW_WEBVIEW, null);
                    dismissOtpPopup();
                    if (getActivity() != null) {
                        getActivity().finish();
                    }
                }
            }
        }, TXN_CALLBACK_WAIT_PERIOD);
    }

    /**
     * Display OTP error message.
     */
    @Override
    public void displayOTPErrorMessage(String message) {
        rootView.findViewById(R.id.otpErrorTextViewId).setVisibility(View.VISIBLE);
        ((TextView) rootView.findViewById(R.id.otpErrorTextViewId)).setText(message);
        final View view = rootView.findViewById(R.id.otpErrorTextViewId);
        view.postDelayed(new Runnable() {
            @Override
            public void run() {
                view.setVisibility(View.GONE);
            }
        }, 3000);
    }


    /**
     * Handle cancel txn scenario.
     */
    private void handleCancelTransaction() {
        AlertDialog.Builder builder = new AlertDialog.Builder(mContext);
        // Add the buttons
        builder.setPositiveButton("Yes", new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dialog, int id) {
                dialog.dismiss();
                if (mTxnType == TxnType.CREDIT_CARD || mTxnType == TxnType.DEBIT_CARD) {
//                    mOTPPopupView.handleCancelTransaction();
                    txnCallbackReceived = true;
                    FlashPaymentTracker.getInstance().notifyListeners(PaymentStatus.CANCELLED);
                    if (mTimer != null) {
                        mTimer.cancel();
                    }
                    unregisterSMSReceivers();
                    dismissOtpPopup();
                    if (getActivity() != null) {
                        getActivity().finish();
                    }
                } else {
                    notifyCitrusWebView(Presenter.CitrusWebViewState.GO_BACK, null);
                }
            }
        });
        builder.setNegativeButton("No", new DialogInterface.OnClickListener() {
            public void onClick(DialogInterface dialog, int id) {
                if (otpPopupCancelImgView != null) {
                    otpPopupCancelImgView.setClickable(true);
                    otpPopupCancelImgView.setEnabled(true);
                }
            }
        });
        // Set other dialog properties
        builder.setMessage("Do you want to close OTP Assist?")
                .setTitle("Close OTP Assist?");
        // Create the AlertDialog
        AlertDialog dialog = builder.create();
        dialog.setCanceledOnTouchOutside(false);
        dialog.show();
    }


    /**
     * Flash Send OTP clicked.
     */
    @Override
    public void onSendOtpClicked() {

        String sendOtpJs = mBankJSConfig.getSendOTPJS();
        notifyCitrusWebView(Presenter.CitrusWebViewState.LOAD_URL, sendOtpJs);

        // This will always be true on older Android versions.
        // On Android 6.0+ it will depend on whether user grants permission.
        if (smsPermissionGranted) {
            startOtpReadTimer();
        }
    }

    /**
     * Flash Enter Password clicked.
     */
    @Override
    public void onEnterPasswordClicked() {

        String enterPwdJS = mBankJSConfig.getEnterPasswordJS();
        notifyCitrusWebView(Presenter.CitrusWebViewState.LOAD_URL, enterPwdJS);

    }

    /**
     * Flash Cancel clicked.
     */
    @Override
    public void onCancelClicked() {
        handleCancelTransaction();
    }

    /**
     * Flash Process TXN clicked.
     */
    @Override
    public void onProcessTransactionClicked(String otp) {

        txnProcessed = true;

        String setOtpJs = mBankJSConfig.getSetOTPJS(otp);
        // Set OTP on bank's page.
        notifyCitrusWebView(Presenter.CitrusWebViewState.LOAD_URL, setOtpJs);

        new Handler().postDelayed(new Runnable() {
            @Override
            public void run() {
                String js = String.format(mBankJSConfig.getOTPTxnJS());
                notifyCitrusWebView(Presenter.CitrusWebViewState.LOAD_URL, js);
            }
        }, 1000);

        waitForTxnCallback();

        otpPopupCancelImgView.setVisibility(View.GONE);

    }

    /**
     * Flash Resend OTP clicked.
     */
    @Override
    public void onResendOTPClicked() {
//        String resendOtpJs = mBankJSConfig.getResendOTPJS();
//        notifyCitrusWebView(Presenter.CitrusWebViewState.LOAD_URL, resendOtpJs);
//
//        // This boolean will always be true on older Android versions.
//        // On Android 6.0+ it will depend on whether user grants permission.
//        if (smsPermissionGranted) {
//            // Register sms receivers
//            registerSMSReceivers();
//            startOtpReadTimer();
//        }
        resendOtpRequested = true;
        checkSmsPermission();
        autoReadOTP = false;
    }

    /**
     * Start OTP Read Timer.
     */
    @Override
    public void startOtpReadTimer() {
        if (smsPermissionGranted) {
            otpReadHandler = new Handler();
            otpReadRunnable = new Runnable() {
                @Override
                public void run() {

                    unregisterSMSReceivers();
                    if (!autoReadOTP && !otpPopupDismissed) {
                        if (otpReadHandler != null || otpReadRunnable != null) {
                            displayOTPErrorMessage(
                                    getResources().getString(R.string.otp_detection_failed_text1));
                            mOTPPopupView.otpReadTimeout();
                            otpReadHandler = null;
                            otpReadRunnable = null;
                        }
                    }
                }
            };
            otpReadHandler.postDelayed(otpReadRunnable, OTP_READ_TIMEOUT);
        }
    }

    /**
     * Stop OTP read Timer.
     */
    @Override
    public void stopOtpReadTimer() {
        Log.d("OTP Read", "Stop Timer");
        if (otpReadHandler != null) {
            unregisterSMSReceivers();
            otpReadHandler.removeCallbacksAndMessages(null);
            otpReadHandler = null;
            otpReadRunnable = null;
            mOTPPopupView.otpReadTimeout();
        }
    }

    /**
     * Dismiss Flash OTP popup.
     */
    @Override
    public void dismissOTPPopup() {
        rootView.findViewById(R.id.otpPopupProcessingTxtId).setVisibility(View.GONE);
        rootView.findViewById(R.id.otpPopupProgressBarID).setVisibility(View.GONE);
        new Handler().postDelayed(new Runnable() {
            @Override
            public void run() {

                if (isCardUnRegistered) {
                    // This event records the end of Card unregistered screen.
//                    awsAnalyticsManager.recordEvent(AwsEventType.CARD_UNREGISTERED);
                }
                if (isCardUnSupported) {
                    // This event records the end of Card unsupported screen.
//                    awsAnalyticsManager.recordEvent(AwsEventType.CARD_UNSUPPORTED);
                }
//                if (mPaymentWebView != null) {
//                    mPaymentWebView.setVisibility(View.VISIBLE);
//                }
                notifyCitrusWebView(Presenter.CitrusWebViewState.SHOW_WEBVIEW, null);
                rootView.findViewById(R.id.otpPopupOverlayId).setVisibility(View.GONE);
                dismissOtpPopup();
                if (getActivity() != null) {
                    getActivity().finish();
                }

            }
        }, 3500);
    }

    /**
     * Flash Password TXN confirmed clicked.
     */
    @Override
    public void onEnteredPasswordConfirmed(String password) {

        txnProcessed = true;

        String setPasswordJs = mBankJSConfig.getSetPasswordJS(password);
        // Set password on bank's page.
        notifyCitrusWebView(Presenter.CitrusWebViewState.LOAD_URL, setPasswordJs);

        new Handler().postDelayed(new Runnable() {
            @Override
            public void run() {
                String js = mBankJSConfig.getPasswordTxnJS();
                notifyCitrusWebView(Presenter.CitrusWebViewState.LOAD_URL, js);
            }
        }, 1000);

        waitForTxnCallback();

        otpPopupCancelImgView.setVisibility(View.GONE);
    }

    /**
     * On Back pressed.
     */
    @Override
    public void onBackPressed() {
        if (!showingOtpScreen) {
            return;
        }

        if (mTxnType == TxnType.CREDIT_CARD || mTxnType == TxnType.DEBIT_CARD) {
            if (!txnProcessed) {
                handleCancelTransaction();
            }
        } else {
            notifyCitrusWebView(Presenter.CitrusWebViewState.GO_BACK, null);
        }
    }


    @Override
    public void onPause() {
        super.onPause();
        if (mTxnType == TxnType.CREDIT_CARD || mTxnType == TxnType.DEBIT_CARD) {
            if (mAutoOtpSMSReceiveListener != null) {
                unregisterSMSReceivers();
            }
        }

        dismissDialog();
    }

    @Override
    public void onStop() {
        super.onStop();
        if (mTxnType == TxnType.CREDIT_CARD || mTxnType == TxnType.DEBIT_CARD) {
            if (mAutoOtpSMSReceiveListener != null) {
                unregisterSMSReceivers();
            }
        }
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (mTxnType == TxnType.CREDIT_CARD || mTxnType == TxnType.DEBIT_CARD) {
            if (mAutoOtpSMSReceiveListener != null) {
                unregisterSMSReceivers();
            }
        }
        if (mTxnType == TxnType.CREDIT_CARD || mTxnType == TxnType.DEBIT_CARD) {
            dismissOtpPopup();
        }
    }

    @Override
    public void onResume() {
        super.onResume();
        if (mTxnType == TxnType.CREDIT_CARD || mTxnType == TxnType.DEBIT_CARD) {
            registerSMSReceivers();
        }
    }


    @Override
    public void timerStart() {
        if (mTimer != null) {
            mTimer.start();
        }
    }

    @Override
    public void timerStop() {
        if (mTimer != null) {
            mTimer.cancel();
        }
    }

    @Override
    public void cardUnregistered() {
        isCardUnRegistered = true;
    }

    @Override
    public void paymentFailed() {
        if (!otpPopupDismissed) {
            displayFlashStatus(PaymentStatus.FAILED);
        }
    }

    @Override
    public void onReceivedCitiOTP2ViewVisibility(
            final String visibility) { // visibility can be "", "none", "block"
        getActivity().runOnUiThread(new Runnable() {
            @Override
            public void run() {
                Log.d("ccc", "CitrusBrowserFragment Visibility : " + visibility);

                // Display OTP Popup
                displayOtpPopup();

                if ("none".equalsIgnoreCase(visibility)) {
                    new Handler().postDelayed(new Runnable() {
                        @Override
                        public void run() {
                            displayOtpAutoDetectPopup();
                        }
                    }, 200);
                }
            }
        });
    }

    /**
     * Notify the presenter to work on the CitrusWebView.
     */
    private void notifyCitrusWebView(Presenter.CitrusWebViewState state, String url) {
        if (presenter != null) {
            presenter.notifyCitrusWebView(state, url);
        }
    }

}
