package com.citruspay.citrusbrowser.listener;

/**
 * This interface contains events to perform on the CitrusWebView.
 * Created by gautam on 8/16/16.
 */
public interface CitrusWebViewObserver {

    /**
     * Load JS/ URL into the Citrus WebView.
     *
     * @param js
     */
    void loadJS(String js);

    /**
     * Stop loading of the Citrus WebView.
     */
    void stopLoading();

    /**
     * Hide the Citrus WebView.
     */
    void hideWebView();

    /**
     * Show the Citrus WebView.
     */
    void showWebView();

    /**
     * Back press of the Citrus WebView.
     */
    void goBack();
}
