package com.citruspay.citrusbrowser.core;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * TxnDetails class is a POJO class which holds the Transaction details i.e. the amount , currency, txn type.
 * Together these details are required to for the flash experience.
 * Created by Gautam on 15/6/16.
 */
public class TxnDetails implements Parcelable {
    private Amount mAmount = null;
    //    private String mCardNumber = null;
    private String mTxnAmt = null;
    private String mTxnCurrency = null;
    private String mTxnTypeStr = null;
    private TxnType mTxnType = null;

    public TxnDetails(Amount amount/*, String cardNumber*/) {
        this.mAmount = amount;
//        this.mCardNumber = cardNumber;
    }

    public TxnDetails(String txnAmt, String txnCurrency, String txnType) {
        this.mAmount = new Amount(txnAmt);
        this.mTxnCurrency = txnCurrency;
        this.mTxnType = TxnType.getTxnType(txnType);
    }

    public TxnDetails(String txnAmt, String txnCurrency, TxnType txnType) {
        this.mAmount = new Amount(txnAmt);
        this.mTxnCurrency = txnCurrency;
        this.mTxnType = txnType;
    }

    public Amount getAmount() {
        return mAmount;
    }

    public void setAmount(Amount amount) {
        this.mAmount = amount;
    }

//    public String getCardNumber() {
//        return mCardNumber;
//    }
//
//    public void setCardNumber(String cardNumber) {
//        this.mCardNumber = cardNumber;
//    }

    public TxnType getTxnType() {
        return mTxnType;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(this.mAmount, flags);
//        dest.writeString(this.mCardNumber);
        dest.writeString(this.mTxnAmt);
        dest.writeString(this.mTxnCurrency);
        dest.writeString(this.mTxnTypeStr);
        dest.writeInt(this.mTxnType == null ? -1 : this.mTxnType.ordinal());
    }

    protected TxnDetails(Parcel in) {
        this.mAmount = in.readParcelable(Amount.class.getClassLoader());
//        this.mCardNumber = in.readString();
        this.mTxnAmt = in.readString();
        this.mTxnCurrency = in.readString();
        this.mTxnTypeStr = in.readString();
        int tmpMTxnType = in.readInt();
        this.mTxnType = tmpMTxnType == -1 ? null : TxnType.values()[tmpMTxnType];
    }

    public static final Creator<TxnDetails> CREATOR = new Creator<TxnDetails>() {
        @Override
        public TxnDetails createFromParcel(Parcel source) {
            return new TxnDetails(source);
        }

        @Override
        public TxnDetails[] newArray(int size) {
            return new TxnDetails[size];
        }
    };
}
