package com.citruspay.citrusbrowser;

import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;

import com.citruspay.citrusbrowser.core.CitrusBrowserConfig;
import com.citruspay.graphics.AssetDownloadManager;
import com.citruspay.graphics.AssetsHelper;

/**
 * This is the main activity which will handle the Payment Experience.
 * Created by Gautam on 15/6/16.
 */
public class CitrusBrowserActivity extends FragmentActivity {

    private static CitrusBrowserFragment citrusBrowserFragment = null;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_citrus_browser);

        AssetDownloadManager.getInstance().init(this, AssetsHelper.SDK_TYPE.FLASH_SDK);

        Bundle bundle = this.getIntent().getExtras();
        if (bundle != null) {
            CitrusBrowserConfig mCitrusBrowserConfig = bundle.getParcelable(CitrusBrowserConfig.KEY_CITRUS_BROWSER_CONFIG);
            if (mCitrusBrowserConfig != null) {
                FragmentManager fragmentManager = getSupportFragmentManager();

                citrusBrowserFragment = CitrusBrowserFragment.newInstance(this, mCitrusBrowserConfig);
                FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction()
                        .add(R.id.citrus_browser_frag_container, citrusBrowserFragment);
                fragmentTransaction.commit();
            }
        }
    }

    @Override
    protected void onPause() {
        super.onPause();
        if (citrusBrowserFragment != null)
            citrusBrowserFragment.onPause();
    }

    @Override
    public void onBackPressed() {
//        super.onBackPressed();
        if (citrusBrowserFragment != null)
            citrusBrowserFragment.onBackPressed();
    }

    @Override
    protected void onResume() {
        super.onResume();
        if (citrusBrowserFragment != null)
            citrusBrowserFragment.onResume();
    }

    @Override
    protected void onStop() {
        super.onStop();
        if (citrusBrowserFragment != null)
            citrusBrowserFragment.onStop();
    }
}
