/*
 * Decompiled with CFR 0.152.
 */
package com.citruspay.citrusbrowser.core;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import com.citruspay.citrusbrowser.core.CardDetails;
import com.citruspay.citrusbrowser.core.NativeScreenType;
import com.citruspay.citrusbrowser.core.PaymentStatus;
import com.citruspay.citrusbrowser.core.TxnDetails;
import java.util.Map;

public class CitrusBrowserConfig
implements Parcelable {
    private Context mContext = null;
    private String paymentUrl = null;
    private Map<String, String> headers = null;
    private TxnDetails mTxnDetails = null;
    private CardDetails mCardDetails = null;
    private PaymentStatus mPaymentStatus = null;
    private NativeScreenType mNativeScreenType = null;
    private boolean autoReadOTP = true;
    private boolean autoSubmitOTP = true;
    public static final String KEY_CITRUS_BROWSER_CONFIG = "key_citrus_browser_config";
    private static CitrusBrowserConfig mCitrusBrowserConfig = null;
    public static final Parcelable.Creator<CitrusBrowserConfig> CREATOR = new Parcelable.Creator<CitrusBrowserConfig>(){

        public CitrusBrowserConfig a(Parcel parcel) {
            return new CitrusBrowserConfig(parcel);
        }

        public CitrusBrowserConfig[] a(int n) {
            return new CitrusBrowserConfig[n];
        }

        public /* synthetic */ Object[] newArray(int n) {
            return this.a(n);
        }

        public /* synthetic */ Object createFromParcel(Parcel parcel) {
            return this.a(parcel);
        }
    };

    private CitrusBrowserConfig(Context context) {
        this.mContext = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CitrusBrowserConfig getInstance(Context context) {
        if (mCitrusBrowserConfig != null) return mCitrusBrowserConfig;
        Class<CitrusBrowserConfig> clazz = CitrusBrowserConfig.class;
        synchronized (CitrusBrowserConfig.class) {
            if (mCitrusBrowserConfig != null) return mCitrusBrowserConfig;
            mCitrusBrowserConfig = new CitrusBrowserConfig(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mCitrusBrowserConfig;
        }
    }

    private void setPaymentUrl(String string2) {
        this.paymentUrl = string2;
    }

    private void setPaymentUrl(String string2, Map<String, String> map) {
        this.paymentUrl = string2;
        this.headers = map;
    }

    private void setPaymentHtml(String string2) {
    }

    private void enableNativeView(boolean bl) {
    }

    public void setTxnDetails(TxnDetails txnDetails) {
        this.mTxnDetails = txnDetails;
    }

    public void setCardDetails(CardDetails cardDetails) {
        this.mCardDetails = cardDetails;
    }

    private void setPaymentStatus(PaymentStatus paymentStatus) {
        this.mPaymentStatus = paymentStatus;
    }

    public void setNativeScreenType(NativeScreenType nativeScreenType) {
        this.mNativeScreenType = nativeScreenType;
    }

    private void setAutoReadOTP(boolean bl) {
        this.autoReadOTP = bl;
    }

    public void setAutoSubmitOTP(boolean bl) {
        this.autoSubmitOTP = bl;
    }

    public TxnDetails getTxnDetails() {
        return this.mTxnDetails;
    }

    private PaymentStatus getPaymentStatus() {
        return this.mPaymentStatus;
    }

    private boolean isAutoReadOTP() {
        return this.autoReadOTP;
    }

    public boolean isAutoSubmitOTP() {
        return this.autoSubmitOTP;
    }

    public NativeScreenType getNativeScreenType() {
        return this.mNativeScreenType;
    }

    private String getPaymentUrl() {
        return this.paymentUrl;
    }

    private Map<String, String> getHeaders() {
        return this.headers;
    }

    public CardDetails getCardDetails() {
        return this.mCardDetails;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.paymentUrl);
        parcel.writeParcelable((Parcelable)this.mTxnDetails, n);
        parcel.writeParcelable((Parcelable)this.mCardDetails, n);
        parcel.writeInt(this.mPaymentStatus == null ? -1 : this.mPaymentStatus.ordinal());
        parcel.writeInt(this.mNativeScreenType == null ? -1 : this.mNativeScreenType.ordinal());
        parcel.writeByte(this.autoReadOTP ? (byte)1 : 0);
        parcel.writeByte(this.autoSubmitOTP ? (byte)1 : 0);
    }

    protected CitrusBrowserConfig(Parcel parcel) {
        this.paymentUrl = parcel.readString();
        this.mTxnDetails = (TxnDetails)parcel.readParcelable(TxnDetails.class.getClassLoader());
        this.mCardDetails = (CardDetails)parcel.readParcelable(CardDetails.class.getClassLoader());
        int n = parcel.readInt();
        this.mPaymentStatus = n == -1 ? null : PaymentStatus.values()[n];
        int n2 = parcel.readInt();
        this.mNativeScreenType = n2 == -1 ? null : NativeScreenType.values()[n2];
        this.autoReadOTP = parcel.readByte() != 0;
        this.autoSubmitOTP = parcel.readByte() != 0;
    }
}

