package com.citruspay.citrusbrowser.network;

import android.content.Context;
import android.os.AsyncTask;
import android.text.TextUtils;
import android.util.Log;

import com.citruspay.citrusbrowser.core.Callback;
import com.citruspay.citrusbrowser.utils.FileStorage;

import org.json.JSONException;
import org.json.JSONObject;

/**
 * This class performs Bin service network call.
 * Created by Gautam on 16/6/16.
 */
public class BinRequest extends AsyncTask<String, String, JSONObject> {

    private Callback binResponseCallback = null;
    private Context mContext;

    public BinRequest(Context context, Callback callback) {
        this.mContext = context;
        binResponseCallback = callback;
    }

    @Override
    protected void onPreExecute() {
        super.onPreExecute();

    }

    @Override
    protected JSONObject doInBackground(String... args) {
        JSONObject binJson = null;

        String url = args[0];
        String replaceString = args[1];
        BinRequestParser binParser = new BinRequestParser();
        String requestUrl;
        if (!TextUtils.isEmpty(replaceString)) { // replacestring is used for BIN request
            requestUrl = url.replace("######", replaceString);
            // Getting JSON from URL
            binJson = binParser.getJSONFromUrl(requestUrl);
        } else { // This is flash config url
            // If Flash config is already downloaded, read from file else fetch from server.
            if (FileStorage.fileExists(mContext)) {
                Log.d("BinRequest", "Found file");
                String flashConfigData = FileStorage.readFile(mContext);
                try {
                    binJson = new JSONObject(flashConfigData);
                    Log.d("BinRequest", "binJson data : " + binJson);
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            } else {
                Log.d("BinRequest", "Fetching from server " + url);
                requestUrl = url;
                // Fetch from server.
                binJson = binParser.getJSONFromUrl(requestUrl);
            }
        }

        return binJson;
    }

    @Override
    protected void onPostExecute(JSONObject json) {
        if (json != null) {
            binResponseCallback.success(json);
        } else {
            binResponseCallback.error();
        }
    }

}