ace.define("ace/mode/crystal_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(s,m,b){"use strict";var v=s("../lib/oop"),x=s("./text_highlight_rules").TextHighlightRules,u=function(){var t=this.$keywords=this.createKeywordMapper({keyword:"if|end|else|elsif|unless|case|when|break|while|next|until|def|return|class|new|getter|setter|property|lib|fun|do|struct|private|protected|public|module|super|abstract|include|extend|begin|enum|raise|yield|with|alias|rescue|ensure|macro|uninitialized|union|type|require","constant.language":"true|TRUE|false|FALSE|nil|NIL|__LINE__|__END_LINE__|__FILE__|__DIR__","variable.language":"$DEBUG|$defout|$FILENAME|$LOAD_PATH|$SAFE|$stdin|$stdout|$stderr|$VERBOSE|root_url|flash|session|cookies|params|request|response|logger|self","support.function":"puts|initialize|previous_def|typeof|as|pointerof|sizeof|instance_sizeof"},"identifier"),i=/\\(?:[nsrtvfbae'"\\]|[0-7]{3}|x[\da-fA-F]{2}|u[\da-fA-F]{4}|u{[\da-fA-F]{1,6}}|u{(:?[\da-fA-F]{2}\s)*[\da-fA-F]{2}})/;this.$rules={start:[{token:"comment",regex:"#.*$"},{token:"string.regexp",regex:"[/]",push:[{token:"constant.language.escape",regex:i},{token:"string.regexp",regex:"[/][imx]*(?=[).,;\\s]|$)",next:"pop"},{defaultToken:"string.regexp"}]},[{regex:"[{}]",onMatch:function(c,k,h){return this.next="{"==c?this.nextState:"","{"==c&&h.length?(h.unshift("start",k),"paren.lparen"):"}"==c&&h.length&&(h.shift(),this.next=h.shift(),-1!=this.next.indexOf("string"))?"paren.end":"{"==c?"paren.lparen":"paren.rparen"},nextState:"start"},{token:"string.start",regex:/"/,push:[{token:"constant.language.escape",regex:i},{token:"string",regex:/\\#{/},{token:"paren.start",regex:/#{/,push:"start"},{token:"string.end",regex:/"/,next:"pop"},{defaultToken:"string"}]},{token:"string.start",regex:/`/,push:[{token:"constant.language.escape",regex:i},{token:"string",regex:/\\#{/},{token:"paren.start",regex:/#{/,push:"start"},{token:"string.end",regex:/`/,next:"pop"},{defaultToken:"string"}]},{stateName:"rpstring",token:"string.start",regex:/%[Qx]?\(/,push:[{token:"constant.language.escape",regex:i},{token:"string.start",regex:/\(/,push:"rpstring"},{token:"string.end",regex:/\)/,next:"pop"},{token:"paren.start",regex:/#{/,push:"start"},{defaultToken:"string"}]},{stateName:"spstring",token:"string.start",regex:/%[Qx]?\[/,push:[{token:"constant.language.escape",regex:i},{token:"string.start",regex:/\[/,push:"spstring"},{token:"string.end",regex:/]/,next:"pop"},{token:"paren.start",regex:/#{/,push:"start"},{defaultToken:"string"}]},{stateName:"fpstring",token:"string.start",regex:/%[Qx]?{/,push:[{token:"constant.language.escape",regex:i},{token:"string.start",regex:/{/,push:"fpstring"},{token:"string.end",regex:/}/,next:"pop"},{token:"paren.start",regex:/#{/,push:"start"},{defaultToken:"string"}]},{stateName:"tpstring",token:"string.start",regex:/%[Qx]?</,push:[{token:"constant.language.escape",regex:i},{token:"string.start",regex:/</,push:"tpstring"},{token:"string.end",regex:/>/,next:"pop"},{token:"paren.start",regex:/#{/,push:"start"},{defaultToken:"string"}]},{stateName:"ppstring",token:"string.start",regex:/%[Qx]?\|/,push:[{token:"constant.language.escape",regex:i},{token:"string.end",regex:/\|/,next:"pop"},{token:"paren.start",regex:/#{/,push:"start"},{defaultToken:"string"}]},{stateName:"rpqstring",token:"string.start",regex:/%[qwir]\(/,push:[{token:"string.start",regex:/\(/,push:"rpqstring"},{token:"string.end",regex:/\)/,next:"pop"},{defaultToken:"string"}]},{stateName:"spqstring",token:"string.start",regex:/%[qwir]\[/,push:[{token:"string.start",regex:/\[/,push:"spqstring"},{token:"string.end",regex:/]/,next:"pop"},{defaultToken:"string"}]},{stateName:"fpqstring",token:"string.start",regex:/%[qwir]{/,push:[{token:"string.start",regex:/{/,push:"fpqstring"},{token:"string.end",regex:/}/,next:"pop"},{defaultToken:"string"}]},{stateName:"tpqstring",token:"string.start",regex:/%[qwir]</,push:[{token:"string.start",regex:/</,push:"tpqstring"},{token:"string.end",regex:/>/,next:"pop"},{defaultToken:"string"}]},{stateName:"ppqstring",token:"string.start",regex:/%[qwir]\|/,push:[{token:"string.end",regex:/\|/,next:"pop"},{defaultToken:"string"}]},{token:"string.start",regex:/'/,push:[{token:"constant.language.escape",regex:/\\(?:[nsrtvfbae'"\\]|[0-7]{3}|x[\da-fA-F]{2}|u[\da-fA-F]{4}|u{[\da-fA-F]{1,6}})/},{token:"string.end",regex:/'|$/,next:"pop"},{defaultToken:"string"}]}],{token:"text",regex:"::"},{token:"variable.instance",regex:"@{1,2}[a-zA-Z_\\d]+"},{token:"variable.fresh",regex:"%[a-zA-Z_\\d]+"},{token:"support.class",regex:"[A-Z][a-zA-Z_\\d]+"},{token:"constant.other.symbol",regex:"[:](?:(?:===|<=>|\\[]\\?|\\[]=|\\[]|>>|\\*\\*|<<|==|!=|>=|<=|!~|=~|<|\\+|-|\\*|\\/|%|&|\\||\\^|>|!|~)|(?:(?:[A-Za-z_]|[@$](?=[a-zA-Z0-9_]))[a-zA-Z0-9_]*[!=?]?))"},{token:"constant.numeric",regex:"[+-]?\\d(?:\\d|_(?=\\d))*(?:(?:\\.\\d(?:\\d|_(?=\\d))*)?(?:[eE][+-]?\\d+)?)?(?:_?[fF](?:32|64))?\\b"},{token:"constant.numeric",regex:"(?:[+-]?)(?:(?:0[xX][\\dA-Fa-f]+)|(?:[0-9][\\d_]*)|(?:0o[0-7][0-7]*)|(?:0[bB][01]+))(?:_?[iIuU](?:8|16|32|64))?\\b"},{token:"constant.other.symbol",regex:':"',push:[{token:"constant.language.escape",regex:i},{token:"constant.other.symbol",regex:'"',next:"pop"},{defaultToken:"constant.other.symbol"}]},{token:"constant.language.boolean",regex:"(?:true|false)\\b"},{token:"support.function",regex:"(?:is_a\\?|nil\\?|responds_to\\?|as\\?)"},{token:t,regex:"[a-zA-Z_$][a-zA-Z0-9_$!?]*\\b"},{token:"variable.system",regex:"\\$\\!|\\$\\?"},{token:"punctuation.separator.key-value",regex:"=>"},{stateName:"heredoc",onMatch:function(c,k,h){var _=c.split(this.splitRegex);return h.push("heredoc",_[3]),[{type:"constant",value:_[1]},{type:"string",value:_[2]},{type:"support.class",value:_[3]},{type:"string",value:_[4]}]},regex:"(<<-)([']?)([\\w]+)([']?)",rules:{heredoc:[{token:"string",regex:"^ +"},{onMatch:function(c,k,h){return c===h[1]?(h.shift(),h.shift(),this.next=h[0]||"start","support.class"):(this.next="","string")},regex:".*$",next:"start"}]}},{regex:"$",token:"empty",next:function(c,k){return"heredoc"===k[0]?k[0]:c}},{token:"punctuation.operator",regex:/[.]\s*(?![.])/,push:[{token:"punctuation.operator",regex:/[.]\s*(?![.])/},{token:"support.function",regex:"[a-zA-Z_$][a-zA-Z0-9_$]*\\b"},{regex:"",token:"empty",next:"pop"}]},{token:"keyword.operator",regex:"!|\\$|%|&|\\*|\\-\\-|\\-|\\+\\+|\\+|~|===|==|=|!=|!==|<=|>=|<<=|>>=|>>>=|<>|<|>|!|\\?|\\:|&&|\\|\\||\\?\\:|\\*=|%=|\\+=|\\-=|&=|\\^=|\\^|\\|"},{token:"punctuation.operator",regex:/[?:,;.]/},{token:"paren.lparen",regex:"[[({]"},{token:"paren.rparen",regex:"[\\])}]"},{token:"text",regex:"\\s+"}]},this.normalizeRules()};v.inherits(u,x),m.CrystalHighlightRules=u}),ace.define("ace/mode/matching_brace_outdent",["require","exports","module","ace/range"],function(s,m,b){"use strict";var v=s("../range").Range,x=function(){};(function(){this.checkOutdent=function(u,l){return!!/^\s+$/.test(u)&&/^\s*\}/.test(l)},this.autoOutdent=function(u,l){var p=u.getLine(l).match(/^(\s*\})/);if(!p)return 0;var n=p[1].length,t=u.findMatchingBracket({row:l,column:n});if(!t||t.row==l)return 0;var e=this.$getIndent(u.getLine(t.row));u.replace(new v(l,0,l,n-1),e)},this.$getIndent=function(u){return u.match(/^\s*/)[0]}}).call(x.prototype),m.MatchingBraceOutdent=x}),ace.define("ace/mode/folding/coffee",["require","exports","module","ace/lib/oop","ace/mode/folding/fold_mode","ace/range"],function(s,m,b){"use strict";var v=s("../../lib/oop"),x=s("./fold_mode").FoldMode,u=s("../../range").Range,l=m.FoldMode=function(){};v.inherits(l,x),function(){this.commentBlock=function(r,p){var n=/\S/,t=r.getLine(p),e=t.search(n);if(-1!=e&&"#"==t[e]){for(var o=t.length,d=r.getLength(),a=p,g=p;++p<d;){var f=(t=r.getLine(p)).search(n);if(-1!=f){if("#"!=t[f])break;g=p}}if(g>a){var i=r.getLine(g).length;return new u(a,o,g,i)}}},this.getFoldWidgetRange=function(r,p,n){var t=this.indentationBlock(r,n);if(t||(t=this.commentBlock(r,n)))return t},this.getFoldWidget=function(r,p,n){var t=r.getLine(n),e=t.search(/\S/),o=r.getLine(n+1),d=r.getLine(n-1),a=d.search(/\S/),g=o.search(/\S/);if(-1==e)return r.foldWidgets[n-1]=-1!=a&&a<g?"start":"","";if(-1==a){if(e==g&&"#"==t[e]&&"#"==o[e])return r.foldWidgets[n-1]="",r.foldWidgets[n+1]="","start"}else if(a==e&&"#"==t[e]&&"#"==d[e]&&-1==r.getLine(n-2).search(/\S/))return r.foldWidgets[n-1]="start",r.foldWidgets[n+1]="","";return r.foldWidgets[n-1]=-1!=a&&a<e?"start":"",e<g?"start":""}}.call(l.prototype)}),ace.define("ace/mode/crystal",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/crystal_highlight_rules","ace/mode/matching_brace_outdent","ace/range","ace/mode/folding/coffee"],function(s,m,b){"use strict";var v=s("../lib/oop"),x=s("./text").Mode,u=s("./crystal_highlight_rules").CrystalHighlightRules,l=s("./matching_brace_outdent").MatchingBraceOutdent,r=s("../range").Range,p=s("./folding/coffee").FoldMode,n=function(){this.HighlightRules=u,this.$outdent=new l,this.$behaviour=this.$defaultBehaviour,this.foldingRules=new p};v.inherits(n,x),function(){this.lineCommentStart="#",this.getNextLineIndent=function(t,e,o){var d=this.$getIndent(e),g=this.getTokenizer().getLineTokens(e,t).tokens;if(g.length&&"comment"==g[g.length-1].type)return d;if("start"==t){var f=e.match(/^.*[\{\(\[]\s*$/),i=e.match(/^\s*(class|def|module)\s.*$/),c=e.match(/.*do(\s*|\s+\|.*\|\s*)$/),k=e.match(/^\s*(if|else|when)\s*/);(f||i||c||k)&&(d+=o)}return d},this.checkOutdent=function(t,e,o){return/^\s+(end|else)$/.test(e+o)||this.$outdent.checkOutdent(e,o)},this.autoOutdent=function(t,e,o){var d=e.getLine(o);if(/}/.test(d))return this.$outdent.autoOutdent(e,o);var a=this.$getIndent(d),g=e.getLine(o-1),f=this.$getIndent(g),i=e.getTabString();f.length<=a.length&&a.slice(-i.length)==i&&e.remove(new r(o,a.length-i.length,o,a.length))},this.$id="ace/mode/crystal"}.call(n.prototype),m.Mode=n}),ace.require(["ace/mode/crystal"],function(s){"object"==typeof module&&"object"==typeof exports&&module&&(module.exports=s)});