ace.define("ace/mode/jsdoc_comment_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(u,h,b){"use strict";var f=u("../lib/oop"),p=u("./text_highlight_rules").TextHighlightRules,g=function(){this.$rules={start:[{token:["comment.doc.tag","comment.doc.text","lparen.doc"],regex:"(@(?:param|member|typedef|property|namespace|var|const|callback))(\\s*)({)",push:[{token:"lparen.doc",regex:"{",push:[{include:"doc-syntax"},{token:"rparen.doc",regex:"}|(?=$)",next:"pop"}]},{token:["rparen.doc","text.doc","variable.parameter.doc","lparen.doc","variable.parameter.doc","rparen.doc"],regex:/(})(\s*)(?:([\w=:\/\.]+)|(?:(\[)([\w=:\/\.]+)(\])))/,next:"pop"},{token:"rparen.doc",regex:"}|(?=$)",next:"pop"},{include:"doc-syntax"},{defaultToken:"text.doc"}]},{token:["comment.doc.tag","text.doc","lparen.doc"],regex:"(@(?:returns?|yields|type|this|suppress|public|protected|private|package|modifies|implements|external|exception|throws|enum|define|extends))(\\s*)({)",push:[{token:"lparen.doc",regex:"{",push:[{include:"doc-syntax"},{token:"rparen.doc",regex:"}|(?=$)",next:"pop"}]},{token:"rparen.doc",regex:"}|(?=$)",next:"pop"},{include:"doc-syntax"},{defaultToken:"text.doc"}]},{token:["comment.doc.tag","text.doc","variable.parameter.doc"],regex:'(@(?:alias|memberof|instance|module|name|lends|namespace|external|this|template|requires|param|implements|function|extends|typedef|mixes|constructor|var|memberof\\!|event|listens|exports|class|constructs|interface|emits|fires|throws|const|callback|borrows|augments))(\\s+)(\\w[\\w#.:/~"\\-]*)?'},{token:["comment.doc.tag","text.doc","variable.parameter.doc"],regex:"(@method)(\\s+)(\\w[\\w.\\(\\)]*)"},{token:"comment.doc.tag",regex:"@access\\s+(?:private|public|protected)"},{token:"comment.doc.tag",regex:"@kind\\s+(?:class|constant|event|external|file|function|member|mixin|module|namespace|typedef)"},{token:"comment.doc.tag",regex:"@\\w+(?=\\s|$)"},g.getTagRule(),{defaultToken:"comment.doc",caseInsensitive:!0}],"doc-syntax":[{token:"operator.doc",regex:/[|:]/},{token:"paren.doc",regex:/[\[\]]/}]},this.normalizeRules()};f.inherits(g,p),g.getTagRule=function(s){return{token:"comment.doc.tag.storage.type",regex:"\\b(?:TODO|FIXME|XXX|HACK)\\b"}},g.getStartRule=function(s){return{token:"comment.doc",regex:"\\/\\*(?=\\*)",next:s}},g.getEndRule=function(s){return{token:"comment.doc",regex:"\\*\\/",next:s}},h.JsDocCommentHighlightRules=g}),ace.define("ace/mode/javascript_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/jsdoc_comment_highlight_rules","ace/mode/text_highlight_rules"],function(u,h,b){"use strict";var f=u("../lib/oop"),p=u("./jsdoc_comment_highlight_rules").JsDocCommentHighlightRules,g=u("./text_highlight_rules").TextHighlightRules,s="[a-zA-Z\\$_\xa1-\uffff][a-zA-Z\\d\\$_\xa1-\uffff]*",r=function(c){var i=this.createKeywordMapper({"variable.language":"Array|Boolean|Date|Function|Iterator|Number|Object|RegExp|String|Proxy|Symbol|Namespace|QName|XML|XMLList|ArrayBuffer|Float32Array|Float64Array|Int16Array|Int32Array|Int8Array|Uint16Array|Uint32Array|Uint8Array|Uint8ClampedArray|Error|EvalError|InternalError|RangeError|ReferenceError|StopIteration|SyntaxError|TypeError|URIError|decodeURI|decodeURIComponent|encodeURI|encodeURIComponent|eval|isFinite|isNaN|parseFloat|parseInt|JSON|Math|this|arguments|prototype|window|document",keyword:"const|yield|import|get|set|async|await|break|case|catch|continue|default|delete|do|else|finally|for|function|if|in|of|instanceof|new|return|switch|throw|try|typeof|let|var|while|with|debugger|__parent__|__count__|escape|unescape|with|__proto__|class|enum|extends|super|export|implements|private|public|interface|package|protected|static|constructor","storage.type":"const|let|var|function","constant.language":"null|Infinity|NaN|undefined","support.function":"alert","constant.language.boolean":"true|false"},"identifier"),n="\\\\(?:x[0-9a-fA-F]{2}|u[0-9a-fA-F]{4}|u{[0-9a-fA-F]{1,6}}|[0-2][0-7]{0,2}|3[0-7][0-7]?|[4-7][0-7]?|.)";this.$rules={no_regex:[p.getStartRule("doc-start"),a("no_regex"),{token:"string",regex:"'(?=.)",next:"qstring"},{token:"string",regex:'"(?=.)',next:"qqstring"},{token:"constant.numeric",regex:/0(?:[xX][0-9a-fA-F]+|[oO][0-7]+|[bB][01]+)\b/},{token:"constant.numeric",regex:/(?:\d\d*(?:\.\d*)?|\.\d+)(?:[eE][+-]?\d+\b)?/},{token:["storage.type","punctuation.operator","support.function","punctuation.operator","entity.name.function","text","keyword.operator"],regex:"("+s+")(\\.)(prototype)(\\.)("+s+")(\\s*)(=)",next:"function_arguments"},{token:["storage.type","punctuation.operator","entity.name.function","text","keyword.operator","text","storage.type","text","paren.lparen"],regex:"("+s+")(\\.)("+s+")(\\s*)(=)(\\s*)(function\\*?)(\\s*)(\\()",next:"function_arguments"},{token:["entity.name.function","text","keyword.operator","text","storage.type","text","paren.lparen"],regex:"("+s+")(\\s*)(=)(\\s*)(function\\*?)(\\s*)(\\()",next:"function_arguments"},{token:["storage.type","punctuation.operator","entity.name.function","text","keyword.operator","text","storage.type","text","entity.name.function","text","paren.lparen"],regex:"("+s+")(\\.)("+s+")(\\s*)(=)(\\s*)(function\\*?)(\\s+)(\\w+)(\\s*)(\\()",next:"function_arguments"},{token:["storage.type","text","entity.name.function","text","paren.lparen"],regex:"(function\\*?)(\\s+)("+s+")(\\s*)(\\()",next:"function_arguments"},{token:["entity.name.function","text","punctuation.operator","text","storage.type","text","paren.lparen"],regex:"("+s+")(\\s*)(:)(\\s*)(function\\*?)(\\s*)(\\()",next:"function_arguments"},{token:["text","text","storage.type","text","paren.lparen"],regex:"(:)(\\s*)(function\\*?)(\\s*)(\\()",next:"function_arguments"},{token:"keyword",regex:"from(?=\\s*('|\"))"},{token:"keyword",regex:"(?:case|do|else|finally|in|instanceof|return|throw|try|typeof|yield|void)\\b",next:"start"},{token:"support.constant",regex:/that\b/},{token:["storage.type","punctuation.operator","support.function.firebug"],regex:/(console)(\.)(warn|info|log|error|time|trace|timeEnd|assert)\b/},{token:i,regex:s},{token:"punctuation.operator",regex:/[.](?![.])/,next:"property"},{token:"storage.type",regex:/=>/,next:"start"},{token:"keyword.operator",regex:/--|\+\+|\.{3}|===|==|=|!=|!==|<+=?|>+=?|!|&&|\|\||\?:|[!$%&*+\-~\/^]=?/,next:"start"},{token:"punctuation.operator",regex:/[?:,;.]/,next:"start"},{token:"paren.lparen",regex:/[\[({]/,next:"start"},{token:"paren.rparen",regex:/[\])}]/},{token:"comment",regex:/^#!.*$/}],property:[{token:"text",regex:"\\s+"},{token:["storage.type","punctuation.operator","entity.name.function","text","keyword.operator","text","storage.type","text","entity.name.function","text","paren.lparen"],regex:"("+s+")(\\.)("+s+")(\\s*)(=)(\\s*)(function\\*?)(?:(\\s+)(\\w+))?(\\s*)(\\()",next:"function_arguments"},{token:"punctuation.operator",regex:/[.](?![.])/},{token:"support.function",regex:/(s(?:h(?:ift|ow(?:Mod(?:elessDialog|alDialog)|Help))|croll(?:X|By(?:Pages|Lines)?|Y|To)?|t(?:op|rike)|i(?:n|zeToContent|debar|gnText)|ort|u(?:p|b(?:str(?:ing)?)?)|pli(?:ce|t)|e(?:nd|t(?:Re(?:sizable|questHeader)|M(?:i(?:nutes|lliseconds)|onth)|Seconds|Ho(?:tKeys|urs)|Year|Cursor|Time(?:out)?|Interval|ZOptions|Date|UTC(?:M(?:i(?:nutes|lliseconds)|onth)|Seconds|Hours|Date|FullYear)|FullYear|Active)|arch)|qrt|lice|avePreferences|mall)|h(?:ome|andleEvent)|navigate|c(?:har(?:CodeAt|At)|o(?:s|n(?:cat|textual|firm)|mpile)|eil|lear(?:Timeout|Interval)?|a(?:ptureEvents|ll)|reate(?:StyleSheet|Popup|EventObject))|t(?:o(?:GMTString|S(?:tring|ource)|U(?:TCString|pperCase)|Lo(?:caleString|werCase))|est|a(?:n|int(?:Enabled)?))|i(?:s(?:NaN|Finite)|ndexOf|talics)|d(?:isableExternalCapture|ump|etachEvent)|u(?:n(?:shift|taint|escape|watch)|pdateCommands)|j(?:oin|avaEnabled)|p(?:o(?:p|w)|ush|lugins.refresh|a(?:ddings|rse(?:Int|Float)?)|r(?:int|ompt|eference))|e(?:scape|nableExternalCapture|val|lementFromPoint|x(?:p|ec(?:Script|Command)?))|valueOf|UTC|queryCommand(?:State|Indeterm|Enabled|Value)|f(?:i(?:nd|lter|le(?:ModifiedDate|Size|CreatedDate|UpdatedDate)|xed)|o(?:nt(?:size|color)|rward|rEach)|loor|romCharCode)|watch|l(?:ink|o(?:ad|g)|astIndexOf)|a(?:sin|nchor|cos|t(?:tachEvent|ob|an(?:2)?)|pply|lert|b(?:s|ort))|r(?:ou(?:nd|teEvents)|e(?:size(?:By|To)|calc|turnValue|place|verse|l(?:oad|ease(?:Capture|Events)))|andom)|g(?:o|et(?:ResponseHeader|M(?:i(?:nutes|lliseconds)|onth)|Se(?:conds|lection)|Hours|Year|Time(?:zoneOffset)?|Da(?:y|te)|UTC(?:M(?:i(?:nutes|lliseconds)|onth)|Seconds|Hours|Da(?:y|te)|FullYear)|FullYear|A(?:ttention|llResponseHeaders)))|m(?:in|ove(?:B(?:y|elow)|To(?:Absolute)?|Above)|ergeAttributes|a(?:tch|rgins|x))|b(?:toa|ig|o(?:ld|rderWidths)|link|ack))\b(?=\()/},{token:"support.function.dom",regex:/(s(?:ub(?:stringData|mit)|plitText|e(?:t(?:NamedItem|Attribute(?:Node)?)|lect))|has(?:ChildNodes|Feature)|namedItem|c(?:l(?:ick|o(?:se|neNode))|reate(?:C(?:omment|DATASection|aption)|T(?:Head|extNode|Foot)|DocumentFragment|ProcessingInstruction|E(?:ntityReference|lement)|Attribute))|tabIndex|i(?:nsert(?:Row|Before|Cell|Data)|tem)|open|delete(?:Row|C(?:ell|aption)|T(?:Head|Foot)|Data)|focus|write(?:ln)?|a(?:dd|ppend(?:Child|Data))|re(?:set|place(?:Child|Data)|move(?:NamedItem|Child|Attribute(?:Node)?)?)|get(?:NamedItem|Element(?:sBy(?:Name|TagName|ClassName)|ById)|Attribute(?:Node)?)|blur)\b(?=\()/},{token:"support.constant",regex:/(s(?:ystemLanguage|cr(?:ipts|ollbars|een(?:X|Y|Top|Left))|t(?:yle(?:Sheets)?|atus(?:Text|bar)?)|ibling(?:Below|Above)|ource|uffixes|e(?:curity(?:Policy)?|l(?:ection|f)))|h(?:istory|ost(?:name)?|as(?:h|Focus))|y|X(?:MLDocument|SLDocument)|n(?:ext|ame(?:space(?:s|URI)|Prop))|M(?:IN_VALUE|AX_VALUE)|c(?:haracterSet|o(?:n(?:structor|trollers)|okieEnabled|lorDepth|mp(?:onents|lete))|urrent|puClass|l(?:i(?:p(?:boardData)?|entInformation)|osed|asses)|alle(?:e|r)|rypto)|t(?:o(?:olbar|p)|ext(?:Transform|Indent|Decoration|Align)|ags)|SQRT(?:1_2|2)|i(?:n(?:ner(?:Height|Width)|put)|ds|gnoreCase)|zIndex|o(?:scpu|n(?:readystatechange|Line)|uter(?:Height|Width)|p(?:sProfile|ener)|ffscreenBuffering)|NEGATIVE_INFINITY|d(?:i(?:splay|alog(?:Height|Top|Width|Left|Arguments)|rectories)|e(?:scription|fault(?:Status|Ch(?:ecked|arset)|View)))|u(?:ser(?:Profile|Language|Agent)|n(?:iqueID|defined)|pdateInterval)|_content|p(?:ixelDepth|ort|ersonalbar|kcs11|l(?:ugins|atform)|a(?:thname|dding(?:Right|Bottom|Top|Left)|rent(?:Window|Layer)?|ge(?:X(?:Offset)?|Y(?:Offset)?))|r(?:o(?:to(?:col|type)|duct(?:Sub)?|mpter)|e(?:vious|fix)))|e(?:n(?:coding|abledPlugin)|x(?:ternal|pando)|mbeds)|v(?:isibility|endor(?:Sub)?|Linkcolor)|URLUnencoded|P(?:I|OSITIVE_INFINITY)|f(?:ilename|o(?:nt(?:Size|Family|Weight)|rmName)|rame(?:s|Element)|gColor)|E|whiteSpace|l(?:i(?:stStyleType|n(?:eHeight|kColor))|o(?:ca(?:tion(?:bar)?|lName)|wsrc)|e(?:ngth|ft(?:Context)?)|a(?:st(?:M(?:odified|atch)|Index|Paren)|yer(?:s|X)|nguage))|a(?:pp(?:MinorVersion|Name|Co(?:deName|re)|Version)|vail(?:Height|Top|Width|Left)|ll|r(?:ity|guments)|Linkcolor|bove)|r(?:ight(?:Context)?|e(?:sponse(?:XML|Text)|adyState))|global|x|m(?:imeTypes|ultiline|enubar|argin(?:Right|Bottom|Top|Left))|L(?:N(?:10|2)|OG(?:10E|2E))|b(?:o(?:ttom|rder(?:Width|RightWidth|BottomWidth|Style|Color|TopWidth|LeftWidth))|ufferDepth|elow|ackground(?:Color|Image)))\b/},{token:"identifier",regex:s},{regex:"",token:"empty",next:"no_regex"}],start:[p.getStartRule("doc-start"),a("start"),{token:"string.regexp",regex:"\\/",next:"regex"},{token:"text",regex:"\\s+|^$",next:"start"},{token:"empty",regex:"",next:"no_regex"}],regex:[{token:"regexp.keyword.operator",regex:"\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"},{token:"string.regexp",regex:"/[sxngimy]*",next:"no_regex"},{token:"invalid",regex:/\{\d+\b,?\d*\}[+*]|[+*$^?][+*]|[$^][?]|\?{3,}/},{token:"constant.language.escape",regex:/\(\?[:=!]|\)|\{\d+\b,?\d*\}|[+*]\?|[()$^+*?.]/},{token:"constant.language.delimiter",regex:/\|/},{token:"constant.language.escape",regex:/\[\^?/,next:"regex_character_class"},{token:"empty",regex:"$",next:"no_regex"},{defaultToken:"string.regexp"}],regex_character_class:[{token:"regexp.charclass.keyword.operator",regex:"\\\\(?:u[\\da-fA-F]{4}|x[\\da-fA-F]{2}|.)"},{token:"constant.language.escape",regex:"]",next:"regex"},{token:"constant.language.escape",regex:"-"},{token:"empty",regex:"$",next:"no_regex"},{defaultToken:"string.regexp.charachterclass"}],default_parameter:[{token:"string",regex:"'(?=.)",push:[{token:"string",regex:"'|$",next:"pop"},{include:"qstring"}]},{token:"string",regex:'"(?=.)',push:[{token:"string",regex:'"|$',next:"pop"},{include:"qqstring"}]},{token:"constant.language",regex:"null|Infinity|NaN|undefined"},{token:"constant.numeric",regex:/0(?:[xX][0-9a-fA-F]+|[oO][0-7]+|[bB][01]+)\b/},{token:"constant.numeric",regex:/(?:\d\d*(?:\.\d*)?|\.\d+)(?:[eE][+-]?\d+\b)?/},{token:"punctuation.operator",regex:",",next:"function_arguments"},{token:"text",regex:"\\s+"},{token:"punctuation.operator",regex:"$"},{token:"empty",regex:"",next:"no_regex"}],function_arguments:[a("function_arguments"),{token:"variable.parameter",regex:s},{token:"punctuation.operator",regex:","},{token:"text",regex:"\\s+"},{token:"punctuation.operator",regex:"$"},{token:"empty",regex:"",next:"no_regex"}],qqstring:[{token:"constant.language.escape",regex:n},{token:"string",regex:"\\\\$",consumeLineEnd:!0},{token:"string",regex:'"|$',next:"no_regex"},{defaultToken:"string"}],qstring:[{token:"constant.language.escape",regex:n},{token:"string",regex:"\\\\$",consumeLineEnd:!0},{token:"string",regex:"'|$",next:"no_regex"},{defaultToken:"string"}]},(!c||!c.noES6)&&(this.$rules.no_regex.unshift({regex:"[{}]",onMatch:function(e,o,l){if(this.next="{"==e?this.nextState:"","{"==e&&l.length)l.unshift("start",o);else if("}"==e&&l.length&&(l.shift(),this.next=l.shift(),-1!=this.next.indexOf("string")||-1!=this.next.indexOf("jsx")))return"paren.quasi.end";return"{"==e?"paren.lparen":"paren.rparen"},nextState:"start"},{token:"string.quasi.start",regex:/`/,push:[{token:"constant.language.escape",regex:n},{token:"paren.quasi.start",regex:/\${/,push:"start"},{token:"string.quasi.end",regex:/`/,next:"pop"},{defaultToken:"string.quasi"}]},{token:["variable.parameter","text"],regex:"("+s+")(\\s*)(?=\\=>)"},{token:"paren.lparen",regex:"(\\()(?=.+\\s*=>)",next:"function_arguments"},{token:"variable.language",regex:"(?:(?:(?:Weak)?(?:Set|Map))|Promise)\\b"}),this.$rules.function_arguments.unshift({token:"keyword.operator",regex:"=",next:"default_parameter"},{token:"keyword.operator",regex:"\\.{3}"}),this.$rules.property.unshift({token:"support.function",regex:"(findIndex|repeat|startsWith|endsWith|includes|isSafeInteger|trunc|cbrt|log2|log10|sign|then|catch|finally|resolve|reject|race|any|all|allSettled|keys|entries|isInteger)\\b(?=\\()"},{token:"constant.language",regex:"(?:MAX_SAFE_INTEGER|MIN_SAFE_INTEGER|EPSILON)\\b"}),(!c||0!=c.jsx)&&d.call(this)),this.embedRules(p,"doc-",[p.getEndRule("no_regex")]),this.normalizeRules()};function d(){var c=s.replace("\\d","\\d\\-"),i={onMatch:function(n,e,o){var l="/"==n.charAt(1)?2:1;return 1==l?(e!=this.nextState?o.unshift(this.next,this.nextState,0):o.unshift(this.next),o[2]++):2==l&&e==this.nextState&&(o[1]--,(!o[1]||o[1]<0)&&(o.shift(),o.shift())),[{type:"meta.tag.punctuation."+(1==l?"":"end-")+"tag-open.xml",value:n.slice(0,l)},{type:"meta.tag.tag-name.xml",value:n.substr(l)}]},regex:"</?"+c,next:"jsxAttributes",nextState:"jsx"};this.$rules.start.unshift(i);var t={regex:"{",token:"paren.quasi.start",push:"start"};this.$rules.jsx=[t,i,{include:"reference"},{defaultToken:"string"}],this.$rules.jsxAttributes=[{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",onMatch:function(n,e,o){return e==o[0]&&o.shift(),2==n.length&&(o[0]==this.nextState&&o[1]--,(!o[1]||o[1]<0)&&o.splice(0,2)),this.next=o[0]||"start",[{type:this.token,value:n}]},nextState:"jsx"},t,a("jsxAttributes"),{token:"entity.other.attribute-name.xml",regex:c},{token:"keyword.operator.attribute-equals.xml",regex:"="},{token:"text.tag-whitespace.xml",regex:"\\s+"},{token:"string.attribute-value.xml",regex:"'",stateName:"jsx_attr_q",push:[{token:"string.attribute-value.xml",regex:"'",next:"pop"},{include:"reference"},{defaultToken:"string.attribute-value.xml"}]},{token:"string.attribute-value.xml",regex:'"',stateName:"jsx_attr_qq",push:[{token:"string.attribute-value.xml",regex:'"',next:"pop"},{include:"reference"},{defaultToken:"string.attribute-value.xml"}]},i],this.$rules.reference=[{token:"constant.language.escape.reference.xml",regex:"(?:&#[0-9]+;)|(?:&#x[0-9a-fA-F]+;)|(?:&[a-zA-Z0-9_:\\.-]+;)"}]}function a(c){return[{token:"comment",regex:/\/\*/,next:[p.getTagRule(),{token:"comment",regex:"\\*\\/",next:c||"pop"},{defaultToken:"comment",caseInsensitive:!0}]},{token:"comment",regex:"\\/\\/",next:[p.getTagRule(),{token:"comment",regex:"$|^",next:c||"pop"},{defaultToken:"comment",caseInsensitive:!0}]}]}f.inherits(r,g),h.JavaScriptHighlightRules=r}),ace.define("ace/mode/matching_brace_outdent",["require","exports","module","ace/range"],function(u,h,b){"use strict";var f=u("../range").Range,p=function(){};(function(){this.checkOutdent=function(g,s){return!!/^\s+$/.test(g)&&/^\s*\}/.test(s)},this.autoOutdent=function(g,s){var d=g.getLine(s).match(/^(\s*\})/);if(!d)return 0;var a=d[1].length,c=g.findMatchingBracket({row:s,column:a});if(!c||c.row==s)return 0;var i=this.$getIndent(g.getLine(c.row));g.replace(new f(s,0,s,a-1),i)},this.$getIndent=function(g){return g.match(/^\s*/)[0]}}).call(p.prototype),h.MatchingBraceOutdent=p}),ace.define("ace/mode/folding/cstyle",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],function(u,h,b){"use strict";var f=u("../../lib/oop"),p=u("../../range").Range,g=u("./fold_mode").FoldMode,s=h.FoldMode=function(r){r&&(this.foldingStartMarker=new RegExp(this.foldingStartMarker.source.replace(/\|[^|]*?$/,"|"+r.start)),this.foldingStopMarker=new RegExp(this.foldingStopMarker.source.replace(/\|[^|]*?$/,"|"+r.end)))};f.inherits(s,g),function(){this.foldingStartMarker=/([\{\[\(])[^\}\]\)]*$|^\s*(\/\*)/,this.foldingStopMarker=/^[^\[\{\(]*([\}\]\)])|^[\s\*]*(\*\/)/,this.singleLineBlockCommentRe=/^\s*(\/\*).*\*\/\s*$/,this.tripleStarBlockCommentRe=/^\s*(\/\*\*\*).*\*\/\s*$/,this.startRegionRe=/^\s*(\/\*|\/\/)#?region\b/,this._getFoldWidgetBase=this.getFoldWidget,this.getFoldWidget=function(r,d,a){var c=r.getLine(a);if(this.singleLineBlockCommentRe.test(c)&&!this.startRegionRe.test(c)&&!this.tripleStarBlockCommentRe.test(c))return"";var i=this._getFoldWidgetBase(r,d,a);return!i&&this.startRegionRe.test(c)?"start":i},this.getFoldWidgetRange=function(r,d,a,c){var e,i=r.getLine(a);if(this.startRegionRe.test(i))return this.getCommentRegionBlock(r,i,a);if(e=i.match(this.foldingStartMarker)){var t=e.index;if(e[1])return this.openingBracketBlock(r,e[1],a,t);var n=r.getCommentFoldRange(a,t+e[0].length,1);return n&&!n.isMultiLine()&&(c?n=this.getSectionRange(r,a):"all"!=d&&(n=null)),n}return"markbegin"!==d&&(e=i.match(this.foldingStopMarker))?(t=e.index+e[0].length,e[1]?this.closingBracketBlock(r,e[1],a,t):r.getCommentFoldRange(a,t,-1)):void 0},this.getSectionRange=function(r,d){for(var a=r.getLine(d),c=a.search(/\S/),i=d,t=a.length,n=d+=1,e=r.getLength();++d<e;){var o=(a=r.getLine(d)).search(/\S/);if(-1!==o){if(c>o)break;var l=this.getFoldWidgetRange(r,"all",d);if(l){if(l.start.row<=i)break;if(l.isMultiLine())d=l.end.row;else if(c==o)break}n=d}}return new p(i,t,n,r.getLine(n).length)},this.getCommentRegionBlock=function(r,d,a){for(var c=d.search(/\s*$/),i=r.getLength(),t=a,n=/^\s*(?:\/\*|\/\/|--)#?(end)?region\b/,e=1;++a<i;){d=r.getLine(a);var o=n.exec(d);if(o&&(o[1]?e--:e++,!e))break}if(a>t)return new p(t,c,a,d.length)}}.call(s.prototype)}),ace.define("ace/mode/javascript",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/javascript_highlight_rules","ace/mode/matching_brace_outdent","ace/worker/worker_client","ace/mode/behaviour/cstyle","ace/mode/folding/cstyle"],function(u,h,b){"use strict";var f=u("../lib/oop"),p=u("./text").Mode,g=u("./javascript_highlight_rules").JavaScriptHighlightRules,s=u("./matching_brace_outdent").MatchingBraceOutdent,r=u("../worker/worker_client").WorkerClient,d=u("./behaviour/cstyle").CstyleBehaviour,a=u("./folding/cstyle").FoldMode,c=function(){this.HighlightRules=g,this.$outdent=new s,this.$behaviour=new d,this.foldingRules=new a};f.inherits(c,p),function(){this.lineCommentStart="//",this.blockComment={start:"/*",end:"*/"},this.$quotes={'"':'"',"'":"'","`":"`"},this.$pairQuotesAfter={"`":/\w/},this.getNextLineIndent=function(i,t,n){var e=this.$getIndent(t),o=this.getTokenizer().getLineTokens(t,i),l=o.tokens,m=o.state;if(l.length&&"comment"==l[l.length-1].type)return e;if("start"==i||"no_regex"==i)(x=t.match(/^.*(?:\bcase\b.*:|[\{\(\[])\s*$/))&&(e+=n);else if("doc-start"==i){if("start"==m||"no_regex"==m)return"";var x;(x=t.match(/^\s*(\/?)\*/))&&(x[1]&&(e+=" "),e+="* ")}return e},this.checkOutdent=function(i,t,n){return this.$outdent.checkOutdent(t,n)},this.autoOutdent=function(i,t,n){this.$outdent.autoOutdent(t,n)},this.createWorker=function(i){var t=new r(["ace"],"ace/mode/javascript_worker","JavaScriptWorker");return t.attachToDocument(i.getDocument()),t.on("annotate",function(n){i.setAnnotations(n.data)}),t.on("terminate",function(){i.clearAnnotations()}),t},this.$id="ace/mode/javascript",this.snippetFileId="ace/snippets/javascript"}.call(c.prototype),h.Mode=c}),ace.define("ace/mode/css_highlight_rules",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/text_highlight_rules"],function(u,h,b){"use strict";var f=u("../lib/oop"),g=(u("../lib/lang"),u("./text_highlight_rules").TextHighlightRules),s=h.supportType="align-content|align-items|align-self|all|animation|animation-delay|animation-direction|animation-duration|animation-fill-mode|animation-iteration-count|animation-name|animation-play-state|animation-timing-function|backface-visibility|background|background-attachment|background-blend-mode|background-clip|background-color|background-image|background-origin|background-position|background-repeat|background-size|border|border-bottom|border-bottom-color|border-bottom-left-radius|border-bottom-right-radius|border-bottom-style|border-bottom-width|border-collapse|border-color|border-image|border-image-outset|border-image-repeat|border-image-slice|border-image-source|border-image-width|border-left|border-left-color|border-left-style|border-left-width|border-radius|border-right|border-right-color|border-right-style|border-right-width|border-spacing|border-style|border-top|border-top-color|border-top-left-radius|border-top-right-radius|border-top-style|border-top-width|border-width|bottom|box-shadow|box-sizing|caption-side|clear|clip|color|column-count|column-fill|column-gap|column-rule|column-rule-color|column-rule-style|column-rule-width|column-span|column-width|columns|content|counter-increment|counter-reset|cursor|direction|display|empty-cells|filter|flex|flex-basis|flex-direction|flex-flow|flex-grow|flex-shrink|flex-wrap|float|font|font-family|font-size|font-size-adjust|font-stretch|font-style|font-variant|font-weight|hanging-punctuation|height|justify-content|left|letter-spacing|line-height|list-style|list-style-image|list-style-position|list-style-type|margin|margin-bottom|margin-left|margin-right|margin-top|max-height|max-width|max-zoom|min-height|min-width|min-zoom|nav-down|nav-index|nav-left|nav-right|nav-up|opacity|order|outline|outline-color|outline-offset|outline-style|outline-width|overflow|overflow-x|overflow-y|padding|padding-bottom|padding-left|padding-right|padding-top|page-break-after|page-break-before|page-break-inside|perspective|perspective-origin|position|quotes|resize|right|tab-size|table-layout|text-align|text-align-last|text-decoration|text-decoration-color|text-decoration-line|text-decoration-style|text-indent|text-justify|text-overflow|text-shadow|text-transform|top|transform|transform-origin|transform-style|transition|transition-delay|transition-duration|transition-property|transition-timing-function|unicode-bidi|user-select|user-zoom|vertical-align|visibility|white-space|width|word-break|word-spacing|word-wrap|z-index",r=h.supportFunction="rgb|rgba|url|attr|counter|counters",d=h.supportConstant="absolute|after-edge|after|all-scroll|all|alphabetic|always|antialiased|armenian|auto|avoid-column|avoid-page|avoid|balance|baseline|before-edge|before|below|bidi-override|block-line-height|block|bold|bolder|border-box|both|bottom|box|break-all|break-word|capitalize|caps-height|caption|center|central|char|circle|cjk-ideographic|clone|close-quote|col-resize|collapse|column|consider-shifts|contain|content-box|cover|crosshair|cubic-bezier|dashed|decimal-leading-zero|decimal|default|disabled|disc|disregard-shifts|distribute-all-lines|distribute-letter|distribute-space|distribute|dotted|double|e-resize|ease-in|ease-in-out|ease-out|ease|ellipsis|end|exclude-ruby|flex-end|flex-start|fill|fixed|georgian|glyphs|grid-height|groove|hand|hanging|hebrew|help|hidden|hiragana-iroha|hiragana|horizontal|icon|ideograph-alpha|ideograph-numeric|ideograph-parenthesis|ideograph-space|ideographic|inactive|include-ruby|inherit|initial|inline-block|inline-box|inline-line-height|inline-table|inline|inset|inside|inter-ideograph|inter-word|invert|italic|justify|katakana-iroha|katakana|keep-all|last|left|lighter|line-edge|line-through|line|linear|list-item|local|loose|lower-alpha|lower-greek|lower-latin|lower-roman|lowercase|lr-tb|ltr|mathematical|max-height|max-size|medium|menu|message-box|middle|move|n-resize|ne-resize|newspaper|no-change|no-close-quote|no-drop|no-open-quote|no-repeat|none|normal|not-allowed|nowrap|nw-resize|oblique|open-quote|outset|outside|overline|padding-box|page|pointer|pre-line|pre-wrap|pre|preserve-3d|progress|relative|repeat-x|repeat-y|repeat|replaced|reset-size|ridge|right|round|row-resize|rtl|s-resize|scroll|se-resize|separate|slice|small-caps|small-caption|solid|space|square|start|static|status-bar|step-end|step-start|steps|stretch|strict|sub|super|sw-resize|table-caption|table-cell|table-column-group|table-column|table-footer-group|table-header-group|table-row-group|table-row|table|tb-rl|text-after-edge|text-before-edge|text-bottom|text-size|text-top|text|thick|thin|transparent|underline|upper-alpha|upper-latin|upper-roman|uppercase|use-script|vertical-ideographic|vertical-text|visible|w-resize|wait|whitespace|z-index|zero|zoom",a=h.supportConstantColor="aliceblue|antiquewhite|aqua|aquamarine|azure|beige|bisque|black|blanchedalmond|blue|blueviolet|brown|burlywood|cadetblue|chartreuse|chocolate|coral|cornflowerblue|cornsilk|crimson|cyan|darkblue|darkcyan|darkgoldenrod|darkgray|darkgreen|darkgrey|darkkhaki|darkmagenta|darkolivegreen|darkorange|darkorchid|darkred|darksalmon|darkseagreen|darkslateblue|darkslategray|darkslategrey|darkturquoise|darkviolet|deeppink|deepskyblue|dimgray|dimgrey|dodgerblue|firebrick|floralwhite|forestgreen|fuchsia|gainsboro|ghostwhite|gold|goldenrod|gray|green|greenyellow|grey|honeydew|hotpink|indianred|indigo|ivory|khaki|lavender|lavenderblush|lawngreen|lemonchiffon|lightblue|lightcoral|lightcyan|lightgoldenrodyellow|lightgray|lightgreen|lightgrey|lightpink|lightsalmon|lightseagreen|lightskyblue|lightslategray|lightslategrey|lightsteelblue|lightyellow|lime|limegreen|linen|magenta|maroon|mediumaquamarine|mediumblue|mediumorchid|mediumpurple|mediumseagreen|mediumslateblue|mediumspringgreen|mediumturquoise|mediumvioletred|midnightblue|mintcream|mistyrose|moccasin|navajowhite|navy|oldlace|olive|olivedrab|orange|orangered|orchid|palegoldenrod|palegreen|paleturquoise|palevioletred|papayawhip|peachpuff|peru|pink|plum|powderblue|purple|rebeccapurple|red|rosybrown|royalblue|saddlebrown|salmon|sandybrown|seagreen|seashell|sienna|silver|skyblue|slateblue|slategray|slategrey|snow|springgreen|steelblue|tan|teal|thistle|tomato|turquoise|violet|wheat|white|whitesmoke|yellow|yellowgreen",c=h.supportConstantFonts="arial|century|comic|courier|cursive|fantasy|garamond|georgia|helvetica|impact|lucida|symbol|system|tahoma|times|trebuchet|utopia|verdana|webdings|sans-serif|serif|monospace",i=h.numRe="\\-?(?:(?:[0-9]+(?:\\.[0-9]+)?)|(?:\\.[0-9]+))",t=h.pseudoElements="(\\:+)\\b(after|before|first-letter|first-line|moz-selection|selection)\\b",n=h.pseudoClasses="(:)\\b(active|checked|disabled|empty|enabled|first-child|first-of-type|focus|hover|indeterminate|invalid|last-child|last-of-type|link|not|nth-child|nth-last-child|nth-last-of-type|nth-of-type|only-child|only-of-type|required|root|target|valid|visited)\\b",e=function(){var o=this.createKeywordMapper({"support.function":r,"support.constant":d,"support.type":s,"support.constant.color":a,"support.constant.fonts":c},"text",!0);this.$rules={start:[{include:["strings","url","comments"]},{token:"paren.lparen",regex:"\\{",next:"ruleset"},{token:"paren.rparen",regex:"\\}"},{token:"string",regex:"@(?!viewport)",next:"media"},{token:"keyword",regex:"#[a-z0-9-_]+"},{token:"keyword",regex:"%"},{token:"variable",regex:"\\.[a-z0-9-_]+"},{token:"string",regex:":[a-z0-9-_]+"},{token:"constant.numeric",regex:i},{token:"constant",regex:"[a-z0-9-_]+"},{caseInsensitive:!0}],media:[{include:["strings","url","comments"]},{token:"paren.lparen",regex:"\\{",next:"start"},{token:"paren.rparen",regex:"\\}",next:"start"},{token:"string",regex:";",next:"start"},{token:"keyword",regex:"(?:media|supports|document|charset|import|namespace|media|supports|document|page|font|keyframes|viewport|counter-style|font-feature-values|swash|ornaments|annotation|stylistic|styleset|character-variant)"}],comments:[{token:"comment",regex:"\\/\\*",push:[{token:"comment",regex:"\\*\\/",next:"pop"},{defaultToken:"comment"}]}],ruleset:[{regex:"-(webkit|ms|moz|o)-",token:"text"},{token:"punctuation.operator",regex:"[:;]"},{token:"paren.rparen",regex:"\\}",next:"start"},{include:["strings","url","comments"]},{token:["constant.numeric","keyword"],regex:"("+i+")(ch|cm|deg|em|ex|fr|gd|grad|Hz|in|kHz|mm|ms|pc|pt|px|rad|rem|s|turn|vh|vmax|vmin|vm|vw|%)"},{token:"constant.numeric",regex:i},{token:"constant.numeric",regex:"#[a-f0-9]{6}"},{token:"constant.numeric",regex:"#[a-f0-9]{3}"},{token:["punctuation","entity.other.attribute-name.pseudo-element.css"],regex:t},{token:["punctuation","entity.other.attribute-name.pseudo-class.css"],regex:n},{include:"url"},{token:o,regex:"\\-?[a-zA-Z_][a-zA-Z0-9_\\-]*"},{caseInsensitive:!0}],url:[{token:"support.function",regex:"(?:url(:?-prefix)?|domain|regexp)\\(",push:[{token:"support.function",regex:"\\)",next:"pop"},{defaultToken:"string"}]}],strings:[{token:"string.start",regex:"'",push:[{token:"string.end",regex:"'|$",next:"pop"},{include:"escapes"},{token:"constant.language.escape",regex:/\\$/,consumeLineEnd:!0},{defaultToken:"string"}]},{token:"string.start",regex:'"',push:[{token:"string.end",regex:'"|$',next:"pop"},{include:"escapes"},{token:"constant.language.escape",regex:/\\$/,consumeLineEnd:!0},{defaultToken:"string"}]}],escapes:[{token:"constant.language.escape",regex:/\\([a-fA-F\d]{1,6}|[^a-fA-F\d])/}]},this.normalizeRules()};f.inherits(e,g),h.CssHighlightRules=e}),ace.define("ace/mode/css_completions",["require","exports","module"],function(u,h,b){"use strict";var f={background:{"#$0":1},"background-color":{"#$0":1,transparent:1,fixed:1},"background-image":{"url('/$0')":1},"background-repeat":{repeat:1,"repeat-x":1,"repeat-y":1,"no-repeat":1,inherit:1},"background-position":{bottom:2,center:2,left:2,right:2,top:2,inherit:2},"background-attachment":{scroll:1,fixed:1},"background-size":{cover:1,contain:1},"background-clip":{"border-box":1,"padding-box":1,"content-box":1},"background-origin":{"border-box":1,"padding-box":1,"content-box":1},border:{"solid $0":1,"dashed $0":1,"dotted $0":1,"#$0":1},"border-color":{"#$0":1},"border-style":{solid:2,dashed:2,dotted:2,double:2,groove:2,hidden:2,inherit:2,inset:2,none:2,outset:2,ridged:2},"border-collapse":{collapse:1,separate:1},bottom:{px:1,em:1,"%":1},clear:{left:1,right:1,both:1,none:1},color:{"#$0":1,"rgb(#$00,0,0)":1},cursor:{default:1,pointer:1,move:1,text:1,wait:1,help:1,progress:1,"n-resize":1,"ne-resize":1,"e-resize":1,"se-resize":1,"s-resize":1,"sw-resize":1,"w-resize":1,"nw-resize":1},display:{none:1,block:1,inline:1,"inline-block":1,"table-cell":1},"empty-cells":{show:1,hide:1},float:{left:1,right:1,none:1},"font-family":{Arial:2,"Comic Sans MS":2,Consolas:2,"Courier New":2,Courier:2,Georgia:2,Monospace:2,"Sans-Serif":2,"Segoe UI":2,Tahoma:2,"Times New Roman":2,"Trebuchet MS":2,Verdana:1},"font-size":{px:1,em:1,"%":1},"font-weight":{bold:1,normal:1},"font-style":{italic:1,normal:1},"font-variant":{normal:1,"small-caps":1},height:{px:1,em:1,"%":1},left:{px:1,em:1,"%":1},"letter-spacing":{normal:1},"line-height":{normal:1},"list-style-type":{none:1,disc:1,circle:1,square:1,decimal:1,"decimal-leading-zero":1,"lower-roman":1,"upper-roman":1,"lower-greek":1,"lower-latin":1,"upper-latin":1,georgian:1,"lower-alpha":1,"upper-alpha":1},margin:{px:1,em:1,"%":1},"margin-right":{px:1,em:1,"%":1},"margin-left":{px:1,em:1,"%":1},"margin-top":{px:1,em:1,"%":1},"margin-bottom":{px:1,em:1,"%":1},"max-height":{px:1,em:1,"%":1},"max-width":{px:1,em:1,"%":1},"min-height":{px:1,em:1,"%":1},"min-width":{px:1,em:1,"%":1},overflow:{hidden:1,visible:1,auto:1,scroll:1},"overflow-x":{hidden:1,visible:1,auto:1,scroll:1},"overflow-y":{hidden:1,visible:1,auto:1,scroll:1},padding:{px:1,em:1,"%":1},"padding-top":{px:1,em:1,"%":1},"padding-right":{px:1,em:1,"%":1},"padding-bottom":{px:1,em:1,"%":1},"padding-left":{px:1,em:1,"%":1},"page-break-after":{auto:1,always:1,avoid:1,left:1,right:1},"page-break-before":{auto:1,always:1,avoid:1,left:1,right:1},position:{absolute:1,relative:1,fixed:1,static:1},right:{px:1,em:1,"%":1},"table-layout":{fixed:1,auto:1},"text-decoration":{none:1,underline:1,"line-through":1,blink:1},"text-align":{left:1,right:1,center:1,justify:1},"text-transform":{capitalize:1,uppercase:1,lowercase:1,none:1},top:{px:1,em:1,"%":1},"vertical-align":{top:1,bottom:1},visibility:{hidden:1,visible:1},"white-space":{nowrap:1,normal:1,pre:1,"pre-line":1,"pre-wrap":1},width:{px:1,em:1,"%":1},"word-spacing":{normal:1},filter:{"alpha(opacity=$0100)":1},"text-shadow":{"$02px 2px 2px #777":1},"text-overflow":{"ellipsis-word":1,clip:1,ellipsis:1},"-moz-border-radius":1,"-moz-border-radius-topright":1,"-moz-border-radius-bottomright":1,"-moz-border-radius-topleft":1,"-moz-border-radius-bottomleft":1,"-webkit-border-radius":1,"-webkit-border-top-right-radius":1,"-webkit-border-top-left-radius":1,"-webkit-border-bottom-right-radius":1,"-webkit-border-bottom-left-radius":1,"-moz-box-shadow":1,"-webkit-box-shadow":1,transform:{"rotate($00deg)":1,"skew($00deg)":1},"-moz-transform":{"rotate($00deg)":1,"skew($00deg)":1},"-webkit-transform":{"rotate($00deg)":1,"skew($00deg)":1}},p=function(){};(function(){this.completionsDefined=!1,this.defineCompletions=function(){if(document){var g=document.createElement("c").style;for(var s in g)if("string"==typeof g[s]){var r=s.replace(/[A-Z]/g,function(d){return"-"+d.toLowerCase()});f.hasOwnProperty(r)||(f[r]=1)}}this.completionsDefined=!0},this.getCompletions=function(g,s,r,d){if(this.completionsDefined||this.defineCompletions(),"ruleset"===g||"ace/mode/scss"==s.$mode.$id){var a=s.getLine(r.row).substr(0,r.column),c=/\([^)]*$/.test(a);return c&&(a=a.substr(a.lastIndexOf("(")+1)),/:[^;]+$/.test(a)?(/([\w\-]+):[^:]*$/.test(a),this.getPropertyValueCompletions(g,s,r,d)):this.getPropertyCompletions(g,s,r,d,c)}return[]},this.getPropertyCompletions=function(g,s,r,d,a){return a=a||!1,Object.keys(f).map(function(i){return{caption:i,snippet:i+": $0"+(a?"":";"),meta:"property",score:1e6}})},this.getPropertyValueCompletions=function(g,s,r,d){var a=s.getLine(r.row).substr(0,r.column),c=(/([\w\-]+):[^:]*$/.exec(a)||{})[1];if(!c)return[];var i=[];return c in f&&"object"==typeof f[c]&&(i=Object.keys(f[c])),i.map(function(t){return{caption:t,snippet:t,meta:"property value",score:1e6}})}}).call(p.prototype),h.CssCompletions=p}),ace.define("ace/mode/behaviour/css",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/mode/behaviour/cstyle","ace/token_iterator"],function(u,h,b){"use strict";var f=u("../../lib/oop"),g=(u("../behaviour"),u("./cstyle").CstyleBehaviour),s=u("../../token_iterator").TokenIterator,r=function(){this.inherit(g),this.add("colon","insertion",function(d,a,c,i,t){if(":"===t&&c.selection.isEmpty()){var n=c.getCursorPosition(),e=new s(i,n.row,n.column),o=e.getCurrentToken();if(o&&o.value.match(/\s+/)&&(o=e.stepBackward()),o&&"support.type"===o.type){var l=i.doc.getLine(n.row);if(":"===l.substring(n.column,n.column+1))return{text:"",selection:[1,1]};if(/^(\s+[^;]|\s*$)/.test(l.substring(n.column)))return{text:":;",selection:[1,1]}}}}),this.add("colon","deletion",function(d,a,c,i,t){var n=i.doc.getTextRange(t);if(!t.isMultiLine()&&":"===n){var e=c.getCursorPosition(),o=new s(i,e.row,e.column),l=o.getCurrentToken();if(l&&l.value.match(/\s+/)&&(l=o.stepBackward()),l&&"support.type"===l.type&&";"===i.doc.getLine(t.start.row).substring(t.end.column,t.end.column+1))return t.end.column++,t}}),this.add("semicolon","insertion",function(d,a,c,i,t){if(";"===t&&c.selection.isEmpty()){var n=c.getCursorPosition();if(";"===i.doc.getLine(n.row).substring(n.column,n.column+1))return{text:"",selection:[1,1]}}}),this.add("!important","insertion",function(d,a,c,i,t){if("!"===t&&c.selection.isEmpty()){var n=c.getCursorPosition(),e=i.doc.getLine(n.row);if(/^\s*(;|}|$)/.test(e.substring(n.column)))return{text:"!important",selection:[10,10]}}})};f.inherits(r,g),h.CssBehaviour=r}),ace.define("ace/mode/css",["require","exports","module","ace/lib/oop","ace/mode/text","ace/mode/css_highlight_rules","ace/mode/matching_brace_outdent","ace/worker/worker_client","ace/mode/css_completions","ace/mode/behaviour/css","ace/mode/folding/cstyle"],function(u,h,b){"use strict";var f=u("../lib/oop"),p=u("./text").Mode,g=u("./css_highlight_rules").CssHighlightRules,s=u("./matching_brace_outdent").MatchingBraceOutdent,r=u("../worker/worker_client").WorkerClient,d=u("./css_completions").CssCompletions,a=u("./behaviour/css").CssBehaviour,c=u("./folding/cstyle").FoldMode,i=function(){this.HighlightRules=g,this.$outdent=new s,this.$behaviour=new a,this.$completer=new d,this.foldingRules=new c};f.inherits(i,p),function(){this.foldingRules="cStyle",this.blockComment={start:"/*",end:"*/"},this.getNextLineIndent=function(t,n,e){var o=this.$getIndent(n),l=this.getTokenizer().getLineTokens(n,t).tokens;return l.length&&"comment"==l[l.length-1].type||n.match(/^.*\{\s*$/)&&(o+=e),o},this.checkOutdent=function(t,n,e){return this.$outdent.checkOutdent(n,e)},this.autoOutdent=function(t,n,e){this.$outdent.autoOutdent(n,e)},this.getCompletions=function(t,n,e,o){return this.$completer.getCompletions(t,n,e,o)},this.createWorker=function(t){var n=new r(["ace"],"ace/mode/css_worker","Worker");return n.attachToDocument(t.getDocument()),n.on("annotate",function(e){t.setAnnotations(e.data)}),n.on("terminate",function(){t.clearAnnotations()}),n},this.$id="ace/mode/css",this.snippetFileId="ace/snippets/css"}.call(i.prototype),h.Mode=i}),ace.define("ace/mode/xml_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/text_highlight_rules"],function(u,h,b){"use strict";var f=u("../lib/oop"),p=u("./text_highlight_rules").TextHighlightRules,g=function(s){var r="[_:a-zA-Z\xc0-\uffff][-_:.a-zA-Z0-9\xc0-\uffff]*";this.$rules={start:[{token:"string.cdata.xml",regex:"<\\!\\[CDATA\\[",next:"cdata"},{token:["punctuation.instruction.xml","keyword.instruction.xml"],regex:"(<\\?)("+r+")",next:"processing_instruction"},{token:"comment.start.xml",regex:"<\\!--",next:"comment"},{token:["xml-pe.doctype.xml","xml-pe.doctype.xml"],regex:"(<\\!)(DOCTYPE)(?=[\\s])",next:"doctype",caseInsensitive:!0},{include:"tag"},{token:"text.end-tag-open.xml",regex:"</"},{token:"text.tag-open.xml",regex:"<"},{include:"reference"},{defaultToken:"text.xml"}],processing_instruction:[{token:"entity.other.attribute-name.decl-attribute-name.xml",regex:r},{token:"keyword.operator.decl-attribute-equals.xml",regex:"="},{include:"whitespace"},{include:"string"},{token:"punctuation.xml-decl.xml",regex:"\\?>",next:"start"}],doctype:[{include:"whitespace"},{include:"string"},{token:"xml-pe.doctype.xml",regex:">",next:"start"},{token:"xml-pe.xml",regex:"[-_a-zA-Z0-9:]+"},{token:"punctuation.int-subset",regex:"\\[",push:"int_subset"}],int_subset:[{token:"text.xml",regex:"\\s+"},{token:"punctuation.int-subset.xml",regex:"]",next:"pop"},{token:["punctuation.markup-decl.xml","keyword.markup-decl.xml"],regex:"(<\\!)("+r+")",push:[{token:"text",regex:"\\s+"},{token:"punctuation.markup-decl.xml",regex:">",next:"pop"},{include:"string"}]}],cdata:[{token:"string.cdata.xml",regex:"\\]\\]>",next:"start"},{token:"text.xml",regex:"\\s+"},{token:"text.xml",regex:"(?:[^\\]]|\\](?!\\]>))+"}],comment:[{token:"comment.end.xml",regex:"--\x3e",next:"start"},{defaultToken:"comment.xml"}],reference:[{token:"constant.language.escape.reference.xml",regex:"(?:&#[0-9]+;)|(?:&#x[0-9a-fA-F]+;)|(?:&[a-zA-Z0-9_:\\.-]+;)"}],attr_reference:[{token:"constant.language.escape.reference.attribute-value.xml",regex:"(?:&#[0-9]+;)|(?:&#x[0-9a-fA-F]+;)|(?:&[a-zA-Z0-9_:\\.-]+;)"}],tag:[{token:["meta.tag.punctuation.tag-open.xml","meta.tag.punctuation.end-tag-open.xml","meta.tag.tag-name.xml"],regex:"(?:(<)|(</))((?:"+r+":)?"+r+")",next:[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:"start"}]}],tag_whitespace:[{token:"text.tag-whitespace.xml",regex:"\\s+"}],whitespace:[{token:"text.whitespace.xml",regex:"\\s+"}],string:[{token:"string.xml",regex:"'",push:[{token:"string.xml",regex:"'",next:"pop"},{defaultToken:"string.xml"}]},{token:"string.xml",regex:'"',push:[{token:"string.xml",regex:'"',next:"pop"},{defaultToken:"string.xml"}]}],attributes:[{token:"entity.other.attribute-name.xml",regex:r},{token:"keyword.operator.attribute-equals.xml",regex:"="},{include:"tag_whitespace"},{include:"attribute_value"}],attribute_value:[{token:"string.attribute-value.xml",regex:"'",push:[{token:"string.attribute-value.xml",regex:"'",next:"pop"},{include:"attr_reference"},{defaultToken:"string.attribute-value.xml"}]},{token:"string.attribute-value.xml",regex:'"',push:[{token:"string.attribute-value.xml",regex:'"',next:"pop"},{include:"attr_reference"},{defaultToken:"string.attribute-value.xml"}]}]},this.constructor===g&&this.normalizeRules()};(function(){this.embedTagRules=function(s,r,d){this.$rules.tag.unshift({token:["meta.tag.punctuation.tag-open.xml","meta.tag."+d+".tag-name.xml"],regex:"(<)("+d+"(?=\\s|>|$))",next:[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:r+"start"}]}),this.$rules[d+"-end"]=[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:"start",onMatch:function(a,c,i){return i.splice(0),this.token}}],this.embedRules(s,r,[{token:["meta.tag.punctuation.end-tag-open.xml","meta.tag."+d+".tag-name.xml"],regex:"(</)("+d+"(?=\\s|>|$))",next:d+"-end"},{token:"string.cdata.xml",regex:"<\\!\\[CDATA\\["},{token:"string.cdata.xml",regex:"\\]\\]>"}])}}).call(p.prototype),f.inherits(g,p),h.XmlHighlightRules=g}),ace.define("ace/mode/html_highlight_rules",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/css_highlight_rules","ace/mode/javascript_highlight_rules","ace/mode/xml_highlight_rules"],function(u,h,b){"use strict";var f=u("../lib/oop"),p=u("../lib/lang"),g=u("./css_highlight_rules").CssHighlightRules,s=u("./javascript_highlight_rules").JavaScriptHighlightRules,r=u("./xml_highlight_rules").XmlHighlightRules,d=p.createMap({a:"anchor",button:"form",form:"form",img:"image",input:"form",label:"form",option:"form",script:"script",select:"form",textarea:"form",style:"style",table:"table",tbody:"table",td:"table",tfoot:"table",th:"table",tr:"table"}),a=function(){r.call(this),this.addRules({attributes:[{include:"tag_whitespace"},{token:"entity.other.attribute-name.xml",regex:"[-_a-zA-Z0-9:.]+"},{token:"keyword.operator.attribute-equals.xml",regex:"=",push:[{include:"tag_whitespace"},{token:"string.unquoted.attribute-value.html",regex:"[^<>='\"`\\s]+",next:"pop"},{token:"empty",regex:"",next:"pop"}]},{include:"attribute_value"}],tag:[{token:function(c,i){var t=d[i];return["meta.tag.punctuation."+("<"==c?"":"end-")+"tag-open.xml","meta.tag"+(t?"."+t:"")+".tag-name.xml"]},regex:"(</?)([-_a-zA-Z0-9:.]+)",next:"tag_stuff"}],tag_stuff:[{include:"attributes"},{token:"meta.tag.punctuation.tag-close.xml",regex:"/?>",next:"start"}]}),this.embedTagRules(g,"css-","style"),this.embedTagRules(new s({jsx:!1}).getRules(),"js-","script"),this.constructor===a&&this.normalizeRules()};f.inherits(a,r),h.HtmlHighlightRules=a}),ace.define("ace/mode/behaviour/xml",["require","exports","module","ace/lib/oop","ace/mode/behaviour","ace/token_iterator","ace/lib/lang"],function(u,h,b){"use strict";var f=u("../../lib/oop"),p=u("../behaviour").Behaviour,g=u("../../token_iterator").TokenIterator;function r(a,c){return a&&a.type.lastIndexOf(c+".xml")>-1}u("../../lib/lang");var d=function(){this.add("string_dquotes","insertion",function(a,c,i,t,n){if('"'==n||"'"==n){var e=n,o=t.doc.getTextRange(i.getSelectionRange());if(""!==o&&"'"!==o&&'"'!=o&&i.getWrapBehavioursEnabled())return{text:e+o+e,selection:!1};var l=i.getCursorPosition(),x=t.doc.getLine(l.row).substring(l.column,l.column+1),k=new g(t,l.row,l.column),v=k.getCurrentToken();if(x==e&&(r(v,"attribute-value")||r(v,"string")))return{text:"",selection:[1,1]};if(v||(v=k.stepBackward()),!v)return;for(;r(v,"tag-whitespace")||r(v,"whitespace");)v=k.stepBackward();var y=!x||x.match(/\s/);if(r(v,"attribute-equals")&&(y||">"==x)||r(v,"decl-attribute-equals")&&(y||"?"==x))return{text:e+e,selection:[1,1]}}}),this.add("string_dquotes","deletion",function(a,c,i,t,n){var e=t.doc.getTextRange(n);if(!n.isMultiLine()&&('"'==e||"'"==e)&&t.doc.getLine(n.start.row).substring(n.start.column+1,n.start.column+2)==e)return n.end.column++,n}),this.add("autoclosing","insertion",function(a,c,i,t,n){if(">"==n){var e=i.getSelectionRange().start,o=new g(t,e.row,e.column),l=o.getCurrentToken()||o.stepBackward();if(!l||!(r(l,"tag-name")||r(l,"tag-whitespace")||r(l,"attribute-name")||r(l,"attribute-equals")||r(l,"attribute-value"))||r(l,"reference.attribute-value"))return;if(r(l,"attribute-value")){var m=o.getCurrentTokenColumn()+l.value.length;if(e.column<m)return;if(e.column==m){var x=o.stepForward();if(x&&r(x,"attribute-value"))return;o.stepBackward()}}if(/^\s*>/.test(t.getLine(e.row).slice(e.column)))return;for(;!r(l,"tag-name");)if("<"==(l=o.stepBackward()).value){l=o.stepForward();break}var k=o.getCurrentTokenRow(),v=o.getCurrentTokenColumn();if(r(o.stepBackward(),"end-tag-open"))return;var y=l.value;return k==e.row&&(y=y.substring(0,e.column-v)),this.voidElements.hasOwnProperty(y.toLowerCase())?void 0:{text:"></"+y+">",selection:[1,1]}}}),this.add("autoindent","insertion",function(a,c,i,t,n){if("\n"==n){var e=i.getCursorPosition(),o=t.getLine(e.row),l=new g(t,e.row,e.column),m=l.getCurrentToken();if(m&&-1!==m.type.indexOf("tag-close")){if("/>"==m.value)return;for(;m&&-1===m.type.indexOf("tag-name");)m=l.stepBackward();if(!m)return;var x=m.value,k=l.getCurrentTokenRow();if(!(m=l.stepBackward())||-1!==m.type.indexOf("end-tag"))return;if(this.voidElements&&!this.voidElements[x]){var v=t.getTokenAt(e.row,e.column+1),y=(o=t.getLine(k),this.$getIndent(o)),w=y+t.getTabString();return v&&"</"===v.value?{text:"\n"+w+"\n"+y,selection:[1,w.length,1,w.length]}:{text:"\n"+w}}}}})};f.inherits(d,p),h.XmlBehaviour=d}),ace.define("ace/mode/folding/mixed",["require","exports","module","ace/lib/oop","ace/mode/folding/fold_mode"],function(u,h,b){"use strict";var f=u("../../lib/oop"),p=u("./fold_mode").FoldMode,g=h.FoldMode=function(s,r){this.defaultMode=s,this.subModes=r};f.inherits(g,p),function(){this.$getMode=function(s){for(var r in"string"!=typeof s&&(s=s[0]),this.subModes)if(0===s.indexOf(r))return this.subModes[r];return null},this.$tryMode=function(s,r,d,a){var c=this.$getMode(s);return c?c.getFoldWidget(r,d,a):""},this.getFoldWidget=function(s,r,d){return this.$tryMode(s.getState(d-1),s,r,d)||this.$tryMode(s.getState(d),s,r,d)||this.defaultMode.getFoldWidget(s,r,d)},this.getFoldWidgetRange=function(s,r,d){var a=this.$getMode(s.getState(d-1));return(!a||!a.getFoldWidget(s,r,d))&&(a=this.$getMode(s.getState(d))),(!a||!a.getFoldWidget(s,r,d))&&(a=this.defaultMode),a.getFoldWidgetRange(s,r,d)}}.call(g.prototype)}),ace.define("ace/mode/folding/xml",["require","exports","module","ace/lib/oop","ace/range","ace/mode/folding/fold_mode"],function(u,h,b){"use strict";var f=u("../../lib/oop"),p=u("../../range").Range,g=u("./fold_mode").FoldMode,s=h.FoldMode=function(a,c){g.call(this),this.voidElements=a||{},this.optionalEndTags=f.mixin({},this.voidElements),c&&f.mixin(this.optionalEndTags,c)};f.inherits(s,g);var r=function(){this.tagName="",this.closing=!1,this.selfClosing=!1,this.start={row:0,column:0},this.end={row:0,column:0}};function d(a,c){return a.type.lastIndexOf(c+".xml")>-1}(function(){this.getFoldWidget=function(a,c,i){var t=this._getFirstTagInLine(a,i);return t?t.closing||!t.tagName&&t.selfClosing?"markbeginend"===c?"end":"":!t.tagName||t.selfClosing||this.voidElements.hasOwnProperty(t.tagName.toLowerCase())||this._findEndTagInLine(a,i,t.tagName,t.end.column)?"":"start":this.getCommentFoldWidget(a,i)},this.getCommentFoldWidget=function(a,c){return/comment/.test(a.getState(c))&&/<!-/.test(a.getLine(c))?"start":""},this._getFirstTagInLine=function(a,c){for(var i=a.getTokens(c),t=new r,n=0;n<i.length;n++){var e=i[n];if(d(e,"tag-open")){if(t.end.column=t.start.column+e.value.length,t.closing=d(e,"end-tag-open"),!(e=i[++n]))return null;for(t.tagName=e.value,t.end.column+=e.value.length,n++;n<i.length;n++)if(t.end.column+=(e=i[n]).value.length,d(e,"tag-close")){t.selfClosing="/>"==e.value;break}return t}if(d(e,"tag-close"))return t.selfClosing="/>"==e.value,t;t.start.column+=e.value.length}return null},this._findEndTagInLine=function(a,c,i,t){for(var n=a.getTokens(c),e=0,o=0;o<n.length;o++){var l=n[o];if(!((e+=l.value.length)<t)&&d(l,"end-tag-open")&&(l=n[o+1])&&l.value==i)return!0}return!1},this.getFoldWidgetRange=function(a,c,i){var t=a.getMatchingTags({row:i,column:0});return t?new p(t.openTag.end.row,t.openTag.end.column,t.closeTag.start.row,t.closeTag.start.column):this.getCommentFoldWidget(a,i)&&a.getCommentFoldRange(i,a.getLine(i).length)}}).call(s.prototype)}),ace.define("ace/mode/folding/html",["require","exports","module","ace/lib/oop","ace/mode/folding/mixed","ace/mode/folding/xml","ace/mode/folding/cstyle"],function(u,h,b){"use strict";var f=u("../../lib/oop"),p=u("./mixed").FoldMode,g=u("./xml").FoldMode,s=u("./cstyle").FoldMode,r=h.FoldMode=function(d,a){p.call(this,new g(d,a),{"js-":new s,"css-":new s})};f.inherits(r,p)}),ace.define("ace/mode/html_completions",["require","exports","module","ace/token_iterator"],function(u,h,b){"use strict";var f=u("../token_iterator").TokenIterator,s=["accesskey","class","contenteditable","contextmenu","dir","draggable","dropzone","hidden","id","inert","itemid","itemprop","itemref","itemscope","itemtype","lang","spellcheck","style","tabindex","title","translate"].concat(["onabort","onblur","oncancel","oncanplay","oncanplaythrough","onchange","onclick","onclose","oncontextmenu","oncuechange","ondblclick","ondrag","ondragend","ondragenter","ondragleave","ondragover","ondragstart","ondrop","ondurationchange","onemptied","onended","onerror","onfocus","oninput","oninvalid","onkeydown","onkeypress","onkeyup","onload","onloadeddata","onloadedmetadata","onloadstart","onmousedown","onmousemove","onmouseout","onmouseover","onmouseup","onmousewheel","onpause","onplay","onplaying","onprogress","onratechange","onreset","onscroll","onseeked","onseeking","onselect","onshow","onstalled","onsubmit","onsuspend","ontimeupdate","onvolumechange","onwaiting"]),r={a:{href:1,target:{_blank:1,top:1},ping:1,rel:{nofollow:1,alternate:1,author:1,bookmark:1,help:1,license:1,next:1,noreferrer:1,prefetch:1,prev:1,search:1,tag:1},media:1,hreflang:1,type:1},abbr:{},address:{},area:{shape:1,coords:1,href:1,hreflang:1,alt:1,target:1,media:1,rel:1,ping:1,type:1},article:{pubdate:1},aside:{},audio:{src:1,autobuffer:1,autoplay:{autoplay:1},loop:{loop:1},controls:{controls:1},muted:{muted:1},preload:{auto:1,metadata:1,none:1}},b:{},base:{href:1,target:1},bdi:{},bdo:{},blockquote:{cite:1},body:{onafterprint:1,onbeforeprint:1,onbeforeunload:1,onhashchange:1,onmessage:1,onoffline:1,onpopstate:1,onredo:1,onresize:1,onstorage:1,onundo:1,onunload:1},br:{},button:{autofocus:1,disabled:{disabled:1},form:1,formaction:1,formenctype:1,formmethod:1,formnovalidate:1,formtarget:1,name:1,value:1,type:{button:1,submit:1}},canvas:{width:1,height:1},caption:{},cite:{},code:{},col:{span:1},colgroup:{span:1},command:{type:1,label:1,icon:1,disabled:1,checked:1,radiogroup:1,command:1},data:{},datalist:{},dd:{},del:{cite:1,datetime:1},details:{open:1},dfn:{},dialog:{open:1},div:{},dl:{},dt:{},em:{},embed:{src:1,height:1,width:1,type:1},fieldset:{disabled:1,form:1,name:1},figcaption:{},figure:{},footer:{},form:{"accept-charset":1,action:1,autocomplete:1,enctype:{"multipart/form-data":1,"application/x-www-form-urlencoded":1},method:{get:1,post:1},name:1,novalidate:1,target:{_blank:1,top:1}},h1:{},h2:{},h3:{},h4:{},h5:{},h6:{},head:{},header:{},hr:{},html:{manifest:1},i:{},iframe:{name:1,src:1,height:1,width:1,sandbox:{"allow-same-origin":1,"allow-top-navigation":1,"allow-forms":1,"allow-scripts":1},seamless:{seamless:1}},img:{alt:1,src:1,height:1,width:1,usemap:1,ismap:1},input:{type:{text:1,password:1,hidden:1,checkbox:1,submit:1,radio:1,file:1,button:1,reset:1,image:31,color:1,date:1,datetime:1,"datetime-local":1,email:1,month:1,number:1,range:1,search:1,tel:1,time:1,url:1,week:1},accept:1,alt:1,autocomplete:{on:1,off:1},autofocus:{autofocus:1},checked:{checked:1},disabled:{disabled:1},form:1,formaction:1,formenctype:{"application/x-www-form-urlencoded":1,"multipart/form-data":1,"text/plain":1},formmethod:{get:1,post:1},formnovalidate:{formnovalidate:1},formtarget:{_blank:1,_self:1,_parent:1,_top:1},height:1,list:1,max:1,maxlength:1,min:1,multiple:{multiple:1},name:1,pattern:1,placeholder:1,readonly:{readonly:1},required:{required:1},size:1,src:1,step:1,width:1,files:1,value:1},ins:{cite:1,datetime:1},kbd:{},keygen:{autofocus:1,challenge:{challenge:1},disabled:{disabled:1},form:1,keytype:{rsa:1,dsa:1,ec:1},name:1},label:{form:1,for:1},legend:{},li:{value:1},link:{href:1,hreflang:1,rel:{stylesheet:1,icon:1},media:{all:1,screen:1,print:1},type:{"text/css":1,"image/png":1,"image/jpeg":1,"image/gif":1},sizes:1},main:{},map:{name:1},mark:{},math:{},menu:{type:1,label:1},meta:{"http-equiv":{"content-type":1},name:{description:1,keywords:1},content:{"text/html; charset=UTF-8":1},charset:1},meter:{value:1,min:1,max:1,low:1,high:1,optimum:1},nav:{},noscript:{href:1},object:{param:1,data:1,type:1,height:1,width:1,usemap:1,name:1,form:1,classid:1},ol:{start:1,reversed:1},optgroup:{disabled:1,label:1},option:{disabled:1,selected:1,label:1,value:1},output:{for:1,form:1,name:1},p:{},param:{name:1,value:1},pre:{},progress:{value:1,max:1},q:{cite:1},rp:{},rt:{},ruby:{},s:{},samp:{},script:{charset:1,type:{"text/javascript":1},src:1,defer:1,async:1},select:{autofocus:1,disabled:1,form:1,multiple:{multiple:1},name:1,size:1,readonly:{readonly:1}},small:{},source:{src:1,type:1,media:1},span:{},strong:{},style:{type:1,media:{all:1,screen:1,print:1},scoped:1},sub:{},sup:{},svg:{},table:{summary:1},tbody:{},td:{headers:1,rowspan:1,colspan:1},textarea:{autofocus:{autofocus:1},disabled:{disabled:1},form:1,maxlength:1,name:1,placeholder:1,readonly:{readonly:1},required:{required:1},rows:1,cols:1,wrap:{on:1,off:1,hard:1,soft:1}},tfoot:{},th:{headers:1,rowspan:1,colspan:1,scope:1},thead:{},time:{datetime:1},title:{},tr:{},track:{kind:1,src:1,srclang:1,label:1,default:1},section:{},summary:{},u:{},ul:{},var:{},video:{src:1,autobuffer:1,autoplay:{autoplay:1},loop:{loop:1},controls:{controls:1},width:1,height:1,poster:1,muted:{muted:1},preload:{auto:1,metadata:1,none:1}},wbr:{}},d=Object.keys(r);function a(n,e){return n.type.lastIndexOf(e+".xml")>-1}function c(n,e){for(var o=new f(n,e.row,e.column),l=o.getCurrentToken();l&&!a(l,"tag-name");)l=o.stepBackward();if(l)return l.value}var t=function(){};(function(){this.getCompletions=function(n,e,o,l){var m=e.getTokenAt(o.row,o.column);if(!m)return[];if(a(m,"tag-name")||a(m,"tag-open")||a(m,"end-tag-open"))return this.getTagCompletions(n,e,o,l);if(a(m,"tag-whitespace")||a(m,"attribute-name"))return this.getAttributeCompletions(n,e,o,l);if(a(m,"attribute-value"))return this.getAttributeValueCompletions(n,e,o,l);var x=e.getLine(o.row).substr(0,o.column);return/&[a-z]*$/i.test(x)?this.getHTMLEntityCompletions(n,e,o,l):[]},this.getTagCompletions=function(n,e,o,l){return d.map(function(m){return{value:m,meta:"tag",score:1e6}})},this.getAttributeCompletions=function(n,e,o,l){var m=c(e,o);if(!m)return[];var x=s;return m in r&&(x=x.concat(Object.keys(r[m]))),x.map(function(k){return{caption:k,snippet:k+'="$0"',meta:"attribute",score:1e6}})},this.getAttributeValueCompletions=function(n,e,o,l){var m=c(e,o),x=function i(n,e){for(var o=new f(n,e.row,e.column),l=o.getCurrentToken();l&&!a(l,"attribute-name");)l=o.stepBackward();if(l)return l.value}(e,o);if(!m)return[];var k=[];return m in r&&x in r[m]&&"object"==typeof r[m][x]&&(k=Object.keys(r[m][x])),k.map(function(v){return{caption:v,snippet:v,meta:"attribute value",score:1e6}})},this.getHTMLEntityCompletions=function(n,e,o,l){return["Aacute;","aacute;","Acirc;","acirc;","acute;","AElig;","aelig;","Agrave;","agrave;","alefsym;","Alpha;","alpha;","amp;","and;","ang;","Aring;","aring;","asymp;","Atilde;","atilde;","Auml;","auml;","bdquo;","Beta;","beta;","brvbar;","bull;","cap;","Ccedil;","ccedil;","cedil;","cent;","Chi;","chi;","circ;","clubs;","cong;","copy;","crarr;","cup;","curren;","Dagger;","dagger;","dArr;","darr;","deg;","Delta;","delta;","diams;","divide;","Eacute;","eacute;","Ecirc;","ecirc;","Egrave;","egrave;","empty;","emsp;","ensp;","Epsilon;","epsilon;","equiv;","Eta;","eta;","ETH;","eth;","Euml;","euml;","euro;","exist;","fnof;","forall;","frac12;","frac14;","frac34;","frasl;","Gamma;","gamma;","ge;","gt;","hArr;","harr;","hearts;","hellip;","Iacute;","iacute;","Icirc;","icirc;","iexcl;","Igrave;","igrave;","image;","infin;","int;","Iota;","iota;","iquest;","isin;","Iuml;","iuml;","Kappa;","kappa;","Lambda;","lambda;","lang;","laquo;","lArr;","larr;","lceil;","ldquo;","le;","lfloor;","lowast;","loz;","lrm;","lsaquo;","lsquo;","lt;","macr;","mdash;","micro;","middot;","minus;","Mu;","mu;","nabla;","nbsp;","ndash;","ne;","ni;","not;","notin;","nsub;","Ntilde;","ntilde;","Nu;","nu;","Oacute;","oacute;","Ocirc;","ocirc;","OElig;","oelig;","Ograve;","ograve;","oline;","Omega;","omega;","Omicron;","omicron;","oplus;","or;","ordf;","ordm;","Oslash;","oslash;","Otilde;","otilde;","otimes;","Ouml;","ouml;","para;","part;","permil;","perp;","Phi;","phi;","Pi;","pi;","piv;","plusmn;","pound;","Prime;","prime;","prod;","prop;","Psi;","psi;","quot;","radic;","rang;","raquo;","rArr;","rarr;","rceil;","rdquo;","real;","reg;","rfloor;","Rho;","rho;","rlm;","rsaquo;","rsquo;","sbquo;","Scaron;","scaron;","sdot;","sect;","shy;","Sigma;","sigma;","sigmaf;","sim;","spades;","sub;","sube;","sum;","sup;","sup1;","sup2;","sup3;","supe;","szlig;","Tau;","tau;","there4;","Theta;","theta;","thetasym;","thinsp;","THORN;","thorn;","tilde;","times;","trade;","Uacute;","uacute;","uArr;","uarr;","Ucirc;","ucirc;","Ugrave;","ugrave;","uml;","upsih;","Upsilon;","upsilon;","Uuml;","uuml;","weierp;","Xi;","xi;","Yacute;","yacute;","yen;","Yuml;","yuml;","Zeta;","zeta;","zwj;","zwnj;"].map(function(x){return{caption:x,snippet:x,meta:"html entity",score:1e6}})}}).call(t.prototype),h.HtmlCompletions=t}),ace.define("ace/mode/html",["require","exports","module","ace/lib/oop","ace/lib/lang","ace/mode/text","ace/mode/javascript","ace/mode/css","ace/mode/html_highlight_rules","ace/mode/behaviour/xml","ace/mode/folding/html","ace/mode/html_completions","ace/worker/worker_client"],function(u,h,b){"use strict";var f=u("../lib/oop"),p=u("../lib/lang"),g=u("./text").Mode,s=u("./javascript").Mode,r=u("./css").Mode,d=u("./html_highlight_rules").HtmlHighlightRules,a=u("./behaviour/xml").XmlBehaviour,c=u("./folding/html").FoldMode,i=u("./html_completions").HtmlCompletions,t=u("../worker/worker_client").WorkerClient,n=["area","base","br","col","embed","hr","img","input","keygen","link","meta","menuitem","param","source","track","wbr"],e=["li","dt","dd","p","rt","rp","optgroup","option","colgroup","td","th"],o=function(l){this.fragmentContext=l&&l.fragmentContext,this.HighlightRules=d,this.$behaviour=new a,this.$completer=new i,this.createModeDelegates({"js-":s,"css-":r}),this.foldingRules=new c(this.voidElements,p.arrayToMap(e))};f.inherits(o,g),function(){this.blockComment={start:"\x3c!--",end:"--\x3e"},this.voidElements=p.arrayToMap(n),this.getNextLineIndent=function(l,m,x){return this.$getIndent(m)},this.checkOutdent=function(l,m,x){return!1},this.getCompletions=function(l,m,x,k){return this.$completer.getCompletions(l,m,x,k)},this.createWorker=function(l){if(this.constructor==o){var m=new t(["ace"],"ace/mode/html_worker","Worker");return m.attachToDocument(l.getDocument()),this.fragmentContext&&m.call("setOptions",[{context:this.fragmentContext}]),m.on("error",function(x){l.setAnnotations(x.data)}),m.on("terminate",function(){l.clearAnnotations()}),m}},this.$id="ace/mode/html",this.snippetFileId="ace/snippets/html"}.call(o.prototype),h.Mode=o}),ace.define("ace/mode/astro_highlight_rules",["require","exports","module","ace/lib/oop","ace/mode/html_highlight_rules","ace/mode/javascript_highlight_rules"],function(u,h,b){"use strict";var f=u("../lib/oop"),p=u("./html_highlight_rules").HtmlHighlightRules,g=u("./javascript_highlight_rules").JavaScriptHighlightRules,s=function(){p.call(this);var r={token:"paren.quasi.start",regex:/{/,next:function(i,t){return"start"!==i&&(-1!==i.indexOf("attribute-equals")?(t.splice(0),t.unshift("tag_stuff")):t.unshift(i)),"inline-js-start"}};for(var d in this.$rules)d.startsWith("js")||d.startsWith("css")||d.startsWith("comment")||this.$rules[d].unshift(r);this.$rules.start.unshift({token:"comment",regex:/^---$/,onMatch:function(i,t,n){return n.splice(0),this.token},next:"javascript-start"}),this.embedRules(g,"javascript-",[{regex:/^---$/,token:"comment",next:"start",onMatch:function(i,t,n){return n.splice(0),this.token}}]),this.embedRules(g,"inline-js-");var a=[{regex:/}/,token:"paren.quasi.end",onMatch:function(i,t,n){return"inline-js-start"===n[0]?(n.shift(),this.next=n.shift(),-1!==this.next.indexOf("string")?"paren.quasi.end":"paren.rparen"):(this.next=n.shift()||"start",this.token)}},{regex:/{/,token:"paren.lparen",push:"inline-js-start"}];function c(i){for(var t in this.$rules[i+"jsxAttributes"])if("meta.tag.punctuation.tag-close.xml"===this.$rules[i+"jsxAttributes"][t].token){this.$rules[i+"jsxAttributes"][t].onMatch=function(n,e,o){return e==o[0]&&o.shift(),2==n.length&&(o[0]==this.nextState&&o[1]--,(!o[1]||o[1]<0)&&o.splice(0,2)),this.next=o[0]||i+"start",[{type:this.token,value:n}]};break}}this.$rules["inline-js-start"].unshift(a),this.$rules["inline-js-no_regex"].unshift(a),c.call(this,"javascript-"),c.call(this,"inline-js-"),this.normalizeRules()};f.inherits(s,p),h.AstroHighlightRules=s}),ace.define("ace/mode/behaviour/html",["require","exports","module","ace/lib/oop","ace/mode/behaviour/xml"],function(u,h,b){"use strict";var f=u("../../lib/oop"),p=u("../behaviour/xml").XmlBehaviour,g=function(){p.call(this)};f.inherits(g,p),h.HtmlBehaviour=g}),ace.define("ace/mode/astro",["require","exports","module","ace/lib/oop","ace/mode/html","ace/mode/astro_highlight_rules","ace/mode/behaviour/html"],function(u,h,b){"use strict";var f=u("../lib/oop"),p=u("./html").Mode,g=u("./astro_highlight_rules").AstroHighlightRules,s=u("./behaviour/html").HtmlBehaviour,r=function(){p.call(this),this.HighlightRules=g,this.$behaviour=new s};f.inherits(r,p),function(){this.$id="ace/mode/astro"}.call(r.prototype),h.Mode=r}),ace.require(["ace/mode/astro"],function(u){"object"==typeof module&&"object"==typeof exports&&module&&(module.exports=u)});