ace.define("ace/snippets",["require","exports","module","ace/lib/dom","ace/lib/oop","ace/lib/event_emitter","ace/lib/lang","ace/range","ace/range_list","ace/keyboard/hash_handler","ace/tokenizer","ace/clipboard","ace/editor"],function(v,E,F){"use strict";var $=v("./lib/dom"),M=v("./lib/oop"),N=v("./lib/event_emitter").EventEmitter,y=v("./lib/lang"),S=v("./range").Range,T=v("./range_list").RangeList,k=v("./keyboard/hash_handler").HashHandler,R=v("./tokenizer").Tokenizer,L=v("./clipboard"),s={CURRENT_WORD:function(e){return e.session.getTextRange(e.session.getWordRange())},SELECTION:function(e,i,r){var t=e.session.getTextRange();return r?t.replace(/\n\r?([ \t]*\S)/g,"\n"+r+"$1"):t},CURRENT_LINE:function(e){return e.session.getLine(e.getCursorPosition().row)},PREV_LINE:function(e){return e.session.getLine(e.getCursorPosition().row-1)},LINE_INDEX:function(e){return e.getCursorPosition().row},LINE_NUMBER:function(e){return e.getCursorPosition().row+1},SOFT_TABS:function(e){return e.session.getUseSoftTabs()?"YES":"NO"},TAB_SIZE:function(e){return e.session.getTabSize()},CLIPBOARD:function(e){return L.getText&&L.getText()},FILENAME:function(e){return/[^/\\]*$/.exec(this.FILEPATH(e))[0]},FILENAME_BASE:function(e){return/[^/\\]*$/.exec(this.FILEPATH(e))[0].replace(/\.[^.]*$/,"")},DIRECTORY:function(e){return this.FILEPATH(e).replace(/[^/\\]*$/,"")},FILEPATH:function(e){return"/not implemented.txt"},WORKSPACE_NAME:function(){return"Unknown"},FULLNAME:function(){return"Unknown"},BLOCK_COMMENT_START:function(e){var i=e.session.$mode||{};return i.blockComment&&i.blockComment.start||""},BLOCK_COMMENT_END:function(e){var i=e.session.$mode||{};return i.blockComment&&i.blockComment.end||""},LINE_COMMENT:function(e){return(e.session.$mode||{}).lineCommentStart||""},CURRENT_YEAR:n.bind(null,{year:"numeric"}),CURRENT_YEAR_SHORT:n.bind(null,{year:"2-digit"}),CURRENT_MONTH:n.bind(null,{month:"numeric"}),CURRENT_MONTH_NAME:n.bind(null,{month:"long"}),CURRENT_MONTH_NAME_SHORT:n.bind(null,{month:"short"}),CURRENT_DATE:n.bind(null,{day:"2-digit"}),CURRENT_DAY_NAME:n.bind(null,{weekday:"long"}),CURRENT_DAY_NAME_SHORT:n.bind(null,{weekday:"short"}),CURRENT_HOUR:n.bind(null,{hour:"2-digit",hour12:!1}),CURRENT_MINUTE:n.bind(null,{minute:"2-digit"}),CURRENT_SECOND:n.bind(null,{second:"2-digit"})};function n(e){var i=(new Date).toLocaleString("en-us",e);return 1==i.length?"0"+i:i}s.SELECTED_TEXT=s.SELECTION;var p=function(){this.snippetMap={},this.snippetNameMap={}};(function(){M.implement(this,N),this.getTokenizer=function(){return p.$tokenizer||this.createTokenizer()},this.createTokenizer=function(){function e(t){return t=t.substr(1),/^\d+$/.test(t)?[{tabstopId:parseInt(t,10)}]:[{text:t}]}function i(t){return"(?:[^\\\\"+t+"]|\\\\.)"}var r={regex:"/("+i("/")+"+)/",onMatch:function(t,a,l){var o=l[0];return o.fmtString=!0,o.guard=t.slice(1,-1),o.flag="",""},next:"formatString"};return p.$tokenizer=new R({start:[{regex:/\\./,onMatch:function(t,a,l){var o=t[1];return("}"==o&&l.length||-1!="`$\\".indexOf(o))&&(t=o),[t]}},{regex:/}/,onMatch:function(t,a,l){return[l.length?l.shift():t]}},{regex:/\$(?:\d+|\w+)/,onMatch:e},{regex:/\$\{[\dA-Z_a-z]+/,onMatch:function(t,a,l){var o=e(t.substr(1));return l.unshift(o[0]),o},next:"snippetVar"},{regex:/\n/,token:"newline",merge:!1}],snippetVar:[{regex:"\\|"+i("\\|")+"*\\|",onMatch:function(t,a,l){var o=t.slice(1,-1).replace(/\\[,|\\]|,/g,function(u){return 2==u.length?u[1]:"\0"}).split("\0").map(function(u){return{value:u}});return l[0].choices=o,[o[0]]},next:"start"},r,{regex:"([^:}\\\\]|\\\\.)*:?",token:"",next:"start"}],formatString:[{regex:/:/,onMatch:function(t,a,l){return l.length&&l[0].expectElse?(l[0].expectElse=!1,l[0].ifEnd={elseEnd:l[0]},[l[0].ifEnd]):":"}},{regex:/\\./,onMatch:function(t,a,l){var o=t[1];return"}"==o&&l.length||-1!="`$\\".indexOf(o)?t=o:"n"==o?t="\n":"t"==o?t="\t":-1!="ulULE".indexOf(o)&&(t={changeCase:o,local:o>"a"}),[t]}},{regex:"/\\w*}",onMatch:function(t,a,l){var o=l.shift();return o&&(o.flag=t.slice(1,-1)),this.next=o&&o.tabstopId?"start":"",[o||t]},next:"start"},{regex:/\$(?:\d+|\w+)/,onMatch:function(t,a,l){return[{text:t.slice(1)}]}},{regex:/\${\w+/,onMatch:function(t,a,l){var o={text:t.slice(2)};return l.unshift(o),[o]},next:"formatStringVar"},{regex:/\n/,token:"newline",merge:!1},{regex:/}/,onMatch:function(t,a,l){var o=l.shift();return this.next=o&&o.tabstopId?"start":"",[o||t]},next:"start"}],formatStringVar:[{regex:/:\/\w+}/,onMatch:function(t,a,l){return l[0].formatFunction=t.slice(2,-1),[l.shift()]},next:"formatString"},r,{regex:/:[\?\-+]?/,onMatch:function(t,a,l){"+"==t[1]&&(l[0].ifEnd=l[0]),"?"==t[1]&&(l[0].expectElse=!0)},next:"formatString"},{regex:"([^:}\\\\]|\\\\.)*:?",token:"",next:"formatString"}]})},this.tokenizeTmSnippet=function(e,i){return this.getTokenizer().getLineTokens(e,i).tokens.map(function(r){return r.value||r})},this.getVariableValue=function(e,i,r){if(/^\d+$/.test(i))return(this.variables.__||{})[i]||"";if(/^[A-Z]\d+$/.test(i))return(this.variables[i[0]+"__"]||{})[i.substr(1)]||"";if(i=i.replace(/^TM_/,""),!this.variables.hasOwnProperty(i))return"";var t=this.variables[i];return"function"==typeof t&&(t=this.variables[i](e,i,r)),null==t?"":t},this.variables=s,this.tmStrFormat=function(e,i,r){if(!i.fmt)return e;var a=i.guard;a=new RegExp(a,(i.flag||"").replace(/[^gim]/g,""));var l="string"==typeof i.fmt?this.tokenizeTmSnippet(i.fmt,"formatString"):i.fmt,o=this,u=e.replace(a,function(){var c=o.variables.__;o.variables.__=[].slice.call(arguments);for(var d=o.resolveVariables(l,r),f="E",m=0;m<d.length;m++){var b=d[m];if("object"==typeof b)if(d[m]="",b.changeCase&&b.local){var w=d[m+1];w&&"string"==typeof w&&(d[m]="u"==b.changeCase?w[0].toUpperCase():w[0].toLowerCase(),d[m+1]=w.substr(1))}else b.changeCase&&(f=b.changeCase);else"U"==f?d[m]=b.toUpperCase():"L"==f&&(d[m]=b.toLowerCase())}return o.variables.__=c,d.join("")});return u},this.tmFormatFunction=function(e,i,r){return"upcase"==i.formatFunction?e.toUpperCase():"downcase"==i.formatFunction?e.toLowerCase():e},this.resolveVariables=function(e,i){for(var r=[],t="",a=!0,l=0;l<e.length;l++){var o=e[l];if("string"!=typeof o){if(o){if(a=!1,o.fmtString){var u=e.indexOf(o,l+1);-1==u&&(u=e.length),o.fmt=e.slice(l+1,u),l=u}if(o.text){var c=this.getVariableValue(i,o.text,t)+"";o.fmtString&&(c=this.tmStrFormat(c,o,i)),o.formatFunction&&(c=this.tmFormatFunction(c,o,i)),c&&!o.ifEnd?(r.push(c),d(o)):!c&&o.ifEnd&&d(o.ifEnd)}else o.elseEnd?d(o.elseEnd):(null!=o.tabstopId||null!=o.changeCase)&&r.push(o)}}else r.push(o),"\n"==o?(a=!0,t=""):a&&(t=/^\t*/.exec(o)[0],a=/\S/.test(o))}function d(f){var m=e.indexOf(f,l+1);-1!=m&&(l=m)}return r},this.insertSnippetForSelection=function(e,i){var r=e.getCursorPosition(),t=e.session.getLine(r.row),a=e.session.getTabString(),l=t.match(/^\s*/)[0];r.column<l.length&&(l=l.slice(0,r.column)),i=i.replace(/\r/g,"");var o=this.tokenizeTmSnippet(i);o=(o=this.resolveVariables(o,e)).map(function(C){return"\n"==C?C+l:"string"==typeof C?C.replace(/\t/g,a):C});var u=[];o.forEach(function(C,O){if("object"==typeof C){var H=C.tabstopId,A=u[H];if(A||((A=u[H]=[]).index=H,A.value="",A.parents={}),-1===A.indexOf(C)){C.choices&&!A.choices&&(A.choices=C.choices),A.push(C);var z=o.indexOf(C,O+1);if(-1!==z){var U=o.slice(O+1,z);U.some(function(Z){return"object"==typeof Z})&&!A.value?A.value=U:U.length&&(!A.value||"string"!=typeof A.value)&&(A.value=U.join(""))}}}}),u.forEach(function(C){C.length=0});var c={};function d(C){for(var O=[],H=0;H<C.length;H++){var A=C[H];if("object"==typeof A){if(c[A.tabstopId])continue;A=O[C.lastIndexOf(A,H-1)]||{tabstopId:A.tabstopId}}O[H]=A}return O}for(var f=0;f<o.length;f++){var m=o[f];if("object"==typeof m){var b=m.tabstopId,w=u[b],P=o.indexOf(m,f+1);if(c[b]){c[b]===m&&(delete c[b],Object.keys(c).forEach(function(C){w.parents[C]=!0}));continue}c[b]=m;var I=w.value;"string"!=typeof I?I=d(I):m.fmt&&(I=this.tmStrFormat(I,m,e)),o.splice.apply(o,[f+1,Math.max(0,P-f)].concat(I,m)),-1===w.indexOf(m)&&w.push(m)}}var B=0,D=0,V="";o.forEach(function(C){if("string"==typeof C){var O=C.split("\n");O.length>1?(D=O[O.length-1].length,B+=O.length-1):D+=C.length,V+=C}else C&&(C.start?C.end={row:B,column:D}:C.start={row:B,column:D})});var W=e.getSelectionRange(),K=e.session.replace(W,V);new h(e).addTabstops(u,W.start,K,e.inVirtualSelectionMode&&e.selection.index)},this.insertSnippet=function(e,i){var r=this;if(e.inVirtualSelectionMode)return r.insertSnippetForSelection(e,i);e.forEachSelection(function(){r.insertSnippetForSelection(e,i)},null,{keepOrder:!0}),e.tabstopManager&&e.tabstopManager.tabNext()},this.$getScope=function(e){var i=e.session.$mode.$id||"";if("html"===(i=i.split("/").pop())||"php"===i){"php"===i&&!e.session.$mode.inlinePhp&&(i="html");var r=e.getCursorPosition(),t=e.session.getState(r.row);"object"==typeof t&&(t=t[0]),t.substring&&("js-"==t.substring(0,3)?i="javascript":"css-"==t.substring(0,4)?i="css":"php-"==t.substring(0,4)&&(i="php"))}return i},this.getActiveScopes=function(e){var i=this.$getScope(e),r=[i],t=this.snippetMap;return t[i]&&t[i].includeScopes&&r.push.apply(r,t[i].includeScopes),r.push("_"),r},this.expandWithTab=function(e,i){var r=this,t=e.forEachSelection(function(){return r.expandSnippetForSelection(e,i)},null,{keepOrder:!0});return t&&e.tabstopManager&&e.tabstopManager.tabNext(),t},this.expandSnippetForSelection=function(e,i){var u,r=e.getCursorPosition(),t=e.session.getLine(r.row),a=t.substring(0,r.column),l=t.substr(r.column),o=this.snippetMap;return this.getActiveScopes(e).some(function(c){var d=o[c];return d&&(u=this.findMatchingSnippet(d,a,l)),!!u},this),!!u&&(i&&i.dryRun||(e.session.doc.removeInLine(r.row,r.column-u.replaceBefore.length,r.column+u.replaceAfter.length),this.variables.M__=u.matchBefore,this.variables.T__=u.matchAfter,this.insertSnippetForSelection(e,u.content),this.variables.M__=this.variables.T__=null),!0)},this.findMatchingSnippet=function(e,i,r){for(var t=e.length;t--;){var a=e[t];if((!a.startRe||a.startRe.test(i))&&(!a.endRe||a.endRe.test(r))&&(a.startRe||a.endRe))return a.matchBefore=a.startRe?a.startRe.exec(i):[""],a.matchAfter=a.endRe?a.endRe.exec(r):[""],a.replaceBefore=a.triggerRe?a.triggerRe.exec(i)[0]:"",a.replaceAfter=a.endTriggerRe?a.endTriggerRe.exec(r)[0]:"",a}},this.snippetMap={},this.snippetNameMap={},this.register=function(e,i){var r=this.snippetMap,t=this.snippetNameMap,a=this;function l(c){return c&&!/^\^?\(.*\)\$?$|^\\b$/.test(c)&&(c="(?:"+c+")"),c||""}function o(c,d,f){return c=l(c),d=l(d),f?(c=d+c)&&"$"!=c[c.length-1]&&(c+="$"):(c+=d)&&"^"!=c[0]&&(c="^"+c),new RegExp(c)}function u(c){c.scope||(c.scope=i||"_"),r[i=c.scope]||(r[i]=[],t[i]={});var d=t[i];if(c.name){var f=d[c.name];f&&a.unregister(f),d[c.name]=c}r[i].push(c),c.prefix&&(c.tabTrigger=c.prefix),!c.content&&c.body&&(c.content=Array.isArray(c.body)?c.body.join("\n"):c.body),c.tabTrigger&&!c.trigger&&(!c.guard&&/^\w/.test(c.tabTrigger)&&(c.guard="\\b"),c.trigger=y.escapeRegExp(c.tabTrigger)),(c.trigger||c.guard||c.endTrigger||c.endGuard)&&(c.startRe=o(c.trigger,c.guard,!0),c.triggerRe=new RegExp(c.trigger),c.endRe=o(c.endTrigger,c.endGuard,!0),c.endTriggerRe=new RegExp(c.endTrigger))}e||(e=[]),Array.isArray(e)?e.forEach(u):Object.keys(e).forEach(function(c){u(e[c])}),this._signal("registerSnippets",{scope:i})},this.unregister=function(e,i){var r=this.snippetMap,t=this.snippetNameMap;function a(l){var o=t[l.scope||i];if(o&&o[l.name]){delete o[l.name];var u=r[l.scope||i],c=u&&u.indexOf(l);c>=0&&u.splice(c,1)}}e.content?a(e):Array.isArray(e)&&e.forEach(a)},this.parseSnippetFile=function(e){e=e.replace(/\r/g,"");for(var a,i=[],r={},t=/^#.*|^({[\s\S]*})\s*$|^(\S+) (.*)$|^((?:\n*\t.*)+)/gm;a=t.exec(e);){if(a[1])try{r=JSON.parse(a[1]),i.push(r)}catch(c){}if(a[4])r.content=a[4].replace(/^\t/gm,""),i.push(r),r={};else{var l=a[2],o=a[3];if("regex"==l){var u=/\/((?:[^\/\\]|\\.)*)|$/g;r.guard=u.exec(o)[1],r.trigger=u.exec(o)[1],r.endTrigger=u.exec(o)[1],r.endGuard=u.exec(o)[1]}else"snippet"==l?(r.tabTrigger=o.match(/^\S*/)[0],r.name||(r.name=o)):l&&(r[l]=o)}}return i},this.getSnippetByName=function(e,i){var t,r=this.snippetNameMap;return this.getActiveScopes(i).some(function(a){var l=r[a];return l&&(t=l[e]),!!t},this),t}}).call(p.prototype);var h=function(e){if(e.tabstopManager)return e.tabstopManager;e.tabstopManager=this,this.$onChange=this.onChange.bind(this),this.$onChangeSelection=y.delayedCall(this.onChangeSelection.bind(this)).schedule,this.$onChangeSession=this.onChangeSession.bind(this),this.$onAfterExec=this.onAfterExec.bind(this),this.attach(e)};(function(){this.attach=function(e){this.index=0,this.ranges=[],this.tabstops=[],this.$openTabstops=null,this.selectedTabstop=null,this.editor=e,this.editor.on("change",this.$onChange),this.editor.on("changeSelection",this.$onChangeSelection),this.editor.on("changeSession",this.$onChangeSession),this.editor.commands.on("afterExec",this.$onAfterExec),this.editor.keyBinding.addKeyboardHandler(this.keyboardHandler)},this.detach=function(){this.tabstops.forEach(this.removeTabstopMarkers,this),this.ranges=null,this.tabstops=null,this.selectedTabstop=null,this.editor.removeListener("change",this.$onChange),this.editor.removeListener("changeSelection",this.$onChangeSelection),this.editor.removeListener("changeSession",this.$onChangeSession),this.editor.commands.removeListener("afterExec",this.$onAfterExec),this.editor.keyBinding.removeKeyboardHandler(this.keyboardHandler),this.editor.tabstopManager=null,this.editor=null},this.onChange=function(e){for(var i="r"==e.action[0],r=this.selectedTabstop||{},t=r.parents||{},a=(this.tabstops||[]).slice(),l=0;l<a.length;l++){var o=a[l];if(o.rangeList.$bias=o==r||t[o.index]?0:1,"remove"==e.action&&o!==r){var c=o.parents&&o.parents[r.index],d=o.rangeList.pointIndex(e.start,c);d=d<0?-d-1:d+1;for(var f=o.rangeList.pointIndex(e.end,c),m=o.rangeList.ranges.slice(d,f=f<0?-f-1:f-1),b=0;b<m.length;b++)this.removeRange(m[b])}o.rangeList.$onChange(e)}var w=this.editor.session;!this.$inChange&&i&&1==w.getLength()&&!w.getValue()&&this.detach()},this.updateLinkedFields=function(){var e=this.selectedTabstop;if(e&&e.hasLinkedRanges&&e.firstNonLinked){this.$inChange=!0;for(var i=this.editor.session,r=i.getTextRange(e.firstNonLinked),t=0;t<e.length;t++){var a=e[t];if(a.linked){var o=E.snippetManager.tmStrFormat(r,a.original,this.editor);i.replace(a,o)}}this.$inChange=!1}},this.onAfterExec=function(e){e.command&&!e.command.readOnly&&this.updateLinkedFields()},this.onChangeSelection=function(){if(this.editor){for(var e=this.editor.selection.lead,i=this.editor.selection.anchor,r=this.editor.selection.isEmpty(),t=0;t<this.ranges.length;t++)if(!this.ranges[t].linked){var a=this.ranges[t].contains(e.row,e.column),l=r||this.ranges[t].contains(i.row,i.column);if(a&&l)return}this.detach()}},this.onChangeSession=function(){this.detach()},this.tabNext=function(e){var i=this.tabstops.length,r=this.index+(e||1);(r=Math.min(Math.max(r,1),i))==i&&(r=0),this.selectTabstop(r),0===r&&this.detach()},this.selectTabstop=function(e){this.$openTabstops=null;var i=this.tabstops[this.index];if(i&&this.addTabstopMarkers(i),this.index=e,(i=this.tabstops[this.index])&&i.length){this.selectedTabstop=i;var r=i.firstNonLinked||i;if(i.choices&&(r.cursor=r.start),this.editor.inVirtualSelectionMode)this.editor.selection.fromOrientedRange(r);else{var t=this.editor.multiSelect;t.toSingleRange(r);for(var a=0;a<i.length;a++)i.hasLinkedRanges&&i[a].linked||t.addRange(i[a].clone(),!0)}this.editor.keyBinding.addKeyboardHandler(this.keyboardHandler),this.selectedTabstop&&this.selectedTabstop.choices&&this.editor.execCommand("startAutocomplete",{matches:this.selectedTabstop.choices})}},this.addTabstops=function(e,i,r){var t=this.useLink||!this.editor.getOption("enableMultiselect");if(this.$openTabstops||(this.$openTabstops=[]),!e[0]){var a=S.fromPoints(r,r);x(a.start,i),x(a.end,i),e[0]=[a],e[0].index=0}var o=[this.index+1,0],u=this.ranges;e.forEach(function(c,d){for(var f=this.$openTabstops[d]||c,m=0;m<c.length;m++){var b=c[m],w=S.fromPoints(b.start,b.end||b.start);g(w.start,i),g(w.end,i),w.original=b,w.tabstop=f,u.push(w),f!=c?f.unshift(w):f[m]=w,b.fmtString||f.firstNonLinked&&t?(w.linked=!0,f.hasLinkedRanges=!0):f.firstNonLinked||(f.firstNonLinked=w)}f.firstNonLinked||(f.hasLinkedRanges=!1),f===c&&(o.push(f),this.$openTabstops[d]=f),this.addTabstopMarkers(f),f.rangeList=f.rangeList||new T,f.rangeList.$bias=0,f.rangeList.addList(f)},this),o.length>2&&(this.tabstops.length&&o.push(o.splice(2,1)[0]),this.tabstops.splice.apply(this.tabstops,o))},this.addTabstopMarkers=function(e){var i=this.editor.session;e.forEach(function(r){r.markerId||(r.markerId=i.addMarker(r,"ace_snippet-marker","text"))})},this.removeTabstopMarkers=function(e){var i=this.editor.session;e.forEach(function(r){i.removeMarker(r.markerId),r.markerId=null})},this.removeRange=function(e){var i=e.tabstop.indexOf(e);-1!=i&&e.tabstop.splice(i,1),-1!=(i=this.ranges.indexOf(e))&&this.ranges.splice(i,1),-1!=(i=e.tabstop.rangeList.ranges.indexOf(e))&&e.tabstop.splice(i,1),this.editor.session.removeMarker(e.markerId),e.tabstop.length||(-1!=(i=this.tabstops.indexOf(e.tabstop))&&this.tabstops.splice(i,1),this.tabstops.length||this.detach())},this.keyboardHandler=new k,this.keyboardHandler.bindKeys({Tab:function(e){E.snippetManager&&E.snippetManager.expandWithTab(e)||(e.tabstopManager.tabNext(1),e.renderer.scrollCursorIntoView())},"Shift-Tab":function(e){e.tabstopManager.tabNext(-1),e.renderer.scrollCursorIntoView()},Esc:function(e){e.tabstopManager.detach()}})}).call(h.prototype);var g=function(e,i){0==e.row&&(e.column+=i.column),e.row+=i.row},x=function(e,i){e.row==i.row&&(e.column-=i.column),e.row-=i.row};$.importCssString(".ace_snippet-marker {    -moz-box-sizing: border-box;    box-sizing: border-box;    background: rgba(194, 193, 208, 0.09);    border: 1px dotted rgba(211, 208, 235, 0.62);    position: absolute;}","snippets.css",!1),E.snippetManager=new p;var _=v("./editor").Editor;(function(){this.insertSnippet=function(e,i){return E.snippetManager.insertSnippet(this,e,i)},this.expandSnippet=function(e){return E.snippetManager.expandWithTab(this,e)}}).call(_.prototype)}),ace.define("ace/autocomplete/popup",["require","exports","module","ace/virtual_renderer","ace/editor","ace/range","ace/lib/event","ace/lib/lang","ace/lib/dom"],function(v,E,F){"use strict";var $=v("../virtual_renderer").VirtualRenderer,M=v("../editor").Editor,N=v("../range").Range,y=v("../lib/event"),S=v("../lib/lang"),T=v("../lib/dom"),k=function(L){var s=new $(L);s.$maxLines=4;var n=new M(s);return n.setHighlightActiveLine(!1),n.setShowPrintMargin(!1),n.renderer.setShowGutter(!1),n.renderer.setHighlightGutterLine(!1),n.$mouseHandler.$focusTimeout=0,n.$highlightTagPending=!0,n};T.importCssString(".ace_editor.ace_autocomplete .ace_marker-layer .ace_active-line {    background-color: #CAD6FA;    z-index: 1;}.ace_dark.ace_editor.ace_autocomplete .ace_marker-layer .ace_active-line {    background-color: #3a674e;}.ace_editor.ace_autocomplete .ace_line-hover {    border: 1px solid #abbffe;    margin-top: -1px;    background: rgba(233,233,253,0.4);    position: absolute;    z-index: 2;}.ace_dark.ace_editor.ace_autocomplete .ace_line-hover {    border: 1px solid rgba(109, 150, 13, 0.8);    background: rgba(58, 103, 78, 0.62);}.ace_completion-meta {    opacity: 0.5;    margin: 0.9em;}.ace_completion-message {    color: blue;}.ace_editor.ace_autocomplete .ace_completion-highlight{    color: #2d69c7;}.ace_dark.ace_editor.ace_autocomplete .ace_completion-highlight{    color: #93ca12;}.ace_editor.ace_autocomplete {    width: 300px;    z-index: 200000;    border: 1px lightgray solid;    position: fixed;    box-shadow: 2px 3px 5px rgba(0,0,0,.2);    line-height: 1.4;    background: #fefefe;    color: #111;}.ace_dark.ace_editor.ace_autocomplete {    border: 1px #484747 solid;    box-shadow: 2px 3px 5px rgba(0, 0, 0, 0.51);    line-height: 1.4;    background: #25282c;    color: #c1c1c1;}","autocompletion.css",!1),E.AcePopup=function(L){var s=T.createElement("div"),n=new k(s);L&&L.appendChild(s),s.style.display="none",n.renderer.content.style.cursor="default",n.renderer.setStyle("ace_autocomplete"),n.setOption("displayIndentGuides",!1),n.setOption("dragDelay",150);var p=function(){};n.focus=p,n.$isFocused=!0,n.renderer.$cursorLayer.restartTimer=p,n.renderer.$cursorLayer.element.style.opacity=0,n.renderer.$maxLines=8,n.renderer.$keepTextAreaAtCursor=!1,n.setHighlightActiveLine(!1),n.session.highlight(""),n.session.$searchHighlight.clazz="ace_highlight-marker",n.on("mousedown",function(r){var t=r.getDocumentPosition();n.selection.moveToPosition(t),x.start.row=x.end.row=t.row,r.stop()});var h,g=new N(-1,0,-1,1/0),x=new N(-1,0,-1,1/0);x.id=n.session.addMarker(x,"ace_active-line","fullLine"),n.setSelectOnHover=function(r){r?g.id&&(n.session.removeMarker(g.id),g.id=null):g.id=n.session.addMarker(g,"ace_line-hover","fullLine")},n.setSelectOnHover(!1),n.on("mousemove",function(r){if(h){if(h.x!=r.x||h.y!=r.y){(h=r).scrollTop=n.renderer.scrollTop;var t=h.getDocumentPosition().row;g.start.row!=t&&(g.id||n.setRow(t),e(t))}}else h=r}),n.renderer.on("beforeRender",function(){if(h&&-1!=g.start.row){h.$pos=null;var r=h.getDocumentPosition().row;g.id||n.setRow(r),e(r,!0)}}),n.renderer.on("afterRender",function(){var r=n.getRow(),t=n.renderer.$textLayer,a=t.element.childNodes[r-t.config.firstRow];a!==t.selectedNode&&t.selectedNode&&T.removeCssClass(t.selectedNode,"ace_selected"),t.selectedNode=a,a&&T.addCssClass(a,"ace_selected")});var _=function(){e(-1)},e=function(r,t){r!==g.start.row&&(g.start.row=g.end.row=r,t||n.session._emit("changeBackMarker"),n._emit("changeHoverMarker"))};n.getHoveredRow=function(){return g.start.row},y.addListener(n.container,"mouseout",_),n.on("hide",_),n.on("changeSelection",_),n.session.doc.getLength=function(){return n.data.length},n.session.doc.getLine=function(r){var t=n.data[r];return"string"==typeof t?t:t&&t.value||""};var i=n.session.bgTokenizer;return i.$tokenizeRow=function(r){var t=n.data[r],a=[];if(!t)return a;"string"==typeof t&&(t={value:t});var l=t.caption||t.value||t.name;function o(P,I){P&&a.push({type:(t.className||"")+(I||""),value:P})}for(var u=l.toLowerCase(),c=(n.filterText||"").toLowerCase(),d=0,f=0,m=0;m<=c.length;m++)if(m!=f&&(t.matchMask&1<<m||m==c.length)){var b=c.slice(f,m);f=m;var w=u.indexOf(b,d);if(-1==w)continue;o(l.slice(d,w),""),o(l.slice(w,d=w+b.length),"completion-highlight")}return o(l.slice(d,l.length),""),t.meta&&a.push({type:"completion-meta",value:t.meta}),t.message&&a.push({type:"completion-message",value:t.message}),a},i.$updateOnChange=p,i.start=p,n.session.$computeWidth=function(){return this.screenWidth=0},n.isOpen=!1,n.isTopdown=!1,n.autoSelect=!0,n.filterText="",n.data=[],n.setData=function(r,t){n.filterText=t||"",n.setValue(S.stringRepeat("\n",r.length),-1),n.data=r||[],n.setRow(0)},n.getData=function(r){return n.data[r]},n.getRow=function(){return x.start.row},n.setRow=function(r){r=Math.max(this.autoSelect?0:-1,Math.min(this.data.length,r)),x.start.row!=r&&(n.selection.clearSelection(),x.start.row=x.end.row=r||0,n.session._emit("changeBackMarker"),n.moveCursorTo(r||0,0),n.isOpen&&n._signal("select"))},n.on("changeSelection",function(){n.isOpen&&n.setRow(n.selection.lead.row),n.renderer.scrollCursorIntoView()}),n.hide=function(){this.container.style.display="none",this._signal("hide"),n.isOpen=!1},n.show=function(r,t,a){var l=this.container,o=window.innerHeight,u=window.innerWidth,c=this.renderer,f=r.top+this.$borderSize;f>o/2&&!a&&f+t+c.$maxLines*t*1.4>o?(c.$maxPixelHeight=f-2*this.$borderSize,l.style.top="",l.style.bottom=o-f+"px",n.isTopdown=!1):(c.$maxPixelHeight=o-(f+=t)-.2*t,l.style.top=f+"px",l.style.bottom="",n.isTopdown=!0),l.style.display="";var b=r.left;b+l.offsetWidth>u&&(b=u-l.offsetWidth),l.style.left=b+"px",this._signal("show"),h=null,n.isOpen=!0},n.goTo=function(r){var t=this.getRow(),a=this.session.getLength()-1;switch(r){case"up":t=t<=0?a:t-1;break;case"down":t=t>=a?-1:t+1;break;case"start":t=0;break;case"end":t=a}this.setRow(t)},n.getTextLeftOffset=function(){return this.$borderSize+this.renderer.$padding+this.$imageSize},n.$imageSize=0,n.$borderSize=1,n},E.$singleLineEditor=k}),ace.define("ace/autocomplete/util",["require","exports","module"],function(v,E,F){"use strict";E.parForEach=function(M,N,y){var S=0,T=M.length;0===T&&y();for(var k=0;k<T;k++)N(M[k],function(R,L){++S===T&&y(R,L)})};var $=/[a-zA-Z_0-9\$\-\u00A2-\u2000\u2070-\uFFFF]/;E.retrievePrecedingIdentifier=function(M,N,y){y=y||$;for(var S=[],T=N-1;T>=0&&y.test(M[T]);T--)S.push(M[T]);return S.reverse().join("")},E.retrieveFollowingIdentifier=function(M,N,y){y=y||$;for(var S=[],T=N;T<M.length&&y.test(M[T]);T++)S.push(M[T]);return S},E.getCompletionPrefix=function(M){var S,N=M.getCursorPosition(),y=M.session.getLine(N.row);return M.completers.forEach(function(T){T.identifierRegexps&&T.identifierRegexps.forEach(function(k){!S&&k&&(S=this.retrievePrecedingIdentifier(y,N.column,k))}.bind(this))}.bind(this)),S||this.retrievePrecedingIdentifier(y,N.column)}}),ace.define("ace/autocomplete",["require","exports","module","ace/keyboard/hash_handler","ace/autocomplete/popup","ace/autocomplete/util","ace/lib/lang","ace/lib/dom","ace/snippets","ace/config"],function(v,E,F){"use strict";var $=v("./keyboard/hash_handler").HashHandler,M=v("./autocomplete/popup").AcePopup,N=v("./autocomplete/util"),y=v("./lib/lang"),S=v("./lib/dom"),T=v("./snippets").snippetManager,k=v("./config"),R=function(){this.autoInsert=!1,this.autoSelect=!0,this.exactMatch=!1,this.gatherCompletionsId=0,this.keyboardHandler=new $,this.keyboardHandler.bindKeys(this.commands),this.blurListener=this.blurListener.bind(this),this.changeListener=this.changeListener.bind(this),this.mousedownListener=this.mousedownListener.bind(this),this.mousewheelListener=this.mousewheelListener.bind(this),this.changeTimer=y.delayedCall(function(){this.updateCompletions(!0)}.bind(this)),this.tooltipTimer=y.delayedCall(this.updateDocTooltip.bind(this),50)};(function(){this.$init=function(){return this.popup=new M(document.body||document.documentElement),this.popup.on("click",function(s){this.insertMatch(),s.stop()}.bind(this)),this.popup.focus=this.editor.focus.bind(this.editor),this.popup.on("show",this.tooltipTimer.bind(null,null)),this.popup.on("select",this.tooltipTimer.bind(null,null)),this.popup.on("changeHoverMarker",this.tooltipTimer.bind(null,null)),this.popup},this.getPopup=function(){return this.popup||this.$init()},this.openPopup=function(s,n,p){this.popup||this.$init(),this.popup.autoSelect=this.autoSelect,this.popup.setData(this.completions.filtered,this.completions.filterText),s.keyBinding.addKeyboardHandler(this.keyboardHandler);var h=s.renderer;if(this.popup.setRow(this.autoSelect?0:-1),p)p&&!n&&this.detach();else{this.popup.setTheme(s.getTheme()),this.popup.setFontSize(s.getFontSize());var g=h.layerConfig.lineHeight,x=h.$cursorLayer.getPixelPosition(this.base,!0);x.left-=this.popup.getTextLeftOffset();var _=s.container.getBoundingClientRect();x.top+=_.top-h.layerConfig.offset,x.left+=_.left-s.renderer.scrollLeft,x.left+=h.gutterWidth,this.popup.show(x,g)}this.changeTimer.cancel()},this.detach=function(){this.editor.keyBinding.removeKeyboardHandler(this.keyboardHandler),this.editor.off("changeSelection",this.changeListener),this.editor.off("blur",this.blurListener),this.editor.off("mousedown",this.mousedownListener),this.editor.off("mousewheel",this.mousewheelListener),this.changeTimer.cancel(),this.hideDocTooltip(),this.gatherCompletionsId+=1,this.popup&&this.popup.isOpen&&this.popup.hide(),this.base&&this.base.detach(),this.activated=!1,this.completions=this.base=null},this.changeListener=function(s){var n=this.editor.selection.lead;(n.row!=this.base.row||n.column<this.base.column)&&this.detach(),this.activated?this.changeTimer.schedule():this.detach()},this.blurListener=function(s){var n=document.activeElement,p=this.editor.textInput.getElement(),h=s.relatedTarget&&this.tooltipNode&&this.tooltipNode.contains(s.relatedTarget);n!=p&&n.parentNode!=(this.popup&&this.popup.container)&&!h&&n!=this.tooltipNode&&s.relatedTarget!=p&&this.detach()},this.mousedownListener=function(s){this.detach()},this.mousewheelListener=function(s){this.detach()},this.goTo=function(s){this.popup.goTo(s)},this.insertMatch=function(s,n){if(s||(s=this.popup.getData(this.popup.getRow())),!s)return!1;var p=this.completions;if(this.editor.startOperation({command:{name:"insertMatch"}}),s.completer&&s.completer.insertMatch)s.completer.insertMatch(this.editor,s);else{if(!p)return!1;if(p.filterText)for(var x,h=this.editor.selection.getAllRanges(),g=0;x=h[g];g++)x.start.column-=p.filterText.length,this.editor.session.remove(x);s.snippet?T.insertSnippet(this.editor,s.snippet):this.editor.execCommand("insertstring",s.value||s)}this.completions==p&&this.detach(),this.editor.endOperation()},this.commands={Up:function(s){s.completer.goTo("up")},Down:function(s){s.completer.goTo("down")},"Ctrl-Up|Ctrl-Home":function(s){s.completer.goTo("start")},"Ctrl-Down|Ctrl-End":function(s){s.completer.goTo("end")},Esc:function(s){s.completer.detach()},Return:function(s){return s.completer.insertMatch()},"Shift-Return":function(s){s.completer.insertMatch(null,{deleteSuffix:!0})},Tab:function(s){var n=s.completer.insertMatch();if(n||s.tabstopManager)return n;s.completer.goTo("down")},PageUp:function(s){s.completer.popup.gotoPageUp()},PageDown:function(s){s.completer.popup.gotoPageDown()}},this.gatherCompletions=function(s,n){var p=s.getSession(),h=s.getCursorPosition(),g=N.getCompletionPrefix(s);this.base=p.doc.createAnchor(h.row,h.column-g.length),this.base.$insertRight=!0;var x=[],_=s.completers.length;return s.completers.forEach(function(e,i){e.getCompletions(s,p,h,g,function(r,t){!r&&t&&(x=x.concat(t)),n(null,{prefix:N.getCompletionPrefix(s),matches:x,finished:0==--_})})}),!0},this.showPopup=function(s,n){this.editor&&this.detach(),this.activated=!0,this.editor=s,s.completer!=this&&(s.completer&&s.completer.detach(),s.completer=this),s.on("changeSelection",this.changeListener),s.on("blur",this.blurListener),s.on("mousedown",this.mousedownListener),s.on("mousewheel",this.mousewheelListener),this.updateCompletions(!1,n)},this.updateCompletions=function(s,n){if(s&&this.base&&this.completions){var p=this.editor.getCursorPosition(),h=this.editor.session.getTextRange({start:this.base,end:p});if(h==this.completions.filterText)return;return this.completions.setFilter(h),this.completions.filtered.length&&(1!=this.completions.filtered.length||this.completions.filtered[0].value!=h||this.completions.filtered[0].snippet)?void this.openPopup(this.editor,h,s):this.detach()}if(n&&n.matches)return p=this.editor.getSelectionRange().start,this.base=this.editor.session.doc.createAnchor(p.row,p.column),this.base.$insertRight=!0,this.completions=new L(n.matches),this.openPopup(this.editor,"",s);var g=this.gatherCompletionsId,x=function(t){if(t.finished)return this.detach()}.bind(this),_=function(t){var a=t.prefix;this.completions=new L(t.matches),this.exactMatch&&(this.completions.exactMatch=!0),this.completions.setFilter(a);var o=this.completions.filtered;return!o.length||1==o.length&&o[0].value==a&&!o[0].snippet?x(t):this.autoInsert&&1==o.length&&t.finished?this.insertMatch(o[0]):void this.openPopup(this.editor,a,s)}.bind(this),e=!0,i=null;if(this.gatherCompletions(this.editor,function(t,a){var l=a.prefix,o=a&&a.matches;if(!o||!o.length)return x(a);if(0===l.indexOf(a.prefix)&&g==this.gatherCompletionsId){if(e)return void(i=a);_(a)}}.bind(this)),e=!1,i){var r=i;i=null,_(r)}},this.cancelContextMenu=function(){this.editor.$mouseHandler.cancelContextMenu()},this.updateDocTooltip=function(){var s=this.popup,n=s.data,p=n&&(n[s.getHoveredRow()]||n[s.getRow()]),h=null;return p&&this.editor&&this.popup.isOpen?(this.editor.completers.some(function(g){return g.getDocTooltip&&(h=g.getDocTooltip(p)),h}),!h&&"string"!=typeof p&&(h=p),"string"==typeof h&&(h={docText:h}),h&&(h.docHTML||h.docText)?void this.showDocTooltip(h):this.hideDocTooltip()):this.hideDocTooltip()},this.showDocTooltip=function(s){this.tooltipNode||(this.tooltipNode=S.createElement("div"),this.tooltipNode.className="ace_tooltip ace_doc-tooltip",this.tooltipNode.style.margin=0,this.tooltipNode.style.pointerEvents="auto",this.tooltipNode.tabIndex=-1,this.tooltipNode.onblur=this.blurListener.bind(this),this.tooltipNode.onclick=this.onTooltipClick.bind(this));var n=this.tooltipNode;s.docHTML?n.innerHTML=s.docHTML:s.docText&&(n.textContent=s.docText),n.parentNode||document.body.appendChild(n);var p=this.popup,h=p.container.getBoundingClientRect();n.style.top=p.container.style.top,n.style.bottom=p.container.style.bottom,n.style.display="block",window.innerWidth-h.right<320?h.left<320?p.isTopdown?(n.style.top=h.bottom+"px",n.style.left=h.left+"px",n.style.right="",n.style.bottom=""):(n.style.top=p.container.offsetTop-n.offsetHeight+"px",n.style.left=h.left+"px",n.style.right="",n.style.bottom=""):(n.style.right=window.innerWidth-h.left+"px",n.style.left=""):(n.style.left=h.right+1+"px",n.style.right="")},this.hideDocTooltip=function(){if(this.tooltipTimer.cancel(),this.tooltipNode){var s=this.tooltipNode;!this.editor.isFocused()&&document.activeElement==s&&this.editor.focus(),this.tooltipNode=null,s.parentNode&&s.parentNode.removeChild(s)}},this.onTooltipClick=function(s){for(var n=s.target;n&&n!=this.tooltipNode;){if("A"==n.nodeName&&n.href){n.rel="noreferrer",n.target="_blank";break}n=n.parentNode}},this.destroy=function(){if(this.detach(),this.popup){this.popup.destroy();var s=this.popup.container;s&&s.parentNode&&s.parentNode.removeChild(s)}this.popup=null}}).call(R.prototype),R.for=function(s){return s.completer||(k.get("sharedPopups")?(R.$shared||(R.$sharedInstance=new R),s.completer=R.$sharedInstance):(s.completer=new R,s.once("destroy",function(n,p){p.completer.destroy()}))),s.completer},R.startCommand={name:"startAutocomplete",exec:function(s,n){var p=R.for(s);p.autoInsert=!1,p.autoSelect=!0,p.showPopup(s,n),p.cancelContextMenu()},bindKey:"Ctrl-Space|Ctrl-Shift-Space|Alt-Space"};var L=function(s,n){this.all=s,this.filtered=s,this.filterText=n||"",this.exactMatch=!1};(function(){this.setFilter=function(s){if(s.length>this.filterText&&0===s.lastIndexOf(this.filterText,0))var n=this.filtered;else n=this.all;this.filterText=s,n=(n=this.filterCompletions(n,this.filterText)).sort(function(h,g){return g.exactMatch-h.exactMatch||g.$score-h.$score||(h.caption||h.value).localeCompare(g.caption||g.value)});var p=null;n=n.filter(function(h){var g=h.snippet||h.caption||h.value;return g!==p&&(p=g,!0)}),this.filtered=n},this.filterCompletions=function(s,n){var p=[],h=n.toUpperCase(),g=n.toLowerCase();e:for(var _,x=0;_=s[x];x++){var e=_.caption||_.value||_.snippet;if(e){var a,l,i=-1,r=0,t=0;if(this.exactMatch){if(n!==e.substr(0,n.length))continue e}else{var o=e.toLowerCase().indexOf(g);if(o>-1)t=o;else for(var u=0;u<n.length;u++){var c=e.indexOf(g[u],i+1),d=e.indexOf(h[u],i+1);if((a=c>=0&&(d<0||c<d)?c:d)<0)continue e;(l=a-i-1)>0&&(-1===i&&(t+=10),t+=l,r|=1<<u),i=a}}_.matchMask=r,_.exactMatch=t?0:1,_.$score=(_.score||0)-t,p.push(_)}}return p}}).call(L.prototype),E.Autocomplete=R,E.FilteredList=L}),ace.define("ace/autocomplete/text_completer",["require","exports","module","ace/range"],function(v,E,F){var $=v("../range").Range,M=/[^a-zA-Z_0-9\$\-\u00C0-\u1FFF\u2C00-\uD7FF\w]+/;E.getCompletions=function(S,T,k,R,L){var s=function y(S,T){var k=function N(S,T){return S.getTextRange($.fromPoints({row:0,column:0},T)).split(M).length-1}(S,T),R=S.getValue().split(M),L=Object.create(null),s=R[k];return R.forEach(function(n,p){if(n&&n!==s){var h=Math.abs(k-p),g=R.length-h;L[n]=L[n]?Math.max(g,L[n]):g}}),L}(T,k);L(null,Object.keys(s).map(function(p){return{caption:p,value:p,score:s[p],meta:"local"}}))}}),ace.define("ace/ext/language_tools",["require","exports","module","ace/snippets","ace/autocomplete","ace/config","ace/lib/lang","ace/autocomplete/util","ace/autocomplete/text_completer","ace/editor","ace/config"],function(v,E,F){"use strict";var $=v("../snippets").snippetManager,M=v("../autocomplete").Autocomplete,N=v("../config"),y=v("../lib/lang"),S=v("../autocomplete/util"),T=v("../autocomplete/text_completer"),k={getCompletions:function(e,i,r,t,a){if(i.$mode.completer)return i.$mode.completer.getCompletions(e,i,r,t,a);var l=e.session.getState(r.row);a(null,i.$mode.getCompletions(l,i,r,t))}},R=function(e){var i={};return e.replace(/\${(\d+)(:(.*?))?}/g,function(r,t,a,l){return i[t]=l||""}).replace(/\$(\d+?)/g,function(r,t){return i[t]})},L={getCompletions:function(e,i,r,t,a){var l=[],o=i.getTokenAt(r.row,r.column);o&&o.type.match(/(tag-name|tag-open|tag-whitespace|attribute-name|attribute-value)\.xml$/)?l.push("html-tag"):l=$.getActiveScopes(e);var u=$.snippetMap,c=[];l.forEach(function(d){for(var f=u[d]||[],m=f.length;m--;){var b=f[m],w=b.name||b.tabTrigger;!w||c.push({caption:w,snippet:b.content,meta:b.tabTrigger&&!b.name?b.tabTrigger+"\u21e5 ":"snippet",type:"snippet"})}},this),a(null,c)},getDocTooltip:function(e){"snippet"==e.type&&!e.docHTML&&(e.docHTML=["<b>",y.escapeHTML(e.caption),"</b>","<hr></hr>",y.escapeHTML(R(e.snippet))].join(""))}},s=[L,T,k];E.setCompleters=function(e){s.length=0,e&&s.push.apply(s,e)},E.addCompleter=function(e){s.push(e)},E.textCompleter=T,E.keyWordCompleter=k,E.snippetCompleter=L;var n={name:"expandSnippet",exec:function(e){return $.expandWithTab(e)},bindKey:"Tab"},p=function(e,i){h(i.session.$mode)},h=function(e){"string"==typeof e&&(e=N.$modes[e]),e&&($.files||($.files={}),g(e.$id,e.snippetFileId),e.modes&&e.modes.forEach(h))},g=function(e,i){!i||!e||$.files[e]||($.files[e]={},N.loadModule(i,function(r){!r||($.files[e]=r,!r.snippets&&r.snippetText&&(r.snippets=$.parseSnippetFile(r.snippetText)),$.register(r.snippets||[],r.scope),r.includeScopes&&($.snippetMap[r.scope].includeScopes=r.includeScopes,r.includeScopes.forEach(function(t){h("ace/mode/"+t)})))}))},x=function(e){var i=e.editor,r=i.completer&&i.completer.activated;if("backspace"===e.command.name)r&&!S.getCompletionPrefix(i)&&i.completer.detach();else if("insertstring"===e.command.name&&S.getCompletionPrefix(i)&&!r){var a=M.for(i);a.autoInsert=!1,a.showPopup(i)}},_=v("../editor").Editor;v("../config").defineOptions(_.prototype,"editor",{enableBasicAutocompletion:{set:function(e){e?(this.completers||(this.completers=Array.isArray(e)?e:s),this.commands.addCommand(M.startCommand)):this.commands.removeCommand(M.startCommand)},value:!1},enableLiveAutocompletion:{set:function(e){e?(this.completers||(this.completers=Array.isArray(e)?e:s),this.commands.on("afterExec",x)):this.commands.removeListener("afterExec",x)},value:!1},enableSnippets:{set:function(e){e?(this.commands.addCommand(n),this.on("changeMode",p),p(0,this)):(this.commands.removeCommand(n),this.off("changeMode",p))},value:!1}})}),ace.require(["ace/ext/language_tools"],function(v){"object"==typeof module&&"object"==typeof exports&&module&&(module.exports=v)});