/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.tools;

import com.chutneytesting.tools.UncheckedException;
import java.util.function.Consumer;

@FunctionalInterface
public interface ThrowingConsumer<T> {
    public void accept(T var1) throws Exception;

    public static <T> Consumer<T> toUnchecked(ThrowingConsumer<T> throwingConsumer) throws UncheckedException {
        return ThrowingConsumer.silence(throwingConsumer, e -> {
            throw UncheckedException.throwUncheckedException(e);
        });
    }

    public static <T> Consumer<T> silence(ThrowingConsumer<T> throwingConsumer, Consumer<Exception> exceptionHandler) {
        return t -> {
            try {
                throwingConsumer.accept(t);
            }
            catch (Exception e) {
                exceptionHandler.accept(e);
            }
        };
    }
}

