/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.tools;

import com.chutneytesting.tools.Try;
import com.chutneytesting.tools.UncheckedException;
import java.util.function.Function;
import java.util.function.Supplier;

@FunctionalInterface
public interface ThrowingSupplier<T, E extends Exception> {
    public T get() throws E;

    default public T unsafeGet() {
        return Try.unsafe(this);
    }

    public static <T, E extends Exception> Supplier<T> toUnchecked(ThrowingSupplier<T, E> throwingFunction) throws UncheckedException {
        return ThrowingSupplier.silence(throwingFunction, e -> {
            throw UncheckedException.throwUncheckedException(e);
        });
    }

    public static <T, E extends Exception> Supplier<T> silence(ThrowingSupplier<T, E> throwingFunction, Function<Exception, T> exceptionHandler) {
        return () -> {
            try {
                return throwingFunction.get();
            }
            catch (Exception e) {
                return exceptionHandler.apply(e);
            }
        };
    }
}

