/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.tools.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FileUtils {
    private FileUtils() {
    }

    public static void initFolder(Path folderPath) throws UncheckedIOException {
        try {
            Files.createDirectories(folderPath, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot create directory: " + folderPath);
        }
        int rand = (int)(Math.random() * 10000.0);
        Path testPath = folderPath.resolve("test" + rand);
        if (!Files.exists(testPath, new LinkOption[0])) {
            try {
                Files.createFile(testPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException("Unable to write in directory: " + folderPath, e);
            }
        }
        FileUtils.deleteFolder(testPath);
    }

    public static void deleteFolder(Path folderPath) {
        try {
            Files.delete(folderPath);
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (DirectoryNotEmptyException e) {
            FileUtils.cleanFolder(folderPath);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to delete directory: " + folderPath, e);
        }
    }

    public static void cleanFolder(Path folderPath) {
        Arrays.stream(Optional.ofNullable(folderPath.toFile().listFiles()).orElse(new File[0])).forEach(file -> {
            if (file.isDirectory()) {
                FileUtils.cleanFolder(file.toPath());
            }
            file.delete();
        });
    }

    public static String getNameWithoutExtension(Path path) {
        String fileName = path.getFileName().toString();
        if (fileName.indexOf(".") > 0) {
            fileName = fileName.substring(0, fileName.lastIndexOf("."));
        }
        return fileName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <R> R doOnListFiles(Path path, Function<Stream<Path>, R> exec) throws UncheckedIOException {
        try (Stream<Path> stream = Files.list(path);){
            R r = exec.apply(stream);
            return r;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to do something on files of path: " + path, e);
        }
    }

    public static List<Path> listFiles(Path folder) {
        return FileUtils.doOnListFiles(folder, pathStream -> pathStream.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).collect(Collectors.toList()));
    }

    public static String readContent(Path path) throws UncheckedIOException {
        try {
            return new String(Files.readAllBytes(path));
        }
        catch (IOException e) {
            throw new UncheckedIOException("Cannot read variable file: " + path, e);
        }
    }

    public static void writeContent(Path path, String content) throws UncheckedIOException {
        try (FileOutputStream outputStream = new FileOutputStream(path.toString());){
            byte[] strToBytes = content.getBytes();
            outputStream.write(strToBytes);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Cannot write into file: " + path, e);
        }
    }
}

