/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.tools;

import com.chutneytesting.tools.ThrowingFunction;
import com.chutneytesting.tools.ThrowingSupplier;
import java.util.function.Consumer;
import java.util.function.Function;

public class Try<T> {
    private final T value;
    private final Exception error;

    public static <T, E extends Exception> T unsafe(ThrowingSupplier<T, E> block) {
        return Try.unsafe(null, block);
    }

    public static <T, E extends Exception> T unsafe(String message, ThrowingSupplier<T, E> block) {
        return super.runtime(message);
    }

    public static <T, E extends Exception> Try<T> exec(ThrowingSupplier<T, E> builder) {
        try {
            return new Try<T>(builder.get(), null);
        }
        catch (Exception e) {
            return new Try<Object>(null, e);
        }
    }

    private Try(T value, Exception error) {
        this.value = value;
        this.error = error;
    }

    public T runtime() {
        return this.runtime((String)null);
    }

    private T runtime(String message) {
        return this.runtime((? super Exception e) -> {
            if (message == null && e instanceof RuntimeException) {
                return (RuntimeException)e;
            }
            return new RuntimeException(message != null ? message : e.getMessage(), (Throwable)e);
        });
    }

    private T runtime(Function<? super Exception, ? extends RuntimeException> wrapper) {
        if (this.isSuccess()) {
            return this.value;
        }
        throw wrapper.apply(this.error);
    }

    private boolean isError() {
        return this.error != null;
    }

    private boolean isSuccess() {
        return !this.isError();
    }

    public T get() throws IllegalStateException {
        if (this.isSuccess()) {
            return this.value;
        }
        throw new IllegalStateException("Cannot get value if Try is in error state");
    }

    public Exception getError() throws IllegalStateException {
        if (this.isError()) {
            return this.error;
        }
        throw new IllegalStateException("Cannot get error if Try is not in error state");
    }

    public Try<T> ifFailed(Consumer<Exception> errorHandler) {
        if (this.isError()) {
            errorHandler.accept(this.error);
        }
        return this;
    }

    public <Handled extends Exception> Try<T> tryToRecover(Class<Handled> handledClass, ThrowingFunction<? super Exception, T, ? extends Exception> recoverFunction) {
        return this.tryToRecover(error -> {
            if (handledClass.isInstance(error)) {
                return recoverFunction.apply((Exception)error);
            }
            throw error;
        });
    }

    public Try<T> tryToRecover(ThrowingFunction<? super Exception, T, ? extends Exception> recoverFunction) {
        if (this.isSuccess()) {
            return new Try<T>(this.value, null);
        }
        return Try.exec(() -> recoverFunction.apply(this.error));
    }

    public Try<T> ifSuccess(Consumer<T> valueHandler) {
        if (this.isSuccess()) {
            valueHandler.accept(this.value);
        }
        return this;
    }
}

