/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.tools;

import java.util.Comparator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;

class SkipUntilSpliterator<T>
implements Spliterator<T> {
    private final Spliterator<T> source;
    private final Predicate<T> condition;
    private final boolean inclusive;
    private boolean conditionMet = false;

    static <T> SkipUntilSpliterator<T> over(Spliterator<T> source, Predicate<T> condition) {
        return new SkipUntilSpliterator<T>(source, condition, false);
    }

    static <T> SkipUntilSpliterator<T> overInclusive(Spliterator<T> source, Predicate<T> condition) {
        return new SkipUntilSpliterator<T>(source, condition, true);
    }

    private SkipUntilSpliterator(Spliterator<T> source, Predicate<T> condition, boolean inclusive) {
        this.source = source;
        this.condition = condition;
        this.inclusive = inclusive;
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        if (this.conditionMet) {
            return this.source.tryAdvance(action);
        }
        while (!this.conditionMet && this.source.tryAdvance(e -> {
            if (this.condition.test(e)) {
                if (this.inclusive) {
                    action.accept(e);
                }
                this.conditionMet = true;
            }
        })) {
        }
        return this.conditionMet;
    }

    @Override
    public void forEachRemaining(Consumer<? super T> action) {
        if (!this.conditionMet) {
            this.tryAdvance(action);
        }
        if (this.conditionMet) {
            this.source.forEachRemaining(action);
        }
    }

    @Override
    public Spliterator<T> trySplit() {
        return null;
    }

    @Override
    public long estimateSize() {
        return this.conditionMet ? this.source.estimateSize() : Long.MAX_VALUE;
    }

    @Override
    public int characteristics() {
        return this.source.characteristics() & 0xFFFFFFBF;
    }

    @Override
    public Comparator<? super T> getComparator() {
        return this.source.getComparator();
    }
}

