/*
 * Decompiled with CFR 0.152.
 */
package com.chutneytesting.task.spi.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class Validator<T> {
    private final T toValidate;
    private final List<String> errors = new ArrayList<String>();

    private Validator(T toValidate) {
        this.toValidate = toValidate;
    }

    public static <T> Validator<T> of(T toValidate) {
        return new Validator<T>(toValidate);
    }

    public <U> Validator<T> validate(Function<? super T, ? extends U> projection, Predicate<? super U> validation, String message) {
        return this.validate(projection.andThen(validation::test)::apply, message);
    }

    public Validator<T> validate(Predicate<? super T> validation, String message) {
        try {
            if (!validation.test(this.toValidate)) {
                this.addError(message);
            }
        }
        catch (Exception e) {
            this.addError("[" + message + "] not applied because of exception " + e.getClass().getCanonicalName() + "(" + e.getMessage() + ")");
        }
        return this;
    }

    public void addError(String message) {
        this.errors.add(message);
    }

    public static List<String> getErrorsFrom(Validator<?> ... validators) {
        return Arrays.stream(validators).flatMap(l -> l.getErrors().stream()).collect(Collectors.toList());
    }

    public boolean isValid() {
        return this.errors.size() == 0;
    }

    public List<String> getErrors() {
        return this.errors;
    }
}

